/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.email.EmailException;
import com.savvion.sbm.bizlogic.email.EmailReader;
import com.savvion.sbm.bizlogic.email.EmailTemplate;
import com.savvion.sbm.bizlogic.email.HtmlComposer;
import com.savvion.sbm.bizlogic.email.HtmlComposerImpl;
import com.savvion.sbm.bizlogic.email.REManager;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.util.CodecUtil;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.MessageFactory;
import com.savvion.sbm.util.PService;
import com.savvion.sbm.util.ResourceUtil;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.dcl.FileClassLoader;
import com.savvion.sbm.util.logger.SBMLogger;
import com.tdiinc.common.Emailer.SendEmail;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;

public class EmailUtil {
    public static final String WORKSTEP_ID = "PCTX.WS_ID";
    public static final String TEMPLATE_ID = "PCTX.TEMPLATE_ID";
    public static final String WORKITEM_ID = "PCTX.WI_ID";
    public static final String INSTANCE_ID = "PCTX.INSTANCE_ID";
    public static final String WORKSTEP_NAME = "PCTX.WS_NAME";
    public static final String INSTANCE_NAME = "PCTX.INSTANCE_NAME";
    public static final String TEMPLATE_NAME = "PCTX.TEMPLATE_NAME";
    public static final String WI_PERFORMER = "PCTX.WI_PERFORMER";
    public static final String EMAIL_CLIENT = "EMAIL.CLIENT_NAME";
    public static final String INPUT_DATASLOTS = "PCTX.INPUT_DATASLOTS";
    public static final String OUTPUT_DATASLOTS = "PCTX.OUTPUT_DATASLOTS";
    public static final String ALL_WS_DATASLOTS = "PCTX.ALL_WS_DATASLOTS";
    public static final String ENC_WORKITEM_ID = "PCTX.ENC.WI_ID";
    public static final String WS_INSTRUCTION = "PCTX.WS_INSTRUCTION";
    public static final String BIZSITE_LOGIN_URL = "PCTX.BIZSITE_LOGIN_URL";
    public static final String WS_START_DATE = "PCTX.WS_START_DATE";
    public static final String WS_DUE_DATE = "PCTX.WS_DUE_DATE";
    public static final String WS_PRIORITY = "PCTX.WS_PRIORITY";
    private static final String REMOVE_CHARS = "bizlogic.email.remove.chars";
    private static final String BACKUP_FOLDER = "bizlogic.email.backup.folder";
    private static final String SUBJECT_PATTERN = "bizlogic.email.subject.pattern";
    private static final String ATTACHMENT_FOLDER = "bizlogic.emailparser.attachment.path";
    private static final String BL_EMAIL_ID = "bizlogic.email.id";
    private static final String INCOMING_MAIL_SERVER = "bizlogic.email.incoming.server";
    private static final String INCOMING_MAIL_PROTOCOL = "bizlogic.email.incoming.server.protocol";
    private static final String INCOMING_MAIL_PORT = "bizlogic.email.incoming.server.port";
    private static final String INCOMING_MAIL_USER = "bizlogic.email.incoming.server.user";
    private static final String INCOMING_MAIL_PASSWD = "bizlogic.email.incoming.server.password";
    private static final String SLEEP_INTERVAL = "bizlogic.email.check.interval";
    private static final String CONNECTION_TIMEOUT = "bizlogic.mail.incoming.server.connectiontimeout";
    private static final String READ_TIMEOUT = "bizlogic.mail.incoming.server.readtimeout";
    private static final String EMAIL_DEBUG = "bizlogic.email.debug";
    private static final String EMAIL_SESSION_DEBUG = "bizlogic.email.session.debug";
    public static final String EMAILVAR_NAME_PREFIX = "bizlogic.email.variable.name.prefix";
    public static final String EMAILVAR_NAME_SUFFIX = "bizlogic.email.variable.name.suffix";
    public static final String EMAILVAR_OPVALUE_PREFIX = "bizlogic.email.variable.outputvalue.prefix";
    public static final String EMAILVAR_OPVALUE_SUFFIX = "bizlogic.email.variable.outputvalue.suffix";
    public static final String EMAILVAR_IPVALUE_PREFIX = "bizlogic.email.variable.inputvalue.prefix";
    public static final String EMAILVAR_IPVALUE_SUFFIX = "bizlogic.email.variable.inputvalue.suffix";
    public static final String EMAIL_ADAPTER_RECEIVER = "bizlogic.email.adapter.receiver";
    public static final String FILL_OUTPUT_VALUES = "bizlogic.email.template.print.outputvalues";
    public static final String HTML_COMPOSER_CLASS_NAME = "bizlogic.email.template.html.composer.class";
    public static final String EMAIL_READER_START = "bizlogic.email.reader.start";
    public static final String PREFERRED_EMAIL_TEMPLATE_TYPE = "bizlogic.email.preferred.template.type";
    public static final String EMAIL_REQUIRED_DATASLOTS_CHECK = "bizlogic.email.required.dataslots.check";
    public static final String EMAIL_DECODEPLUS_OUTPUT_VALUES = "bizlogic.email.decodeplus.outvalues";
    public static final String SEND_EMAIL_CONTENT_AS_ATTACHMENT = "bizlogic.email.send.content.attachment";
    public static final String TASKCOMPLETIONBYEMAIL_ATTACHDOCUMENT = "bizlogic.taskcompletionbyemail.attachdocument";
    public static final String BIZSOLO_URL = "bizsolo.url";
    public static final String WORKITEM_NAME_PATTERN = "${WORKITEM_NAME}";
    public static final String WORKITEM_ID_PATTERN = "${WORKITEM_ID}";
    public static final String DS_CHOICE_PREFIX = "(choices: ";
    public static final String DS_CHOICE_SUFFIX = ")";
    public static final String IMAP = "imap";
    public static final String POP3 = "pop3";
    public static final String IMAPS = "imaps";
    public static final String POP3S = "pop3s";
    public static final String TEMPLATE_TYPE_ETL = "etl";
    public static final String TEMPLATE_TYPE_HTL = "htl";
    public static final String EMAIL_BCC = "EMAIL.BCC";
    public static final String EMAIL_CC = "EMAIL.CC";
    public static final String EMAIL_SUBJECT = "EMAIL.SUBJECT";
    public static final String EMAIL_SUBJECT_PATTERN = "EMAIL.SUBJECT_PATTERN";
    public static final String EMAIL_SECURITY_KEY = "EMAIL.SKEY";
    public static final String EMAIL_TYPE = "EMAIL.TYPE";
    public static final String EMAIL_USER = "EMAIL.USER";
    public static final String EMAIL_BLEMAIL_ID = "EMAIL.BLEMAIL_ID";
    public static final String EMAIL_TEMPLATE = "EMAIL_TEMPLATE";
    public static final String EMAIL_ENC_USER = "EMAIL.ENC.USER";
    private static final String EMAIL_CONF_FILE = "sbmemail.properties";
    private static final String BIZSOLO_CONF_FILE = "bizsolo.conf";
    private static final String LOG_MESSAGE_FILE = "EmailMessages";
    public static final String ASSIGNED_WI_TEMPLATE = "assignedwi.etl";
    public static final String AVAILABLE_WI_TEMPLATE = "availablewi.etl";
    public static final String ASSIGNED_WI_HTML_TEMPLATE = "assignedwi.htl";
    public static final String AVAILABLE_WI_HTML_TEMPLATE = "availablewi.htl";
    public static final String AVAILABLE_WI_NOTIFICATION_TEMPLATE = "notification_availablewi.etl";
    public static final String ASSIGNED_WI_NOTIFICATION_TEMPLATE = "notification_assignedwi.etl";
    public static final String BLDS_NULL_VALUE = "<NULL>";
    public static final String BL_EMAIL_ADDRESS = "blemail@savvion.com";
    public static final String HTML_FOOTER = "footer.htl";
    public static final String ETL_FOOTER = "footer.etl";
    public static final String HTML_HEADER = "header.htl";
    public static final String ETL_INPUTDS = "inputdsheader.etl";
    public static final String ETL_OUTPUTDS = "outputdsheader.etl";
    public static final String MICROSOFT = "microsoft";
    private static final String simpleDateFormatStr = "MMM d, yyyy";
    private static boolean debug = false;
    private static boolean sessionDebug = false;
    private static EmailUtil self = null;
    protected static SBMLogger logger = null;
    private String seperator;
    private long sleepDuration = 30000L;
    private String attachmentFolder = null;
    private String subjectPattern = "";
    private String backupFolder = null;
    private List removeChars;
    private String fromEmailId = null;
    private String incomingMailServer = null;
    private String incomingMailProtocol = "imap";
    private int incomingMailPort = 143;
    private String incomingMailUser = null;
    private String incomingMailPassword = null;
    private int connectiontimeout = 0;
    private int readtimeout = 0;
    private final String lineSeperator = System.getProperty("line.separator");
    private String emailVarNamePrefix = "{";
    private String emailVarNameSuffix = "}";
    private String emailVarSeperator = "=";
    private String emailVarOutputPrefix = "[";
    private String emailVarOutputSuffix = "]";
    private String emailVarInputPrefix = "(";
    private String emailVarInputSuffix = ")";
    private Class emailAdapterReceiver = null;
    private boolean fillOutputValues;
    private boolean checkRequiredDS = true;
    private final boolean decodePlus = true;
    private boolean contentAsAttachment = false;
    private boolean attachDocument = true;
    private final String defTemplatePath;
    private EmailTemplate defAssignedTemplate;
    private EmailTemplate defAvailableTemplate;
    private Class htmlComposerClass = HtmlComposerImpl.class;
    private MessageFactory msgFactory;
    private boolean startEmailReader = false;
    private String defTemplateType = "etl";
    private String bizSoloURL = null;
    private EmailTemplate defAvailableNotificationTemplate;
    private EmailTemplate defAssignedNotificationTemplate;

    private EmailUtil() {
        this.setMessageFactory(LOG_MESSAGE_FILE);
        this.readConfigurations();
        this.setSeperator("=");
        this.defTemplatePath = SBMUtil.self().getSBMAppsDir() + "common/templates/email/";
        EmailTemplate.setEtlFooter(this.defTemplatePath + ETL_FOOTER);
        EmailTemplate.setHtmlFooter(this.defTemplatePath + HTML_FOOTER);
        EmailTemplate.setHtmlHeader(this.defTemplatePath + HTML_HEADER);
        String etlDSHeader = FileUtil.getString((String)(this.defTemplatePath + ETL_INPUTDS), (String)SBMUtil.self().getMailCharset());
        EmailTemplate.setEtlInputDSHeader(etlDSHeader + this.getLineSeperator());
        etlDSHeader = FileUtil.getString((String)(this.defTemplatePath + ETL_OUTPUTDS), (String)SBMUtil.self().getMailCharset());
        EmailTemplate.setEtlOutputDSHeader(etlDSHeader + this.getLineSeperator());
        this.setDefaultAssignedTemplate();
        this.setDefaultAvailableTemplate();
        this.setDefaultAssignedNotificationTemplate();
        this.setDefaultAvailableNotificationTemplate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EmailUtil self() {
        if (null != self) return self;
        Class<EmailUtil> clazz = EmailUtil.class;
        synchronized (EmailUtil.class) {
            if (null != self) return self;
            self = new EmailUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    private void readConfigurations() {
        this.readBizLogicProperties();
        this.readBLEmailProperties();
        this.readBizSoloProperties();
        this.printConfig();
    }

    private Properties getPropertiesObject(String confFile) {
        this.debug("Loading configuration from " + confFile + " ....");
        Properties props = null;
        try {
            props = ResourceUtil.getPropertyObject((String)confFile);
        }
        catch (IOException e) {
            this.throwEmailException("EMAIL_MSG_200", new Object[]{confFile});
        }
        return props;
    }

    private void readBizLogicProperties() {
        BLConstants.single();
        Properties props = this.getPropertiesObject("bizlogic.conf");
        String propStr = props.getProperty(EMAIL_READER_START);
        this.startEmailReader = SBMUtil.getBooleanValue((String)propStr, (boolean)this.startEmailReader);
        this.setAttachDocument(props.getProperty(TASKCOMPLETIONBYEMAIL_ATTACHDOCUMENT));
    }

    private void readBLEmailProperties() {
        Properties props = this.getPropertiesObject(EMAIL_CONF_FILE);
        this.setDebug(props.getProperty(EMAIL_DEBUG));
        this.setFillOutputValues(props.getProperty(FILL_OUTPUT_VALUES));
        this.setEmailVarNamePrefix(props.getProperty(EMAILVAR_NAME_PREFIX));
        this.setEmailVarNameSuffix(props.getProperty(EMAILVAR_NAME_SUFFIX));
        this.setEmailVarOutputPrefix(props.getProperty(EMAILVAR_OPVALUE_PREFIX));
        this.setEmailVarOutputSuffix(props.getProperty(EMAILVAR_OPVALUE_SUFFIX));
        this.setEmailVarInputPrefix(props.getProperty(EMAILVAR_IPVALUE_PREFIX));
        this.setEmailVarInputSuffix(props.getProperty(EMAILVAR_IPVALUE_SUFFIX));
        this.setEmailVarSeperator("=");
        this.setFromEmailId(props.getProperty(BL_EMAIL_ID));
        this.setSessionDebug(props.getProperty(EMAIL_SESSION_DEBUG));
        this.setSubjectPattern(props.getProperty(SUBJECT_PATTERN));
        this.setHtmlComposerClass(props.getProperty(HTML_COMPOSER_CLASS_NAME));
        this.setDefaultTemplateType(props.getProperty(PREFERRED_EMAIL_TEMPLATE_TYPE));
        this.setCheckRequiredDS(props.getProperty(EMAIL_REQUIRED_DATASLOTS_CHECK));
        this.setDecodePlus(props.getProperty(EMAIL_DECODEPLUS_OUTPUT_VALUES));
        this.setSendContentAsAttachment(props.getProperty(SEND_EMAIL_CONTENT_AS_ATTACHMENT));
        if (this.startEmailReader) {
            this.readEmailReaderProperties(props);
        }
    }

    private void readEmailReaderProperties(Properties props) {
        this.setSleepDuration(props.getProperty(SLEEP_INTERVAL));
        this.setRemoveChars(props);
        this.setEmailAdapterReceiver(props.getProperty(EMAIL_ADAPTER_RECEIVER));
        this.setAttachmentFolder(props.getProperty(ATTACHMENT_FOLDER));
        this.setBackupFolder(props.getProperty(BACKUP_FOLDER));
        this.setIncomingMailServer(props.getProperty(INCOMING_MAIL_SERVER));
        this.setIncomingMailProtocol(props.getProperty(INCOMING_MAIL_PROTOCOL));
        this.setIncomingMailUser(props.getProperty(INCOMING_MAIL_USER));
        this.setConnectionTimeout(props.getProperty(CONNECTION_TIMEOUT));
        this.setReadTimeout(props.getProperty(READ_TIMEOUT));
        String passwd = EmailUtil.getDecryptedValue(props.getProperty(INCOMING_MAIL_PASSWD));
        if (passwd == null || passwd.trim().isEmpty()) {
            passwd = props.getProperty(INCOMING_MAIL_PASSWD);
        }
        this.setIncomingMailPassword(passwd);
        this.setIncomingMailPort(props.getProperty(INCOMING_MAIL_PORT));
        if (IMAP.equals(this.incomingMailProtocol) && this.incomingMailPort == 110) {
            this.throwEmailException("EMAIL_MSG_122", new Object[]{String.valueOf(this.incomingMailPort)});
        }
        if (POP3.equals(this.incomingMailProtocol) && this.incomingMailPort == 143) {
            this.throwEmailException("EMAIL_MSG_123", new Object[]{String.valueOf(this.incomingMailPort)});
        }
    }

    public void enableEmailReader() {
        this.startEmailReader = true;
        Properties props = this.getPropertiesObject(EMAIL_CONF_FILE);
        this.readEmailReaderProperties(props);
    }

    public void disableEmailReader() {
        this.startEmailReader = false;
    }

    private void readBizSoloProperties() {
        Properties props = this.getPropertiesObject(BIZSOLO_CONF_FILE);
        this.setBizSoloTaskUrl(props.getProperty(BIZSOLO_URL));
    }

    public String getSubjectPattern() {
        return this.subjectPattern;
    }

    public String getAttachmentFolder() {
        return this.attachmentFolder;
    }

    public String getBackupFolder() {
        return this.backupFolder;
    }

    public HtmlComposer createHtmlComposer(Map metadata, Map dsValues) {
        try {
            Constructor constructor = this.htmlComposerClass.getConstructor(Map.class, Map.class);
            return (HtmlComposer)constructor.newInstance(metadata, dsValues);
        }
        catch (Throwable th) {
            String message = this.getMessage("EMAIL_MSG_247", new Object[]{this.htmlComposerClass.getName()});
            throw new EmailException(message, th);
        }
    }

    public Class getEmailAdapterReceiver() {
        return this.emailAdapterReceiver;
    }

    public String getIncomingMailServer() {
        return this.incomingMailServer;
    }

    public int getIncomingMailPort() {
        return this.incomingMailPort;
    }

    public String getIncomingMailProtocol() {
        return this.incomingMailProtocol;
    }

    public String getIncomingMailUser() {
        return this.incomingMailUser;
    }

    public String getIncomingMailPassword() {
        return this.incomingMailPassword;
    }

    public List getRemoveChars() {
        return this.removeChars;
    }

    public long getSleepInterval() {
        return this.sleepDuration;
    }

    public boolean isDebug() {
        return debug;
    }

    public boolean isFillOutputValues() {
        return this.fillOutputValues;
    }

    public boolean isSessionDebug() {
        return sessionDebug;
    }

    public boolean isTemplateTypeEtl() {
        return TEMPLATE_TYPE_ETL.equals(this.defTemplateType);
    }

    public boolean isTemplateTypeHtl() {
        return TEMPLATE_TYPE_HTL.equals(this.defTemplateType);
    }

    public MessageFactory getMessageFactory() {
        return this.msgFactory;
    }

    public final String getLineSeperator() {
        return this.lineSeperator;
    }

    public String getEmailVarNamePrefix() {
        return this.emailVarNamePrefix;
    }

    public String getEmailVarNameSuffix() {
        return this.emailVarNameSuffix;
    }

    public String getEmailVarOutputPrefix() {
        return this.emailVarOutputPrefix;
    }

    public String getEmailVarOutputSuffix() {
        return this.emailVarOutputSuffix;
    }

    public String getEmailVarInputPrefix() {
        return this.emailVarInputPrefix;
    }

    public String getEmailVarInputSuffix() {
        return this.emailVarInputSuffix;
    }

    public String getEmailVarSeperator() {
        return this.emailVarSeperator;
    }

    public String getFromEmailId() {
        return this.fromEmailId;
    }

    public boolean isCheckRequiredDSEnabled() {
        return this.checkRequiredDS;
    }

    public boolean isDecodePlusEnabled() {
        return this.decodePlus;
    }

    public boolean sendContentAsAttachment() {
        return this.contentAsAttachment;
    }

    public boolean isAttachDocumentEnabled() {
        return this.attachDocument;
    }

    private void setAttachmentFolder(String folder) {
        if (!EmailUtil.isValidProperty(folder)) {
            this.throwEmailException("EMAIL_MSG_201", new String[]{folder});
        } else {
            File attachmentDir;
            if (!(folder = folder.trim()).endsWith("/")) {
                folder = folder + "/";
            }
            if (!(attachmentDir = new File(folder)).exists()) {
                this.throwEmailException("EMAIL_MSG_202", new String[]{folder});
            } else {
                if (!attachmentDir.isDirectory()) {
                    this.throwEmailException("EMAIL_MSG_203", new String[]{folder});
                }
                if (!attachmentDir.canWrite()) {
                    this.throwEmailException("EMAIL_MSG_204", new String[]{folder});
                }
            }
            this.attachmentFolder = folder;
        }
    }

    private void setBackupFolder(String folder) {
        this.backupFolder = SBMUtil.getStringValue((String)folder, (String)this.backupFolder);
    }

    private void setHtmlComposerClass(String htmlComposerClassName) {
        HtmlComposer.setPrintOutputValues((boolean)this.fillOutputValues);
        if (EmailUtil.isValidProperty(htmlComposerClassName)) {
            try {
                Class<?> composerClass = Class.forName(htmlComposerClassName);
                Constructor<?> constructor = composerClass.getConstructor(Map.class, Map.class);
                Object dummyComposerObject = constructor.newInstance(new HashMap(), new HashMap());
                if (dummyComposerObject instanceof HtmlComposer) {
                    this.htmlComposerClass = composerClass;
                } else {
                    this.error("EMAIL_MSG_248", new Object[]{htmlComposerClassName, HTML_COMPOSER_CLASS_NAME, HtmlComposer.class.getName()});
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.error("EMAIL_MSG_249", new Object[]{htmlComposerClassName, HTML_COMPOSER_CLASS_NAME}, cnfe);
            }
            catch (Throwable th) {
                this.error("EMAIL_MSG_250", new Object[]{htmlComposerClassName, HTML_COMPOSER_CLASS_NAME}, th);
            }
        }
    }

    private void setIncomingMailServer(String hostName) {
        this.incomingMailServer = SBMUtil.getStringValue((String)hostName, (String)this.incomingMailServer);
        try {
            SBMUtil.isValidHost((String)hostName);
        }
        catch (UnknownHostException e) {
            this.throwEmailException("EMAIL_MSG_209", new Object[]{"Incoming Mail Server", hostName});
        }
    }

    private void setIncomingMailPort(String port) {
        if (EmailUtil.isValidProperty(port)) {
            try {
                this.incomingMailPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                this.error("EMAIL_MSG_241", new Object[]{port, String.valueOf(this.incomingMailPort)});
            }
        }
    }

    private void setIncomingMailProtocol(String protocol) {
        if (EmailUtil.isValidProperty(protocol)) {
            if (POP3.equals(protocol = protocol.toLowerCase().trim()) || IMAP.equals(protocol) || IMAPS.equals(protocol) || POP3S.equals(protocol)) {
                this.incomingMailProtocol = protocol;
            } else {
                this.error("EMAIL_MSG_242", new Object[]{protocol, this.incomingMailProtocol});
            }
        }
    }

    private void setIncomingMailUser(String name) {
        if (EmailUtil.isValidProperty(name)) {
            this.incomingMailUser = name;
        } else {
            this.throwEmailException("EMAIL_MSG_236", new Object[]{INCOMING_MAIL_USER});
        }
    }

    private void setIncomingMailPassword(String value) {
        if (EmailUtil.isValidProperty(value)) {
            this.incomingMailPassword = value;
        } else {
            this.throwEmailException("EMAIL_MSG_237", new Object[]{INCOMING_MAIL_PASSWD});
        }
    }

    private void setRemoveChars(Properties props) {
        String eatable;
        this.removeChars = new ArrayList();
        int charCount = 1;
        while (EmailUtil.isValidProperty(eatable = props.getProperty("bizlogic.email.remove.chars." + charCount++))) {
            this.removeChars.add(eatable);
        }
    }

    private void setSleepDuration(String duration) {
        if (EmailUtil.isValidProperty(duration)) {
            try {
                long sleepTime = Long.parseLong(duration);
                if (sleepTime > 1000L) {
                    this.sleepDuration = sleepTime;
                }
            }
            catch (NumberFormatException nfe) {
                this.error("EMAIL_MSG_243", new Object[]{duration, String.valueOf(this.sleepDuration)});
            }
        }
    }

    private void setSubjectPattern(String val) {
        this.subjectPattern = SBMUtil.getStringValue((String)val, (String)this.subjectPattern).toLowerCase();
    }

    private void setDefaultTemplateType(String type) {
        if (EmailUtil.isValidProperty(type)) {
            if (TEMPLATE_TYPE_ETL.equals(type = type.toLowerCase().trim()) || TEMPLATE_TYPE_HTL.equals(type)) {
                this.defTemplateType = type;
            }
        } else {
            this.defTemplateType = TEMPLATE_TYPE_ETL;
        }
    }

    private void setCheckRequiredDS(String val) {
        this.checkRequiredDS = SBMUtil.getBooleanValue((String)val, (boolean)this.checkRequiredDS);
    }

    private void setDecodePlus(String val) {
        this.checkRequiredDS = SBMUtil.getBooleanValue((String)val, (boolean)this.checkRequiredDS);
    }

    private void setSendContentAsAttachment(String val) {
        this.contentAsAttachment = SBMUtil.getBooleanValue((String)val, (boolean)this.contentAsAttachment);
    }

    private void setAttachDocument(String value) {
        this.attachDocument = SBMUtil.getBooleanValue((String)value, (boolean)this.attachDocument);
    }

    private void setDefaultAvailableTemplate() {
        String templatePath = null;
        templatePath = this.isTemplateTypeHtl() ? this.defTemplatePath + AVAILABLE_WI_HTML_TEMPLATE : this.defTemplatePath + AVAILABLE_WI_TEMPLATE;
        if (!this.isValidFile(templatePath, false)) {
            this.throwEmailException("EMAIL_MSG_258", new Object[]{templatePath});
        }
        this.defAvailableTemplate = new EmailTemplate(templatePath);
    }

    private void setDefaultAssignedTemplate() {
        String templatePath = null;
        templatePath = this.isTemplateTypeHtl() ? this.defTemplatePath + ASSIGNED_WI_HTML_TEMPLATE : this.defTemplatePath + ASSIGNED_WI_TEMPLATE;
        if (!this.isValidFile(templatePath, false)) {
            this.throwEmailException("EMAIL_MSG_258", new Object[]{templatePath});
        }
        this.defAssignedTemplate = new EmailTemplate(templatePath);
    }

    private void setDefaultAvailableNotificationTemplate() {
        String templatePath = null;
        templatePath = this.defTemplatePath + AVAILABLE_WI_NOTIFICATION_TEMPLATE;
        if (!this.isValidFile(templatePath, false)) {
            this.throwEmailException("EMAIL_MSG_258", new Object[]{templatePath});
        }
        String content = FileUtil.getString((String)templatePath, (String)SBMUtil.self().getMailCharset());
        this.defAvailableNotificationTemplate = new EmailTemplate(content, "text/plain", false);
    }

    private void setDefaultAssignedNotificationTemplate() {
        String templatePath = null;
        templatePath = this.defTemplatePath + ASSIGNED_WI_NOTIFICATION_TEMPLATE;
        if (!this.isValidFile(templatePath, false)) {
            this.throwEmailException("EMAIL_MSG_258", new Object[]{templatePath});
        }
        String content = FileUtil.getString((String)templatePath, (String)SBMUtil.self().getMailCharset());
        this.defAssignedNotificationTemplate = new EmailTemplate(content, "text/plain", false);
    }

    private EmailTemplate getAssignedTemplate(String basePath) {
        return this.getCustomTemplateByPreference(basePath, ASSIGNED_WI_TEMPLATE, ASSIGNED_WI_HTML_TEMPLATE, "Assigned");
    }

    private EmailTemplate getAvailableTemplate(String basePath) {
        return this.getCustomTemplateByPreference(basePath, AVAILABLE_WI_TEMPLATE, AVAILABLE_WI_HTML_TEMPLATE, "Available");
    }

    private EmailTemplate getCustomTemplateByPreference(String basePath, String etlTemplate, String htlTemplate, String type) {
        EmailTemplate template = null;
        String templatePath = null;
        if (this.isTemplateTypeEtl()) {
            templatePath = basePath + etlTemplate;
            if (!this.isValidFile(templatePath, false)) {
                templatePath = basePath + htlTemplate;
            }
        } else if (this.isTemplateTypeHtl() && !this.isValidFile(templatePath = basePath + htlTemplate, false)) {
            templatePath = basePath + etlTemplate;
        }
        if (this.isValidFile(templatePath, false)) {
            if (this.isDebug()) {
                this.debug("EMAIL_MSG_030", new Object[]{type, templatePath});
            }
            template = new EmailTemplate(templatePath);
        }
        return template;
    }

    private boolean isValidFile(String path, boolean logWarning) {
        boolean isValid;
        File file = new File(path);
        boolean bl = isValid = file.exists() && file.canRead();
        if (!isValid && logWarning) {
            this.warn("EMAIL_MSG_126", new Object[]{path});
        }
        return isValid;
    }

    private void setDebug(String value) {
        debug = SBMUtil.getBooleanValue((String)value, (boolean)debug);
    }

    private void setFillOutputValues(String val) {
        this.fillOutputValues = SBMUtil.getBooleanValue((String)val, (boolean)this.fillOutputValues);
    }

    private void setEmailVarNamePrefix(String val) {
        this.emailVarNamePrefix = SBMUtil.getStringValue((String)val, (String)this.emailVarNamePrefix);
    }

    private void setEmailVarNameSuffix(String val) {
        this.emailVarNameSuffix = SBMUtil.getStringValue((String)val, (String)this.emailVarNameSuffix);
    }

    private void setEmailVarOutputPrefix(String val) {
        this.emailVarOutputPrefix = SBMUtil.getStringValue((String)val, (String)this.emailVarOutputPrefix);
    }

    private void setEmailVarOutputSuffix(String val) {
        this.emailVarOutputSuffix = SBMUtil.getStringValue((String)val, (String)this.emailVarOutputSuffix);
    }

    private void setEmailVarInputPrefix(String val) {
        this.emailVarInputPrefix = SBMUtil.getStringValue((String)val, (String)this.emailVarInputPrefix);
    }

    private void setEmailVarInputSuffix(String val) {
        this.emailVarInputSuffix = SBMUtil.getStringValue((String)val, (String)this.emailVarInputSuffix);
    }

    private void setEmailVarSeperator(String val) {
        this.emailVarSeperator = SBMUtil.getStringValue((String)val, (String)this.emailVarSeperator);
    }

    private void setFromEmailId(String mailId) {
        this.fromEmailId = EmailUtil.isValidProperty(mailId) ? mailId : (EmailUtil.isValidProperty(SBMUtil.self().getAdminEmailId()) ? SBMUtil.self().getAdminEmailId() : BL_EMAIL_ADDRESS);
    }

    private void setSessionDebug(String val) {
        sessionDebug = SBMUtil.getBooleanValue((String)val, (boolean)sessionDebug);
    }

    private void setSeperator(String chr) {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.lineSeperator);
        for (int i = 0; i < 80; ++i) {
            sb.append(chr);
        }
        sb.append(this.lineSeperator);
        this.seperator = sb.toString();
    }

    private void setEmailAdapterReceiver(String receiver) {
        if (EmailUtil.isValidProperty(receiver)) {
            try {
                FileClassLoader loader = new FileClassLoader(this.getClass().getClassLoader(), new String[]{SBMUtil.self().getSBMAppsDir()});
                String[] jarLocs = new String[]{SBMUtil.self().getSBMAppsDir() + "common/lib/"};
                FileClassLoader.setCommonResources(null, (String[])jarLocs);
                this.emailAdapterReceiver = loader.loadClass(receiver);
            }
            catch (Throwable error) {
                this.error("EMAIL_MSG_244", new Object[]{receiver}, error);
            }
        }
    }

    private void setBizSoloTaskUrl(String url) {
        this.bizSoloURL = EmailUtil.isValidProperty(url) ? url : SBMUtil.self().BizSiteLoginURL;
    }

    private void setMessageFactory(String messageFile) {
        try {
            this.msgFactory = MessageFactory.getInstance((String)messageFile);
        }
        catch (Exception msge) {
            throw new RuntimeException(msge);
        }
    }

    public static String replace(String text, String toReplace, String replaceWith) {
        if (text == null || toReplace == null || replaceWith == null || toReplace.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(toReplace, start)) != -1) {
            buf.append(text.substring(start, end)).append(replaceWith);
            start = end + toReplace.length();
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public String getMessage(String messageKey) {
        return this.msgFactory.lookup(messageKey);
    }

    public String getMessage(String messageKey, Object[] args) {
        return this.msgFactory.lookup(messageKey, args);
    }

    public String getDefaultTemplateType() {
        return this.defTemplateType;
    }

    public EmailTemplate getDefaultAvailableTemplate() {
        return this.defAvailableTemplate;
    }

    public EmailTemplate getDefaultAssignedTemplate() {
        return this.defAssignedTemplate;
    }

    public String getDefaultTemplatePath() {
        return this.defTemplatePath;
    }

    public EmailTemplate getDefaultTemplate(int wiState) {
        BLConstants.single();
        if (28 == wiState) {
            return this.getDefaultAssignedTemplate();
        }
        return this.getDefaultAvailableTemplate();
    }

    public static String getChoicePrefix() {
        return DS_CHOICE_PREFIX;
    }

    public EmailTemplate getPerformingAppTemplate(String ptName, String wsName, String perfApp) {
        if (perfApp == null) {
            return null;
        }
        if (!perfApp.toLowerCase().endsWith(".etl") && !perfApp.toLowerCase().endsWith(".htl")) {
            return null;
        }
        String templatePath = SBMUtil.self().getSBMAppsDir() + ptName + "/templates/email/" + wsName + "/" + perfApp;
        EmailTemplate template = null;
        if (this.isValidFile(templatePath, true)) {
            if (this.isDebug()) {
                this.debug("EMAIL_MSG_030", new Object[]{"PerformingApp", templatePath});
            }
            template = new EmailTemplate(templatePath);
        }
        return template;
    }

    public EmailTemplate getCustomTemplate(String ptName, String wsName, int wiState) {
        EmailTemplate template = null;
        String basePath = SBMUtil.self().getSBMAppsDir() + ptName + "/templates/email/" + wsName + "/";
        BLConstants.single();
        template = 28 == wiState ? this.getAssignedTemplate(basePath) : this.getAvailableTemplate(basePath);
        return template;
    }

    public String getCSValues(Collection collection) {
        StringBuilder values = new StringBuilder();
        if (null != collection) {
            Object[] data = collection.toArray();
            for (int idx = 0; idx < data.length; ++idx) {
                values.append(String.valueOf(data[idx]));
                if (idx + 1 >= data.length) continue;
                values.append(",");
            }
        }
        return values.toString();
    }

    public String getBizSoloTaskURL(String workItemName, long workItemId) {
        String taskDetailURL = SBMUtil.self().webHost + this.bizSoloURL;
        return taskDetailURL;
    }

    public static synchronized void setLogger(SBMLogger sbmLogger) {
        logger = sbmLogger;
    }

    public void debug(String messageKey, Object[] args) {
        String msg = this.getMessageFactory().lookup(messageKey, args);
        this.debug(msg);
    }

    public void debug(String message) {
        if (null != logger) {
            logger.debug((Object)message);
        } else {
            LoggerUtil.logSOP((Object)message);
        }
    }

    public void warn(String messageKey, Object[] args) {
        String msg = this.getMessageFactory().lookup(messageKey, args);
        this.warn(msg);
    }

    public void warn(String message) {
        if (null != logger) {
            logger.warn((Object)message);
        } else {
            LoggerUtil.logSOP((Object)message);
        }
    }

    public void info(String messageKey, Object[] args) {
        String msg = this.getMessageFactory().lookup(messageKey, args);
        this.info(msg);
    }

    public void info(String message) {
        if (null != logger) {
            logger.info((Object)message);
        } else {
            LoggerUtil.logSOP((Object)message);
        }
    }

    public void error(String message) {
        if (null != logger) {
            logger.error((Object)message);
        } else {
            LoggerUtil.logSOP((Object)message);
        }
    }

    public void error(String messageKey, Object[] args) {
        String msg = this.getMessageFactory().lookup(messageKey, args);
        this.error(msg);
    }

    public void error(String messageKey, Object[] args, Throwable th) {
        String msg = this.getMessageFactory().lookup(messageKey, args);
        this.error(msg, th);
    }

    public void error(String msg, Throwable th) {
        if (null != logger) {
            logger.error((Object)msg, th);
        } else {
            LoggerUtil.logSOP((Object)msg);
            th.printStackTrace();
        }
    }

    public void logSeperator() {
        this.debug(this.seperator);
    }

    public static boolean isValidProperty(String val) {
        return null != val && val.trim().length() > 0;
    }

    public static boolean isEmpty(String val) {
        return null == val || val.trim().length() == 0;
    }

    public static boolean isDataSlotEmpty(String val) {
        return null == val || val.trim().length() == 0 || BLDS_NULL_VALUE.equals(val.trim());
    }

    public boolean sendAttachmentsWithReply() {
        return false;
    }

    public static String getFormattedDate(long timeMills) {
        return SBMUtil.self().getFormattedDate(timeMills);
    }

    public static String getEncryptedValue(String key) {
        return PService.self().encrypt(key);
    }

    public static String encryptSecurityKey(String target) {
        return EmailUtil.getEncryptedValue(EmailUtil.getEncryptedValue(target));
    }

    public static String getDecryptedValue(String key) {
        return PService.self().decrypt(key);
    }

    public static String decryptSecurityKey(String target) {
        return EmailUtil.getDecryptedValue(EmailUtil.getDecryptedValue(target));
    }

    public static String getDebugKey(String target) {
        String key = EmailUtil.getEncryptedValue(target) + " enc " + target;
        return key;
    }

    public void replyAndDeleteMessage(String messageKey) {
        this.throwEmailException(messageKey, null, true, true, null);
    }

    public void replyAndDeleteMessage(String messageKey, Object[] args) {
        this.throwEmailException(messageKey, args, true, true, null);
    }

    public void replyAndDeleteMessage(String messageKey, Object[] args, Throwable th) {
        this.throwEmailException(messageKey, args, true, true, th);
    }

    public void deleteMessage(String messageKey) {
        this.throwEmailException(messageKey, null, false, true, null);
    }

    public void deleteMessage(String messageKey, Object[] args) {
        this.throwEmailException(messageKey, args, false, true, null);
    }

    public void throwEmailException(String messageKey, Object[] args) {
        this.throwEmailException(messageKey, args, null);
    }

    public void throwEmailException(String messageKey, Object[] args, Throwable th) {
        boolean sendReply = false;
        boolean deleteMail = false;
        this.throwEmailException(messageKey, args, sendReply, deleteMail, th);
    }

    public void throwEmailException(String messageKey, Object[] args, boolean sendReply, boolean deleteEmail, Throwable th) {
        String message = this.getMessage(messageKey, args);
        EmailException mailExcp = new EmailException(message, th);
        this.error(message, mailExcp);
        mailExcp.setSendMail(sendReply);
        mailExcp.setDeleteMail(deleteEmail);
        throw mailExcp;
    }

    public void throwEmailException(String message, Throwable th) {
        EmailException mailExcp = new EmailException(message, th);
        this.error(message, mailExcp);
        mailExcp.setSendMail(true);
        mailExcp.setDeleteMail(true);
        throw mailExcp;
    }

    public static synchronized void clean() {
        REManager.clean();
        self = null;
    }

    private void printConfig() {
        StringBuffer buffer = new StringBuffer(300);
        if (this.startEmailReader) {
            this.putInBuffer(buffer, REMOVE_CHARS, this.getRemoveChars().toString());
            this.putInBuffer(buffer, BACKUP_FOLDER, this.getBackupFolder());
            this.putInBuffer(buffer, ATTACHMENT_FOLDER, this.getAttachmentFolder());
            this.putInBuffer(buffer, INCOMING_MAIL_SERVER, this.getIncomingMailServer());
            this.putInBuffer(buffer, INCOMING_MAIL_PORT, String.valueOf(this.getIncomingMailPort()));
            this.putInBuffer(buffer, INCOMING_MAIL_PROTOCOL, this.getIncomingMailProtocol());
            this.putInBuffer(buffer, INCOMING_MAIL_USER, this.getIncomingMailUser());
            this.putInBuffer(buffer, INCOMING_MAIL_PASSWD, this.getIncomingMailPassword());
            this.putInBuffer(buffer, SLEEP_INTERVAL, String.valueOf(this.getSleepInterval()));
            this.putInBuffer(buffer, INCOMING_MAIL_SERVER, this.getIncomingMailServer());
        }
        this.putInBuffer(buffer, SUBJECT_PATTERN, this.getSubjectPattern());
        this.putInBuffer(buffer, EMAIL_DEBUG, String.valueOf(this.isDebug()));
        this.putInBuffer(buffer, EMAIL_SESSION_DEBUG, String.valueOf(this.isSessionDebug()));
        this.putInBuffer(buffer, EMAILVAR_NAME_PREFIX, this.getEmailVarNamePrefix());
        this.putInBuffer(buffer, EMAILVAR_NAME_SUFFIX, this.getEmailVarNameSuffix());
        this.putInBuffer(buffer, EMAILVAR_OPVALUE_PREFIX, this.getEmailVarOutputPrefix());
        this.putInBuffer(buffer, EMAILVAR_OPVALUE_SUFFIX, this.getEmailVarOutputSuffix());
        this.putInBuffer(buffer, EMAILVAR_IPVALUE_PREFIX, this.getEmailVarInputPrefix());
        this.putInBuffer(buffer, EMAILVAR_IPVALUE_SUFFIX, this.getEmailVarInputSuffix());
        this.putInBuffer(buffer, EMAIL_ADAPTER_RECEIVER, this.getEmailAdapterReceiver());
        this.putInBuffer(buffer, "fromEmailId", this.getFromEmailId());
        this.putInBuffer(buffer, FILL_OUTPUT_VALUES, String.valueOf(this.isFillOutputValues()));
        this.putInBuffer(buffer, EMAIL_REQUIRED_DATASLOTS_CHECK, String.valueOf(this.isCheckRequiredDSEnabled()));
        this.putInBuffer(buffer, EMAIL_DECODEPLUS_OUTPUT_VALUES, String.valueOf(this.isDecodePlusEnabled()));
        this.putInBuffer(buffer, SEND_EMAIL_CONTENT_AS_ATTACHMENT, String.valueOf(this.sendContentAsAttachment()));
        this.putInBuffer(buffer, BIZSOLO_URL, this.bizSoloURL);
        this.debug(buffer.toString());
    }

    private void putInBuffer(StringBuffer buffer, String name, Object value) {
        buffer.append("<").append(name).append("=").append(value).append(">");
        buffer.append(this.getLineSeperator());
    }

    public void printMap(String mapName, Map map) {
        this.debug(this.lineSeperator);
        this.debug("---------------" + mapName + "---------------");
        String key2 = null;
        for (String key2 : map.keySet()) {
            this.debug("    >   " + key2 + "   :   " + map.get(key2));
        }
        this.debug("------------------------------------------------");
        this.debug(this.lineSeperator);
    }

    public static void disconnect(BLServer server, com.savvion.sbm.bizlogic.util.Session session) {
        if (null == server || null == session) {
            return;
        }
        try {
            server.disConnect(session);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Session getIncomingMailSession() {
        Session session = null;
        Properties props = SBMUtil.self().getOutgoingMailServerProps();
        String userName = SBMUtil.self().getOutgoingMailUser();
        String password = SBMUtil.self().getOutgoingMailPassword();
        String outgoingMailProtocol = SBMUtil.self().getOutgoingMailProtocol();
        props.put("mail." + this.incomingMailProtocol + ".connectiontimeout", (Object)this.connectiontimeout);
        props.put("mail." + this.incomingMailProtocol + ".timeout", (Object)this.readtimeout);
        SendEmail.EmailAuthenticator authenticator = null;
        if (EmailUtil.isValidProperty(userName) && password != null) {
            String propPrefix = SBMUtil.self().getOutgoingMailPropPrefix();
            props.put(propPrefix + "auth", "true");
            authenticator = new SendEmail.EmailAuthenticator(userName, password);
        }
        session = Session.getInstance((Properties)props, authenticator);
        SBMConstants.self().getClass();
        session.setProtocolForAddress("rfc822", outgoingMailProtocol);
        return session;
    }

    public String prepareReplyMessage(String content, String performer) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Dear ");
        buffer.append(performer).append(",");
        buffer.append(this.getLineSeperator());
        buffer.append(this.getLineSeperator());
        buffer.append("Could not process your email as it had following error.");
        buffer.append(this.getLineSeperator());
        buffer.append(content);
        buffer.append(this.getLineSeperator());
        buffer.append(this.getLineSeperator());
        buffer.append("Thanks and Regards");
        buffer.append(this.getLineSeperator());
        buffer.append("SBM Administrator");
        return buffer.toString();
    }

    public static boolean isHTTPUrl(String url) {
        return url != null && url.toLowerCase().startsWith("http://");
    }

    public static boolean isValidHtmlUrl(String url) {
        if (url == null) {
            return false;
        }
        String urlLower = url.toLowerCase();
        return urlLower.endsWith(".html") || urlLower.endsWith(".htm") || urlLower.endsWith(".mht");
    }

    public static boolean isValidHtmlTemplateUrl(String url) {
        if (url == null) {
            return false;
        }
        String urlLower = url.toLowerCase();
        return urlLower.endsWith(".htl");
    }

    public String getContent(Part message, int depth) throws Exception {
        String txtCnt;
        Object content;
        if (this.isDebug()) {
            this.debug("EMAIL_MSG_035", new Object[]{message.getContentType(), String.valueOf(depth)});
        }
        if (depth == 25) {
            this.replyAndDeleteMessage("EMAIL_MSG_037", new Object[0]);
        }
        if ((content = message.getContent()) instanceof Multipart) {
            int idx = 0;
            Multipart part = (Multipart)content;
            int count = part.getCount();
            if (idx < count) {
                return this.getContent((Part)part.getBodyPart(idx), ++depth);
            }
        } else if (content instanceof String && (txtCnt = (String)content).indexOf("{EMAIL.SKEY}") != -1) {
            if (this.isDebug()) {
                this.debug("EMAIL_MSG_036", new Object[]{message.getContentType(), String.valueOf(depth)});
            }
            return txtCnt;
        }
        return null;
    }

    public static synchronized String formatWsDate(Date date) {
        return EmailUtil.getSimpleDateFormatter().format(date);
    }

    public static String formatWsDate(long timeMillis) {
        return EmailUtil.formatWsDate(new Date(timeMillis));
    }

    public static String mangleInstanceName(String instanceName) {
        String name = instanceName;
        int hashIndex = instanceName.lastIndexOf("#");
        if (hashIndex > 0) {
            StringBuilder instanceLabel = new StringBuilder(instanceName);
            name = instanceLabel.replace(hashIndex, hashIndex + 1, " (").append(DS_CHOICE_SUFFIX).toString();
        }
        return name;
    }

    public static void main(String[] args) {
        LoggerUtil.logSOP((Object)EmailUtil.mangleInstanceName("prcess"));
    }

    public static String getMessageId(Message message) {
        String messageId = "";
        try {
            String[] arr = message.getHeader("Message-Id");
            if (arr != null && arr.length == 1) {
                messageId = arr[0];
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return messageId;
    }

    public static URL getAbsoluteURL(String baseURL, String filePath) throws MalformedURLException {
        URL url = null;
        if (EmailUtil.isEmpty(baseURL)) {
            throw new MalformedURLException("Url can't be empty !");
        }
        String tmpURL = baseURL.toLowerCase().trim();
        if (!tmpURL.startsWith("file:") && !tmpURL.startsWith("http")) {
            baseURL = "file:///" + baseURL;
        }
        URL base = new URL(baseURL);
        url = new URL(base, filePath);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidURL(String url) {
        boolean bl;
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            bl = true;
        }
        catch (Throwable th) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                throw throwable;
            }
            FileUtil.close((InputStream)is);
            return bl2;
        }
        FileUtil.close((InputStream)is);
        return bl;
    }

    public String decode(String fileName, List validFileNames) {
        String decfileName = null;
        if (fileName == null) {
            return decfileName;
        }
        if (!validFileNames.contains(fileName)) {
            decfileName = CodecUtil.decodeBase64((String)fileName);
            if (null == decfileName || !validFileNames.contains(decfileName)) {
                decfileName = CodecUtil.decodeQuotedPrintable((String)fileName);
            }
        } else {
            return fileName;
        }
        return decfileName;
    }

    public void refresh() {
        Properties props = this.getPropertiesObject(EMAIL_CONF_FILE);
        this.setDebug(props.getProperty(EMAIL_DEBUG));
        this.setFillOutputValues(props.getProperty(FILL_OUTPUT_VALUES));
        HtmlComposer.setPrintOutputValues((boolean)this.fillOutputValues);
        this.setSessionDebug(props.getProperty(EMAIL_SESSION_DEBUG));
        EmailReader.self().setSessionDebug(this.isSessionDebug());
        this.setDefaultTemplateType(props.getProperty(PREFERRED_EMAIL_TEMPLATE_TYPE));
        this.setDefaultAssignedTemplate();
        this.setDefaultAvailableTemplate();
        this.setDefaultAssignedNotificationTemplate();
        this.setDefaultAvailableNotificationTemplate();
        this.setSleepDuration(props.getProperty(SLEEP_INTERVAL));
        EmailReader.self().setSleepTime(this.getSleepInterval());
        this.setRemoveChars(props);
        this.setCheckRequiredDS(props.getProperty(EMAIL_REQUIRED_DATASLOTS_CHECK));
        this.setDecodePlus(props.getProperty(EMAIL_DECODEPLUS_OUTPUT_VALUES));
        this.setSendContentAsAttachment(props.getProperty(SEND_EMAIL_CONTENT_AS_ATTACHMENT));
        this.printRefreshProperties();
    }

    public String decode(String dsName, String dsValue, String emailClientName) {
        if (emailClientName != null && emailClientName.toLowerCase().indexOf(MICROSOFT) != -1 && dsValue != null && dsValue.indexOf("+") != -1) {
            try {
                String preDecodeValue = dsValue;
                SBMConstants.self().getClass();
                dsValue = URLDecoder.decode(dsValue, "UTF-8");
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().debug("EMAIL_MSG_043", new Object[]{preDecodeValue, dsValue});
                }
            }
            catch (Throwable th) {
                EmailUtil.self().warn("EMAIL_MSG_128", new Object[]{dsValue, dsName});
            }
        }
        return dsValue;
    }

    private void printRefreshProperties() {
        StringBuffer buffer = new StringBuffer(300);
        buffer.append("Refreshed following email properties:\n");
        this.putInBuffer(buffer, REMOVE_CHARS, this.getRemoveChars().toString());
        this.putInBuffer(buffer, SLEEP_INTERVAL, String.valueOf(this.getSleepInterval()));
        this.putInBuffer(buffer, EMAIL_DEBUG, String.valueOf(this.isDebug()));
        this.putInBuffer(buffer, EMAIL_SESSION_DEBUG, String.valueOf(this.isSessionDebug()));
        this.putInBuffer(buffer, FILL_OUTPUT_VALUES, String.valueOf(this.isFillOutputValues()));
        this.putInBuffer(buffer, PREFERRED_EMAIL_TEMPLATE_TYPE, this.getDefaultTemplateType());
        this.putInBuffer(buffer, EMAIL_REQUIRED_DATASLOTS_CHECK, String.valueOf(this.isCheckRequiredDSEnabled()));
        this.putInBuffer(buffer, EMAIL_DECODEPLUS_OUTPUT_VALUES, String.valueOf(this.isDecodePlusEnabled()));
        this.putInBuffer(buffer, SEND_EMAIL_CONTENT_AS_ATTACHMENT, String.valueOf(this.sendContentAsAttachment()));
        this.info(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDBConnectionValid() {
        Connection conn = null;
        try {
            conn = SBMDatabase.self().getConnection();
            boolean bl = true;
            return bl;
        }
        catch (Throwable th) {
            boolean bl = false;
            return bl;
        }
        finally {
            SBMDatabase.self().closeConnection(conn);
        }
    }

    public boolean isBizLogicServerRunning() {
        try {
            BLServer server = BLClientUtil.getBizLogicServer();
            return server.ping();
        }
        catch (Throwable th) {
            return false;
        }
    }

    public static String encode(String s) throws UnsupportedEncodingException {
        int caseDiff = 32;
        StringBuilder out = new StringBuilder();
        byte[] ba = s.getBytes("UTF-8");
        for (int j = 0; j < ba.length; ++j) {
            char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - caseDiff);
            }
            out.append(ch);
            ch = Character.forDigit(ba[j] & 0xF, 16);
            if (Character.isLetter(ch)) {
                ch = (char)(ch - caseDiff);
            }
            out.append(ch);
        }
        return out.toString();
    }

    public EmailTemplate getDefaultNotificationTemplate(int wiState) {
        BLConstants.single();
        if (27 == wiState) {
            return this.defAvailableNotificationTemplate;
        }
        return this.defAssignedNotificationTemplate;
    }

    public static boolean isSendNotificationEmail(WFWorkstep ws) {
        WFAtomicWS atomicWS;
        return ws instanceof WFAtomicWS && !(atomicWS = (WFAtomicWS)ws).getEmailSupport() && BLUtil.self().isSendEmailForTask();
    }

    private void setConnectionTimeout(String timeout) {
        if (EmailUtil.isValidProperty(timeout)) {
            try {
                this.connectiontimeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                this.error("EMAIL_MSG_268", new Object[]{timeout, String.valueOf(this.connectiontimeout)});
            }
        }
    }

    private void setReadTimeout(String timeout) {
        if (EmailUtil.isValidProperty(timeout)) {
            try {
                this.readtimeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                this.error("EMAIL_MSG_269", new Object[]{timeout, String.valueOf(this.readtimeout)});
            }
        }
    }

    private static SimpleDateFormat getSimpleDateFormatter() {
        return new SimpleDateFormat(simpleDateFormatStr);
    }
}

