/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.scheduler;

import com.savvion.sbm.bizlogic.scheduler.WorkManagerThreadExecutor;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.logger.LoggerManager;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class TaskExecutorThreadPool
implements ThreadPool {
    private static final SBMLogger logger;
    private String workManagerName;
    private Executor taskExecutor;

    public void setInstanceId(String schedInstId) {
    }

    public void setInstanceName(String schedName) {
    }

    public void initialize() throws SchedulerConfigException {
        try {
            this.taskExecutor = (ExecutorService)new InitialContext().lookup(this.workManagerName);
        }
        catch (NamingException e) {
            throw new IllegalStateException("Could not locate WorkManager: " + e.getMessage(), e);
        }
    }

    public void shutdown(boolean waitForJobsToComplete) {
        throw new UnsupportedOperationException("Shutdown is not supported.");
    }

    public int getPoolSize() {
        return -1;
    }

    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        try {
            this.taskExecutor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException ex) {
            logger.error((Object)"Execution failed", (Throwable)ex);
            return false;
        }
    }

    public int blockForAvailableThreads() {
        return 1;
    }

    public void setWorkManagerName(String workManagerName) {
        this.workManagerName = workManagerName;
    }

    static {
        LoggerManager loggerManager = LoggerManager.self();
        SBMConstants.self().getClass();
        logger = loggerManager.createLogger("BizLogic", "sbmlog.conf", "BLMessages", WorkManagerThreadExecutor.class.getClassLoader());
    }
}

