/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.client.AdapterExecutorNodeCacheService;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFExternalInstance;
import com.savvion.sbm.bizlogic.server.WFExternalWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkStepInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.ep.EPAdapterSB;
import com.savvion.sbm.bizlogic.server.ep.EPAdapterSBHome;
import com.savvion.sbm.bizlogic.server.svo.DataSlotType;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BCLService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicAppException;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.ObjectPoolFactory;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.dcl.FCLService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBHome;

public class EPManager {
    private static final String SYSTEM_DATASLOT = "System Dataslot";
    private static final String HASHTABLE = "Hashtable";
    private static boolean initialized = false;
    private static final String BULK_SET_METHOD = "setAllInputDataslots";
    private static final String BULK_GET_METHOD = "getAllOutputDataslots";
    private static final String SET_PROCESSCONTEXT_METHOD = "setProcessContextData";
    private static final String SET_CALLERINFO_35_METHOD = "PAKcallerID";
    private static final String SET_CALLERINFO_METHOD = "BizLogicCallerID";
    private static final String APPSERVER_HOST_SEP = "_";
    static final String CT = "CT";
    static final String UT = "UT";
    static final String NODE_IDENTIFIER = EPManager.getNodeIdentifier();
    private static ObjectPoolFactory epManagerPool;
    private String ptName;
    private String ptVersion;
    private String piName;
    private String wsName;
    private long ptid;
    private long piid;
    private long wsid;
    private int loopCounter;
    private boolean isSync;
    private boolean txRequired = false;
    private WFProcessContext pCtx;
    private String performer;
    private String performedBy;
    private Map dsTypes;
    private Map inputSlotsMapping;
    private Map outputSlotsMapping;
    private Map inputDS;
    private HashMap inputDSNameValue;
    private boolean hasOutputDS = true;
    private Object epInstanceObj;
    private Class epClassObj;
    private Method performedByMethod;
    private Method setAllMethod;
    private Method getAllMethod;
    private Method setProcessContextMethod;
    private Map setMethods;
    private Map getMethods;
    private static Map<String, Class[]> dsTypeClass;
    private static Map javaTypeClass;
    private static Properties callerInfo;
    private boolean isCompleted = false;
    private boolean onlyPerforming = false;
    private String TRANSACTION_TYPE = "UT";
    private String debugMsg = "";
    private Object[] debugArgs;
    private static final long SLEEP_BEFORE_THROWEX = 45000L;
    private boolean isDuplicateMessage = false;
    private static final String JAVAUTIL = "java.util.";

    public static final synchronized void init() {
        if (initialized) {
            return;
        }
        try {
            epManagerPool = new ObjectPoolFactory(EPManager.class);
            EPManager.setClassForJavaType();
            EPManager.setClassForDataslotType();
            EPManager.setCallerInfoProperties();
            initialized = true;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_925", "EPManager.init", new Object[]{"EPManager"}, th);
        }
    }

    public static final synchronized EPManager getInstance() {
        if (!initialized) {
            return null;
        }
        return (EPManager)epManagerPool.create();
    }

    public static final synchronized void putInstance(EPManager me) {
        FCLService.removeCurrentThreadCL();
        if (epManagerPool == null || me == null) {
            return;
        }
        epManagerPool.remove((Object)me);
    }

    public void execute(HashMap message) throws BizLogicException {
        String adapterInstanceId = null;
        try {
            this.readDataFromMsg(message);
            if (!this.prepareToInvoke(message)) {
                return;
            }
            this.printDetails();
            if (ServiceLocator.self().isEnterpriseCloudMode()) {
                String destConfigName = this.getUseName();
                adapterInstanceId = "" + this.piid + APPSERVER_HOST_SEP + this.wsid;
                AdapterExecutorNodeCacheService.self().addAdapterExecutorNode(adapterInstanceId, message, NODE_IDENTIFIER, destConfigName);
            }
            HashMap outputValues = null;
            outputValues = this.isEnterprise() ? this.processEnterprise() : this.processAdapter();
            this.updateAdapterOutput(outputValues);
            if (ServiceLocator.self().isEnterpriseCloudMode() && adapterInstanceId != null) {
                AdapterExecutorNodeCacheService.self().removeAdapterExecutorNode(adapterInstanceId, NODE_IDENTIFIER);
            }
        }
        catch (BizLogicAppException bae) {
            throw new BizLogicException("BizLogic_ERR_3501", "EPM.execute()", this.getDebugArgs(), (Throwable)bae, false);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_3501", "EPM.execute()", this.getDebugArgs(), th);
        }
        finally {
            if (ServiceLocator.self().isEnterpriseCloudMode() && adapterInstanceId != null) {
                AdapterExecutorNodeCacheService.self().removeAdapterExecutorNode(adapterInstanceId, NODE_IDENTIFIER);
            }
        }
    }

    void readDataFromMsg(Map message) throws BizLogicAppException {
        BLConstants consts = BLControl.consts;
        try {
            this.ptid = (Long)message.get("PROCESSTEMPLATEID");
            this.piid = (Long)message.get("PROCESSINSTANCEID");
            this.wsid = (Long)message.get("WORKSTEPID");
            this.isSync = (Boolean)message.get("SYNCHRONOUS");
            this.loopCounter = (Integer)message.get("LOOPCOUNTER");
            if (BLControl.util.DEBUG_EP) {
                BLControl.logger.debug((Object)("EPM.readDataFromMsg(): " + this.getDebugMsg()));
            }
            this.preLoad();
        }
        catch (Throwable th) {
            throw new BizLogicAppException("BizLogic_ERR_3501", "EPM.readDataFromMsg", this.getDebugArgs(), th);
        }
        finally {
            consts = null;
        }
    }

    public boolean isDuplicateMessage() {
        return this.isDuplicateMessage;
    }

    private void checkDuplicateMessage() throws BizLogicAppException {
        block3: {
            block2: {
                int state = WorkStepInstanceDAO.getWorkstepState(this.piid, this.wsid, this.loopCounter);
                if (state == -1) break block2;
                BLConstants.single();
                if (state != 21) break block3;
            }
            this.isDuplicateMessage = true;
            throw new BizLogicAppException("Bizlogic_ERR_3710", "EPManager.isDuplicateMessage", new Object[]{this.piid, this.wsid, this.loopCounter}, false);
        }
        this.isDuplicateMessage = false;
    }

    boolean prepareToInvoke(HashMap message) throws BizLogicAppException {
        try {
            if (!this.workstepReady(message)) {
                return false;
            }
            this.setMetaData();
            if (!this.isValidPerformer()) {
                throw new BizLogicAppException("BizLogic_ERR_3503", "EPM.prepareToInvoke", this.getDebugArgs());
            }
            WFProcess pt = ProcessControl.getProcessTemplate(this.ptid);
            String ptPerformer = pt.getWorkstep(this.wsid).getPerformer();
            if (ptPerformer != null) {
                if (!this.performer.equalsIgnoreCase(ptPerformer) || this.epInstanceObj == null) {
                    this.epInstanceObj = this.load();
                }
            } else {
                this.epInstanceObj = this.load();
            }
            this.getDataFromBCL();
            this.validate();
            if (!this.isSync && !this.hasOutputDS) {
                this.complete();
                int wsiState = this.pCtx.getWorkstepInstanceEB(this.wsid).getState();
                if (wsiState != 21) {
                    return false;
                }
            }
            this.pCtx.setAdapterInvocationTime(System.currentTimeMillis());
        }
        catch (Throwable tex) {
            throw new BizLogicAppException("BizLogic_ERR_3501", "EPM.prepareToInvoke()", this.getDebugArgs(), tex);
        }
        if (BLControl.util.DEBUG_EP) {
            BLControl.logger.debugKey("BizLogic_ERR_3506", this.getDebugArgs());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap executeUT(HashMap wsidata) throws BizLogicAppException {
        String adapterInstanceId = null;
        try {
            if (ServiceLocator.self().isEnterpriseCloudMode()) {
                String destConfigName = this.getUseName();
                adapterInstanceId = "" + this.piid + APPSERVER_HOST_SEP + this.wsid;
                AdapterExecutorNodeCacheService.self().addAdapterExecutorNode(adapterInstanceId, wsidata, NODE_IDENTIFIER, destConfigName);
            }
            HashMap hashMap = this.processAdapter();
            return hashMap;
        }
        finally {
            if (ServiceLocator.self().isEnterpriseCloudMode() && adapterInstanceId != null) {
                AdapterExecutorNodeCacheService.self().removeAdapterExecutorNode(adapterInstanceId, NODE_IDENTIFIER);
            }
        }
    }

    HashMap processAdapter() throws BizLogicAppException {
        try {
            this.checkServerRunning("process adapter");
            HashMap output = null;
            int retry = 0;
            while (true) {
                try {
                    if (retry > 0) {
                        this.warnKey("Retrying with retry count " + retry);
                    }
                    output = this.invokeAdapter();
                    if (BLControl.util.DEBUG_EP) {
                        BLControl.logger.debug((Object)("processAdapter() completed:" + this.getDebugMsg()));
                    }
                    return output;
                }
                catch (BizLogicAppException e) {
                    this.errorKey("Execution FAILED ", e);
                    BLUtil.fireEvent(WFExternalInstance.self().getEventContext(this.pCtx, this.wsid, 34), (int)34);
                    if (++retry >= BLControl.util.getEPRetries()) {
                        throw e;
                    }
                    try {
                        BLControl.util.sleep(BLControl.util.getEPRetryInterval());
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                break;
            }
        }
        catch (Throwable th) {
            throw new BizLogicAppException("BizLogic_ERR_3501", "EPM.processAdapter", this.getDebugArgs(), th);
        }
    }

    private HashMap invokeAdapter() throws BizLogicAppException {
        if (this.onlyPerforming) {
            return this.invokeOnlyPerforming();
        }
        this.setProcessContext();
        this.setInputSlots();
        if (!this.isSync) {
            this.setCallerInfo();
        }
        this.invokePerformingMethod();
        if (!this.isSync) {
            return null;
        }
        return this.getOutputSlots();
    }

    private void preLoad() {
        try {
            WFProcess pt = ProcessControl.getProcessTemplate(this.ptid);
            this.performer = pt.getWorkstep(this.wsid).getPerformer();
            this.ptName = pt.getName();
            this.ptVersion = pt.getVersion();
            if (!this.isValidPerformer()) {
                return;
            }
            this.epInstanceObj = this.load();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object load() throws BizLogicAppException {
        if (this.isEnterprise()) {
            return null;
        }
        if (BLControl.util.DEBUG_EP) {
            this.debugKey("EP loading begins");
        }
        Object obj = null;
        obj = !this.isRemote() ? this.loadLocal() : (this.isJNDI() ? this.loadJNDI() : this.loadRMI());
        this.epClassObj = obj.getClass();
        if (BLControl.util.DEBUG_EP) {
            this.debugKey("Class Loaded successfully");
        }
        return obj;
    }

    private Object loadLocal() throws BizLogicAppException {
        try {
            FCLService service = BCLService.getService((String)this.ptName);
            Class epClassObj = service.loadClass(this.performer);
            FCLService.setCurrentThreadCL((Class)epClassObj);
            return epClassObj.newInstance();
        }
        catch (Throwable t) {
            throw new BizLogicAppException("BizLogic_ERR_637", "EPManager.loadLocal", new Object[]{this.ptName, this.performer, this.piName}, t);
        }
    }

    private Object loadJNDI() throws BizLogicAppException {
        try {
            Hashtable ejbHash = BLUtil.parseEJBPerformer((String)this.performer, (String)this.piName, (String)this.ptName);
            if (ejbHash == null) {
                throw new BizLogicAppException("BizLogic_ERR_3006", "EPManager.loadJNDI", new Object[]{this.piName, this.performer, this.ptName});
            }
            String appserverName = (String)ejbHash.get("APPSERVER");
            String jndiName = (String)ejbHash.get("JNDINAME");
            if (BLControl.util.DEBUG_EP) {
                StringBuilder msg = new StringBuilder("EPManager.loadJNDI()");
                msg.append("\n APPSERVER=").append(appserverName);
                msg.append("\n JNDINAME=").append(jndiName);
                this.debug(msg.toString());
            }
            if (BLControl.util.useEPAdapter) {
                EPAdapterSBHome epHome = (EPAdapterSBHome)SBMControl.homeFactory.lookupHome(EPAdapterSBHome.class);
                EPAdapterSB epAdapter = epHome.create();
                return epAdapter.connect(this.ptName, appserverName, jndiName);
            }
            FCLService service = BCLService.getService((String)this.ptName);
            Class classObj = BLUtil.getClassObject((FCLService)service, (String)appserverName, (String)jndiName);
            FCLService.setCurrentThreadCL((Class)classObj);
            EJBHome homeObject = SBMControl.homeFactory.lookupHome(appserverName, jndiName, classObj);
            Method m = homeObject.getClass().getMethod("create", new Class[0]);
            return m.invoke((Object)homeObject, new Object[0]);
        }
        catch (Throwable t) {
            throw new BizLogicAppException("BizLogic_ERR_580", "EPManager.loadJNDI", new Object[]{this.performer, this.piName, this.ptName}, t);
        }
    }

    private Object loadRMI() throws BizLogicAppException {
        try {
            return Naming.lookup(this.performer);
        }
        catch (Throwable th) {
            throw new BizLogicAppException("BizLogic_ERR_580", "EPManager.loadRMI", new Object[]{this.performer, this.ptName, this.piName}, th);
        }
    }

    private void validate() throws BizLogicAppException {
        if (this.isEnterprise() || this.isOnlyPerforming()) {
            return;
        }
        this.validateInputSlotMethods();
        this.validatePerformingMethod();
        if (this.isSync) {
            this.validateOutputSlotMethods();
        }
    }

    private void validateInputSlotMethods() throws BizLogicAppException {
        if (BLControl.util.DEBUG_EP) {
            this.debug("EPManager.validateInputSlotMethods()");
        }
        if (this.getBulkSetMethod() || this.inputDS == null || this.inputDS.isEmpty()) {
            return;
        }
        this.setMethods = new HashMap();
        for (Object dsName : this.inputDS.keySet()) {
            this.validateDsTypeClassANdMethod((String)dsName);
        }
    }

    private void validateDsTypeClassANdMethod(String dsName) throws BizLogicAppException {
        String dsMappedName = (String)this.inputSlotsMapping.get(dsName);
        String dsType = (String)this.dsTypes.get(dsName);
        Class[] dsTypeClasses = this.getAllDsTypeClasses(dsName, dsType);
        if (dsTypeClasses == null) {
            if (dsType == null) {
                dsType = SYSTEM_DATASLOT;
            }
            throw new BizLogicAppException("BizLogic_ERR_1550", "EPManager.validateInputSlotMethods", new Object[]{this.piName, dsName, dsType, this.wsName});
        }
        String methodName = EPManager.prepareMethodName(dsName, dsMappedName);
        this.addMethodToSetMethods(dsName, dsTypeClasses, methodName);
    }

    private static String prepareMethodName(String dsName, String dsMappedName) {
        String methodName = dsMappedName;
        if (dsName.equals(dsMappedName)) {
            methodName = "set" + methodName;
        } else if (dsMappedName.startsWith("@")) {
            methodName = dsMappedName.substring(1);
        }
        return methodName;
    }

    private void addMethodToSetMethods(String dsName, Class[] classes, String methodName) throws BizLogicAppException {
        try {
            Method methodObj = null;
            StringBuilder message = new StringBuilder();
            for (Class clazz : classes) {
                try {
                    methodObj = this.epClassObj.getMethod(methodName, clazz);
                }
                catch (NoSuchMethodException | RuntimeException th) {
                    message.append(th.getClass().getName()).append(':').append(th.getMessage()).append('\n');
                }
                if (methodObj != null) break;
            }
            if (methodObj == null) {
                throw new RuntimeException(message.toString());
            }
            this.setMethods.put(dsName, methodObj);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Got the method <" + methodName + ">");
            }
        }
        catch (RuntimeException t) {
            throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.validateInputSlotMethods", new Object[]{this.performer, methodName, this.piName}, (Throwable)t);
        }
    }

    private Class[] getAllDsTypeClasses(String dsName, String dsType) throws BizLogicAppException {
        Class[] clazz = null;
        if (dsType == null) {
            String systemDSName = BLUtil.getParameter((String)dsName);
            clazz = dsTypeClass.get(systemDSName.toUpperCase());
            if (clazz == null) {
                clazz = new Class[]{(Class)javaTypeClass.get("String")};
            }
        } else if (WFDataslot.isCollection(dsType)) {
            Class<?> theClass;
            WFDataslot ds = this.pCtx.getDataslot(dsName);
            String storageFormat = ds.getStorageFormat();
            boolean isJavaCollection = storageFormat.startsWith(JAVAUTIL);
            if (isJavaCollection && (theClass = (Class<?>)javaTypeClass.get(storageFormat)) != null) {
                clazz = EPManager.copyClasses(dsType, theClass);
            }
            if (!isJavaCollection || clazz == null) {
                theClass = null;
                try {
                    theClass = this.epClassObj.getClassLoader().loadClass(storageFormat);
                    if (theClass != null) {
                        clazz = EPManager.copyClasses(dsType, theClass);
                    }
                }
                catch (ClassNotFoundException th) {
                    throw new BizLogicAppException("BizLogic_ERR_3558", "EPManager.validateInputSlotMethods", new Object[]{this.piName, dsName, dsType, this.wsName, storageFormat});
                }
                if (isJavaCollection) {
                    javaTypeClass.put(storageFormat, theClass);
                }
            }
        } else {
            clazz = dsTypeClass.get(dsType);
        }
        return clazz;
    }

    private static Class[] copyClasses(String dsType, Class theClass) {
        Class[] typeClassArray = dsTypeClass.get(dsType);
        Class[] clazz = new Class[typeClassArray.length + 1];
        clazz[0] = theClass;
        System.arraycopy(typeClassArray, 0, clazz, 1, typeClassArray.length);
        return clazz;
    }

    private boolean getBulkSetMethod() {
        try {
            Class[] methSig = new Class[]{(Class)javaTypeClass.get(HASHTABLE)};
            this.setAllMethod = this.epClassObj.getMethod(BULK_SET_METHOD, methSig);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Got the method <setAllInputDataslots>");
            }
            return true;
        }
        catch (NoSuchMethodException | RuntimeException th) {
            this.debugKey("The method <setAllInputDataslots> not implemented");
            return false;
        }
    }

    private void validatePerformingMethod() throws BizLogicAppException {
        if (this.performedBy == null || this.performedBy.trim().length() == 0) {
            this.performedByMethod = null;
            return;
        }
        try {
            this.performedByMethod = this.epClassObj.getMethod(this.performedBy, new Class[0]);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Got the method <" + this.performedBy + ">");
            }
        }
        catch (Throwable t) {
            throw new BizLogicAppException("BizLogic_ERR_1538", "EPManager.validatePerformingMethod", new Object[]{this.performedBy, this.performer, this.piName}, t);
        }
    }

    private boolean isOnlyPerforming() {
        try {
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Trying to get method <" + this.performedBy + "> with ProcessContext as argument");
            }
            Class[] methSig = new Class[]{(Class)javaTypeClass.get("ProcessContext")};
            this.performedByMethod = this.epClassObj.getMethod(this.performedBy, methSig);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Got the method <" + this.performedBy + "> with ProcessContext as argument");
            }
            this.onlyPerforming = true;
        }
        catch (Throwable th) {
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("The method <" + this.performedBy + "> with ProcessContext as argument is not implemented");
            }
            this.onlyPerforming = false;
        }
        return this.onlyPerforming;
    }

    private void validateOutputSlotMethods() throws BizLogicAppException {
        if (BLControl.util.DEBUG_EP) {
            this.debugKey("EPManager.validateOutputSlotMethods()");
        }
        if (!this.hasOutputDS) {
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("NO output slots exist");
            }
            return;
        }
        try {
            this.getAllMethod = this.epClassObj.getMethod(BULK_GET_METHOD, new Class[0]);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Got the method <getAllOutputDataslots>");
            }
            return;
        }
        catch (Throwable th) {
            this.debugKey("The method <getAllOutputDataslots> not implemented");
            String dsMappedName = "";
            String dsName2 = "";
            Method methodObj = null;
            this.getMethods = new HashMap();
            for (String dsName2 : this.outputSlotsMapping.keySet()) {
                String methodName = dsMappedName = (String)this.outputSlotsMapping.get(dsName2);
                if (dsName2.equals(dsMappedName)) {
                    methodName = "get" + methodName;
                }
                try {
                    methodObj = this.epClassObj.getMethod(methodName, new Class[0]);
                    this.getMethods.put(dsName2, methodObj);
                    if (!BLControl.util.DEBUG_EP) continue;
                    this.debugKey("Got the method <" + methodName + ">");
                }
                catch (Throwable t) {
                    throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.validateOutputSlotMethods", new Object[]{this.performer, methodName, this.piName}, t);
                }
            }
            return;
        }
    }

    private void setProcessContext() throws BizLogicAppException {
        Method processCtxMethod;
        block9: {
            processCtxMethod = null;
            try {
                Class[] methSig = new Class[]{(Class)javaTypeClass.get(HASHTABLE)};
                processCtxMethod = this.epClassObj.getMethod(SET_PROCESSCONTEXT_METHOD, methSig);
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Got the method <setProcessContextData>");
                }
            }
            catch (NoSuchMethodException e) {
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("The method <setProcessContextData> not implemented");
                }
            }
            catch (SecurityException e) {
                if (!BLControl.util.DEBUG_EP) break block9;
                BLControl.logger.debugKey("BizLogic_ERR_2127", new Object[]{SET_PROCESSCONTEXT_METHOD, this.performer, this.wsName, this.piName});
            }
        }
        if (processCtxMethod != null) {
            try {
                processCtxMethod.invoke(this.epInstanceObj, this.getProcessContextData());
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Invoked method <setProcessContextData>");
                }
            }
            catch (Throwable t) {
                throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.setProcessContext", new Object[]{this.performer, SET_PROCESSCONTEXT_METHOD, this.piName}, t);
            }
        }
    }

    private void setInputSlots() throws BizLogicAppException {
        if (this.setAllMethod != null) {
            try {
                this.setAllMethod.invoke(this.epInstanceObj, this.getInputSlots());
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Invoked method <setAllInputDataslots>");
                }
                return;
            }
            catch (Throwable t) {
                throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.setInputSlots", new Object[]{this.performer, BULK_SET_METHOD, this.piName}, t);
            }
        }
        if (this.setMethods == null || this.setMethods.isEmpty()) {
            return;
        }
        for (String dsName : this.inputDS.keySet()) {
            Object dsValue = this.inputDS.get(dsName);
            Method method = (Method)this.setMethods.get(dsName);
            try {
                if (dsValue != null && "<NULL>".equals(dsValue)) {
                    dsValue = null;
                }
                if (dsValue instanceof DocumentDS) {
                    this.invokeDocDSMethod(method, (DocumentDS)dsValue);
                } else {
                    method.invoke(this.epInstanceObj, dsValue);
                }
                if (!BLControl.util.DEBUG_EP) continue;
                this.debugKey("Invoked method <" + method.getName() + ">");
            }
            catch (Throwable t) {
                throw new BizLogicAppException("BizLogic_ERR_1577", "EPManager.setInputSlots", new Object[]{this.performer, method.getName(), this.piName}, t);
            }
        }
    }

    private void invokeDocDSMethod(Method method, DocumentDS docDS) throws Exception {
        Class<?> clazz = method.getParameterTypes()[0];
        if (clazz.equals(DocumentDS.class)) {
            method.invoke(this.epInstanceObj, docDS);
        } else if (clazz.equals(Map.class)) {
            method.invoke(this.epInstanceObj, docDS.getAllContents());
        } else {
            throw new BizLogicAppException("BizLogic_ERR_3068", "EPManager.setInputSlots", new Object[]{method.getName(), "DocumentDS, Map<S,byte[]>", clazz.getName()});
        }
    }

    private void setCallerInfo() throws BizLogicAppException {
        Method epMethodObj = null;
        try {
            Class[] methSig = new Class[]{Long.TYPE, Long.TYPE, (Class)javaTypeClass.get("Properties")};
            epMethodObj = this.epClassObj.getMethod(SET_CALLERINFO_METHOD, methSig);
            Object[] methArgs = new Object[]{this.pCtx.getProcessInstanceID(), this.wsid, callerInfo};
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Invoking method <BizLogicCallerID>");
            }
            epMethodObj.invoke(this.epInstanceObj, methArgs);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Invoked method <BizLogicCallerID>");
            }
        }
        catch (Throwable e) {
            try {
                Properties tempCallerInfo = new Properties(callerInfo);
                tempCallerInfo.setProperty("JNDI_NAME", "BizLogicManager");
                Class[] methSig = new Class[]{(Class)javaTypeClass.get("String"), (Class)javaTypeClass.get("String"), (Class)javaTypeClass.get("Properties")};
                epMethodObj = this.epClassObj.getMethod(SET_CALLERINFO_35_METHOD, methSig);
                Object[] methArgs = new Object[]{this.piName, this.wsName, tempCallerInfo};
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Invoking method <PAKcallerID>");
                }
                epMethodObj.invoke(this.epInstanceObj, methArgs);
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Invoked method <PAKcallerID>");
                }
            }
            catch (Throwable ex) {
                throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.setCallerInfo", new Object[]{this.performer, "BizLogicCallerID|PAKcallerID", this.piName}, ex);
            }
        }
    }

    private void invokePerformingMethod() throws BizLogicAppException {
        if (this.performedByMethod == null) {
            return;
        }
        try {
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Invoking method <" + this.performedBy + ">");
            }
            this.performedByMethod.invoke(this.epInstanceObj, new Object[0]);
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Invoked method <" + this.performedBy + ">");
            }
        }
        catch (Throwable t) {
            throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.invokePerformingMethod", new Object[]{this.performer, this.performedBy, this.piName}, t);
        }
    }

    private HashMap invokeOnlyPerforming() throws BizLogicAppException {
        if (this.performedByMethod == null) {
            return null;
        }
        HashMap contextInfo = new HashMap();
        Hashtable data = this.getProcessContextData();
        Hashtable mapDataSlots = (Hashtable)data.get("MappedInputDataslots");
        data.put("MappedInputDataslots", new HashMap(mapDataSlots));
        mapDataSlots = (Hashtable)data.get("MappedOutputDataslots");
        data.put("MappedOutputDataslots", new HashMap(mapDataSlots));
        mapDataSlots = (Hashtable)data.get("DataslotTypes");
        data.put("DataslotTypes", new HashMap(mapDataSlots));
        contextInfo.put("ProcessContext", new HashMap(data));
        contextInfo.put("InputSlots", new HashMap(this.getInputSlots()));
        if (!this.isSync) {
            contextInfo.put("CallerInfo", BLControl.getCallerInfo());
        }
        Map output = null;
        try {
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Invoking method <" + this.performedBy + "> with PC as argument");
            }
            output = (Map)this.performedByMethod.invoke(this.epInstanceObj, new ProcessContext(contextInfo));
            if (BLControl.util.DEBUG_EP) {
                this.debugKey("Invoked method <" + this.performedBy + "> with PC as argument");
            }
        }
        catch (Throwable t) {
            throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.invokeOnlyPerforming", new Object[]{this.performer, this.performedBy, this.piName}, t);
        }
        if (this.isSync) {
            return this.verifyOutputSlots(output);
        }
        return null;
    }

    private HashMap getOutputSlots() throws BizLogicAppException {
        if (this.getAllMethod != null) {
            try {
                Map output = (Map)this.getAllMethod.invoke(this.epInstanceObj, new Object[0]);
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Invoked method <getAllOutputDataslots>");
                }
                return this.verifyOutputSlots(output);
            }
            catch (Throwable t) {
                throw new BizLogicAppException("BizLogic_ERR_1576", "EPManager.getOutputSlots", new Object[]{this.performer, BULK_GET_METHOD, this.piName}, t);
            }
        }
        if (this.getMethods == null || this.getMethods.isEmpty()) {
            return null;
        }
        Method method = null;
        try {
            HashMap<String, Object> dsValues = new HashMap<String, Object>();
            for (String dsName : this.outputSlotsMapping.keySet()) {
                String dsType = (String)this.dsTypes.get(dsName);
                method = (Method)this.getMethods.get(dsName);
                Object value = method.invoke(this.epInstanceObj, new Object[0]);
                if (BLControl.util.DEBUG_EP) {
                    this.debugKey("Invoked method <" + method.getName() + ">");
                }
                if ("DECIMAL".equals(dsType)) {
                    dsValues.put(dsName, Decimal.getInstance((BigDecimal)value));
                    continue;
                }
                if ("XML".equals(dsType)) {
                    XML xmlDSValue;
                    dsValues.put(dsName, new XML((String)value));
                    if (this.inputDSNameValue == null || this.inputDSNameValue.isEmpty() || !this.inputDSNameValue.containsKey(dsName) || (xmlDSValue = (XML)this.inputDSNameValue.get(dsName)) == null) continue;
                    xmlDSValue.setContent((String)value);
                    dsValues.put(dsName, xmlDSValue);
                    continue;
                }
                if ("DATETIME".equals(dsType)) {
                    dsValues.put(dsName, new DateTime((Timestamp)value));
                    continue;
                }
                dsValues.put(dsName, value);
            }
            return dsValues;
        }
        catch (Throwable t) {
            if (method != null) {
                throw new BizLogicAppException("BizLogic_ERR_1577", "EPManager.setOutputSlots", new Object[]{this.performer, method.getName(), this.piName}, t);
            }
            throw new BizLogicAppException("BizLogic_ERR_1577", "EPManager.setOutputSlots", new Object[]{this.performer, null, this.piName}, t);
        }
    }

    private HashMap verifyOutputSlots(Map output) {
        if (!this.hasOutputDS) {
            return null;
        }
        if (output == null) {
            BLControl.logger.warnKey("BizLogic_ERR_641", "EPManager.verifyOutputSlots", new Object[]{this.ptName, this.wsName, this.performer});
            return null;
        }
        if (BLControl.util.DEBUG_EP) {
            this.checkMissingOutputSlots(output);
        }
        HashMap<String, DataSlotType> map = new HashMap<String, DataSlotType>(output.size());
        String dsName2 = null;
        String dsMappedName = null;
        String dsType = null;
        Object value = null;
        for (String dsName2 : this.outputSlotsMapping.keySet()) {
            dsMappedName = (String)this.outputSlotsMapping.get(dsName2);
            if (!output.containsKey(dsMappedName)) continue;
            value = output.get(dsMappedName);
            dsType = (String)this.dsTypes.get(dsName2);
            if ("DECIMAL".equals(dsType) && value instanceof BigDecimal) {
                map.put(dsName2, Decimal.getInstance((BigDecimal)value));
                continue;
            }
            if ("XML".equals(dsType) && value instanceof String) {
                map.put(dsName2, new XML((String)value));
                continue;
            }
            if ("DATETIME".equals(dsType) && value instanceof Timestamp) {
                map.put(dsName2, new DateTime((Timestamp)value));
                continue;
            }
            map.put(dsName2, (DataSlotType)value);
        }
        return map;
    }

    private void checkMissingOutputSlots(Map output) {
        StringBuilder missingDataSlots = new StringBuilder();
        for (Object mappedDataslot : this.outputSlotsMapping.values()) {
            if (output.containsKey(mappedDataslot)) continue;
            String missingDSName = mappedDataslot.toString();
            missingDataSlots.append(missingDSName);
            missingDataSlots.append(",");
        }
        if (missingDataSlots.length() != 0) {
            missingDataSlots.deleteCharAt(missingDataSlots.length() - 1);
            BLControl.logger.debugKey("BizLogic_ERR_1578", new Object[]{missingDataSlots.toString(), this.piName, this.wsName});
        }
    }

    void updateAdapterOutput(HashMap output) throws BizLogicAppException {
        this.checkServerRunning("update adapter output dataslots");
        if (!this.isSync) {
            return;
        }
        try {
            this.pCtx.setCurrentWorkStepID(this.wsid);
            this.pCtx.updateSlotValue(output);
            this.checkDuplicateMessage();
            this.complete();
            if (BLControl.util.DEBUG_EP) {
                BLControl.logger.debug((Object)("updateAdapterOutput() completed:" + this.getDebugMsg()));
            }
        }
        catch (Throwable th) {
            this.isCompleted = false;
            throw new BizLogicAppException("BizLogic_ERR_3502", "EPM.updateAdapterOutput", this.getDebugArgs(), th);
        }
    }

    HashMap processEnterprise() throws BizLogicAppException {
        HashMap outputValues = this.invokeEnterprise();
        if (outputValues == null) {
            if (!this.isCompleted) {
                this.suspend(null);
            }
            return null;
        }
        return outputValues;
    }

    private HashMap invokeEnterprise() throws BizLogicAppException {
        if (BLControl.util.EE == null) {
            BLControl.logger.warnKey("BizLogic_ERR_631", null);
            return null;
        }
        try {
            String channel = this.performer.substring("b2b://".length(), this.performer.lastIndexOf("/"));
            int i = this.performer.lastIndexOf(47);
            String epName = this.performer.substring(i + 1);
            String receiver = this.performer.substring(0, i);
            if (BLControl.util.DEBUG_EP) {
                this.debug(" *** Following Data is being send to Enterprise EP ***");
                this.debug("    channel=" + channel);
                this.debug("    piName=" + this.piName);
                this.debug("    wsName=" + this.wsName);
                this.debug("    EPname=" + epName);
                this.debug("    inputDS=" + this.inputDS.toString());
                this.debug("    performedBy=" + this.performedBy);
                this.debug("    outputSlotsMapping=" + this.outputSlotsMapping.toString());
                this.debug("*****************************************************");
            }
            Hashtable output = BLControl.util.EE.callRemoteEP(channel, receiver, this.piName, this.wsName, epName, (Hashtable)this.inputDS, this.performedBy, (Hashtable)this.outputSlotsMapping);
            HashMap outputValues = new HashMap(output);
            return outputValues;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_630", "EPManager.invokeEnterprise", new Object[]{this.performer}, th);
        }
    }

    private void complete() {
        if (BLControl.util.DEBUG_EP) {
            this.debugKey("Completing");
        }
        this.pCtx.completeWorkstep(this.wsid);
        this.isCompleted = true;
    }

    void suspend(Throwable causedBy) {
        if (!BLControl.isServerReady()) {
            this.checkServerRunning("suspend adapter");
        }
        if (!this.isValidProcessInstance()) {
            return;
        }
        try {
            if (this.pCtx != null) {
                BLUtil.getServiceLocal().suspendAdapter(this.pCtx, this.wsid, causedBy);
            } else {
                BLUtil.getServiceLocal().suspendAdapter(this.piid, this.wsid, causedBy);
            }
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_8011", "EPManager.suspend()", new Object[]{"suspending", this.wsName, this.loopCounter, this.piName, this.ptName}, th);
        }
    }

    public static void suspend(WFProcessContext pCtx, long wsid, Throwable causedBy) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setSuspendState(3);
        pCtx.suspendWorkstep(wsid, true, causedBy, null);
        BLUtil.fireEvent(WFExternalInstance.self().getEventContext(pCtx, wsid, 35), (int)35);
    }

    private boolean isRemote() {
        return this.performer.indexOf("//") != -1 || this.performer.indexOf("\\") != -1;
    }

    private boolean isJNDI() {
        if (this.performer == null) {
            return false;
        }
        return this.performer.toUpperCase().startsWith("jndi://".toUpperCase());
    }

    private boolean isValidPerformer() {
        if (this.performer == null || this.performer.trim().length() == 0) {
            BLControl.logger.errorKey("BizLogic_ERR_600", new Object[]{this.piName, this.performer, this.wsName});
            return false;
        }
        return true;
    }

    boolean isEnterprise() {
        BLConstants.single();
        return this.performer.startsWith("b2b://");
    }

    private Hashtable getProcessContextData() {
        Hashtable<String, Object> processCtx = new Hashtable<String, Object>();
        processCtx.put("ProcessTemplateName", this.ptName);
        processCtx.put("ProcessTemplateVersion", this.ptVersion);
        processCtx.put("ProcessInstanceName", this.piName);
        processCtx.put("WorkstepName", this.wsName);
        processCtx.put("ProcessInstanceID", this.piid);
        processCtx.put("WorkstepID", this.wsid);
        processCtx.put("MappedInputDataslots", this.reverse(this.inputSlotsMapping));
        processCtx.put("MappedOutputDataslots", this.reverse(this.outputSlotsMapping));
        processCtx.put("DataslotTypes", this.dsTypes);
        processCtx.put("SYNCHRONOUS", this.isSync);
        processCtx.put("LOOPCOUNTER", this.loopCounter);
        return processCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCallerInfoProperties() {
        Class<EPManager> clazz = EPManager.class;
        synchronized (EPManager.class) {
            callerInfo = new Properties();
            // ** MonitorExit[var0] (shouldn't be in output)
            Properties sbmJNDIProps = ServiceLocator.self().getJNDIProperty();
            String defaultAppServer = ServiceLocator.self().getAppServerID();
            String str = new StringBuffer("sbm.").append(defaultAppServer).append(".").toString();
            callerInfo.put("INITIAL_FACTORY", sbmJNDIProps.getProperty(str + "factory.initial"));
            callerInfo.put("PROVIDER_URL", sbmJNDIProps.getProperty(str + "provider.url"));
            callerInfo.put("PRINCIPAL", sbmJNDIProps.getProperty(str + "principal"));
            callerInfo.put("CREDENTIALS", sbmJNDIProps.getProperty(str + "credentials"));
            callerInfo.put("APPSERVER", defaultAppServer);
            if (defaultAppServer.indexOf(APPSERVER_HOST_SEP) != -1) {
                callerInfo.put("APPSERVER", defaultAppServer.substring(0, defaultAppServer.indexOf(APPSERVER_HOST_SEP)));
            }
            callerInfo.put("JNDI_NAME", "ejb/" + BLServerHome.class.getName());
            return;
        }
    }

    private void setMetaData() {
        this.pCtx = new WFProcessContext(BLControl.getServerSession(), this.ptid, this.piid);
        WFExternalWS ws = (WFExternalWS)this.pCtx.getWorkstep(this.wsid);
        this.ptName = this.pCtx.getProcessTemplateName();
        this.piName = this.pCtx.getProcessInstanceName();
        this.wsName = ws.getName();
        this.performer = this.pCtx.getWorkstepRealPerformer(this.wsid, this.pCtx.getWorkstepInstanceEB(this.wsid).getPerformer());
        this.performedBy = ws.getPerformedBy();
        this.txRequired = BLControl.util.isAdapterTxRequired();
    }

    private void getDataFromBCL() throws RemoteException, BizLogicClientException {
        this.dsTypes = BLUtil.convertToHashtable((HashMap)this.pCtx.getSlotsType());
        this.inputSlotsMapping = BLUtil.convertToHashtable((HashMap)this.pCtx.getWorkstep(this.wsid).getInputSlotsMapping());
        this.outputSlotsMapping = BLUtil.convertToHashtable((HashMap)this.pCtx.getWorkstep(this.wsid).getOutputSlotsMapping());
        HashMap inputDSlots = this.pCtx.getWorkstepInputSlotValueList(this.wsid);
        this.inputDS = new Hashtable();
        this.inputDSNameValue = new HashMap();
        if (inputDSlots != null) {
            for (String dsName : inputDSlots.keySet()) {
                Object dsValue = inputDSlots.get(dsName);
                String dsType = (String)this.dsTypes.get(dsName);
                if ("DECIMAL".equals(dsType)) {
                    dsValue = ((Decimal)dsValue).getValue();
                } else if ("XML".equals(dsType)) {
                    this.inputDSNameValue.put(dsName, dsValue);
                    dsValue = ((XML)dsValue).getContent(this.pCtx.getSession());
                } else if ("DATETIME".equals(dsType)) {
                    dsValue = ((DateTime)dsValue).getValue();
                }
                if (dsValue == null) {
                    dsValue = "<NULL>";
                }
                this.inputDS.put(dsName, dsValue);
            }
        }
        this.hasOutputDS = this.outputSlotsMapping != null && !this.outputSlotsMapping.isEmpty();
    }

    private Hashtable getInputSlots() {
        if (this.inputDS == null) {
            return new Hashtable();
        }
        Hashtable ht = new Hashtable(this.inputDS.size());
        for (String dsName : this.inputDS.keySet()) {
            Object dsValue = this.inputDS.get(dsName);
            ht.put(this.inputSlotsMapping.get(dsName), dsValue);
        }
        return ht;
    }

    void checkServerRunning(String context) {
        if (BLControl.isServerReady()) {
            return;
        }
        String msg = "Cannot <" + context + "> <" + this.wsName + "> with loopcounter <" + this.loopCounter + "> of Process Instance <" + this.piName + "> and ProcessTemplate <" + this.ptName + "> as BizLogic server is not running.";
        if (BLControl.logger == null) {
            LoggerUtil.logSOP((Object)msg);
        }
        this.sleep();
        throw new RuntimeException(msg);
    }

    private boolean workstepReady(Map<Object, Object> message) {
        if (!ProcessControl.isProcessTemplateExist(this.ptid)) {
            BLControl.logger.errorKey("BizLogic_ERR_8013", new Object[]{this.ptName, message});
            return false;
        }
        Boolean terminate = this.processTillMaxRetry(message);
        if (terminate != null) {
            return terminate;
        }
        if (this.checkProcessCompleted() || this.checkIfEventExist(message)) {
            return false;
        }
        WFProcess processTemplate = ProcessControl.getProcessTemplate(this.ptid);
        WFWorkstep wfws = processTemplate.getWorkstep(this.wsid);
        if (!wfws.isInLineTask()) {
            this.repostMsg((HashMap)message);
        } else {
            BLControl.logger.errorKey("BizLogic_ERR_4710", "EPManager.workstepReady()", new Object[]{this.ptid, this.piid, this.wsid, this.wsName});
        }
        return false;
    }

    private Boolean processTillMaxRetry(Map<Object, Object> message) {
        int loopCounter = this.getLoopCounter(message);
        boolean firstTime = true;
        for (long totSleepTime = 0L; totSleepTime < BLUtil.self().getMsgRetryMaxTime(); totSleepTime += BLUtil.self().getMsgRetryInterval()) {
            try {
                if (BLControl.util.isSleepFirst() && firstTime) {
                    Thread.sleep(BLControl.util.SLEEP_FIRST_INTERVAL);
                    firstTime = false;
                }
                if (this.isWsiactivated(loopCounter)) {
                    return true;
                }
                long jmsTimeStamp = (Long)message.get("JMSTIMESTAMP");
                long msgSendBeforeTime = System.currentTimeMillis() - jmsTimeStamp;
                if (BLControl.util.DEBUG_EP) {
                    BLControl.logger.debugKey("BizLogic_ERR_4685", "EPManager.workstepReady()", new Object[]{jmsTimeStamp, System.currentTimeMillis(), msgSendBeforeTime});
                }
                if (jmsTimeStamp > 0L && msgSendBeforeTime > BLControl.util.getMsgDiscardAfterInterval()) {
                    BLControl.logger.warnKey("BizLogic_ERR_4683", "EPManager.workstepReady()", new Object[]{this.ptid, this.piid, this.wsid, BLControl.util.getMsgDiscardAfterInterval() / 1000L, jmsTimeStamp, System.currentTimeMillis()});
                    return false;
                }
                Thread.sleep(BLUtil.self().getMsgRetryInterval());
            }
            catch (InterruptedException | RuntimeException th) {
                this.throwExIfDBNotReady("EPManager.workstepReady()", "execute", th);
            }
            if (!ServiceLocator.self().isWebsphere() || !BLControl.util.DEBUG_EP) continue;
            BLControl.logger.debugKey("BizLogic_ERR_3220", new Object[]{this.piid, this.wsid, loopCounter});
        }
        return null;
    }

    private boolean isWsiactivated(int loopCounter) {
        boolean wsiactivated = false;
        wsiactivated = loopCounter > 0 ? WFWorkstepInstance.single().isActivated(this.piid, this.wsid, loopCounter) : WFWorkstepInstance.single().isActivated(this.piid, this.wsid);
        return wsiactivated;
    }

    private boolean checkProcessCompleted() {
        try {
            if (WFWorkstepInstance.single().isCompleted(this.piid, this.wsid)) {
                BLControl.logger.warnKey("BizLogic_ERR_4711", "EPManager.workstepReady()", new Object[]{this.ptid, this.piid, this.wsid});
                return true;
            }
        }
        catch (RuntimeException th) {
            this.throwExIfDBNotReady("EPManager.workstepReady()", "execute", th);
        }
        return false;
    }

    private boolean checkIfEventExist(Map<Object, Object> message) {
        try {
            if (!ProcessInstanceDAO.isProcessInstanceExist(this.piid)) {
                int repeatMsgCount = this.getRepeatMsgCount((HashMap)message);
                BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{this.piid, "external", this.wsid, repeatMsgCount});
                if (ProcessInstanceDAO.isEventExistForPI(this.piid)) {
                    BLControl.logger.warnKey("BizLogic_ERR_4684", "EPManager.workstepReady()", new Object[]{this.ptid, this.piid, this.wsid});
                    return true;
                }
            }
        }
        catch (RuntimeException th) {
            this.throwExIfDBNotReady("EPManager.workstepReady()", "execute", th);
            BLControl.logger.errorKey("BizLogic_ERR_3725", new Object[]{this.piid, this.wsName, this.wsid, "EPManager.workstepReady()"}, (Throwable)th);
        }
        return false;
    }

    private int getLoopCounter(Map<Object, Object> message) {
        try {
            return (Integer)message.get("LOOPCOUNTER");
        }
        catch (RuntimeException th) {
            if (BLControl.util.DEBUG_EP) {
                BLControl.logger.debugKey("BizLogic_ERR_2127", "Error fetching loop counter from message", new Object[0]);
            }
            return 0;
        }
    }

    private boolean isValidProcessInstance() {
        try {
            if (ProcessInstanceDAO.isProcessInstanceExist(this.piid)) {
                return true;
            }
            BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{this.piid, "external", this.wsid});
            if (ProcessInstanceDAO.isEventExistForPI(this.piid)) {
                BLControl.logger.warnKey("BizLogic_ERR_4684", "EPManager.isValidProcessInstance()", new Object[]{this.ptid, this.piid, this.wsid});
                return false;
            }
            throw new BizLogicException("BizLogic_ERR_8071", "EPManager.isValidProcessInstance()", new Object[]{this.piid});
        }
        catch (BizLogicException blException) {
            throw blException;
        }
        catch (Throwable th) {
            throw new BizLogicException(BLControl.logger.getMessage("BizLogic_ERR_3725", new Object[]{this.piid, this.wsName, this.wsid, "EPManager.isValidProcessInstance()"}), th);
        }
    }

    private void throwExIfDBNotReady(String context, String stage, Throwable th) {
        if (!BLDAOService.isDBReady()) {
            this.sleep();
            throw new BizLogicException("BizLogic_ERR_8012", context, new Object[]{stage, this.wsid, this.loopCounter, this.piName, this.ptName}, th);
        }
    }

    private void sleep() {
        try {
            Thread.currentThread();
            Thread.sleep(45000L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getUseName() {
        String useName;
        WFProcess pt = ProcessControl.getProcessTemplate(this.ptid);
        WFExternalWS wfews = (WFExternalWS)pt.getWorkstep(this.wsid);
        if (wfews.isEnterpriseAdapter()) {
            BLConstants.single();
            useName = "enterpriseadapter";
        } else {
            BLConstants.single();
            useName = "ep";
        }
        return useName;
    }

    boolean isAdapterTxRequired() {
        return this.txRequired;
    }

    void setTransactionType(String type) {
        this.TRANSACTION_TYPE = type;
    }

    boolean isSync() {
        return this.isSync;
    }

    private void repostMsg(HashMap message) {
        try {
            int repeatMsgCount = this.getRepeatMsgCount(message);
            int maxRetryCount = BLControl.util.getMsgRetryMaxCount();
            if (repeatMsgCount <= maxRetryCount) {
                if (repeatMsgCount == maxRetryCount) {
                    BLControl.logger.warnKey("BizLogic_ERR_2146", new Object[]{repeatMsgCount, this.piid, this.wsid, "EPManager.repostMsg()"});
                }
                BLControl.logger.warnKey("BizLogic_ERR_1008", new Object[]{repeatMsgCount, this.piid, this.wsid, "EPManager.repostMsg()"});
                BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
                message.put("REPEAT_MSG_COUNT", ++repeatMsgCount);
                BLControl.util.epHandler.notify(message, this.getUseName());
            } else {
                BLControl.logger.errorKey("BizLogic_ERR_2147", new Object[]{repeatMsgCount, this.piid, this.wsid, "EPManager.repostMsg()"});
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            this.throwExIfDBNotReady("EPManager.repostMsg()", "execute", th);
        }
    }

    private int getRepeatMsgCount(HashMap message) {
        int repeatMsgCount = 0;
        try {
            BLConstants.ClusterConstants cfr_ignored_0 = BLControl.consts.cluster;
            repeatMsgCount = (Integer)message.get("REPEAT_MSG_COUNT");
        }
        catch (Throwable th) {
            BLControl.logger.errorKey("BizLogic_ERR_3724", new Object[]{this.piid, this.wsName, this.wsid, "EPManager.getRepeatMsgCount()"}, th);
        }
        return repeatMsgCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setClassForDataslotType() {
        Class<String> stringClass = String.class;
        Class<EPManager> clazz = EPManager.class;
        synchronized (EPManager.class) {
            dsTypeClass = new HashMap<String, Class[]>();
            dsTypeClass.put("ALLDATASLOTS", new Class[]{Object.class});
            dsTypeClass.put("STARTTIME", new Class[]{Long.TYPE});
            dsTypeClass.put("PROCESS_INSTANCE_ID", new Class[]{Long.TYPE});
            dsTypeClass.put("LONG", new Class[]{Long.TYPE});
            dsTypeClass.put("DOUBLE", new Class[]{Double.TYPE});
            dsTypeClass.put("BOOLEAN", new Class[]{Boolean.TYPE});
            dsTypeClass.put("STRING", new Class[]{stringClass});
            dsTypeClass.put("DOCUMENT", new Class[]{DocumentDS.class, Map.class});
            dsTypeClass.put("OBJECT", new Class[]{Object.class});
            dsTypeClass.put("URL", new Class[]{stringClass});
            dsTypeClass.put("DECIMAL", new Class[]{BigDecimal.class});
            dsTypeClass.put("XML", new Class[]{stringClass});
            dsTypeClass.put("DATETIME", new Class[]{Timestamp.class});
            dsTypeClass.put("SET", new Class[]{Collection.class});
            dsTypeClass.put("LIST", new Class[]{Collection.class});
            dsTypeClass.put("MAP", new Class[]{Map.class});
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setClassForJavaType() {
        Class<EPManager> clazz = EPManager.class;
        synchronized (EPManager.class) {
            javaTypeClass = new HashMap();
            javaTypeClass.put(HASHTABLE, Hashtable.class);
            javaTypeClass.put("String", String.class);
            javaTypeClass.put("Properties", Properties.class);
            javaTypeClass.put("ProcessContext", ProcessContext.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private Hashtable reverse(Map sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        Hashtable newMap = new Hashtable();
        for (Object key : sourceMap.keySet()) {
            Object value = sourceMap.get(key);
            newMap.put(value, key);
        }
        return newMap;
    }

    void printDetails() {
        if (BLControl.util.DEBUG_EP) {
            StringBuilder msg = new StringBuilder();
            msg.append(" ********** Details of EP are **************");
            msg.append("\n    PTNAME=" + this.ptName);
            msg.append("\n    PINAME=" + this.piName);
            msg.append("\n    WSNAME=" + this.wsName);
            msg.append("\n    LOOPCOUNTER=" + this.loopCounter);
            msg.append("\n    PERFORMER=" + this.performer);
            msg.append("\n    PERFORMEREDBY=" + this.performedBy);
            msg.append("\n    SYNCHRONOUS=" + this.isSync);
            msg.append("\n**********************************************");
            this.debug(msg.toString());
        }
    }

    String getDebugMsg() {
        if (this.debugMsg == null) {
            this.debugMsg = BLControl.logger.getMessage("BizLogic_ERR_3507", this.getDebugArgs());
        }
        return this.debugMsg;
    }

    Object[] getDebugArgs() {
        if (this.piName == null || this.debugArgs == null) {
            this.debugArgs = new Object[]{this.piid, this.wsid, this.loopCounter, this.TRANSACTION_TYPE, Thread.currentThread().getName()};
        } else if (!this.debugArgs[1].equals(this.wsName)) {
            this.debugArgs[0] = this.piName;
            this.debugArgs[1] = this.wsName;
            this.debugMsg = null;
        }
        return this.debugArgs;
    }

    private final void debugKey(String msg) {
        BLControl.logger.debugKey("BizLogic_ERR_2126", new Object[]{msg, this.wsName, this.piName});
    }

    private final void errorKey(String msg, Throwable th) {
        BLControl.logger.errorKey("BizLogic_ERR_2126", new Object[]{msg, this.wsName, this.piName}, th);
    }

    private final void warnKey(String msg) {
        BLControl.logger.warnKey("BizLogic_ERR_2126", new Object[]{msg, this.wsName, this.piName});
    }

    private final void debug(String message) {
        BLControl.logger.debug((Object)message);
    }

    private static final String getNodeIdentifier() {
        String awsInstanceId;
        if (ServiceLocator.self().isEnterpriseCloudMode() && (awsInstanceId = EPManager.getAWSId()) != null) {
            return awsInstanceId;
        }
        return EPManager.getHostIPAddress();
    }

    private static final String getHostIPAddress() {
        try {
            InetAddress IP = InetAddress.getLocalHost();
            String hostAddress = IP.getHostAddress();
            return hostAddress;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static final String getAWSId() {
        String awsInstanceIdProviderURL = ServiceLocator.self().getJNDIProperty().getProperty("sbm.enterprise.cloud.aws.instanceId.provider.url");
        if (awsInstanceIdProviderURL != null) {
            HttpURLConnection conn = null;
            try {
                URL url = new URL(awsInstanceIdProviderURL);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "text/plain");
                if (conn.getResponseCode() == 200) {
                    String output;
                    BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((output = br.readLine()) != null) {
                        sb.append(output);
                    }
                    String string = sb.toString();
                    return string;
                }
            }
            catch (SocketException se) {
                BLControl.logger.trace((Object)"Expected exception while connecting to AWS instanceId provider service url from non AWS environment", (Throwable)se);
                String string = null;
                return string;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Exception while creating AWS instanceId provider service url. Please check jndi property \"sbm.enterprise.cloud.aws.instanceId.provider.url\"", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while connecting to AWS instanceId provider service url.", e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return null;
    }

    public static final synchronized void close() {
        try {
            epManagerPool.destroyPool();
            epManagerPool = null;
            dsTypeClass = null;
            javaTypeClass = null;
            callerInfo = null;
            initialized = false;
        }
        catch (Throwable th) {
            BLControl.logger.error((Object)"Failed to destroy object pool for EPManager", th);
        }
    }

    public final void clean() {
        this.ptName = null;
        this.piName = null;
        this.wsName = null;
        this.wsid = 0L;
        this.ptid = 0L;
        this.piid = 0L;
        this.loopCounter = -1;
        this.isSync = false;
        this.pCtx = null;
        this.performer = null;
        this.performedBy = null;
        this.dsTypes = null;
        this.inputSlotsMapping = null;
        this.outputSlotsMapping = null;
        this.inputDS = null;
        this.hasOutputDS = true;
        this.epInstanceObj = null;
        this.epClassObj = null;
        this.performedByMethod = null;
        this.setAllMethod = null;
        this.getAllMethod = null;
        this.setProcessContextMethod = null;
        this.setMethods = null;
        this.getMethods = null;
        this.isCompleted = false;
        this.onlyPerforming = false;
        this.txRequired = false;
        this.debugMsg = null;
        this.debugArgs = null;
        this.TRANSACTION_TYPE = UT;
        this.isDuplicateMessage = false;
        this.ptVersion = null;
    }
}

