/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.enums.BLLockContext;
import com.savvion.sbm.bizlogic.server.BLBusinessObjectService;
import com.savvion.sbm.bizlogic.server.BOManager;
import com.savvion.sbm.bizlogic.server.ExtBOConfig;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFPreCondition;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.XMLDocRepository;
import com.savvion.sbm.bizlogic.server.dao.DataSlotDAO;
import com.savvion.sbm.bizlogic.server.dao.WaitWorkStepDAO;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDocService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DAOContext;
import com.savvion.sbm.bizlogic.util.DataslotUtil;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.DSContext;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.dms.util.DSUtil;
import com.savvion.sbm.objectgraph.service.OGSFactory;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class WFDataSlotInstance {
    private static WFDataSlotInstance self = null;

    public WFDataSlotInstance() {
        WFDataSlotInstance.init();
    }

    private static void init() {
    }

    public static WFDataSlotInstance self() {
        if (self == null) {
            self = new WFDataSlotInstance();
        }
        return self;
    }

    public Object truncateValue(String piname, WFDataslot ds, Object data) {
        if (!BLUtil.self().isTruncateDSValue() || data == null) {
            return data;
        }
        if (ds.isString()) {
            int size = ds.getSize();
            if (BLUtil.self().isTruncateDSValue() && ((String)data).length() > size) {
                data = BLUtil.trim(null, null, (String)((String)data), (int)size, (boolean)false);
                BLControl.logger.warnKey("BizLogic_ERR_1137", new Object[]{"String", ds.getName(), piname, size, data});
            }
        }
        return data;
    }

    private Object getValidatedValueForUpdate(WFProcessContext pCtx, WFDataslot ds, Object v) {
        String type = ds.getType();
        String piname = pCtx.getProcessInstanceName();
        String dsName = ds.getName();
        Object curValue = v;
        v = this.truncateValue(piname, ds, v);
        if ((v = ds.getValidatedValueForUpdate(v)) == null) {
            return null;
        }
        this.checkChoice(pCtx, ds, v);
        if (type.equals("XML")) {
            HashMap hm = WFProcessInstance.self().getSlotValue(pCtx, new String[]{dsName}, false);
            File[] orgValue = null;
            if (hm != null) {
                orgValue = (File[])hm.get(dsName);
            }
            if (curValue == null) {
                curValue = "";
            }
            if (orgValue != null && curValue instanceof String) {
                File[] newXml = orgValue;
                newXml.setContent((String)curValue);
                v = newXml;
            }
            v = XMLDocRepository.validate(pCtx.getProcessTemplateName(), dsName, ds.getXMLCollectionID(), (XML)orgValue, (XML)v);
        }
        if (type.equals("STRING")) {
            Object appendWith;
            if (!((String)v).startsWith("@") && (appendWith = ds.getAppendWith()) != null) {
                Object aw = this.getAppendWith(pCtx, appendWith);
                v = v == null || "<NULL>".equalsIgnoreCase(v.toString()) ? aw.toString() : (String)v + aw.toString();
                return v;
            }
        }
        if (type.equals("DOCUMENT")) {
            DocumentDS docDS;
            if (v == null || "<NULL>".equalsIgnoreCase(v.toString())) {
                v = pCtx.getSlotValue(ds.getName());
            } else if (v instanceof DocumentDS) {
                DocumentDS docds = (DocumentDS)v;
                if (!dsName.equals(docds.getDataslotName())) {
                    throw new BizLogicException("BizLogic_ERR_3869", "WFDataSlotInstance.getValidatedValueForUpdate", new Object[]{dsName, docds.getDataslotName()});
                }
            } else if (v instanceof File) {
                File docFile = (File)v;
                if (!docFile.exists()) {
                    throw new BizLogicException("BizLogic_ERR_1631", "WFDataSlotInstance.getValidatedValueForUpdate", new Object[]{docFile.getAbsolutePath()});
                }
                docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                docDS.createOrReplace(pCtx.getSession().getUser(), docFile.getName(), (InputStream)FileUtil.getContent((File)docFile), null);
                v = docDS;
            } else if (v instanceof File[]) {
                File[] docFiles = (File[])v;
                docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                for (File docFile : docFiles) {
                    if (!docFile.exists()) {
                        throw new BizLogicException("BizLogic_ERR_1631", "WFDataSlotInstance.getValidatedValueForUpdate", new Object[]{docFile.getAbsolutePath()});
                    }
                    docDS.createOrReplace(pCtx.getSession().getUser(), docFile.getName(), (InputStream)FileUtil.getContent((File)docFile), null);
                }
                v = docDS;
            } else if (v instanceof Map) {
                Map contents = (Map)v;
                docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                docDS.createOrReplace(pCtx.getSession().getUser(), contents, null);
                v = docDS;
            } else if (v instanceof Document) {
                Document doc = (Document)v;
                docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                HashMap attributes = new HashMap(doc.getMetadata());
                DSUtil.removeSystemDocAttrs(attributes);
                docDS.createOrReplace(doc.getCreator(), doc.getName(), (InputStream)doc.getContent(docDS.getDSContext()), attributes);
                v = docDS;
            } else if (WFDataslot.isDocumentList(v)) {
                List docObjs = (List)v;
                docDS = (DocumentDS)pCtx.getSlotValue(ds.getName());
                for (Document doc : docObjs) {
                    HashMap attributes = new HashMap(doc.getMetadata());
                    DSUtil.removeSystemDocAttrs(attributes);
                    docDS.createOrReplace(doc.getCreator(), doc.getName(), (InputStream)doc.getContent(docDS.getDSContext()), attributes);
                }
                v = docDS;
            } else {
                throw new BizLogicException("BizLogic_ERR_3733", "WFDataSlotInstance.getValidatedValueForUpdate", new Object[]{v, pCtx.getProcessInstanceID(), pCtx.getProcessTemplateName()});
            }
        }
        if (type.equals("URL")) {
            BLUtil.validateURLValue((String)ds.getName(), (String)((String)v), (String)pCtx.getProcessInstanceName());
        }
        return v;
    }

    public Object getAppendWith(WFProcessContext pCtx, Object appendWith) {
        if (appendWith != null) {
            if (((String)appendWith).startsWith("@")) {
                String appendWithStr = (String)appendWith;
                String tmp = BLControl.util.cutoutSlotName((String)appendWith);
                ProcessInstanceEBLocal pieb = pCtx.getProcessInstanceEB();
                if ("CREATOR".equalsIgnoreCase(tmp)) {
                    return pieb.getCreator();
                }
                if ("PROCESSNAME".equalsIgnoreCase(tmp)) {
                    return pieb.getName();
                }
                if ("STARTTIME".equalsIgnoreCase(tmp)) {
                    return pieb.getTimeStarted();
                }
                if ("PERFORMER".equalsIgnoreCase(tmp)) {
                    return pCtx.getSession().getUser();
                }
                if ("@PROCESS_INSTANCE_ID".equalsIgnoreCase(appendWithStr)) {
                    return pCtx.getProcessInstanceID();
                }
                if ("@PROCESS_TEMPLATE_NAME".equalsIgnoreCase(appendWithStr)) {
                    return pCtx.getProcessTemplateName();
                }
            }
        }
        return appendWith;
    }

    private void storeDoc(WFProcessContext pCtx, DocumentDS docDS, URL srcUrl) {
        String piName = pCtx.getProcessInstanceName();
        try {
            docDS.create(pCtx.getSession().getUser(), BLUtil.getDocumentName((URL)srcUrl), srcUrl, null);
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_1635", "WFDataSlotInstance.storeDoc", new Object[]{piName, docDS.getDataslotName()}, (Throwable)e);
        }
    }

    public void removeDocumentDS(WFProcessContext pCtx, HashMap dsMap) {
        for (Object dsName : dsMap.keySet()) {
            Object value;
            String dataslotName = (String)dsName;
            if (BLControl.util.DEBUG_DOCUMENT) {
                BLControl.logger.debugKey("BizLogic_ERR_1127", new Object[]{pCtx.getProcessInstanceName(), dataslotName, "all documents", "ENTERED"});
            }
            if ((value = dsMap.get(dsName)) == null) {
                throw new BizLogicException("BizLogic_ERR_1639", "WFDataSlotInstance.removeDocumentDS", new Object[]{dataslotName});
            }
            WFDataslot ds = pCtx.getProcess().getDataslot(dataslotName);
            if (!ds.isDocument()) {
                throw new BizLogicException("BizLogic_ERR_1632", "WFDataSlotInstance.removeDocumentDS", new Object[]{dataslotName});
            }
            BLDocService.removeDocumentDS((DocumentDS)((DocumentDS)value));
            if (!BLControl.util.DEBUG_DOCUMENT) continue;
            BLControl.logger.debugKey("BizLogic_ERR_1127", new Object[]{pCtx.getProcessInstanceName(), dataslotName, "all documents", "FINISHED"});
        }
    }

    public List getDocumentList(WFProcessContext pCtx, String dsname) {
        WFDataslot ds;
        if (BLControl.util.DEBUG_DOCUMENT) {
            BLControl.logger.debugKey("BizLogic_ERR_1627", new Object[]{pCtx.getProcessInstanceName(), dsname, "all documents", "ENTERED"});
        }
        if (!(ds = pCtx.getDataslot(dsname)).isDocument()) {
            throw new BizLogicException("BizLogic_ERR_1632", "WFDataSlotInstance.getDocumentList", new Object[]{dsname});
        }
        DocumentDS docDS = (DocumentDS)pCtx.getSlotValue(dsname);
        return docDS.getDocuments();
    }

    protected Map<String, Object> getEventContext(WFProcessContext pCtx, WFDataslot ds, Object value, int eventType) {
        Map eventContext = SBMUtil.getNewEventContext();
        if (!WFProcessInstance.checkAuditRequired(pCtx, eventType)) {
            eventContext.put("AUDIT_DISABLED", true);
            return eventContext;
        }
        WFProcess pt = pCtx.getProcess();
        eventContext.put("RPID", pCtx.getRootInstanceID());
        eventContext.put("RPTID", pCtx.getRootTemplateID());
        eventContext.put("PROCESSTEMPLATENAME", pt.getName());
        eventContext.put("PROCESSTEMPLATEID", pt.getID());
        eventContext.put("PROCESSINSTANCENAME", pCtx.getProcessInstanceName());
        eventContext.put("PROCESSINSTANCEID", pCtx.getProcessInstanceID());
        eventContext.put("DATASLOTNAME", ds.getName());
        eventContext.put("DATASLOTTYPE", ds.getType());
        eventContext.put("IS_GLOBAL", ds.isGlobal());
        boolean addDSValue = true;
        if (BLControl.util.excludeBlobDSInEvents() && ds.isBlob()) {
            addDSValue = false;
        }
        if (ds.isPublic()) {
            if (!addDSValue) {
                eventContext.put("DATASLOTVALUE", "<VALUE NOT ADDED>");
            } else if (value == null) {
                eventContext.put("DATASLOTVALUE", null);
            } else {
                eventContext.put("DATASLOTVALUE", value.toString());
            }
        }
        if (BLControl.util.isPrintEvent()) {
            eventContext.put("NAME", ds.getName());
        }
        eventContext.put("APP_NAME", pt.getAppName());
        if (pCtx.isDebug()) {
            eventContext.put("PI_DEBUG", Boolean.TRUE);
        }
        if (pCtx.getSession() != null) {
            eventContext.put("SESSION_USER", pCtx.getSession().getUser());
        }
        if (pCtx.getCopyDSContext() != null) {
            eventContext.put("SOURCE_DS_NAME", pCtx.getCopyDSContext());
        }
        return eventContext;
    }

    public void updateSlotValue(WFProcessContext pCtx, Map dsList) {
        if (dsList == null || dsList.isEmpty()) {
            pCtx.lockRootOrInstanceDS(BLLockContext.PIDS, "WFDataSlotInstance.updateSlotValue", new Object[0]);
            return;
        }
        long wsid = this.getSysDsWorkstepId(dsList);
        dsList = this.validateAndUpdateList(pCtx, dsList);
        UpdateSlotAttributes attributes = new UpdateSlotAttributes();
        dsList = WFDataSlotInstance.prepareDataslotForUpdate(pCtx, dsList);
        Map<String, Object> extBODSMap = this.getExternalDs(pCtx, dsList, wsid, attributes);
        long piid = this.updateDsMaps(pCtx, attributes, extBODSMap);
        this.sendUpdatePublicEvents(pCtx, attributes);
        this.revalidatePreconditionForInstanceDs(pCtx, attributes, piid);
    }

    private void revalidatePreconditionForInstanceDs(WFProcessContext pCtx, UpdateSlotAttributes attributes, long piid) {
        Vector<Long> preconditionWaitWSIDs;
        if (!attributes.instanceDSMap.isEmpty() && (preconditionWaitWSIDs = WaitWorkStepDAO.getWsIdListForInstanceDS(piid)) != null && !preconditionWaitWSIDs.isEmpty()) {
            WFPreCondition.self().reValidatePreCondition(pCtx, preconditionWaitWSIDs, (HashMap)attributes.instanceDSMap);
        }
    }

    private void sendUpdatePublicEvents(WFProcessContext pCtx, UpdateSlotAttributes attributes) {
        if (pCtx.sendSUpdateEvent() && attributes.publicDSMap != null && !attributes.publicDSMap.isEmpty()) {
            if (attributes.publicDSMap.size() == 1) {
                Iterator iter = attributes.publicDSMap.keySet().iterator();
                String dataslotName = (String)iter.next();
                WFDataslot wfds = pCtx.getDataslot(dataslotName);
                BLUtil.fireEvent(this.getEventContext(pCtx, wfds, attributes.publicDSMap.get(dataslotName), 33), (int)33);
            } else {
                BLUtil.fireEvent(WFProcessInstance.self().getBulkUpdateEventContext(pCtx, (HashMap)attributes.publicDSMap, 42), (int)42);
            }
        }
    }

    private long updateDsMaps(WFProcessContext pCtx, UpdateSlotAttributes attributes, Map<String, Object> extBODSMap) {
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        if (!attributes.globalDSMap.isEmpty()) {
            if (attributes.instanceDSMap.isEmpty()) {
                pCtx.lockRootOrInstanceDS(BLLockContext.PIDS, "WFDataSlotInstance.updateSlotValue", new Object[0]);
            }
            DataSlotDAO.store(ptid, (HashMap)attributes.globalDSMap);
        }
        if (!extBODSMap.isEmpty()) {
            Map<String, Object> pkDSMap = this.updateExtBODataslots(pCtx, extBODSMap);
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_3834", "WFDataslotInstance.updateSlotValue", new Object[]{pkDSMap.toString(), pCtx.getProcessInstanceID()});
            }
            attributes.instanceDSMap.putAll(pkDSMap);
            for (Map.Entry<String, Object> pkDS : pkDSMap.entrySet()) {
                String currDSName = pkDS.getKey();
                WFDataslot wfDS = pCtx.getDataslot(currDSName);
                if (!wfDS.isPublic()) continue;
                attributes.publicDSMap.put(currDSName, pkDS.getValue());
            }
        }
        if (!attributes.instanceDSMap.isEmpty()) {
            DataSlotDAO.store(ptid, piid, (HashMap)attributes.instanceDSMap);
            pCtx.setInstanceLockObtained(true);
        }
        if (BLUtil.self().DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_8105", "WFDataSlotInstance::updateSlotValue", new Object[]{ptid, piid, attributes.globalDSMap, attributes.instanceDSMap});
        }
        return piid;
    }

    private Map<String, Object> getExternalDs(WFProcessContext pCtx, Map<String, Object> dsList, long wsid, UpdateSlotAttributes attributes) {
        HashMap<String, Object> extBODSMap = new HashMap<String, Object>();
        for (String dsKey : dsList.keySet()) {
            attributes.dsName = dsKey;
            attributes.value = dsList.get(attributes.dsName);
            attributes.ds = pCtx.getDataslot(attributes.dsName);
            if (null == attributes.value && !attributes.ds.canResetToNull()) {
                throw new BizLogicException("BizLogic_ERR_8097", "WFDataSlotInstance.updateSlotValue", new Object[]{attributes.dsName, pCtx.getProcessTemplateName()});
            }
            attributes.value = this.getValidatedValueForUpdate(pCtx, attributes.ds, attributes.value);
            if (attributes.value != null && attributes.ds.isValueMapped() && !attributes.ds.isValueMappedToCreator()) {
                this.setValueMappedSlotValue(pCtx, attributes.dsName, (String)attributes.ds.getValue(), (String)attributes.value);
            }
            if (attributes.ds.isObject()) {
                boolean result;
                if (attributes.ds.isExternalBO()) {
                    extBODSMap.put(attributes.dsName, attributes.value);
                    continue;
                }
                if (attributes.ds.isSqlMap() && attributes.ds.getSqlMap().hasUpdateQuery() && (result = BOManager.self().updateSqlObject(pCtx, wsid, attributes.ds, attributes.value))) continue;
            }
            attributes.addToMap();
        }
        return extBODSMap;
    }

    private Map<String, Object> validateAndUpdateList(WFProcessContext pCtx, Map<String, Object> dsList) {
        boolean rootLockObtained = pCtx.lockRootInstanceDS(BLLockContext.PIDS, "WFDataSlotInstance.updateSlotValue", new Object[0]);
        if (!rootLockObtained && DataslotUtil.containsLargeInstanceDS((long)pCtx.getProcessTemplateID(), dsList)) {
            pCtx.lockInstanceDS(BLLockContext.PIDS, "WFDataSlotInstance.updateSlotValue", new Object[0]);
        }
        if (BLUtil.self().DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_8104", "WFDataSlotInstance::updateSlotValue", new Object[]{pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), dsList});
        }
        if (pCtx.getProcess().isMonitoringProcess() && !pCtx.getProcess().isMonitorDSMappedToPIID()) {
            this.validateMonitorDSValue(pCtx, dsList);
        }
        if (!pCtx.isCompProcess && !pCtx.isProcessRefresh() && pCtx.getProcessInstanceEB().getState() == 8) {
            throw new BizLogicException("BizLogic_ERR_800", "WFDataSlotInstance::updateSlotValue", new Object[]{pCtx.getProcessInstanceName()});
        }
        Map dataSlotList = dsList;
        if (pCtx.getProcess().hasCollectionDS()) {
            dataSlotList = this.collectionElementUpdate(pCtx, dsList);
        }
        return dataSlotList;
    }

    private long getSysDsWorkstepId(Map<String, Object> dsList) {
        long wsid = -1L;
        Long wsidObj = (Long)dsList.remove("@WORKSTEPID");
        if (wsidObj != null) {
            wsid = wsidObj;
        }
        return wsid;
    }

    public Map<String, Object> updateExtBODataslots(WFProcessContext pCtx, Map<String, Object> extBODSMap) {
        HashMap<String, Object> pkDSMap = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> extBOEntries = extBODSMap.entrySet();
        for (Map.Entry<String, Object> entry : extBOEntries) {
            Map<String, Object> response;
            WFDataslot extBODS = pCtx.getDataslot(entry.getKey());
            ExtBOConfig boCtx = extBODS.getBOPersistenceConfig();
            Object extBOValue = entry.getValue();
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8084", "WFDataSlotInstance::updateExtBODataslots", new Object[]{extBODS.getName()});
            }
            if (null == (response = BLBusinessObjectService.self().createOrUpdate(extBODS, extBOValue))) {
                if (!BLControl.util.DEBUG_ENGINE) continue;
                BLControl.logger.debugKey("BizLogic_ERR_8094", "WFDataslotInstance.updateExtBODataslots", new Object[]{pCtx.getProcessInstanceID(), extBODS.getName()});
                continue;
            }
            if (BLControl.util.DEBUG_ENGINE) {
                BLControl.logger.debugKey("BizLogic_ERR_8095", "WFDataslotInstance.updateExtBODataslots", new Object[]{pCtx.getProcessInstanceID(), extBODS.getName(), response.toString()});
            }
            pkDSMap.putAll(this.assignPKValuesToDataSlots(response, boCtx, pCtx, extBODS));
        }
        return pkDSMap;
    }

    private Map<String, Object> assignPKValuesToDataSlots(Map<String, Object> newPKValues, ExtBOConfig boCtx, WFProcessContext pCtx, WFDataslot extBODS) {
        Map<String, String> pkDSMap = boCtx.getPkAttributeDSMap();
        HashMap<String, Object> pkDSValues = new HashMap<String, Object>();
        for (Map.Entry<String, String> pkDSEntry : pkDSMap.entrySet()) {
            pkDSValues.put(pkDSEntry.getValue(), newPKValues.get(pkDSEntry.getKey()));
        }
        if (BLControl.util.DEBUG_ENGINE) {
            BLControl.logger.debugKey("BizLogic_ERR_3833", "WFDataslotInstance.assignPKValuesToDataSlots", new Object[]{((Object)pkDSValues).toString(), extBODS.getName(), pCtx.getProcessInstanceID()});
        }
        return pkDSValues;
    }

    public void setValueMappedSlotValue(WFProcessContext pCtx, String dsName, String mappedValue, String value) {
        String wsName = null;
        WFWorkstep ws = null;
        long wsid = 0L;
        if (mappedValue.toUpperCase().startsWith("@" + "PROCESSPRIORITY")) {
            WFProcessInstance.self().setPriority(pCtx, value, true);
        } else if (mappedValue.toUpperCase().startsWith("@" + "WORKSTEPPRIORITY:")) {
            wsName = mappedValue.substring(mappedValue.indexOf(":") + 1);
            ws = pCtx.getProcess().getWorkstep(wsName);
            wsid = ws.getID();
            WFWorkstepInstance.single().setPriority(pCtx, wsid, value);
        } else if (mappedValue.toUpperCase().startsWith("@" + "WORKSTEPDUEDATE:")) {
            wsName = mappedValue.substring(mappedValue.indexOf(":") + 1);
            ws = pCtx.getProcess().getWorkstep(wsName);
            wsid = ws.getID();
            WFWorkstepInstance.single().setDuedate(pCtx, wsid, value, false);
        } else {
            throw new BizLogicException("BizLogic_ERR_577", "WFDataSlotInstance.setValueMappedSlotValue", (Object[])new String[]{pCtx.getProcessInstanceName(), dsName});
        }
    }

    private Map collectionElementUpdate(WFProcessContext pCtx, Map dsList) {
        Vector readDS = this.getSingleElementOperationDSName(pCtx, dsList);
        if (readDS.isEmpty()) {
            return dsList;
        }
        String[] dsNameList = BLUtil.convertVectorToStringArray((Vector)readDS);
        HashMap orgValues = pCtx.getSlotValue(dsNameList);
        String dsName = null;
        Object orgValue = null;
        Object elementValue = null;
        Map.Entry entry2 = null;
        WFDataslot ds = null;
        for (Map.Entry entry2 : orgValues.entrySet()) {
            dsName = (String)entry2.getKey();
            orgValue = entry2.getValue();
            elementValue = dsList.get(dsName);
            ds = pCtx.getDataslot(dsName);
            dsList.put(dsName, ds.convertToCollectionValue(orgValue, elementValue));
        }
        return dsList;
    }

    private Vector getSingleElementOperationDSName(WFProcessContext pCtx, Map dsList) {
        Object var3_3 = null;
        String dsName = null;
        Object dsValue = null;
        WFDataslot ds = null;
        Vector<String> readDS = new Vector<String>();
        for (Map.Entry entry : dsList.entrySet()) {
            Object newInstance;
            dsName = (String)entry.getKey();
            dsValue = entry.getValue();
            if (BLUtil.isNull(dsValue)) continue;
            ds = pCtx.getDataslot(dsName);
            if (ds.isSet() || ds.isList()) {
                if (dsValue instanceof Collection) {
                    if (dsValue.getClass().getName().equals(ds.getStorageFormat())) continue;
                    newInstance = ds.getEmptyCollection();
                    ((Collection)newInstance).addAll((Collection)dsValue);
                    entry.setValue(newInstance);
                    continue;
                }
                readDS.addElement(dsName);
                continue;
            }
            if (!ds.isMap()) continue;
            if (dsValue instanceof Map) {
                if (dsValue.getClass().getName().equals(ds.getStorageFormat())) continue;
                newInstance = ds.getEmptyCollection();
                ((Map)newInstance).putAll((Map)dsValue);
                entry.setValue(newInstance);
                continue;
            }
            if (dsValue instanceof Map.Entry) {
                readDS.addElement(dsName);
                continue;
            }
            throw new BizLogicException("BizLogic_ERR_781", "WFDataslotInstance:getSingleElementOperationDSName", new Object[]{dsName, "java.util.Map or java.util.Map.Entry"});
        }
        if (BLUtil.self().DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("The single element operation happens on the following dataslot:" + readDS.toString()));
        }
        return readDS;
    }

    public Collection getChoiceList(WFProcessContext pCtx, WFDataslot ds) {
        return ds.getChoices();
    }

    private void checkChoice(WFProcessContext pCtx, WFDataslot ds, Object value) {
        if (!ds.hasChoices() || BLUtil.isNull((Object)value)) {
            return;
        }
        if (!WFDataslot.checkChoice(this.getChoiceList(pCtx, ds), value)) {
            throw new BizLogicException("BizLogic_ERR_513", "WFDataslotInstance.checkChoices", new Object[]{pCtx.getProcessInstanceName() + "::" + ds.getName(), ds.getName(), value, ds.choices});
        }
    }

    public HashMap getAttributes(WFProcessContext pCtx, String dsName) {
        WFProcess pt = pCtx.getProcess();
        WFDataslot ds = pt.getDataslot(dsName);
        HashMap meta = ds.getMetaData();
        return meta;
    }

    public HashMap createDocumentDSWithDefaultValues(WFProcessContext pCtx, HashMap excludeDS) {
        HashMap<String, DocumentDS> dsValues = new HashMap<String, DocumentDS>();
        WFProcess pt = pCtx.getProcess();
        Map.Entry entry = null;
        BLConstants.single();
        HashMap dslist = pt.getDataSlotsWithDefaultValues("DOCUMENT");
        if (dslist.isEmpty()) {
            return dsValues;
        }
        Iterator itr = dslist.entrySet().iterator();
        String dsName = null;
        String defaultValue = null;
        ArrayList defaultValues = null;
        while (itr.hasNext()) {
            entry = itr.next();
            dsName = (String)entry.getKey();
            defaultValues = (ArrayList)entry.getValue();
            if (defaultValues == null || defaultValues.isEmpty() || excludeDS != null && excludeDS.containsKey(dsName)) continue;
            WFDataslot ds = pCtx.getDataslot(dsName);
            DSContext dsContext = null;
            if (BLUtil.self().isMultiUserCredential()) {
                dsContext = BLUtil.self().getDSContext(pCtx.getSession());
            }
            DocumentDS docDS = BLDocService.getInstanceDocumentDS((DSContext)dsContext, (long)pCtx.getProcessTemplateID(), (long)pCtx.getProcessInstanceID(), (String)dsName, null, (boolean)ds.isEditableByAuthor(), (boolean)ds.isMultiLine());
            for (int ix = 0; ix < defaultValues.size(); ++ix) {
                defaultValue = (String)defaultValues.get(ix);
                this.addDefaultDocument(pCtx, docDS, defaultValue);
            }
            dsValues.put(dsName, docDS);
        }
        return dsValues;
    }

    private void addDefaultDocument(WFProcessContext pCtx, DocumentDS docDS, String defaultValue) {
        try {
            URL fileurl = BLUtil.getDefaultDocumentURL((WFProcess)pCtx.getProcess(), (String)docDS.getDataslotName(), (String)defaultValue);
            if (fileurl != null) {
                this.storeDoc(pCtx, docDS, fileurl);
                if (BLControl.util.DEBUG_UTIL) {
                    BLControl.logger.debugKey("BizLogic_ERR_3510", "getDocDSWithDefaultValues", new Object[]{fileurl, pCtx.getProcessTemplateName(), docDS.getDataslotName()});
                }
            }
        }
        catch (Exception ignore) {
            BLControl.logger.errorKey("BizLogic_ERR_3508", "getDocDSWithDefaultValues", (Throwable)ignore, new Object[]{defaultValue, pCtx.getProcessTemplateName(), docDS.getDataslotName()});
        }
    }

    public HashMap getComplexDSDefaultValues(WFProcessContext pCtx, HashMap excludeDS) {
        HashMap dsValues = new HashMap();
        WFProcess pt = pCtx.getProcess();
        HashMap xmlDS = pt.getXMLDSWithDefaultValues(excludeDS, false);
        HashMap docDS = this.createDocumentDSWithDefaultValues(pCtx, excludeDS);
        long startTime = WFProcessInstance.self().getStartTime(pCtx);
        HashMap dateDS = pt.getDateTimeDSWithDefaultValues(excludeDS, false, startTime);
        dsValues.putAll(xmlDS);
        dsValues.putAll(docDS);
        dsValues.putAll(dateDS);
        if (BLControl.util.DEBUG_UTIL) {
            BLControl.logger.warnKey("BizLogic_ERR_3511", "getDSWithDefaultValues", new Object[]{dsValues.size(), pt.getName(), dsValues});
        }
        return dsValues;
    }

    public void incrementLongSlotValue(WFProcessContext pCtx, String dsName, long value) {
        WFDataslot ds = pCtx.getDataslot(dsName);
        DataSlotDAO.incrementLongDS(pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), dsName, ds.isInstance(), value);
    }

    public void appendStringSlotValue(WFProcessContext pCtx, String dsName, String value) {
        WFDataslot ds = pCtx.getDataslot(dsName);
        if (ds.isMonitorDS()) {
            throw new BizLogicException("BizLogic_ERR_4812", "WFDataSlotInstance::appendStringSlotValue", new Object[]{pCtx.getProcessInstanceName(), pCtx.getProcess().getMonitorDSName()});
        }
        DataSlotDAO.appendStringDS(pCtx.getProcessTemplateID(), pCtx.getProcessInstanceID(), dsName, ds.isInstance(), value);
    }

    public void updateSlotValue(Session session, long piid, Map<String, Object> dsValues) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.updateSlotValue(dsValues);
    }

    public void updateGlobalDSValues(Session sess, long ptid, Map<String, Object> dsValues) {
        String dsName;
        if (dsValues == null || dsValues.isEmpty()) {
            BLControl.logger.infoKey("BizLogic_ERR_3265", "WFDataSlotInstance.setGlobalDSValue", new Object[]{ProcessControl.getProcessTemplate(ptid).getName()});
            return;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>(1);
        Set<Map.Entry<String, Object>> entrySet = dsValues.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            dsName = entry.getKey();
            WFProcess processObject = ProcessControl.getProcessTemplate(ptid);
            WFDataslot ds = processObject.getDataslot(dsName);
            if (!ds.isGlobal()) {
                throw new BizLogicException("BizLogic_ERR_3902", "WFDataSlotInstance.updateGlobalDSValues", new Object[]{processObject.getName(), dsName});
            }
            Object dsValue = entry.getValue();
            dsValue = ds.truncateValue(ds.getParentProcess().getName(), dsValue);
            if (ds.isCollection()) {
                Object collectionDSValue = this.getGlobalDSValue(sess, ds);
                dsValue = ds.convertToCollectionValue(collectionDSValue, dsValue);
            }
            if (ds.getType().equals("XML") && dsValue == null) {
                throw new BizLogicException("BizLogic_ERR_4642", "WFDataSlotInstance.updateGlobalDSValues", new Object[]{dsName});
            }
            dsValue = ds.getValidatedValueForUpdate(dsValue);
            ds.checkChoice(dsValue);
            if (ds.getType().equals("XML")) {
                dsValue = XMLDocRepository.validate(ds.getParentProcess().getName(), ds.getName(), ds.getXMLCollectionID(), (XML)this.getGlobalDSValue(sess, ds), (XML)dsValue);
            }
            hm.put(dsName, dsValue);
        }
        DataSlotDAO.store(ptid, hm);
        for (Map.Entry<String, Object> entry : entrySet) {
            dsName = entry.getKey();
            WFDataslot ds = ProcessControl.getProcessTemplate(ptid).getDataslot(dsName);
            Object dsValue = entry.getValue();
            if (!ds.isPublic()) continue;
            BLUtil.fireEvent(ds.getEventContext(sess, ProcessControl.getProcessTemplate(ptid), dsValue, 33), (int)33);
        }
    }

    public Object getGlobalDSValue(Session sess, WFDataslot ds) {
        Object dsValue = ds.getValue();
        if (ds.getParentProcess().isActivated() || ds.getParentProcess().isSuspendedBySeqVersion() || ds.getParentProcess().isSuspended()) {
            long ptid = ds.getParentProcess().getID();
            String dsName = ds.getName();
            DAOContext daoCtx = BLUtil.self().getDAOContext(sess);
            dsValue = DataSlotDAO.findByName(daoCtx, ptid, dsName);
        }
        return dsValue;
    }

    public Map<String, Object> getGlobalDSValues(Session sess, long ptid) {
        WFProcess pt = ProcessControl.getProcessTemplate(ptid);
        HashMap dsValues = pt.getDefaultDSValues(true);
        if (pt.isActivated() || pt.isSuspendedBySeqVersion() || pt.isSuspended()) {
            DAOContext daoCtx = BLUtil.self().getDAOContext(sess);
            dsValues = DataSlotDAO.findByProcessTemplete(daoCtx, ptid);
        }
        return dsValues;
    }

    public Object createObjectForObjectDS(Session sess, WFDataslot ds) {
        Object o = null;
        if (ds.isObject()) {
            try {
                if (ds.objConstrArgType == null) {
                    o = ds.getConstructor().getDeclaringClass().newInstance();
                } else {
                    if (ds.objConstrGlobalDSindex != null) {
                        if (ds.objConstrGlobalDS == null) {
                            ds.setObjConstrGlobalDS();
                        }
                        DAOContext daoCtx = BLUtil.self().getDAOContext(sess);
                        HashMap dsvalue = DataSlotDAO.findByNameList(daoCtx, ds.parentProcess.getID(), (Vector)ds.objConstrGlobalDSName.clone());
                        for (int itr = 0; itr < ds.objConstrGlobalDSName.size(); ++itr) {
                            WFDataslot constrGDS = ds.objConstrGlobalDS[itr];
                            Object val = dsvalue.get(constrGDS.getName());
                            if (constrGDS.isXML()) {
                                val = ((XML)val).getContent(sess);
                            } else if (constrGDS.isDate()) {
                                val = ((DateTime)val).getValue();
                            } else if (constrGDS.isDecimal()) {
                                val = ((Decimal)val).getValue();
                            }
                            ds.objConstrArgValue[ds.objConstrGlobalDSindex[itr]] = val;
                        }
                    }
                    o = ds.getConstructor().newInstance(ds.objConstrArgValue);
                }
            }
            catch (Throwable th) {
                throw new BizLogicException("BizLogic_ERR_088", "WFDataSlotInstance.createObjectForObjectDS", (Object[])new String[]{ds.parentProcess.getName(), ds.javaClassName, ds.getName()}, th);
            }
        }
        return o;
    }

    private void validateMonitorDSValue(WFProcessContext pCtx, Map dsList) {
        String monitorDSName = pCtx.getProcess().getMonitorDSName();
        if (dsList.containsKey(monitorDSName)) {
            String monitorDSValue = pCtx.getMonitorDSValue();
            String newMonitorDSValue = (String)dsList.get(monitorDSName);
            if (newMonitorDSValue == null || newMonitorDSValue.trim().length() == 0 || "<NULL>".equalsIgnoreCase(newMonitorDSValue.trim())) {
                BLControl.logger.warnKey("BizLogic_ERR_8078", "WFDataSlotInstance::validateMonitorDSValue", new Object[]{pCtx.getProcessInstanceID(), monitorDSName});
                dsList.remove(monitorDSName);
                return;
            }
            if (monitorDSValue == null || monitorDSValue.trim().length() == 0 || "<NULL>".equalsIgnoreCase(monitorDSValue.trim())) {
                if (this.isProcessInstanceExist(pCtx.getProcessTemplateName(), newMonitorDSValue) || MPUtil.isProcessInstanceExist(pCtx.getProcessTemplateName(), monitorDSName, newMonitorDSValue)) {
                    throw new BizLogicException("BizLogic_ERR_4817", "WFDataSlotInstance::validateMonitorDSValue", new Object[]{pCtx.getProcessInstanceName(), newMonitorDSValue, monitorDSName});
                }
                MPService.self().getPersistenceService().createMonitorProcessEiid(pCtx.getProcessTemplateID(), newMonitorDSValue);
                MPService.self().getPersistenceService().updateMonitorWaitWorkStepEiid(pCtx.getProcessInstanceID(), newMonitorDSValue);
            } else if (!monitorDSValue.equals(newMonitorDSValue)) {
                throw new BizLogicException("BizLogic_ERR_4812", "WFDataSlotInstance::validateMonitorDSValue", new Object[]{pCtx.getProcessInstanceName(), pCtx.getProcess().getMonitorDSName(), monitorDSValue, newMonitorDSValue});
            }
        }
    }

    public boolean isProcessInstanceExist(String ptName, String monitorDSValue) {
        long piid = WFDataSlotInstance.getProcessInstanceId(ptName, monitorDSValue, false);
        return piid != -1L;
    }

    public static long getProcessInstanceId(String ptName, String monitorDSValue, boolean throwExIfNotfound) {
        String tableName = ProcessControl.getProcessTemplate(ptName).getDSTableName();
        String monitorDSName = ProcessControl.getProcessTemplate(ptName).getMonitorDSName();
        long piid = DataSlotDAO.getProcessInstanceId(monitorDSName, monitorDSValue, tableName);
        if (piid == -1L && throwExIfNotfound) {
            throw new BizLogicException("BizLogic_ERR_4820", "WFDataSlotInstance::getProcessInstanceId", new Object[]{ptName, monitorDSName, monitorDSValue});
        }
        return piid;
    }

    public String getMonitorDSValue(WFProcessContext pCtx) {
        if (!pCtx.getProcess().isMonitoringProcess()) {
            return null;
        }
        if (pCtx.getProcess().isMonitorDSMappedToPIID()) {
            return String.valueOf(pCtx.getProcessInstanceID());
        }
        return (String)pCtx.getSlotValue(pCtx.getProcess().getMonitorDSName());
    }

    private static Map prepareDataslotForUpdate(WFProcessContext pCtx, Map dsList) {
        Map boExprMap = BLUtil.prepareBOExpression(new ArrayList(dsList.keySet()));
        if (boExprMap != null && !boExprMap.isEmpty()) {
            String[] boDsNames = boExprMap.keySet().toArray(new String[0]);
            ArrayList<String> invalidBODsNames = new ArrayList<String>();
            for (String boDsName : boDsNames) {
                if (!dsList.containsKey(boDsName)) continue;
                invalidBODsNames.add(boDsName);
            }
            if (invalidBODsNames != null && !invalidBODsNames.isEmpty()) {
                throw new BizLogicException("BizLogic_ERR_4716", "WFDataSlotInstance::prepareDataslotForUpdate", new Object[]{pCtx.getProcessInstanceID(), invalidBODsNames, dsList});
            }
            HashMap boDsNameValue = WFProcessInstance.self().getSlotValue(pCtx, boDsNames, false);
            for (Map.Entry boExpMapEntry : boExprMap.entrySet()) {
                String boDsName;
                boDsName = (String)boExpMapEntry.getKey();
                Object boDsValue = boDsNameValue.get(boDsName);
                for (String expr : (Set)boExpMapEntry.getValue()) {
                    StringBuilder stringBuilder = new StringBuilder().append(boDsName);
                    BLConstants.single();
                    String dsNameWithExpr = stringBuilder.append(".").append(expr).toString();
                    Object newValue = dsList.get(dsNameWithExpr);
                    try {
                        OGSFactory.getDefault().setValue(boDsValue, expr, newValue);
                    }
                    catch (Throwable th) {
                        throw new BizLogicException("BizLogic_ERR_4718", "WFDataSlotInstance::prepareDataslotForUpdate", new Object[]{pCtx.getProcessInstanceID(), boDsValue, dsNameWithExpr, newValue}, th);
                    }
                }
                boDsNameValue.put(boDsName, boDsValue);
            }
            HashMap dsForUpdate = new HashMap();
            List dsNamesForUpdate = BLUtil.prepareDataSlotNames(new ArrayList(dsList.keySet()), (WFProcessContext)pCtx);
            for (String dsNameForUpdate : dsNamesForUpdate) {
                dsForUpdate.put(dsNameForUpdate, dsList.get(dsNameForUpdate));
            }
            if (boDsNameValue != null && !boDsNameValue.isEmpty()) {
                dsForUpdate.putAll(boDsNameValue);
            }
            return dsForUpdate;
        }
        return dsList;
    }

    private static class UpdateSlotAttributes {
        private String dsName;
        private Object value;
        private WFDataslot ds;
        private Map<String, Object> globalDSMap = new HashMap<String, Object>();
        private Map<String, Object> instanceDSMap = new HashMap<String, Object>();
        private Map<String, Object> publicDSMap = new HashMap<String, Object>();

        private UpdateSlotAttributes() {
        }

        private void addToMap() {
            if (this.ds.isGlobal()) {
                this.globalDSMap.put(this.dsName, this.value);
            } else {
                this.instanceDSMap.put(this.dsName, this.value);
            }
            if (this.ds.isPublic()) {
                this.publicDSMap.put(this.dsName, this.ds.getValue4Event(this.value));
            }
        }
    }
}

