/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFJavaScript;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.WaitWorkStepDAO;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.ServiceManager;
import com.savvion.sbm.replication.ReplicationManager;
import com.savvion.sbm.replication.service.IServiceHandler;
import com.savvion.sbm.replication.service.ServiceRegister;
import com.savvion.sbm.util.BMTimer;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.javascript.Script;

public class WFPreCondition
extends ServiceManager {
    public static boolean isRunning = false;
    private static long sleepTime = 0L;
    private static int rwSize = 0;
    private static final String INVOKING_METHOD = "validateAndResumeWorkStep";
    private static final String NULL = "null";
    private static final String TRUE = "TRUE";
    private static final String SEPERATOR = " ";
    private static WFPreCondition self = new WFPreCondition();

    public WFPreCondition() {
        ServiceRegister.self().registerService((IServiceHandler)new PreConditionHandler());
    }

    public static WFPreCondition self() {
        return self;
    }

    public boolean validateCondition(WFProcessContext pCtx, long wsid, int queryType, String query) {
        if (query == null || query.trim().isEmpty()) {
            pCtx.addValidPreCondWSId(wsid);
            return true;
        }
        if (queryType == 203 || queryType == 205) {
            boolean javaRetVal = false;
            javaRetVal = this.validateJavaCode(pCtx, wsid, null, query);
            if (javaRetVal) {
                pCtx.addValidPreCondWSId(wsid);
            }
            return javaRetVal;
        }
        if (queryType == 201) {
            boolean jsretval = false;
            Object retv = WFWorkstepInstance.single().executeJS(pCtx, wsid, "PRECOND");
            if (retv != null) {
                jsretval = Boolean.valueOf(retv.toString());
            }
            if (BLControl.util.DEBUG_PRECONDITION) {
                BLControl.logger.debugKey("BizLogic_ERR_3256", "WFPreCondition.validateCondition()", new Object[]{jsretval, query, pCtx.getProcessInstanceName(), pCtx.getWorkstep(wsid).getName()});
            }
            if (jsretval) {
                pCtx.addValidPreCondWSId(wsid);
            }
            return jsretval;
        }
        try {
            String tmp = "";
            int p = 0;
            int o = 0;
            int lp = 0;
            int a = 0;
            String q = query;
            Vector<Boolean> terms = new Vector<Boolean>();
            Vector<String> ops = new Vector<String>();
            while (a != -1 || o != -1) {
                a = q.indexOf(" AN ", lp);
                o = q.indexOf(" OR ", lp);
                if (a <= 0 && o <= 0) continue;
                p = a < 0 ? o : a;
                tmp = q.substring(lp, ++p - 1);
                terms.addElement(this.execSimpleQuery(pCtx, tmp));
                ops.addElement(q.substring(lp + tmp.length() + 1, p + 2));
                lp = p + 3;
            }
            terms.addElement(this.execSimpleQuery(pCtx, q.substring(lp, q.length())));
            boolean lastValue = (Boolean)terms.elementAt(0);
            for (int x = 0; x < ops.size(); ++x) {
                lastValue = ((String)ops.elementAt(x)).equals("OR") ? lastValue || (Boolean)terms.elementAt(x + 1) != false : lastValue && (Boolean)terms.elementAt(x + 1) != false;
            }
            if (lastValue) {
                pCtx.addValidPreCondWSId(wsid);
            }
            return lastValue;
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_1700", "WFPreCondition.validateCondition", new Object[]{query}, (Throwable)e);
        }
    }

    private boolean execSimpleQuery(WFProcessContext pCtx, String query) {
        if (query == null) {
            return false;
        }
        String modifiedQuery = query.contains("\n") ? query.substring(0, query.indexOf(10)) : query;
        modifiedQuery = modifiedQuery.trim();
        StringTokenizer tok = new StringTokenizer(query, SEPERATOR);
        StringBuilder slotName = new StringBuilder(tok.nextToken());
        String predicate = tok.nextToken();
        while (!(predicate.startsWith(">") || predicate.startsWith("<") || predicate.startsWith("=") || predicate.startsWith("!"))) {
            slotName.append(SEPERATOR).append(predicate);
            predicate = tok.nextToken();
        }
        String value = modifiedQuery.substring(modifiedQuery.indexOf(predicate) + predicate.length() + 1);
        if ((value = value.trim()).startsWith("DS:")) {
            value = pCtx.getSlotValue(value.substring("DS:".length())).toString();
        }
        Object v = pCtx.getSlotValue(slotName.toString());
        String type = pCtx.getSlotType(slotName.toString());
        Boolean valid = this.validate(predicate, value, v);
        if (valid != null) {
            return valid;
        }
        return this.processSlots(predicate, value, v, type);
    }

    private boolean processSlots(String predicate, String value, Object v, String type) {
        return "STRING".equals(type) && this.processStringSlot(predicate, value, (String)v) || "BOOLEAN".equals(type) && this.processBooleanSlot(predicate, value, (Boolean)v) || "URL".equals(type) && this.processUrlSlot(predicate, value, v) || "LONG".equals(type) && this.processLongSlot(predicate, value, (Long)v) || "DOUBLE".equals(type) && this.processDoubleSlot(predicate, value, (Double)v);
    }

    private Boolean validate(String predicate, String value, Object v) {
        if (v == null) {
            if (predicate.equals("==")) {
                return NULL.equalsIgnoreCase(value);
            }
            if (predicate.equals("!=")) {
                return !NULL.equalsIgnoreCase(value);
            }
            return false;
        }
        return null;
    }

    private boolean processStringSlot(String predicate, String value, String v) {
        switch (predicate) {
            case "==": {
                return v.compareTo(value) == 0;
            }
            case ">=": {
                return v.compareTo(value) >= 0;
            }
            case "<=": {
                return v.compareTo(value) <= 0;
            }
            case ">": {
                return v.compareTo(value) > 0;
            }
            case "<": {
                return v.compareTo(value) < 0;
            }
            case "!=": {
                return v.compareTo(value) != 0;
            }
        }
        return false;
    }

    private boolean processBooleanSlot(String predicate, String value, Boolean booleanValue) {
        if (predicate.equals("==")) {
            if (TRUE.equalsIgnoreCase(value)) {
                return booleanValue;
            }
            return booleanValue == false;
        }
        if (predicate.equals("!=")) {
            if (TRUE.equalsIgnoreCase(value)) {
                return booleanValue == false;
            }
            return booleanValue;
        }
        return false;
    }

    private boolean processUrlSlot(String predicate, String value, Object v) {
        return predicate.equals("==") && v.toString().equalsIgnoreCase(value) || predicate.equals("!=") && !v.toString().equalsIgnoreCase(value);
    }

    private boolean processLongSlot(String predicate, String initialValue, Long v) {
        String value = "NOW".equals(initialValue) ? String.valueOf(new Date().getTime()) : initialValue;
        long longValue = Long.parseLong(value);
        switch (predicate) {
            case "==": {
                return v == longValue;
            }
            case ">=": {
                return v >= longValue;
            }
            case "<=": {
                return v <= longValue;
            }
            case "!=": {
                return v != longValue;
            }
            case ">": {
                return v > longValue;
            }
            case "<": {
                return v < longValue;
            }
        }
        return false;
    }

    private boolean processDoubleSlot(String predicate, String value, Double v) {
        return predicate.equals("==") ? Math.abs(v - Double.valueOf(value)) < 1.0E-8 : (predicate.equals(">=") ? v >= Double.valueOf(value) : (predicate.equals("<=") ? v <= Double.valueOf(value) : (predicate.equals("!=") ? Math.abs(v - Double.valueOf(value)) > 1.0E-8 : (predicate.equals(">") ? v > Double.valueOf(value) : predicate.equals("<") && v < Double.valueOf(value)))));
    }

    public void reValidatePreCondition(WFProcessContext pCtx, Vector preconditionWaitWSIDs, HashMap instanceDSList) {
        WFProcess pt = pCtx.getProcess();
        WFWorkstep ws = null;
        long piid = pCtx.getProcessInstanceID();
        for (int ix = preconditionWaitWSIDs.size() - 1; ix >= 0; --ix) {
            long wsid = (Long)preconditionWaitWSIDs.elementAt(ix);
            if (WFWorkstepInstance.single().isSuspended(pCtx, wsid)) {
                if (!BLControl.util.DEBUG_PRECONDITION) continue;
                BLControl.logger.debugKey("BizLogic_ERR_3276", "WFPreCondition.reValidatePreCondition()", new Object[]{pt.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
                continue;
            }
            ws = pt.getWorkstep(wsid);
            if (BLControl.util.DEBUG_PRECONDITION) {
                BLControl.logger.debugKey("BizLogic_ERR_8002", "WFPreCondition.reValidatePreCondition()", new Object[]{ws.getPreCondition(), ws.getName(), pCtx.getProcessInstanceName()});
            }
            if (!this.validateCondition(pCtx, wsid, ws.getPreConditionType(), ws.getPreCondition())) continue;
            WaitWorkStepDAO.remove(piid, wsid);
            pCtx.resumeWorkstep(wsid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runResumeWS() {
        if (WFPreCondition.isRunning()) {
            BLConstants.single();
            SBMUtil.logDuplicateMessage((SBMLogger)BLControl.logger, (String)"BizLogic_ERR_1009", (String)"Precondition Wait Workstep Service(BLRESUMEWSMDB)");
            return;
        }
        if (!ReplicationManager.self().isPrimaryDatabase()) {
            Object[] objectArray = new Object[1];
            BLConstants.single();
            objectArray[0] = "BLRESUMEWSMDB";
            BLControl.logger.warnKey("BizLogic_ERR_1014", objectArray);
            return;
        }
        Class<WFPreCondition> clazz = WFPreCondition.class;
        synchronized (WFPreCondition.class) {
            if (WFPreCondition.isRunning()) {
                BLConstants.single();
                SBMUtil.logDuplicateMessage((SBMLogger)BLControl.logger, (String)"BizLogic_ERR_1009", (String)"Precondition Wait Workstep Service(BLRESUMEWSMDB)");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            try {
                LoggerUtil logger = new LoggerUtil(BLControl.logger);
                this.initService("RESUMEWS", BLControl.util.DS_JNDI_NAME, ((Object)((Object)this)).getClass(), INVOKING_METHOD, BLControl.util.isClustering(), logger);
                sleepTime = BLControl.util.getTimerSchedule("BLRESUMEWSMDB");
                this.setSleepTime(sleepTime);
            }
            catch (BizLogicException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (BLControl.logger != null) {
                    BLControl.logger.error((Object)"Exception in ResumeWorkstep:runResumeWS(): ", (Throwable)ex);
                }
                throw new RuntimeException("Exception in ResumeWorkstep:runResumeWS() ", ex);
            }
            isRunning = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.setDebug(BLControl.util.DEBUG_PRECONDITION);
                Object[] objectArray = new Object[1];
                BLConstants.single();
                objectArray[0] = "Precondition Wait Workstep Service(BLRESUMEWSMDB)";
                BLControl.logger.infoKey("BizLogic_ERR_1010", objectArray);
                this.runService();
                Object[] objectArray2 = new Object[1];
                BLConstants.single();
                objectArray2[0] = "Precondition Wait Workstep Service(BLRESUMEWSMDB)";
                BLControl.logger.infoKey("BizLogic_ERR_4658", objectArray2);
            }
            catch (BizLogicException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (BLControl.logger != null) {
                    BLControl.logger.error((Object)"Exception in ResumeWorkstep:runService(): ", ex);
                }
                throw new RuntimeException("Exception in ResumeWorkstep: runService() ", ex);
            }
            finally {
                isRunning = false;
            }
            return;
        }
    }

    public void validateAndResumeWorkStep() throws Exception {
        if (BLControl.util.DEBUG_PRECONDITION) {
            BLControl.logger.debugKey("BizLogic_ERR_3261", "WFPreCondition.validateAndResumeWorkStep()", new Object[]{"RESUMEWS", System.currentTimeMillis()});
        }
        Hashtable ht = null;
        BMTimer bmtimer = null;
        this.setDebug(BLControl.util.DEBUG_PRECONDITION);
        if (BLUtil.doBenchmark() && (bmtimer = BMTimer.getInstance((String)"WaitWorkstepDAO")) != null) {
            bmtimer.setLogger(BLControl.logger);
            bmtimer.resetStartTime();
        }
        if ((ht = (Hashtable)BLUtil.getServiceLocal().getPreConditionWaitListForGDS()) != null && !ht.isEmpty()) {
            if (bmtimer != null && BLUtil.doBenchmark()) {
                rwSize = ht.size();
                if (bmtimer != null) {
                    bmtimer.printTime("Loading " + rwSize + " ResumeWS records from DB");
                }
            }
            this.resumeWorkStep(ht, true);
        }
    }

    private void resumeWorkStep(Hashtable ht, boolean isReValidate) throws Exception {
        HashMap ptInfo = (HashMap)ht.get("PTINFO");
        ht.remove("PTINFO");
        long piid = -1L;
        long ptid = -1L;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            piid = (Long)key;
            ptid = (Long)ptInfo.get(key);
            Vector wsids = (Vector)ht.get(key);
            BLUtil.getServiceLocal().executeResumeWS(ptid, piid, wsids, isReValidate);
        }
    }

    public void executeResumeWS(long ptid, long piid, Vector wsids, boolean isReValidate) {
        WFProcess pt = null;
        WFWorkstep ws = null;
        WFProcessContext pCtx = new WFProcessContext(null, ptid, piid);
        int piStatus = pCtx.getProcessInstanceEB().getState();
        BLConstants.single();
        if (piStatus != 8) {
            for (int ix = wsids.size() - 1; ix >= 0; --ix) {
                long wsid = (Long)wsids.elementAt(ix);
                if (WFWorkstepInstance.single().isSuspended(pCtx, wsid)) {
                    if (!BLControl.util.DEBUG_PRECONDITION) continue;
                    pt = pCtx.getProcess();
                    BLControl.logger.debugKey("BizLogic_ERR_3276", "WFPreCondition.executeResumeWS()", new Object[]{pt != null ? pt.getWorkstep(wsid).getName() : NULL, pCtx.getProcessInstanceName()});
                    continue;
                }
                String precond = null;
                int precondType = -1;
                if (isReValidate) {
                    pt = pCtx.getProcess();
                    ws = pt.getWorkstep(wsid);
                    precond = ws.getPreCondition();
                    precondType = ws.getPreConditionType();
                }
                if (BLControl.util.DEBUG_PRECONDITION) {
                    BLControl.logger.debugKey("BizLogic_ERR_8002", "WFPreCondition.executeResumeWS()", new Object[]{pt != null ? pt.getWorkstep(wsid).getPreCondition() : NULL, pt != null ? pt.getWorkstep(wsid).getName() : NULL, pCtx.getProcessInstanceName()});
                }
                boolean isValid = false;
                if (this.validateCondition(pCtx, wsid, precondType, precond)) {
                    pCtx.resumeWorkstep(wsid);
                    WaitWorkStepDAO.remove(piid, wsid);
                    isValid = true;
                }
                if (!BLControl.util.DEBUG_PRECONDITION) continue;
                BLControl.logger.debugKey("BizLogic_ERR_3258", "WFPreCondition.executeResumeWS()", new Object[]{precond, precondType, isValid, pCtx.getProcessInstanceName(), pt == null ? null : pt.getWorkstep(wsid).getName()});
            }
        }
    }

    public String formattingCondition(String preCondition) {
        String q = BLUtil.replace((String)preCondition, (String)" AND ", (String)" AN ");
        q = BLUtil.replace((String)q, (String)"==", (String)" == ");
        q = BLUtil.replace((String)q, (String)"!=", (String)" != ");
        q = BLUtil.replace((String)q, (String)">=", (String)" >= ");
        q = BLUtil.replace((String)q, (String)"<=", (String)" <= ");
        q = BLUtil.replace((String)q, (String)"<", (String)" < ");
        q = BLUtil.replace((String)q, (String)">", (String)" > ");
        q = BLUtil.replace((String)q, (String)" > = ", (String)" >= ");
        q = BLUtil.replace((String)q, (String)" < = ", (String)" <= ");
        return q;
    }

    public Vector getPreConditionSlots(String preCondition) {
        Vector<String> dsNameList = new Vector<String>();
        if (BLUtil.isJS((String)preCondition)) {
            return dsNameList;
        }
        String s1 = BLUtil.replace((String)preCondition, (String)" AN ", (String)"&");
        String s2 = BLUtil.replace((String)s1, (String)" OR ", (String)"&");
        StringTokenizer st = new StringTokenizer(s2, "&");
        while (st.hasMoreTokens()) {
            String singleExpression = st.nextToken().trim();
            StringTokenizer subSt = new StringTokenizer(singleExpression);
            dsNameList.addElement(subSt.nextToken().trim());
            if (!subSt.hasMoreTokens()) continue;
            subSt.nextToken();
            if (!subSt.hasMoreTokens()) continue;
            String value = subSt.nextToken().trim();
            if (!value.startsWith("@")) continue;
            dsNameList.addElement(value.substring("@".length()));
        }
        return dsNameList;
    }

    public Vector getJavaPreConditionSlots(String javaPreCondition, HashMap dsMap) {
        Vector<String> dsVect = new Vector<String>(2);
        for (String dsName : dsMap.keySet()) {
            if (javaPreCondition.indexOf(dsName) == -1 || dsVect.contains(dsName)) continue;
            dsVect.add(dsName);
        }
        return dsVect;
    }

    public boolean validateJS(WFProcessContext pCtx, String wfObjName, String js, Script jScript, String scriptLocation) {
        boolean jsretval = false;
        Object retv = WFJavaScript.executeJS(pCtx, wfObjName, js, jScript, scriptLocation);
        if (retv != null) {
            jsretval = Boolean.valueOf(retv.toString());
        }
        if (BLControl.util.DEBUG_PRECONDITION) {
            BLControl.logger.debugKey("BizLogic_ERR_3256", "WFPreCondition.validateJS()", new Object[]{jsretval, js, pCtx.getProcessInstanceName(), wfObjName});
        }
        return jsretval;
    }

    public boolean validateJavaCode(WFProcessContext pCtx, long wfObjId, String wfObjName, String code) {
        boolean retVal = false;
        Object retv = WFJavaScript.executeJavaCode(pCtx, wfObjId, wfObjName, code);
        if (retv != null) {
            retVal = Boolean.valueOf(retv.toString());
        }
        if (BLControl.util.DEBUG_PRECONDITION) {
            String wsName = wfObjName;
            if ((wsName == null || wsName.trim().length() == 0) && wfObjId != -1L) {
                wsName = pCtx.getProcess().getWorkstep(wfObjId).getName();
            }
            BLControl.logger.debugKey("BizLogic_ERR_3250", "WFPreCondition.validateJavaCode()", new Object[]{code, retVal, wsName, pCtx.getProcessInstanceName()});
        }
        return retVal;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public boolean getStopFlag() {
        return WFPreCondition.isRunning() && BLControl.isServerReady();
    }

    private class PreConditionHandler
    implements IServiceHandler {
        private PreConditionHandler() {
        }

        public String getServiceName() {
            return "PreCondition";
        }

        public void startService() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WFPreCondition.this.runResumeWS();
                }
            }).start();
        }

        public void stopService() {
            isRunning = false;
        }

        public boolean isServiceRunning() {
            return WFPreCondition.isRunning();
        }
    }
}

