/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceEBBBean;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.DBConstants;
import com.savvion.sbm.util.DBService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.ObjectNotFoundException;

public class ProcessInstanceDAO
extends BLDAOService {
    private static final int INITIAL_CAPACITY = 500;
    public static final String PI_DUEDATE = "PI_DUEDATE";
    public static final String PI_STARTTIME = "PI_STARTTIME";
    public static final String PI_STATUS = "PI_STATUS";
    public static final String PI_PRIORITY = "PI_PRIORITY";
    public static final String PI_CREATOR = "PI_CREATOR";
    private static final String[] CREATE_LIST;
    private static final String[] CREATE_TABLELIST;
    private static final String[] LOAD_TABLELIST;
    private static final String[] CLIENT_ATTRLIST;
    private static final String[] CLIENT_ATTR_TABLELIST;
    public static String removeProcessInstance;
    public static String findByPrimaryKey;
    public static String findByName;
    public static String findByProcessTemplate;
    public static String getProcessInstanceCount;
    public static String getProcessInstanceList;
    public static String createProcessInstance;
    public static String loadProcessInstance;
    private static String getCountByProcessTemplateAndCreator;
    private static String getCountByProcessTemplate;
    private static String getCallerInfo;
    private static String getNodeVisited;
    private static String getStartPoint;
    private static String removeLockRecord;
    private static String createLockRecord;
    private static String findByPTWithPID;
    private static String getMilestonePIList;
    private static String getMilestoneSubquery;
    private static String getMilestoneOrderby;
    private static String getNameAndParentId;
    public static String isEventExistForPI;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(HashMap attrsList) throws CreateException {
        String key = null;
        Object value = null;
        Connection conn = null;
        PreparedStatement pstmtCreateProcessInstance = null;
        long piid = -1L;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtCreateProcessInstance = conn.prepareStatement(createProcessInstance);
            for (int ix = 0; ix < CREATE_LIST.length; ++ix) {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        key = CREATE_LIST[ix];
                                        value = attrsList.get(key);
                                        if (key.equalsIgnoreCase("STATUS")) break block30;
                                        if (!key.equalsIgnoreCase("PRIORITY")) break block31;
                                    }
                                    if (value == null) {
                                        pstmtCreateProcessInstance.setNull(ix + 1, 4);
                                        continue;
                                    }
                                    pstmtCreateProcessInstance.setInt(ix + 1, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("PROCESSINSTANCENAME")) break block32;
                                if (key.equalsIgnoreCase("CREATOR")) break block32;
                                if (!key.equalsIgnoreCase("FOLDER_ID")) break block33;
                            }
                            if (value == null) {
                                pstmtCreateProcessInstance.setNull(ix + 1, 12);
                                continue;
                            }
                            pstmtCreateProcessInstance.setString(ix + 1, value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block34;
                        if (key.equalsIgnoreCase("PARENTID")) break block34;
                        if (key.equalsIgnoreCase("RPID")) break block34;
                        if (!key.equalsIgnoreCase("RPTID")) break block35;
                    }
                    if (value == null) {
                        pstmtCreateProcessInstance.setNull(ix + 1, -5);
                        continue;
                    }
                    pstmtCreateProcessInstance.setLong(ix + 1, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("PROCESSINSTANCEID")) {
                    if (value == null) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = "PROCESSINSTANCEID";
                        objectArray[1] = "PROCESSINSTANCE";
                        throw new CreateException(BLControl.msgFactory.lookup("BizLogic_ERR_1588", objectArray));
                    }
                    piid = value;
                    pstmtCreateProcessInstance.setLong(ix + 1, piid);
                    continue;
                }
                if (key.equalsIgnoreCase("DUEDATE")) {
                    if (value == null) {
                        pstmtCreateProcessInstance.setNull(ix + 1, -5);
                        continue;
                    }
                    ProcessInstanceDAO.setDateValue((PreparedStatement)pstmtCreateProcessInstance, (int)(ix + 1), (long)((Long)value).longValue());
                    continue;
                }
                if (!key.equalsIgnoreCase("CALLERINFO")) continue;
                if (value == null) {
                    pstmtCreateProcessInstance.setNull(ix + 1, -3);
                    continue;
                }
                ByteArrayInputStream contextInsert = new ByteArrayInputStream(ProcessInstanceDAO.convertToBytes(value));
                pstmtCreateProcessInstance.setBinaryStream(ix + 1, (InputStream)contextInsert, contextInsert.available());
            }
            pstmtCreateProcessInstance.executeUpdate();
            int n = BLControl.util.getLockLevel();
            BLConstants.single();
            if (n == 3) {
                ProcessInstanceDAO.createLockRecord(piid);
            }
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{createProcessInstance, ProcessInstanceDAO.getPrimaryKey(piid)});
            }
        }
        catch (CreateException createEx) {
            throw createEx;
        }
        catch (Exception ex) {
            ProcessInstanceDAO.handle((Throwable)ex, (String)("PIDAO.create(PKey: " + piid + ")"));
        }
        finally {
            ProcessInstanceDAO.clean(null, (Statement)pstmtCreateProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createLockRecord(long pid) {
        Connection conn = null;
        PreparedStatement pstmtCreateLockRecord = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtCreateLockRecord = conn.prepareStatement(createLockRecord);
            pstmtCreateLockRecord.setLong(1, pid);
            pstmtCreateLockRecord.executeUpdate();
        }
        catch (Exception ex) {
            ProcessInstanceDAO.handle((Throwable)ex, (String)("PIDAO.createLockRecord(PKey: " + pid + ")"));
        }
        finally {
            ProcessInstanceDAO.clean(null, (Statement)pstmtCreateLockRecord, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long findByPrimaryKey(Long piid) throws ObjectNotFoundException {
        Connection conn = null;
        PreparedStatement pstmtFindByPrimaryKey = null;
        ResultSet rs = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtFindByPrimaryKey = conn.prepareStatement(findByPrimaryKey);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
            }
            pstmtFindByPrimaryKey.setLong(1, piid);
            rs = pstmtFindByPrimaryKey.executeQuery();
            if (!rs.next()) {
                throw new ObjectNotFoundException(BLControl.msgFactory.lookup("BizLogic_ERR_1589", new Object[]{"PROCESSINSTANCE", "ID=" + piid}));
            }
            ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
            return piid;
        }
        catch (ObjectNotFoundException finderEx) {
            throw finderEx;
            catch (Throwable th) {
                ProcessInstanceDAO.handle((Throwable)th);
                return piid;
            }
        }
        finally {
            ProcessInstanceDAO.clean(rs, (Statement)pstmtFindByPrimaryKey, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long findByName(String piName) throws ObjectNotFoundException {
        Connection conn = null;
        PreparedStatement pstmtFindByName = null;
        ResultSet rs = null;
        long piid = 0L;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtFindByName = conn.prepareStatement(findByName);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByName, new Object[0]);
            }
            pstmtFindByName.setString(1, piName);
            rs = pstmtFindByName.executeQuery();
            if (!rs.next()) {
                throw new ObjectNotFoundException(BLControl.msgFactory.lookup("BizLogic_ERR_1589", new Object[]{"PROCESSINSTANCE", "NAME=" + piName}));
            }
            piid = rs.getLong(1);
            ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindByName, (Connection)conn);
            return piid;
        }
        catch (ObjectNotFoundException finderEx) {
            throw finderEx;
            catch (Throwable th) {
                ProcessInstanceDAO.handle((Throwable)th);
                return piid;
            }
        }
        finally {
            ProcessInstanceDAO.clean(rs, (Statement)pstmtFindByName, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List findByProcessTemplate(long ptid) {
        ArrayList<Long> primaryKeys = new ArrayList<Long>();
        Connection conn = null;
        PreparedStatement pstmtFindByProcessTemplate = null;
        ResultSet rs = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtFindByProcessTemplate = conn.prepareStatement(findByProcessTemplate);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByProcessTemplate, new Object[0]);
            }
            pstmtFindByProcessTemplate.setLong(1, ptid);
            rs = pstmtFindByProcessTemplate.executeQuery();
            while (rs.next()) {
                primaryKeys.add(rs.getLong(1));
            }
        }
        catch (Throwable th) {
            try {
                ProcessInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ProcessInstanceDAO.clean(rs, (Statement)pstmtFindByProcessTemplate, (Connection)conn);
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindByProcessTemplate, (Connection)conn);
        return primaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> findAfterLastInstanceId(long ptid, long lastPID) {
        ArrayList<Map<String, Object>> piDetails = new ArrayList<Map<String, Object>>();
        Connection conn = null;
        PreparedStatement pstmtFindByPTWithPID = null;
        ResultSet rs = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtFindByPTWithPID = conn.prepareStatement(findByPTWithPID);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPTWithPID, new Object[0]);
            }
            pstmtFindByPTWithPID.setLong(1, ptid);
            pstmtFindByPTWithPID.setLong(2, lastPID);
            rs = pstmtFindByPTWithPID.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> piMap = new HashMap<String, Object>();
                piDetails.add(piMap);
                piMap.put("PROCESSINSTANCEID", rs.getLong(1));
                piMap.put("PARENTID", rs.getLong(2));
                piMap.put("PROCESSTEMPLATEID", rs.getLong(3));
                piMap.put("PROCESSINSTANCENAME", rs.getString(4));
                piMap.put("RPTID", rs.getLong(5));
                piMap.put("RPID", rs.getLong(6));
            }
        }
        catch (Throwable th) {
            try {
                ProcessInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ProcessInstanceDAO.clean(rs, (Statement)pstmtFindByPTWithPID, (Connection)conn);
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindByPTWithPID, (Connection)conn);
        return piDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(ProcessInstanceEBBBean piEB, Long piid) {
        ResultSet rs;
        PreparedStatement pstmtLoadProcessInstance;
        Connection conn;
        block5: {
            conn = null;
            pstmtLoadProcessInstance = null;
            rs = null;
            try {
                conn = ProcessInstanceDAO.getConnection();
                pstmtLoadProcessInstance = conn.prepareStatement(loadProcessInstance);
                pstmtLoadProcessInstance.setLong(1, piid);
                rs = pstmtLoadProcessInstance.executeQuery();
                if (!rs.next()) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = "ProcessInstance";
                    objectArray[1] = piid;
                    DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
                    objectArray[2] = "BIZLOGIC_PROCESSINSTANCE";
                    throw new BizLogicException("BizLogic_ERR_1548", "ProcessInstanceDAO.load", objectArray);
                }
                piEB.id = rs.getLong(1);
                piEB.processTemplateID = rs.getLong(2);
                piEB.parentID = rs.getLong(3);
                piEB.rootInstanceID = rs.getLong(4);
                piEB.duedate = ProcessInstanceDAO.getDateValue((ResultSet)rs, (int)5);
                piEB.timeStarted = ProcessInstanceDAO.getDateValue((ResultSet)rs, (int)6);
                piEB.state = rs.getInt(7);
                piEB.priority = rs.getInt(8);
                piEB.isCallbackCaller = rs.getInt(9);
                piEB.name = rs.getString(10);
                piEB.creator = rs.getString(11);
                piEB.folderId = rs.getString(12);
                piEB.rootTemplateID = rs.getLong("RPTID");
                piEB.startPoint = null;
                piEB.nodeVisited = null;
                piEB.callerInfo = null;
                if (!BLControl.util.DEBUG_DAO) break block5;
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{loadProcessInstance, ProcessInstanceDAO.getPrimaryKey(piid)});
            }
            catch (Exception ex) {
                try {
                    piEB.handleEBEx("PIEB:load", piid, ex);
                    ProcessInstanceDAO.handle((Throwable)ex);
                }
                catch (Throwable throwable) {
                    ProcessInstanceDAO.clean(rs, (Statement)pstmtLoadProcessInstance, (Connection)conn);
                    throw throwable;
                }
                ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtLoadProcessInstance, (Connection)conn);
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtLoadProcessInstance, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(ProcessInstanceEBBBean piEB, Long piid, HashMap modifiedAttrs) {
        Connection conn = null;
        PreparedStatement pstmtStoreProcessInstance = null;
        int attrsCount = modifiedAttrs.size();
        StringBuffer sb = new StringBuffer(200);
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("update ").append("BIZLOGIC_PROCESSINSTANCE");
        ProcessInstanceDAO.addRowlockHint((StringBuffer)sb);
        sb.append(" set ");
        Iterator keySet = modifiedAttrs.keySet().iterator();
        String key = null;
        Object value = null;
        int counter = 0;
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            sb.append(key);
            sb.append(" = ?");
            if (counter != attrsCount - 1) {
                sb.append(", ");
            }
            ++counter;
        }
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        String storeProcessInstance = sb.toString();
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtStoreProcessInstance = conn.prepareStatement(storeProcessInstance);
            keySet = modifiedAttrs.keySet().iterator();
            key = null;
            value = null;
            counter = 1;
            while (keySet.hasNext()) {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                key = (String)keySet.next();
                                                value = modifiedAttrs.get(key);
                                                if (key.equalsIgnoreCase("PROCESSINSTANCEID")) break block32;
                                                if (key.equalsIgnoreCase("PROCESSTEMPLATEID")) break block32;
                                                if (key.equalsIgnoreCase("PARENTID")) break block32;
                                                if (key.equalsIgnoreCase("RPID")) break block32;
                                                if (key.equalsIgnoreCase("RPTID")) break block32;
                                                if (!key.equalsIgnoreCase("PROCESSINSTANCENAME")) break block33;
                                            }
                                            throw new BizLogicException("BizLogic_ERR_1587", "ProcessInstanceDAO.store", new Object[]{key, "ProcessInstance"});
                                        }
                                        if (key.equalsIgnoreCase("PRIORITY")) break block34;
                                        if (!key.equalsIgnoreCase("STATUS")) break block35;
                                    }
                                    if (value == null) {
                                        pstmtStoreProcessInstance.setNull(counter++, 4);
                                        continue;
                                    }
                                    pstmtStoreProcessInstance.setInt(counter++, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("ISCALLBACKCALLER")) {
                                    if (value == null) {
                                        pstmtStoreProcessInstance.setInt(counter++, -1);
                                        continue;
                                    }
                                    pstmtStoreProcessInstance.setInt(counter++, (Integer)value);
                                    continue;
                                }
                                if (key.equalsIgnoreCase("STARTPOINT")) break block36;
                                if (key.equalsIgnoreCase("NODEVISITED")) break block36;
                                if (key.equalsIgnoreCase("CREATOR")) break block36;
                                if (!key.equalsIgnoreCase("FOLDER_ID")) break block37;
                            }
                            if (value == null) {
                                pstmtStoreProcessInstance.setNull(counter++, 12);
                                continue;
                            }
                            pstmtStoreProcessInstance.setString(counter++, value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("DUEDATE")) break block38;
                        if (!key.equalsIgnoreCase("STARTTIME")) break block39;
                    }
                    if (value == null) {
                        pstmtStoreProcessInstance.setNull(counter++, -5);
                        continue;
                    }
                    ProcessInstanceDAO.setDateValue((PreparedStatement)pstmtStoreProcessInstance, (int)counter++, (long)((Long)value).longValue());
                    continue;
                }
                if (!key.equalsIgnoreCase("CALLERINFO")) continue;
                if (value == null) {
                    pstmtStoreProcessInstance.setNull(counter++, -3);
                    continue;
                }
                ByteArrayInputStream contextInsert = new ByteArrayInputStream(ProcessInstanceDAO.convertToBytes(value));
                pstmtStoreProcessInstance.setBinaryStream(counter++, (InputStream)contextInsert, contextInsert.available());
            }
            pstmtStoreProcessInstance.setLong(counter, piid);
            pstmtStoreProcessInstance.executeUpdate();
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{storeProcessInstance, ProcessInstanceDAO.getPrimaryKey(piid)});
            }
        }
        catch (Exception ex) {
            piEB.handleEBEx("PIEB:store", piid, ex);
            ProcessInstanceDAO.handle((Throwable)ex);
        }
        finally {
            ProcessInstanceDAO.clean(null, (Statement)pstmtStoreProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveProcessInstance = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtRemoveProcessInstance = conn.prepareStatement(removeProcessInstance);
            pstmtRemoveProcessInstance.setLong(1, piid);
            pstmtRemoveProcessInstance.executeUpdate();
            int n = BLControl.util.getLockLevel();
            BLConstants.single();
            if (n == 3) {
                ProcessInstanceDAO.removeLockRecord(piid);
            }
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1207", new Object[]{removeProcessInstance, ProcessInstanceDAO.getPrimaryKey(piid)});
            }
        }
        catch (Throwable th) {
            ProcessInstanceDAO.handle((Throwable)th);
        }
        finally {
            ProcessInstanceDAO.clean(null, (Statement)pstmtRemoveProcessInstance, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLockRecord(long pid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveLockRecord = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtRemoveLockRecord = conn.prepareStatement(removeLockRecord);
            pstmtRemoveLockRecord.setLong(1, pid);
            pstmtRemoveLockRecord.executeUpdate();
        }
        catch (Exception ex) {
            ProcessInstanceDAO.handle((Throwable)ex, (String)("PIDAO.removeLockRecord(PKey: " + pid + ")"));
        }
        finally {
            ProcessInstanceDAO.clean(null, (Statement)pstmtRemoveLockRecord, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getStartPoint(ProcessInstanceEBBBean piEB, Long piid) {
        Connection conn = null;
        PreparedStatement pstmtGetStartPoint = null;
        ResultSet rset = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtGetStartPoint = conn.prepareStatement(getStartPoint);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getStartPoint, new Object[0]);
            }
            pstmtGetStartPoint.setLong(1, piid);
            rset = pstmtGetStartPoint.executeQuery();
            if (rset.next()) {
                piEB.startPoint = rset.getString(1);
            }
            ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetStartPoint, (Connection)conn);
        }
        catch (Exception ex) {
            piEB.handleEBEx("PIEB:getStartPoint", piid, ex);
            ProcessInstanceDAO.handle((Throwable)ex);
        }
        finally {
            ProcessInstanceDAO.clean(rset, (Statement)pstmtGetStartPoint, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getNodeVisited(ProcessInstanceEBBBean piEB, Long piid) {
        Connection conn = null;
        PreparedStatement pstmtGetNodeVisited = null;
        ResultSet rset = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtGetNodeVisited = conn.prepareStatement(getNodeVisited);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getNodeVisited, new Object[0]);
            }
            pstmtGetNodeVisited.setLong(1, piid);
            rset = pstmtGetNodeVisited.executeQuery();
            if (rset.next()) {
                piEB.nodeVisited = rset.getString(1);
            }
            ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetNodeVisited, (Connection)conn);
        }
        catch (Exception ex) {
            piEB.handleEBEx("PIEB:getNodeVisited", piid, ex);
            ProcessInstanceDAO.handle((Throwable)ex);
        }
        finally {
            ProcessInstanceDAO.clean(rset, (Statement)pstmtGetNodeVisited, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getCallerInfo(ProcessInstanceEBBBean piEB, Long piid) {
        Connection conn = null;
        PreparedStatement pstmtGetCallerInfo = null;
        ResultSet rset = null;
        try {
            InputStream is;
            conn = ProcessInstanceDAO.getConnection();
            pstmtGetCallerInfo = conn.prepareStatement(getCallerInfo);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getCallerInfo, new Object[0]);
            }
            pstmtGetCallerInfo.setLong(1, piid);
            rset = pstmtGetCallerInfo.executeQuery();
            if (rset.next() && (is = rset.getBinaryStream(1)) != null) {
                Object obj = ProcessInstanceDAO.convertToObject((InputStream)is);
                piEB.callerInfo = (HashMap)obj;
                ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetCallerInfo, (Connection)conn);
                return;
            }
            piEB.callerInfo = null;
            ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetCallerInfo, (Connection)conn);
        }
        catch (Exception ex) {
            piEB.handleEBEx("PIEB:getCallerInfo", piid, ex);
            ProcessInstanceDAO.handle((Throwable)ex);
        }
        finally {
            ProcessInstanceDAO.clean(rset, (Statement)pstmtGetCallerInfo, (Connection)conn);
        }
    }

    public static int getCount(long ptid) {
        return ProcessInstanceDAO.getCount(ptid, null);
    }

    public static int getActiveCount(long ptid) {
        int[] nArray = new int[1];
        nArray[0] = 7;
        return ProcessInstanceDAO.getCount(ptid, nArray);
    }

    public static int getSuspendedCount(long ptid) {
        int[] nArray = new int[1];
        nArray[0] = 8;
        return ProcessInstanceDAO.getCount(ptid, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCount(long ptid, int[] status) {
        ResultSet rs;
        PreparedStatement pstmtGetProcessInstanceCount;
        Connection conn;
        int count;
        block11: {
            count = 0;
            StringBuffer mainClause = new StringBuffer(getProcessInstanceCount);
            if (status != null && status.length > 0) {
                mainClause.append(" AND ");
                DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
                mainClause.append("STATUS");
                if (status.length == 1) {
                    mainClause.append(" = ? ");
                } else {
                    mainClause.append(" IN (");
                    for (int ix = 0; ix < status.length; ++ix) {
                        mainClause.append(String.valueOf(status[ix]));
                        if (ix < status.length - 1) {
                            mainClause.append(", ");
                            continue;
                        }
                        mainClause.append(") ");
                    }
                }
            }
            conn = null;
            pstmtGetProcessInstanceCount = null;
            rs = null;
            try {
                conn = ProcessInstanceDAO.getConnection();
                pstmtGetProcessInstanceCount = conn.prepareStatement(mainClause.toString());
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
                }
                pstmtGetProcessInstanceCount.setLong(1, ptid);
                if (status != null && status.length == 1) {
                    pstmtGetProcessInstanceCount.setInt(2, status[0]);
                }
                if (!(rs = pstmtGetProcessInstanceCount.executeQuery()).next()) break block11;
                count = rs.getInt(1);
            }
            catch (Throwable th) {
                try {
                    ProcessInstanceDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    ProcessInstanceDAO.clean(rs, pstmtGetProcessInstanceCount, (Connection)conn);
                    throw throwable;
                }
                ProcessInstanceDAO.clean(rs, (Statement)pstmtGetProcessInstanceCount, (Connection)conn);
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtGetProcessInstanceCount, (Connection)conn);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getCountByProcessTemplate(String creator, boolean readOnly) {
        Long processTemplateID = null;
        Integer status = null;
        Integer count = null;
        Connection conn = null;
        PreparedStatement pstmtGetCountByProcessTemplate = null;
        ResultSet rs = null;
        HashMap<Long, HashMap<Integer, Integer>> processTemplate = new HashMap<Long, HashMap<Integer, Integer>>();
        String countByProcessTemplate = getCountByProcessTemplate;
        if (creator != null) {
            countByProcessTemplate = getCountByProcessTemplateAndCreator;
        }
        try {
            conn = ProcessInstanceDAO.getConnection((boolean)readOnly);
            HashMap<Integer, Integer> processinstancestatus = null;
            pstmtGetCountByProcessTemplate = conn.prepareStatement(countByProcessTemplate);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", countByProcessTemplate, new Object[0]);
            }
            if (creator != null) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetCountByProcessTemplate.setString(1, creator);
                } else {
                    pstmtGetCountByProcessTemplate.setString(1, creator.toLowerCase());
                }
            }
            rs = pstmtGetCountByProcessTemplate.executeQuery();
            while (rs.next()) {
                processTemplateID = rs.getLong(1);
                status = rs.getInt(2);
                count = rs.getInt(3);
                processinstancestatus = (HashMap<Integer, Integer>)processTemplate.get(processTemplateID);
                if (processinstancestatus == null) {
                    processinstancestatus = new HashMap<Integer, Integer>();
                }
                processinstancestatus.put(status, count);
                processTemplate.put(processTemplateID, processinstancestatus);
            }
        }
        catch (Throwable th) {
            try {
                ProcessInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                ProcessInstanceDAO.clean(rs, pstmtGetCountByProcessTemplate, (Connection)conn);
                throw throwable;
            }
            ProcessInstanceDAO.clean(rs, (Statement)pstmtGetCountByProcessTemplate, (Connection)conn);
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtGetCountByProcessTemplate, (Connection)conn);
        return processTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getProcessInstanceList(long ptid, List wsidList) {
        Vector<Long> pstmtList = new Vector<Long>();
        StringBuffer sb = new StringBuffer(getMilestonePIList);
        sb.append(" ( ").append(getMilestoneSubquery);
        pstmtList.add(ptid);
        if (wsidList != null && !wsidList.isEmpty()) {
            sb.append(" AND ");
            DBConstants.TableAliasConstants cfr_ignored_0 = BLControl.dbconsts.tabalias;
            sb.append("BLWSI").append(".");
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            sb.append("WORKSTEP_ID");
            ProcessInstanceDAO.appendParamToSQLCondition((StringBuffer)sb, (List)wsidList, null);
            pstmtList.addAll(wsidList);
        }
        sb.append(" ) ").append(getMilestoneOrderby);
        Connection conn = null;
        PreparedStatement pstmtGetMilestonePIList = null;
        ResultSet rs = null;
        Vector piList = new Vector();
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtGetMilestonePIList = conn.prepareStatement(sb.toString());
            ProcessInstanceDAO.setPrepStmtValues((PreparedStatement)pstmtGetMilestonePIList, pstmtList);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sb.toString(), new Object[0]);
            }
            Vector<Long> piidList = new Vector<Long>();
            rs = pstmtGetMilestonePIList.executeQuery();
            while (rs.next()) {
                Long piidObj = new Long(rs.getLong(1));
                if (piidList.contains(piidObj)) continue;
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put(CLIENT_ATTRLIST[0], piidObj);
                attrs.put(CLIENT_ATTRLIST[1], rs.getLong(2));
                attrs.put(CLIENT_ATTRLIST[2], rs.getLong(3));
                attrs.put(CLIENT_ATTRLIST[3], rs.getLong(4));
                attrs.put(CLIENT_ATTRLIST[4], ProcessInstanceDAO.getDateValue((ResultSet)rs, (int)5));
                attrs.put(CLIENT_ATTRLIST[5], ProcessInstanceDAO.getDateValue((ResultSet)rs, (int)6));
                attrs.put(CLIENT_ATTRLIST[6], rs.getInt(7));
                attrs.put(CLIENT_ATTRLIST[7], rs.getInt(8));
                attrs.put(CLIENT_ATTRLIST[8], rs.getInt(9));
                attrs.put(CLIENT_ATTRLIST[9], rs.getString(10));
                attrs.put(CLIENT_ATTRLIST[10], rs.getString(11));
                attrs.put(CLIENT_ATTRLIST[11], rs.getString(12));
                attrs.put(CLIENT_ATTRLIST[12], rs.getLong("RPTID"));
                piList.addElement(attrs);
                piidList.add(piidObj);
            }
        }
        catch (Throwable th) {
            try {
                ProcessInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                ProcessInstanceDAO.clean(rs, pstmtGetMilestonePIList, (Connection)conn);
                throw throwable;
            }
            ProcessInstanceDAO.clean(rs, (Statement)pstmtGetMilestonePIList, (Connection)conn);
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtGetMilestonePIList, (Connection)conn);
        return piList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getProcessInstanceList(long[] ptIDs, long[] piIDs, int[] status, String creator, boolean readOnly) {
        Vector piList = new Vector();
        int ix = 0;
        boolean hasCondition = false;
        StringBuffer mainClause = new StringBuffer(getProcessInstanceList);
        StringBuffer whereClause = new StringBuffer(" WHERE ");
        if (ptIDs != null && ptIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
            whereClause.append("PROCESS_TEMPLATE_ID");
            if (ptIDs.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < ptIDs.length; ++ix) {
                    whereClause.append(String.valueOf(ptIDs[ix]));
                    if (ix < ptIDs.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (!hasCondition && piIDs != null && piIDs.length > 0) {
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            whereClause.append("PROCESS_INSTANCE_ID");
            if (piIDs.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < piIDs.length; ++ix) {
                    whereClause.append(String.valueOf(piIDs[ix]));
                    if (ix < piIDs.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (status != null && status.length > 0) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            whereClause.append("STATUS");
            if (status.length == 1) {
                whereClause.append(" = ? ");
            } else {
                whereClause.append(" IN (");
                for (ix = 0; ix < status.length; ++ix) {
                    whereClause.append(String.valueOf(status[ix]));
                    if (ix < status.length - 1) {
                        whereClause.append(", ");
                        continue;
                    }
                    whereClause.append(") ");
                }
            }
            hasCondition = true;
        }
        if (creator != null) {
            if (hasCondition) {
                whereClause.append(" AND ");
            }
            if (BLUtil.isUserManagerCaseSensitive()) {
                DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
                whereClause.append("CREATOR");
                whereClause.append(" = ? ");
            } else {
                BLConstants.single();
                whereClause.append("lower(");
                DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
                whereClause.append("CREATOR");
                whereClause.append(") = ? ");
            }
            hasCondition = true;
        }
        if (hasCondition) {
            mainClause.append(whereClause.toString());
        }
        Connection conn = null;
        PreparedStatement pstmtGetProcessInstanceList = null;
        ResultSet rs = null;
        try {
            conn = ProcessInstanceDAO.getConnection((boolean)readOnly);
            pstmtGetProcessInstanceList = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            int i = 1;
            if (ptIDs != null && ptIDs.length == 1) {
                pstmtGetProcessInstanceList.setLong(i++, ptIDs[0]);
            }
            if ((ptIDs == null || ptIDs.length == 0) && piIDs != null && piIDs.length == 1) {
                pstmtGetProcessInstanceList.setLong(i++, piIDs[0]);
            }
            if (status != null && status.length == 1) {
                pstmtGetProcessInstanceList.setInt(i++, status[0]);
            }
            if (creator != null) {
                if (BLUtil.isUserManagerCaseSensitive()) {
                    pstmtGetProcessInstanceList.setString(i, creator);
                } else {
                    pstmtGetProcessInstanceList.setString(i, creator.toLowerCase());
                }
            }
            rs = pstmtGetProcessInstanceList.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                ix = 0;
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getLong(1));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getLong(2));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getLong(3));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getLong(4));
                attrs.put(CLIENT_ATTRLIST[ix++], ProcessInstanceDAO.getDateValue((ResultSet)rs, (int)5));
                attrs.put(CLIENT_ATTRLIST[ix++], ProcessInstanceDAO.getDateValue((ResultSet)rs, (int)6));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getInt(7));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getInt(8));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getInt(9));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getString(10));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getString(11));
                attrs.put(CLIENT_ATTRLIST[ix++], rs.getString(12));
                int n = ix++;
                attrs.put(CLIENT_ATTRLIST[n], rs.getLong("RPTID"));
                piList.addElement(attrs);
            }
        }
        catch (Throwable th) {
            try {
                ProcessInstanceDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                ProcessInstanceDAO.clean(rs, pstmtGetProcessInstanceList, (Connection)conn);
                throw throwable;
            }
            ProcessInstanceDAO.clean(rs, (Statement)pstmtGetProcessInstanceList, (Connection)conn);
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtGetProcessInstanceList, (Connection)conn);
        return piList;
    }

    public static synchronized void initSQLStatements() {
        int ix = 0;
        StringBuffer sb = new StringBuffer(200);
        sb.append("insert into ");
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        ProcessInstanceDAO.addRowlockHint((StringBuffer)sb);
        sb.append(" (");
        for (ix = 0; ix < CREATE_TABLELIST.length; ++ix) {
            sb.append(CREATE_TABLELIST[ix]);
            if (ix == CREATE_TABLELIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(") values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        createProcessInstance = sb.toString();
        sb = new StringBuffer(220);
        sb.append("select ");
        for (ix = 0; ix < LOAD_TABLELIST.length; ++ix) {
            sb.append(LOAD_TABLELIST[ix]);
            if (ix == LOAD_TABLELIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_1 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        ProcessInstanceDAO.addNolockHint((StringBuffer)sb);
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        ProcessInstanceDAO.addReadUncommittedHint((StringBuffer)sb);
        loadProcessInstance = sb.toString();
        sb = new StringBuffer(90);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        ProcessInstanceDAO.addNolockHint((StringBuffer)sb);
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        ProcessInstanceDAO.addReadUncommittedHint((StringBuffer)sb);
        findByPrimaryKey = sb.toString();
        sb = new StringBuffer(90);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_7 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_NAME");
        sb.append(" = ?");
        findByName = sb.toString();
        sb = new StringBuffer(90);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_10 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(" = ?");
        findByProcessTemplate = sb.toString();
        sb = new StringBuffer(70);
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_12 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        removeProcessInstance = sb.toString();
        sb = new StringBuffer(100);
        sb.append("select count(*) from ");
        DBConstants.TableConstants cfr_ignored_14 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(" = ? ");
        getProcessInstanceCount = sb.toString();
        sb = new StringBuffer(220);
        sb.append("select ");
        for (ix = 0; ix < CLIENT_ATTR_TABLELIST.length; ++ix) {
            sb.append(CLIENT_ATTR_TABLELIST[ix]);
            if (ix == CLIENT_ATTR_TABLELIST.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_16 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" ");
        getProcessInstanceList = sb.toString();
        sb = new StringBuffer(220);
        DBConstants.KeywordConstants cfr_ignored_17 = BLControl.dbconsts.kwd;
        sb.append(" SELECT ");
        for (ix = 0; ix < CLIENT_ATTR_TABLELIST.length; ++ix) {
            DBConstants.TableAliasConstants cfr_ignored_18 = BLControl.dbconsts.tabalias;
            sb.append("BLPI").append(".");
            sb.append(CLIENT_ATTR_TABLELIST[ix]);
            if (ix == CLIENT_ATTR_TABLELIST.length - 1) continue;
            sb.append(", ");
        }
        DBConstants.KeywordConstants cfr_ignored_19 = BLControl.dbconsts.kwd;
        sb.append(" FROM ");
        DBConstants.TableConstants cfr_ignored_20 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        DBConstants.TableAliasConstants cfr_ignored_21 = BLControl.dbconsts.tabalias;
        sb.append(" ").append("BLPI");
        DBConstants.KeywordConstants cfr_ignored_22 = BLControl.dbconsts.kwd;
        sb.append(" ").append(" WHERE ");
        DBConstants.TableAliasConstants cfr_ignored_23 = BLControl.dbconsts.tabalias;
        sb.append(" ").append("BLPI").append(".");
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(" = ? ");
        sb.append(" AND EXISTS ");
        getMilestonePIList = sb.toString();
        sb = new StringBuffer(220);
        DBConstants.KeywordConstants cfr_ignored_25 = BLControl.dbconsts.kwd;
        sb.append(" SELECT ");
        DBConstants.TableAliasConstants cfr_ignored_26 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(".");
        DBConstants.ColConstants cfr_ignored_27 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        DBConstants.KeywordConstants cfr_ignored_28 = BLControl.dbconsts.kwd;
        sb.append(" FROM ");
        DBConstants.TableConstants cfr_ignored_29 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKSTEPINSTANCE");
        DBConstants.TableAliasConstants cfr_ignored_30 = BLControl.dbconsts.tabalias;
        sb.append(" ").append("BLWSI");
        DBConstants.KeywordConstants cfr_ignored_31 = BLControl.dbconsts.kwd;
        sb.append(" ").append(" WHERE ");
        DBConstants.TableAliasConstants cfr_ignored_32 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(".");
        DBConstants.ColConstants cfr_ignored_33 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID").append(" = ");
        DBConstants.TableAliasConstants cfr_ignored_34 = BLControl.dbconsts.tabalias;
        sb.append("BLPI").append(".");
        DBConstants.ColConstants cfr_ignored_35 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID").append(" AND ");
        DBConstants.TableAliasConstants cfr_ignored_36 = BLControl.dbconsts.tabalias;
        sb.append("BLWSI").append(".");
        DBConstants.ColConstants cfr_ignored_37 = BLControl.dbconsts.col;
        sb.append("STATUS").append(" = ");
        sb.append(21);
        getMilestoneSubquery = sb.toString();
        sb = new StringBuffer(100);
        sb.append(" ORDER BY ");
        DBConstants.TableAliasConstants cfr_ignored_38 = BLControl.dbconsts.tabalias;
        sb.append("BLPI").append(".");
        DBConstants.ColConstants cfr_ignored_39 = BLControl.dbconsts.col;
        sb.append("STARTTIME").append(" ASC");
        getMilestoneOrderby = sb.toString();
        sb = new StringBuffer(140);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_40 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_41 = BLControl.dbconsts.col;
        sb.append("STATUS").append(", count(*) ");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_42 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        ProcessInstanceDAO.addNolockHint((StringBuffer)sb);
        sb.append(" where ");
        if (BLUtil.isUserManagerCaseSensitive()) {
            DBConstants.ColConstants cfr_ignored_43 = BLControl.dbconsts.col;
            sb.append("CREATOR");
            sb.append(" = ? group by ");
        } else {
            BLConstants.single();
            sb.append("lower(");
            DBConstants.ColConstants cfr_ignored_44 = BLControl.dbconsts.col;
            sb.append("CREATOR");
            sb.append(") = ? group by ");
        }
        DBConstants.ColConstants cfr_ignored_45 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_46 = BLControl.dbconsts.col;
        sb.append("STATUS");
        ProcessInstanceDAO.addReadUncommittedHint((StringBuffer)sb);
        getCountByProcessTemplateAndCreator = sb.toString();
        sb = new StringBuffer(120);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_47 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_48 = BLControl.dbconsts.col;
        sb.append("STATUS").append(", count(*)");
        sb.append("  from ");
        DBConstants.TableConstants cfr_ignored_49 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" group by ");
        DBConstants.ColConstants cfr_ignored_50 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID").append(", ");
        DBConstants.ColConstants cfr_ignored_51 = BLControl.dbconsts.col;
        sb.append("STATUS");
        getCountByProcessTemplate = sb.toString();
        sb = new StringBuffer(100);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_52 = BLControl.dbconsts.col;
        sb.append("CALLERINFO");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_53 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_54 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        getCallerInfo = sb.toString();
        sb = new StringBuffer(100);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_55 = BLControl.dbconsts.col;
        sb.append("NODEVISITED");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_56 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_57 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        getNodeVisited = sb.toString();
        sb = new StringBuffer(100);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_58 = BLControl.dbconsts.col;
        sb.append("STARTPOINT");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_59 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_60 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        getStartPoint = sb.toString();
        sb = new StringBuffer(100);
        sb.append(" insert into ");
        DBConstants.TableConstants cfr_ignored_61 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PI_LOCK");
        ProcessInstanceDAO.addRowlockHint((StringBuffer)sb);
        sb.append(" ( ");
        DBConstants.ColConstants cfr_ignored_62 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" ) values (?)");
        createLockRecord = sb.toString();
        sb = new StringBuffer(70);
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_63 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PI_LOCK");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_64 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ?");
        removeLockRecord = sb.toString();
        sb = new StringBuffer(150);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_65 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(",");
        DBConstants.ColConstants cfr_ignored_66 = BLControl.dbconsts.col;
        sb.append("PARENTID");
        sb.append(",");
        DBConstants.ColConstants cfr_ignored_67 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(",");
        DBConstants.ColConstants cfr_ignored_68 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_NAME");
        sb.append(",");
        DBConstants.ColConstants cfr_ignored_69 = BLControl.dbconsts.col;
        sb.append("RPTID");
        sb.append(",");
        DBConstants.ColConstants cfr_ignored_70 = BLControl.dbconsts.col;
        sb.append("RPID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_71 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_72 = BLControl.dbconsts.col;
        sb.append("PROCESS_TEMPLATE_ID");
        sb.append(" = ? and ");
        DBConstants.ColConstants cfr_ignored_73 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" > ? order by ");
        DBConstants.ColConstants cfr_ignored_74 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        findByPTWithPID = sb.toString();
        sb = new StringBuffer(100);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_75 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_NAME");
        sb.append(",");
        DBConstants.ColConstants cfr_ignored_76 = BLControl.dbconsts.col;
        sb.append("PARENTID");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_77 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_PROCESSINSTANCE");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_78 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        getNameAndParentId = sb.toString();
        sb = new StringBuffer(100);
        DBConstants.KeywordConstants cfr_ignored_79 = BLControl.dbconsts.kwd;
        sb.append(" SELECT ");
        sb.append(" 1 ");
        DBConstants.KeywordConstants cfr_ignored_80 = BLControl.dbconsts.kwd;
        sb.append(" FROM ");
        sb.append(" BIZEVENT ");
        DBConstants.KeywordConstants cfr_ignored_81 = BLControl.dbconsts.kwd;
        sb.append(" WHERE ");
        DBConstants.ColConstants cfr_ignored_82 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        DBConstants.KeywordConstants cfr_ignored_83 = BLControl.dbconsts.kwd;
        sb.append(" = ? ");
        isEventExistForPI = sb.toString();
        ProcessInstanceDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"ProcessInstanceDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", loadProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByPrimaryKey, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByName, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", findByProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getProcessInstanceCount, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getProcessInstanceList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCountByProcessTemplateAndCreator, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCountByProcessTemplate, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMilestonePIList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMilestoneSubquery, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMilestoneOrderby, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getCallerInfo, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getNodeVisited, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getStartPoint, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createLockRecord, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeLockRecord, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getNameAndParentId, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", isEventExistForPI, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getNameAndParentId(long piid) {
        HashMap<String, Object> piInfo;
        ResultSet rset;
        PreparedStatement pstmt;
        Connection conn;
        block6: {
            conn = null;
            pstmt = null;
            rset = null;
            piInfo = new HashMap<String, Object>();
            try {
                conn = ProcessInstanceDAO.getConnection();
                pstmt = conn.prepareStatement(getNameAndParentId);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", getNameAndParentId, new Object[0]);
                }
                pstmt.setLong(1, piid);
                rset = pstmt.executeQuery();
                if (!rset.next()) break block6;
                piInfo.put("PROCESSINSTANCENAME", rset.getString(1));
                piInfo.put("PARENTID", rset.getLong(2));
            }
            catch (Throwable th) {
                try {
                    ProcessInstanceDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ProcessInstanceDAO.clean(rset, (Statement)pstmt, (Connection)conn);
                }
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmt, (Connection)conn);
        return piInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getProcessInstanceID(String piName) {
        long piid;
        ResultSet rset;
        PreparedStatement pstmtGetProcessInstanceID;
        Connection conn;
        block6: {
            conn = null;
            pstmtGetProcessInstanceID = null;
            rset = null;
            piid = 0L;
            try {
                conn = ProcessInstanceDAO.getConnection();
                pstmtGetProcessInstanceID = conn.prepareStatement(findByName);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", findByName, new Object[0]);
                }
                pstmtGetProcessInstanceID.setString(1, piName);
                rset = pstmtGetProcessInstanceID.executeQuery();
                if (!rset.next()) break block6;
                piid = rset.getLong(1);
            }
            catch (Throwable th) {
                try {
                    ProcessInstanceDAO.handle((Throwable)th);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ProcessInstanceDAO.clean(rset, (Statement)pstmtGetProcessInstanceID, (Connection)conn);
                }
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetProcessInstanceID, (Connection)conn);
        return piid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProcessInstanceExist(String piName) {
        Connection conn = null;
        PreparedStatement pstmtGetProcessInstanceID = null;
        ResultSet rset = null;
        boolean result = false;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtGetProcessInstanceID = conn.prepareStatement(findByName);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByName, new Object[0]);
            }
            pstmtGetProcessInstanceID.setString(1, piName);
            rset = pstmtGetProcessInstanceID.executeQuery();
            if (rset.next()) {
                result = true;
            }
            ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetProcessInstanceID, (Connection)conn);
        }
        catch (Exception ex) {
            if (!ProcessInstanceDAO.isDBReady()) {
                ProcessInstanceDAO.handle((Throwable)ex, (String)("PIDAO.isProcessInstanceExist(" + piName + ")"));
            }
        }
        finally {
            ProcessInstanceDAO.clean(rset, (Statement)pstmtGetProcessInstanceID, (Connection)conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isProcessInstanceExist(long piid) {
        Connection conn = null;
        PreparedStatement pstmtGetProcessInstanceID = null;
        ResultSet rset = null;
        boolean result = false;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtGetProcessInstanceID = conn.prepareStatement(findByPrimaryKey);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", findByPrimaryKey, new Object[0]);
            }
            pstmtGetProcessInstanceID.setLong(1, piid);
            rset = pstmtGetProcessInstanceID.executeQuery();
            if (rset.next()) {
                result = true;
            }
            ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmtGetProcessInstanceID, (Connection)conn);
        }
        catch (Exception ex) {
            if (!ProcessInstanceDAO.isDBReady()) {
                ProcessInstanceDAO.handle((Throwable)ex, (String)("PIDAO.isProcessInstanceExist(" + piid + ")"));
            }
        }
        finally {
            ProcessInstanceDAO.clean(rset, (Statement)pstmtGetProcessInstanceID, (Connection)conn);
        }
        return result;
    }

    public static Map findBySlotValues(long ptid, HashMap slotValues, int[] status) {
        WFProcess process = ProcessControl.getProcessTemplate(ptid);
        StringBuilder whereClause = new StringBuilder(500);
        whereClause.append(" where ");
        boolean hasSlotValues = false;
        int globalSlotCount = 0;
        if (slotValues != null && !slotValues.isEmpty()) {
            hasSlotValues = true;
            for (String dsName : slotValues.keySet()) {
                if (process.getDataslot(dsName).isGlobal()) {
                    ++globalSlotCount;
                }
                whereClause.append(DBService.polish((String)dsName)).append(" = ? ").append(" and ");
            }
            String str = whereClause.toString();
            String newstr = whereClause.substring(0, str.lastIndexOf("and"));
            whereClause = new StringBuilder(newstr);
        }
        ProcessInstanceDAO.addStatusCondition(status, hasSlotValues, whereClause);
        StringBuilder mainClause = new StringBuilder(500);
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        mainClause.append("select ").append(" pi.").append("PROCESS_INSTANCE_ID").append(", pi.").append("PARENTID").append(" from ");
        if (globalSlotCount > 0) {
            mainClause.append(process.getGlobalDSTableName());
            if (globalSlotCount < slotValues.size()) {
                mainClause.append(" , ").append(process.getDSTableName());
            }
        } else {
            mainClause.append(process.getDSTableName());
        }
        if (hasSlotValues && globalSlotCount < slotValues.size()) {
            mainClause.append(" ds ");
            DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
            DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
            whereClause.append(" and ").append("pi.").append("PROCESS_INSTANCE_ID").append(" = ds.").append("PROCESS_INSTANCE_ID");
        }
        DBConstants.TableConstants cfr_ignored_4 = BLControl.dbconsts.tab;
        mainClause.append(" , ").append("BIZLOGIC_PROCESSINSTANCE").append(" pi ").append(whereClause.toString());
        return ProcessInstanceDAO.fetchSlotValues(process, mainClause, slotValues);
    }

    private static void addStatusCondition(int[] status, boolean hasSlotValues, StringBuilder whereClause) {
        if (status != null && status.length > 0) {
            if (!hasSlotValues) {
                whereClause.append(" pi.");
            } else {
                whereClause.append(" and pi.");
            }
            whereClause.append("STATUS").append(ProcessInstanceDAO.getSQLCondition((int[])status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map fetchSlotValues(WFProcess process, StringBuilder mainClause, Map slotValues) {
        HashMap<Long, Long> piParentIDMap = new HashMap<Long, Long>();
        Connection conn = null;
        PreparedStatement pstmtFindBySlotValue = null;
        ResultSet rs = null;
        try {
            conn = ProcessInstanceDAO.getConnection();
            pstmtFindBySlotValue = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            if (slotValues != null) {
                int count = 0;
                for (String slotName : slotValues.keySet()) {
                    Object slotValue = slotValues.get(slotName);
                    WFDataslot ds = process.getDataslot(slotName);
                    String type = ds.getType();
                    if (type.equalsIgnoreCase("BOOLEAN")) {
                        if (((Boolean)slotValue).booleanValue()) {
                            pstmtFindBySlotValue.setInt(++count, 1);
                            continue;
                        }
                        pstmtFindBySlotValue.setInt(++count, 0);
                        continue;
                    }
                    if (type.equalsIgnoreCase("DOUBLE")) {
                        pstmtFindBySlotValue.setDouble(++count, (Double)slotValue);
                        continue;
                    }
                    if (type.equalsIgnoreCase("LONG")) {
                        pstmtFindBySlotValue.setLong(++count, (Long)slotValue);
                        continue;
                    }
                    if (type.equalsIgnoreCase("DECIMAL")) {
                        pstmtFindBySlotValue.setBigDecimal(++count, (BigDecimal)slotValue);
                        continue;
                    }
                    if (type.equalsIgnoreCase("DATETIME")) {
                        pstmtFindBySlotValue.setTimestamp(++count, (Timestamp)slotValue);
                        continue;
                    }
                    pstmtFindBySlotValue.setString(++count, (String)slotValue);
                }
            }
            rs = pstmtFindBySlotValue.executeQuery();
            while (rs.next()) {
                piParentIDMap.put(rs.getLong(1), rs.getLong(2));
            }
        }
        catch (SQLException sqlex) {
            try {
                ProcessInstanceDAO.handle((SQLException)sqlex);
            }
            catch (Throwable throwable) {
                ProcessInstanceDAO.clean(rs, pstmtFindBySlotValue, (Connection)conn);
                throw throwable;
            }
            ProcessInstanceDAO.clean(rs, (Statement)pstmtFindBySlotValue, (Connection)conn);
        }
        ProcessInstanceDAO.clean((ResultSet)rs, (Statement)pstmtFindBySlotValue, (Connection)conn);
        return piParentIDMap;
    }

    private static String getPrimaryKey(long piid) {
        StringBuffer parameterValues = new StringBuffer("piid=");
        parameterValues.append(piid);
        return parameterValues.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEventExistForPI(long piid) {
        boolean isEventExist;
        ResultSet rset;
        PreparedStatement pstmt;
        Connection conn;
        block5: {
            conn = null;
            pstmt = null;
            rset = null;
            isEventExist = false;
            try {
                conn = ProcessInstanceDAO.getConnection();
                pstmt = conn.prepareStatement(isEventExistForPI);
                if (BLControl.util.DEBUG_DAO) {
                    BLControl.logger.debugKey("BizLogic_ERR_1185", isEventExistForPI, new Object[0]);
                }
                pstmt.setLong(1, piid);
                pstmt.setMaxRows(1);
                rset = pstmt.executeQuery();
                if (!rset.next()) break block5;
                isEventExist = true;
            }
            catch (Throwable th) {
                try {
                    ProcessInstanceDAO.handle((Throwable)th, (String)("PIDAO.isEventExistForPI(" + piid + ")"));
                }
                catch (Throwable throwable) {
                    ProcessInstanceDAO.clean(rset, (Statement)pstmt, (Connection)conn);
                    throw throwable;
                }
                ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmt, (Connection)conn);
            }
        }
        ProcessInstanceDAO.clean((ResultSet)rset, (Statement)pstmt, (Connection)conn);
        return isEventExist;
    }

    static {
        String[] stringArray = new String[11];
        stringArray[0] = "PROCESSINSTANCEID";
        stringArray[1] = "PROCESSTEMPLATEID";
        stringArray[2] = "PARENTID";
        stringArray[3] = "RPTID";
        stringArray[4] = "RPID";
        stringArray[5] = "DUEDATE";
        stringArray[6] = "STATUS";
        stringArray[7] = "PRIORITY";
        stringArray[8] = "PROCESSINSTANCENAME";
        stringArray[9] = "CREATOR";
        stringArray[10] = "CALLERINFO";
        CREATE_LIST = stringArray;
        String[] stringArray2 = new String[11];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray2[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray2[2] = "PARENTID";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray2[3] = "RPTID";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[4] = "RPID";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray2[5] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray2[6] = "STATUS";
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray2[7] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray2[8] = "PROCESS_INSTANCE_NAME";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray2[9] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        stringArray2[10] = "CALLERINFO";
        CREATE_TABLELIST = stringArray2;
        String[] stringArray3 = new String[13];
        DBConstants.ColConstants cfr_ignored_11 = BLControl.dbconsts.col;
        stringArray3[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_12 = BLControl.dbconsts.col;
        stringArray3[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_13 = BLControl.dbconsts.col;
        stringArray3[2] = "PARENTID";
        DBConstants.ColConstants cfr_ignored_14 = BLControl.dbconsts.col;
        stringArray3[3] = "RPID";
        DBConstants.ColConstants cfr_ignored_15 = BLControl.dbconsts.col;
        stringArray3[4] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_16 = BLControl.dbconsts.col;
        stringArray3[5] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_17 = BLControl.dbconsts.col;
        stringArray3[6] = "STATUS";
        DBConstants.ColConstants cfr_ignored_18 = BLControl.dbconsts.col;
        stringArray3[7] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_19 = BLControl.dbconsts.col;
        stringArray3[8] = "ISCALLBACKCALLER";
        DBConstants.ColConstants cfr_ignored_20 = BLControl.dbconsts.col;
        stringArray3[9] = "PROCESS_INSTANCE_NAME";
        DBConstants.ColConstants cfr_ignored_21 = BLControl.dbconsts.col;
        stringArray3[10] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_22 = BLControl.dbconsts.col;
        stringArray3[11] = "FOLDER_ID";
        stringArray3[12] = "RPTID";
        LOAD_TABLELIST = stringArray3;
        String[] stringArray4 = new String[13];
        stringArray4[0] = "PROCESSINSTANCEID";
        stringArray4[1] = "PROCESSTEMPLATEID";
        stringArray4[2] = "PARENTID";
        stringArray4[3] = "RPID";
        stringArray4[4] = "DUEDATE";
        stringArray4[5] = "STARTTIME";
        stringArray4[6] = "STATUS";
        stringArray4[7] = "PRIORITY";
        stringArray4[8] = "ISCALLBACKCALLER";
        stringArray4[9] = "PROCESSINSTANCENAME";
        stringArray4[10] = "CREATOR";
        stringArray4[11] = "FOLDER_ID";
        stringArray4[12] = "RPTID";
        CLIENT_ATTRLIST = stringArray4;
        String[] stringArray5 = new String[13];
        DBConstants.ColConstants cfr_ignored_23 = BLControl.dbconsts.col;
        stringArray5[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_24 = BLControl.dbconsts.col;
        stringArray5[1] = "PROCESS_TEMPLATE_ID";
        DBConstants.ColConstants cfr_ignored_25 = BLControl.dbconsts.col;
        stringArray5[2] = "PARENTID";
        DBConstants.ColConstants cfr_ignored_26 = BLControl.dbconsts.col;
        stringArray5[3] = "RPID";
        DBConstants.ColConstants cfr_ignored_27 = BLControl.dbconsts.col;
        stringArray5[4] = "DUEDATE";
        DBConstants.ColConstants cfr_ignored_28 = BLControl.dbconsts.col;
        stringArray5[5] = "STARTTIME";
        DBConstants.ColConstants cfr_ignored_29 = BLControl.dbconsts.col;
        stringArray5[6] = "STATUS";
        DBConstants.ColConstants cfr_ignored_30 = BLControl.dbconsts.col;
        stringArray5[7] = "PRIORITY";
        DBConstants.ColConstants cfr_ignored_31 = BLControl.dbconsts.col;
        stringArray5[8] = "ISCALLBACKCALLER";
        DBConstants.ColConstants cfr_ignored_32 = BLControl.dbconsts.col;
        stringArray5[9] = "PROCESS_INSTANCE_NAME";
        DBConstants.ColConstants cfr_ignored_33 = BLControl.dbconsts.col;
        stringArray5[10] = "CREATOR";
        DBConstants.ColConstants cfr_ignored_34 = BLControl.dbconsts.col;
        stringArray5[11] = "FOLDER_ID";
        DBConstants.ColConstants cfr_ignored_35 = BLControl.dbconsts.col;
        stringArray5[12] = "RPTID";
        CLIENT_ATTR_TABLELIST = stringArray5;
    }
}

