/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class WorkItemPerformerDAO
extends BLDAOService {
    private static final String[] CREATE_TABLELIST;
    private static String insert;
    private static String getPerformer;
    private static String delete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(long piid, long wsid, int loopcounter, long wiid, String performer) {
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        try {
            conn = WorkItemPerformerDAO.getConnection();
            pstmtInsert = conn.prepareStatement(insert);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", insert, new Object[0]);
            }
            pstmtInsert.setLong(1, piid);
            pstmtInsert.setLong(2, wsid);
            pstmtInsert.setInt(3, loopcounter);
            pstmtInsert.setLong(4, wiid);
            pstmtInsert.setString(5, performer);
            pstmtInsert.executeUpdate();
        }
        catch (SQLException sqlex) {
            WorkItemPerformerDAO.handle((SQLException)sqlex);
        }
        finally {
            WorkItemPerformerDAO.clean(null, (Statement)pstmtInsert, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getPerformer(long piid, HashMap wsidList) {
        if (wsidList == null || wsidList.isEmpty()) {
            return new ArrayList();
        }
        WFProcessContext pCtx = new WFProcessContext(BLControl.getServerSession(), piid);
        Map.Entry entry2 = null;
        long wsid = -1L;
        HashMap validwsidList = new HashMap();
        for (Map.Entry entry2 : wsidList.entrySet()) {
            wsid = (Long)entry2.getKey();
            if (pCtx.getWorkstepInstanceEB(wsid, true) == null) {
                String wsName = pCtx.getWorkstep(wsid).getName();
                BLControl.logger.warnKey("BizLogic_ERR_3726", "WorkItemPerformerDAO:getPerformer(piid, wsidList)", new Object[]{wsName, wsid});
                continue;
            }
            validwsidList.put(entry2.getKey(), entry2.getValue());
        }
        if (validwsidList.isEmpty()) {
            return new ArrayList();
        }
        StringBuffer mainClause = new StringBuffer(getPerformer);
        mainClause.append(" where ");
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        mainClause.append("PROCESS_INSTANCE_ID");
        mainClause.append(" = ? AND (");
        int loopCounter = -1;
        Iterator i = validwsidList.entrySet().iterator();
        while (i.hasNext()) {
            entry2 = i.next();
            wsid = (Long)entry2.getKey();
            mainClause.append("(");
            DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
            mainClause.append("WORKSTEP_ID").append(" = ").append(wsid);
            if (((Boolean)entry2.getValue()).booleanValue()) {
                loopCounter = pCtx.getWorkstepInstanceEB(wsid).getLoopCounter();
                mainClause.append(" AND ");
                DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
                mainClause.append("LOOPCOUNTER").append(" = ").append(loopCounter);
            }
            mainClause.append(")");
            if (!i.hasNext()) continue;
            mainClause.append(" OR ");
        }
        mainClause.append(")");
        HashSet<String> performers = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmtGetPerformer = null;
        ResultSet rs = null;
        try {
            conn = WorkItemPerformerDAO.getConnection();
            pstmtGetPerformer = conn.prepareStatement(mainClause.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", mainClause.toString(), new Object[0]);
            }
            pstmtGetPerformer.setLong(1, piid);
            rs = pstmtGetPerformer.executeQuery();
            while (rs.next()) {
                performers.add(rs.getString(1));
            }
        }
        catch (SQLException sqlex) {
            try {
                WorkItemPerformerDAO.handle((SQLException)sqlex);
            }
            catch (Throwable throwable) {
                WorkItemPerformerDAO.clean(rs, pstmtGetPerformer, (Connection)conn);
                throw throwable;
            }
            WorkItemPerformerDAO.clean(rs, (Statement)pstmtGetPerformer, (Connection)conn);
        }
        WorkItemPerformerDAO.clean((ResultSet)rs, (Statement)pstmtGetPerformer, (Connection)conn);
        return new ArrayList(performers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(long piid) {
        Connection conn = null;
        PreparedStatement pstmtDelete = null;
        try {
            conn = WorkItemPerformerDAO.getConnection();
            pstmtDelete = conn.prepareStatement(delete);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", delete, new Object[0]);
            }
            pstmtDelete.setLong(1, piid);
            pstmtDelete.executeUpdate();
        }
        catch (SQLException sqlex) {
            WorkItemPerformerDAO.handle((SQLException)sqlex);
        }
        finally {
            WorkItemPerformerDAO.clean(null, (Statement)pstmtDelete, (Connection)conn);
        }
    }

    public static synchronized void initSQLStatements() {
        DBConstants.TableConstants cfr_ignored_0 = BLControl.dbconsts.tab;
        insert = WorkItemPerformerDAO.composeInsertStatement((String)"BIZLOGIC_WORKITEM_PERFORMER", (String[])CREATE_TABLELIST);
        StringBuffer sb = new StringBuffer(100);
        sb.append("select ");
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        sb.append("PERFORMER");
        sb.append(" from ");
        DBConstants.TableConstants cfr_ignored_2 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM_PERFORMER");
        getPerformer = sb.toString();
        sb = new StringBuffer(100);
        sb.append("delete from ");
        DBConstants.TableConstants cfr_ignored_3 = BLControl.dbconsts.tab;
        sb.append("BIZLOGIC_WORKITEM_PERFORMER");
        sb.append(" where ");
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        sb.append("PROCESS_INSTANCE_ID");
        sb.append(" = ? ");
        delete = sb.toString();
        WorkItemPerformerDAO.printSQLStatements();
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"WorkItemPerformerDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", insert, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getPerformer, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", delete, new Object[0]);
        }
    }

    static {
        String[] stringArray = new String[5];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray[3] = "WORKITEM_ID";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray[4] = "PERFORMER";
        CREATE_TABLELIST = stringArray;
    }
}

