/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.MDBAdapter;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.logger.SBMLogger;
import javax.jms.Message;

public class BLBizStoreMDB
extends MDBAdapter {
    public void onMessage(Message message) {
        String opr = null;
        try {
            BLConstants.single();
            opr = message.getStringProperty("OPERATION");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BLUtil bLUtil = BLUtil.self();
        BLConstants.single();
        BLConstants.single();
        BLConstants.single();
        if (!bLUtil.isBLServerReady("BLBIZSTOREMDB", opr, 5000, 10)) {
            return;
        }
        if (BLControl.util.SYNC_EVENT_WRITE) {
            return;
        }
        if (!BLControl.util.START_BIZSTORE) {
            return;
        }
        if (BLControl.util.DEBUG_UTIL) {
            BLControl.logger.debug((Object)"BLStartBizStoreMDB.onMessage()");
        }
        try {
            this.processBizStoreRequest(message);
        }
        catch (Throwable th) {
            if (BSControl.logger != null) {
                BSControl.logger.error((Object)"Error received in BLBizStoreMDB.onMessage()", th);
            }
            LoggerUtil.logSEP((Object)"Error received in BLBizStoreMDB.onMessage()");
            LoggerUtil.logSEP((Object)th.getMessage());
        }
    }

    private void processBizStoreRequest(Message message) {
        try {
            String sender;
            if (BLUtil.ignoreRedeliveredLifeCycleMessages((Message)message, (String)"BLBIZSTOREMDB")) {
                return;
            }
            String operation = message.getStringProperty("OPERATION");
            if (SBMUtil.isMessageNotFromSameNode((String)operation, (String)(sender = message.getStringProperty("SENDER_NODE_NAME")), (SBMLogger)BSControl.logger, (String)"BizStore_MSG_532", (String)"BizStore Service")) {
                return;
            }
            BSControl.performOperation(operation);
        }
        catch (Throwable t) {
            if (BSControl.logger != null) {
                BSControl.logger.error((Object)"Operation <processBizStoreRequest> Failed.", t);
            }
            LoggerUtil.logSEP((Object)"Operation <processBizStoreRequest> Failed.");
            LoggerUtil.logSEP((Object)t.getMessage());
        }
    }
}

