/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.AbstractDataSlotType;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ServiceLocator;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBObject;

public abstract class AbstractDataSlot
extends AbstractDataSlotType {
    private final long ptid;
    Object value;
    HashMap metaData = null;
    private transient EJBObject remoteRef;
    private Session session;
    boolean isValueModified = false;
    boolean isSystemDataSlot = false;
    private boolean isClustering = false;

    protected AbstractDataSlot(long ptid, String name, Object value, HashMap metaData) {
        super(name);
        this.ptid = ptid;
        this.metaData = metaData;
        this.value = value;
        this.isClustering = ServiceLocator.self().isCluster();
        if (value != null && "<NULL>".equals(value.toString()) && value instanceof String) {
            this.value = null;
        }
        String string = this.getName();
        BLConstants.single();
        this.isSystemDataSlot = string.startsWith("@");
    }

    public long getProcessTemplateID() {
        return this.ptid;
    }

    @Override
    public String getType() {
        try {
            if (this.isSystemDataSlot()) {
                String string = this.getName();
                StringBuilder stringBuilder = new StringBuilder();
                BLConstants.single();
                if (string.equalsIgnoreCase(stringBuilder.append("@").append("ALLDATASLOTS").toString())) {
                    BLConstants.single();
                    return "OBJECT";
                }
                String string2 = this.getName();
                StringBuilder stringBuilder2 = new StringBuilder();
                BLConstants.single();
                if (string2.equalsIgnoreCase(stringBuilder2.append("@").append("STARTTIME").toString())) {
                    BLConstants.single();
                    return "LONG";
                }
                if (this.getName().equalsIgnoreCase("@PROCESS_INSTANCE_ID")) {
                    BLConstants.single();
                    return "LONG";
                }
                BLConstants.single();
                return "STRING";
            }
            HashMap hashMap = this.getMetaData();
            BLConstants.single();
            return (String)hashMap.get("DATASLOTTYPE");
        }
        catch (BizLogicClientException blce) {
            throw new RuntimeException(blce);
        }
    }

    public String getLabel() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            String string = this.getName();
            BLConstants.single();
            return string.substring("@".length());
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        return (String)hashMap.get("LABEL");
    }

    public boolean isRequired() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return false;
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        Object isRequired = hashMap.get("REQUIRED");
        if (isRequired != null) {
            return (Boolean)isRequired;
        }
        return false;
    }

    public String getObjectType() throws BizLogicClientException {
        if (this.isObject()) {
            String string = this.getName();
            StringBuilder stringBuilder = new StringBuilder();
            BLConstants.single();
            if (string.equalsIgnoreCase(stringBuilder.append("@").append("ALLDATASLOTS").toString())) {
                return "java.util.HashMap";
            }
            HashMap hashMap = this.getMetaData();
            BLConstants.single();
            return (String)hashMap.get("DATASLOTOBJECTTYPE");
        }
        return null;
    }

    public List<Map<String, Object>> getConstructorData() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return null;
        }
        if (this.isObject()) {
            HashMap hashMap = this.getMetaData();
            BLConstants.single();
            return (List)hashMap.get("DATASLOTCONSTRUCTORDATA");
        }
        return null;
    }

    public boolean isNull() {
        return this.value == null || "<NULL>".equals(this.value.toString());
    }

    public int getSize() throws BizLogicClientException {
        block2: {
            block3: {
                String type = this.getType();
                if (this.isSystemDataSlot()) break block2;
                BLConstants.single();
                if (type.equals("STRING")) break block3;
                BLConstants.single();
                if (type.equals("URL")) break block3;
                BLConstants.single();
                if (type.equals("DOCUMENT")) break block3;
                BLConstants.single();
                if (!type.equals("DECIMAL")) break block2;
            }
            HashMap hashMap = this.getMetaData();
            BLConstants.single();
            return (Integer)hashMap.get("DATASLOTSIZE");
        }
        return -1;
    }

    public Vector getChoices() throws BizLogicClientException {
        if (this.hasChoices()) {
            BLConstants.single();
            return (Vector)this.metaData.get("DATASLOTCHOICES");
        }
        return null;
    }

    public boolean hasChoices() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return false;
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        Vector choices = (Vector)hashMap.get("DATASLOTCHOICES");
        return choices != null && !choices.isEmpty();
    }

    public Object getAppendWith() throws BizLogicClientException {
        if (!this.isSystemDataSlot()) {
            String string = this.getType();
            BLConstants.single();
            if (string.equals("STRING")) {
                HashMap hashMap = this.getMetaData();
                BLConstants.single();
                return hashMap.get("DATASLOTAPPENDWITH");
            }
        }
        return null;
    }

    public boolean isEditableByAuthor() {
        boolean isEditableByAuthor = false;
        if (!this.isSystemDataSlot()) {
            String string = this.getType();
            BLConstants.single();
            if (string.equals("DOCUMENT") && this.isMultiLine()) {
                HashMap hashMap = this.getMetaData();
                BLConstants.single();
                isEditableByAuthor = (Boolean)hashMap.get("ISEDITABLEBYAUTHORONLY");
            }
        }
        return isEditableByAuthor;
    }

    public boolean isPublic() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return false;
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        return (Boolean)hashMap.get("DATASLOTISPUBLIC");
    }

    public boolean getBizManageAccess() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return false;
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        return (Boolean)hashMap.get("DATASLOTBIZMANAGEACCESS");
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        if (this.isSystemDataSlot()) {
            return;
        }
        this.value = val;
        this.isValueModified = true;
    }

    public void setNullValue() {
        if (this.isSystemDataSlot()) {
            return;
        }
        this.setValue(null);
    }

    protected void setSession(Session ses) {
        this.session = ses;
    }

    public Session getSession() {
        return this.session;
    }

    public final EJBObject getRemoteRef() throws BizLogicClientException {
        if (this.remoteRef == null || this.isClustering) {
            this.remoteRef = this.findRemoteRef();
        }
        return this.remoteRef;
    }

    public boolean isSystemDataSlot() {
        return this.isSystemDataSlot;
    }

    public boolean isMultiLine() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return false;
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        return (Boolean)hashMap.get("DATASLOTMULTILINE");
    }

    public abstract HashMap getMetaData() throws BizLogicClientException;

    protected abstract EJBObject findRemoteRef() throws BizLogicClientException;

    public abstract void save() throws BizLogicClientException, RemoteException;

    public String getStringValue() {
        return this.value == null ? null : this.value.toString();
    }

    public boolean isGlobal() throws BizLogicClientException {
        if (this.isSystemDataSlot()) {
            return false;
        }
        HashMap hashMap = this.getMetaData();
        BLConstants.single();
        Boolean isGlobal = (Boolean)hashMap.get("DATASLOTISGLOBAL");
        if (isGlobal != null) {
            return isGlobal;
        }
        return false;
    }
}

