/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.client.command.LoginDialog;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.BizStoreSB;
import com.savvion.sbm.bizlogic.server.ejb.BizStoreSBHome;
import com.savvion.sbm.bizlogic.server.svo.BizLogicCluster;
import com.savvion.sbm.bizlogic.storeevent.mconsole.ejb.MConsoleSB;
import com.savvion.sbm.bizlogic.storeevent.mconsole.ejb.MConsoleSBHome;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import java.awt.Frame;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BizLogicServer {
    public static long timeout = 20000L;
    public static final String DEFAULT_USER = "ebms";
    protected String user = null;
    protected String passwd = null;
    protected Session session = null;
    private boolean dialogShown = false;
    protected int nodeCount = -1;
    protected boolean clustering = false;
    private HashMap serverInfo = null;
    protected boolean cancelled = false;
    private BLServer blserver = null;

    public BizLogicServer(String user, String passwd) {
        this.validateUser(user, passwd);
        this.user = user;
        this.passwd = passwd;
        this.init(-1);
    }

    public BizLogicServer(boolean showDialog) {
        if (showDialog) {
            this.loginFrame("Connect to BizLogic Server");
            if (this.isCancelled()) {
                return;
            }
        } else {
            this.user = SBMUtil.self().getGuestUser();
            this.passwd = SBMUtil.self().getGuestPasswd();
        }
        this.validateUser(this.user, this.passwd);
        this.init(-1);
    }

    public BizLogicServer(Session sess) {
        if (!this.isValidSession(sess)) {
            throw new BizLogicClientException("BizLogic_ERR_3854");
        }
        this.user = sess.getUser();
        this.session = sess;
        this.init(-1);
    }

    protected BizLogicServer() {
    }

    public Map start() {
        if (this.passwd == null) {
            throw new BizLogicClientException("BizLogic_ERR_3855");
        }
        HashMap blInfo = new HashMap(2);
        BLConstants consts = BLConstants.single();
        try {
            if (BLClientUtil.isBizlogicRunning()) {
                blInfo.put("SERVER_MSG", "BizLogic Server is already started");
                return blInfo;
            }
            this.blserver.start(this.user, this.passwd);
            blInfo = this.getBizLogicRef().getInfo(this.getSession());
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        BLConstants.single();
        blInfo.put("SERVER_MSG", "BizLogic Server is started");
        return blInfo;
    }

    public Map shutdown() {
        HashMap<String, String> blInfo = new HashMap<String, String>(2);
        if (!BLClientUtil.isBizlogicRunning()) {
            BLConstants.single();
            BLConstants.single();
            blInfo.put("SERVER_MSG", "BizLogic Server is already stopped");
            return blInfo;
        }
        return this.shutdown(this.getSession());
    }

    public Map shutdown(Session ses) {
        BLConstants consts = BLConstants.single();
        HashMap<String, String> blInfo = null;
        try {
            blInfo = this.getBizLogicRef().getInfo(ses);
            this.getBizLogicRef().shutdown(ses);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        String id = null;
        if (blInfo != null) {
            id = (String)blInfo.get("SERVER_ID");
        }
        blInfo = new HashMap<String, String>(2);
        blInfo.put("SERVER_MSG", "BizLogic Server is stopped");
        if (id != null) {
            blInfo.put(id, SBMUtil.getHost());
        }
        return blInfo;
    }

    public static boolean isCluster() {
        return ServiceLocator.self().isCluster();
    }

    public HashMap getInfo() {
        try {
            this.serverInfo = this.getBizLogicRef().getInfo(this.getSession());
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        if (!BizLogicServer.isCluster() && this.serverInfo == null) {
            throw new BizLogicClientException("BizLogic_ERR_3856");
        }
        return this.serverInfo;
    }

    public void setResponseTimeout(long to) {
        timeout = to;
    }

    public static BizLogicServer getInstance(String user, String passwd) {
        if (BizLogicServer.isCluster()) {
            return BizLogicServer.getInstance(user, passwd, ServiceLocator.self().getNodeCount());
        }
        return new BizLogicServer(user, passwd);
    }

    public static BizLogicServer getInstance(String user, String passwd, int count) {
        if (BizLogicServer.isCluster()) {
            return new BizLogicCluster(user, passwd, count);
        }
        return new BizLogicServer(user, passwd);
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    protected final void validateUser(String user, String passwd) {
        if (user == null || "".equals(user)) {
            throw new BizLogicClientException("BizLogic_ERR_3857");
        }
        if (passwd == null || "".equals(passwd)) {
            throw new BizLogicClientException("BizLogic_ERR_3858");
        }
        boolean valid = false;
        try {
            this.getBizLogicRef().validateUser(user, passwd);
            valid = true;
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        if (!valid) {
            throw new BizLogicClientException("BizLogic_ERR_3859");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession() {
        if (this.session == null) {
            BizLogicServer bizLogicServer = this;
            synchronized (bizLogicServer) {
                if (this.session == null) {
                    if (this.passwd == null) {
                        throw new BizLogicClientException("BizLogic_ERR_3860");
                    }
                    try {
                        this.session = this.getBizLogicRef().connect(this.user, this.passwd);
                    }
                    catch (Throwable th) {
                        this.throwEx(th);
                    }
                }
            }
        }
        return this.session;
    }

    protected final void init(int count) {
        if (BizLogicServer.isCluster()) {
            if (count <= 0) {
                BLConstants.ClusterConstants cfr_ignored_0 = BLConstants.single().cluster;
                if (count != -1) {
                    throw new BizLogicClientException("BizLogic_ERR_3861");
                }
            }
            this.nodeCount = count;
        }
        this.getBizLogicRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BLServer getBizLogicRef() {
        if (this.blserver == null) {
            BizLogicServer bizLogicServer = this;
            synchronized (bizLogicServer) {
                if (this.blserver == null) {
                    try {
                        BLServerHome home = (BLServerHome)SBMHomeFactory.self().lookupHome(BLServerHome.class);
                        this.blserver = home.create();
                    }
                    catch (Throwable th) {
                        this.throwEx(th);
                    }
                }
            }
        }
        return this.blserver;
    }

    protected BizStoreSB getBizStoreRef() {
        BizStoreSB bizStoreRef = null;
        try {
            BizStoreSBHome home = (BizStoreSBHome)SBMHomeFactory.self().lookupHome(BizStoreSBHome.class);
            bizStoreRef = home.create();
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        return bizStoreRef;
    }

    protected MConsoleSB getMConsoleRef() {
        MConsoleSB mConsoleRef = null;
        try {
            MConsoleSBHome home = (MConsoleSBHome)SBMHomeFactory.self().lookupHome(MConsoleSBHome.class);
            mConsoleRef = home.create();
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        return mConsoleRef;
    }

    protected final void loginFrame(String title) {
        LoginDialog loginDialog = null;
        if (!this.dialogShown) {
            loginDialog = new LoginDialog(new Frame(), title, this.user, false);
            loginDialog.show();
            loginDialog.toFront();
            loginDialog.dispose();
            loginDialog.setModal(true);
            loginDialog.show();
            this.dialogShown = true;
        } else {
            loginDialog = new LoginDialog(new Frame(), title, this.user, true);
            loginDialog.show();
        }
        if (loginDialog.isCancelled()) {
            this.cancelled = true;
            return;
        }
        this.user = loginDialog.username();
        this.passwd = loginDialog.password();
    }

    public Session createSession() {
        if (this.passwd == null) {
            throw new BizLogicClientException("BizLogic_ERR_3855");
        }
        Session sess = null;
        try {
            sess = this.getBizLogicRef().connect(this.user, this.passwd);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        return sess;
    }

    public void closeSession(Session ses) {
        if (ses == null) {
            throw new BizLogicClientException("BizLogic_ERR_3851");
        }
        try {
            this.getBizLogicRef().disConnect(ses);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    public final boolean isValidSession(Session ses) {
        if (ses == null) {
            throw new BizLogicClientException("BizLogic_ERR_3851");
        }
        try {
            return this.getBizLogicRef().isSessionValid(ses);
        }
        catch (Throwable th) {
            this.throwEx(th);
            return false;
        }
    }

    public void suspend() {
        try {
            this.getBizLogicRef().suspend(this.getSession());
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    public void resume() {
        if (this.passwd == null) {
            throw new BizLogicClientException("BizLogic_ERR_3855");
        }
        try {
            this.getBizLogicRef().resume(this.user, this.passwd);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    public void suspendConnections() {
        try {
            this.getBizLogicRef().suspendConnections(this.getSession());
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    public void resumeConnections() {
        if (this.passwd == null) {
            throw new BizLogicClientException("BizLogic_ERR_3855");
        }
        try {
            this.getBizLogicRef().resumeConnections(this.user, this.passwd);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    public String getVersion() {
        String version = null;
        try {
            version = this.getBizLogicRef().getVersion(this.getSession());
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        return version;
    }

    public boolean ping() {
        try {
            return this.getBizLogicRef().ping();
        }
        catch (Throwable th) {
            this.throwEx(th);
            return false;
        }
    }

    public Date getStartTime() {
        return (Date)this.getInfo().get("StartTime");
    }

    public String getState() {
        int i = -1;
        try {
            i = this.getBizLogicRef().getServerState();
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
        SBMConstants.self().getClass();
        if (i == 0) {
            return "Not Running";
        }
        SBMConstants.self().getClass();
        if (i == 1) {
            return "Running";
        }
        SBMConstants.self().getClass();
        if (i == 6) {
            return "Suspended";
        }
        return "Not known";
    }

    public void refresh(String type) {
        try {
            this.getBizLogicRef().refresh(this.session, type);
        }
        catch (Throwable th) {
            this.throwEx(th);
        }
    }

    protected void throwEx(Throwable ex) throws BizLogicClientException {
        throw new BizLogicClientException("BizLogic_ERR_3853", null, ex);
    }
}

