/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.server.svo.ProcessCount;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.Session;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ProcessCountList
implements Serializable {
    private Vector pclist = new Vector();
    private HashMap ProcessTemplateNameList = null;
    private HashMap ProcessTemplateIDList = null;
    private HashMap ActiveProcessTemplateIDList = null;
    private HashMap ActiveProcessTemplateNameList = null;
    private HashMap activePIList = null;
    private HashMap suspendPIList = null;
    private HashMap createPIList = null;
    private HashMap PIList = null;
    private HashMap assignWIList = null;
    private HashMap availableWIList = null;
    private HashMap suspendWIList = null;
    private HashMap WIList = null;
    String performer = null;

    ProcessCountList(Vector pc, String perf) {
        this.pclist = pc;
        this.performer = perf;
    }

    public String getPerformer() {
        return this.performer;
    }

    public HashMap getActiveProcessInstanceCount() {
        if (this.activePIList == null) {
            BLConstants.single();
            this.activePIList = this.getProcessInstanceCountByStatus(7);
        }
        return this.activePIList;
    }

    public HashMap getSuspendProcessInstanceCount() {
        if (this.suspendPIList == null) {
            BLConstants.single();
            this.suspendPIList = this.getProcessInstanceCountByStatus(8);
        }
        return this.suspendPIList;
    }

    public HashMap getCreateProcessInstanceCount() {
        if (this.createPIList == null) {
            BLConstants.single();
            this.createPIList = this.getProcessInstanceCountByStatus(6);
        }
        return this.createPIList;
    }

    public HashMap getAssignWorkItemCount() {
        if (this.assignWIList == null) {
            BLConstants.single();
            this.assignWIList = this.getWorkItemCountByStatus(28);
        }
        return this.assignWIList;
    }

    public HashMap getAvailableWorkItemCount() {
        if (this.availableWIList == null) {
            BLConstants.single();
            this.availableWIList = this.getWorkItemCountByStatus(27);
        }
        return this.availableWIList;
    }

    public HashMap getSuspendWorkItemCount() {
        if (this.suspendWIList == null) {
            BLConstants.single();
            this.suspendWIList = this.getWorkItemCountByStatus(32);
        }
        return this.suspendWIList;
    }

    public HashMap getProcessInstanceCount() {
        if (this.PIList == null) {
            this.PIList = this.getProcessInstanceCountByStatus(0);
        }
        return this.PIList;
    }

    public HashMap getWorkItemCount() {
        if (this.WIList == null) {
            this.WIList = this.getWorkItemCountByStatus(0);
        }
        return this.WIList;
    }

    public HashMap getProcessTemplateNameList() {
        Vector<String> v = null;
        String appName = null;
        if (this.ProcessTemplateNameList == null) {
            this.ProcessTemplateNameList = new HashMap();
            ProcessCount pc = null;
            for (int itr = 0; itr < this.pclist.size(); ++itr) {
                pc = (ProcessCount)this.pclist.elementAt(itr);
                appName = pc.getAppName();
                v = (Vector<String>)this.ProcessTemplateNameList.get(appName);
                if (v == null) {
                    v = new Vector<String>();
                }
                v.add(pc.getProcessTemplateName());
                this.ProcessTemplateNameList.put(appName, v);
            }
        }
        return this.ProcessTemplateNameList;
    }

    public Vector getProcessTemplateName(String appName) {
        Object o = this.getProcessTemplateNameList().get(appName);
        if (o == null) {
            return new Vector();
        }
        return (Vector)o;
    }

    public HashMap getProcessTemplateIDList() {
        Vector<Long> v = null;
        String appName = null;
        if (this.ProcessTemplateIDList == null) {
            this.ProcessTemplateIDList = new HashMap();
            ProcessCount pc = null;
            for (int itr = 0; itr < this.pclist.size(); ++itr) {
                pc = (ProcessCount)this.pclist.elementAt(itr);
                appName = pc.getAppName();
                v = (Vector<Long>)this.ProcessTemplateIDList.get(appName);
                if (v == null) {
                    v = new Vector<Long>();
                }
                v.add(pc.getProcessTemplateID());
                this.ProcessTemplateIDList.put(appName, v);
            }
        }
        return this.ProcessTemplateIDList;
    }

    public Vector getProcessTemplateID(String appName) {
        Object o = this.getProcessTemplateIDList().get(appName);
        if (o == null) {
            return new Vector();
        }
        return (Vector)o;
    }

    public HashMap getActiveProcessTemplateNameList() {
        String appName = null;
        if (this.ActiveProcessTemplateNameList == null) {
            this.ActiveProcessTemplateNameList = new HashMap();
            ProcessCount pc = null;
            for (int itr = 0; itr < this.pclist.size(); ++itr) {
                pc = (ProcessCount)this.pclist.elementAt(itr);
                appName = pc.getAppName();
                if (!pc.isProcessActive()) continue;
                this.ActiveProcessTemplateNameList.put(appName, pc.getProcessTemplateName());
            }
        }
        return this.ActiveProcessTemplateNameList;
    }

    public String getActiveProcessTemplateName(String appName) {
        return (String)this.getActiveProcessTemplateNameList().get(appName);
    }

    public HashMap getActiveProcessTemplateIDList() {
        String appName = null;
        if (this.ActiveProcessTemplateIDList == null) {
            this.ActiveProcessTemplateIDList = new HashMap();
            ProcessCount pc = null;
            for (int itr = 0; itr < this.pclist.size(); ++itr) {
                pc = (ProcessCount)this.pclist.elementAt(itr);
                appName = pc.getAppName();
                if (!pc.isProcessActive()) continue;
                this.ActiveProcessTemplateIDList.put(appName, pc.getProcessTemplateID());
            }
        }
        return this.ActiveProcessTemplateIDList;
    }

    public long getActiveProcessTemplateID(String appName) {
        Object o = this.getActiveProcessTemplateIDList().get(appName);
        if (o == null) {
            return -1L;
        }
        return (Long)o;
    }

    private HashMap getProcessInstanceCountByStatus(int status) {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        ProcessCount pc = null;
        String appName = null;
        Integer prevCount = null;
        for (int itr = 0; itr < this.pclist.size(); ++itr) {
            pc = (ProcessCount)this.pclist.elementAt(itr);
            int count = 0;
            BLConstants.single();
            if (status == 7) {
                count = pc.getActivatedProcessInstanceCount();
            } else {
                BLConstants.single();
                if (status == 8) {
                    count = pc.getSuspendedProcessInstanceCount();
                } else {
                    BLConstants.single();
                    count = status == 6 ? pc.getCreatedProcessInstanceCount() : pc.getProcessInstanceCount();
                }
            }
            appName = pc.getAppName();
            prevCount = (Integer)hm.get(appName);
            if (prevCount != null) {
                count += prevCount.intValue();
            }
            hm.put(appName, count);
        }
        return hm;
    }

    private HashMap getWorkItemCountByStatus(int status) {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        ProcessCount pc = null;
        String appName = null;
        Integer prevCount = null;
        for (int itr = 0; itr < this.pclist.size(); ++itr) {
            pc = (ProcessCount)this.pclist.elementAt(itr);
            int count = 0;
            BLConstants.single();
            if (status == 28) {
                count = pc.getAssignedWorkItemCount();
            } else {
                BLConstants.single();
                if (status == 27) {
                    count = pc.getAvailableWorkItemCount();
                } else {
                    BLConstants.single();
                    count = status == 32 ? pc.getSuspendedWorkItemCount() : pc.getWorkItemCount();
                }
            }
            appName = pc.getAppName();
            prevCount = (Integer)hm.get(appName);
            if (prevCount != null) {
                count += prevCount.intValue();
            }
            hm.put(appName, count);
        }
        return hm;
    }

    public Vector getList() {
        if (this.pclist == null) {
            this.pclist = new Vector();
        }
        return this.pclist;
    }

    public ProcessCount getProcessCount(String ptName) {
        ProcessCount pc = null;
        for (int itr = 0; itr < this.pclist.size(); ++itr) {
            pc = (ProcessCount)this.pclist.elementAt(itr);
            if (!pc.getProcessTemplateName().equals(ptName)) continue;
            return pc;
        }
        return null;
    }

    public ProcessCount getActiveProcessCount(String ptAppName) {
        ProcessCount pc = null;
        for (int itr = 0; itr < this.pclist.size(); ++itr) {
            pc = (ProcessCount)this.pclist.elementAt(itr);
            if (!pc.getAppName().equals(ptAppName) || !pc.isProcessActive()) continue;
            return pc;
        }
        return null;
    }

    public static ProcessCountList get(Session session, String performer, List<String> ptNames, String appName) throws RemoteException {
        return BLClientUtil.getBizLogicServer().getProcessCountList(session, performer, ptNames, appName);
    }
}

