/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotesData;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public class ProcessNotes
extends ProcessNotesData {
    Session session;
    transient boolean isRemoved = false;
    private static transient ProcessInstanceSB pisbRemoteRef;

    ProcessNotes(Session session, long notesID, Map<String, Object> notesAttributes) {
        super(notesID, notesAttributes);
        this.session = session;
    }

    public static ProcessNotes createForProcessInstance(Session session, long piid, String notes, String notesThreadName) throws RemoteException {
        if (piid <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_3887", new Object[]{piid, notes, notesThreadName});
        }
        if (notes == null || notes.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3888", new Object[]{piid, notesThreadName});
        }
        BLConstants.single();
        return ProcessNotes.create(session, piid, null, -1L, -1L, notes, notesThreadName, 1);
    }

    public static ProcessNotes createForWorkStepInstance(Session session, long piid, String wsName, String notes, String notesThreadName) throws RemoteException {
        if (piid <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_3885", new Object[]{piid, wsName, notes, notesThreadName});
        }
        if (wsName == null || wsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3881", new Object[]{piid, notes, notesThreadName});
        }
        if (notes == null || notes.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3886", new Object[]{piid, wsName, notesThreadName});
        }
        BLConstants.single();
        return ProcessNotes.create(session, piid, wsName, -1L, -1L, notes, notesThreadName, 2);
    }

    public static ProcessNotes createForWorkItem(Session session, long piid, long wiid, String notes, String notesThreadName) throws RemoteException {
        if (wiid <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_3889", new Object[]{wiid, piid, notes, notesThreadName});
        }
        if (notes == null || notes.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3890", new Object[]{wiid, piid, notesThreadName});
        }
        BLConstants.single();
        return ProcessNotes.create(session, piid, null, wiid, -1L, notes, notesThreadName, 3);
    }

    public static ProcessNotes createForCWorkItem(Session session, long piid, long cWorkItemId, String notes, String notesThreadName) throws RemoteException {
        if (cWorkItemId <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_3891", new Object[]{cWorkItemId, piid, notes, notesThreadName});
        }
        if (notes == null || notes.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3892", new Object[]{cWorkItemId, piid, notesThreadName});
        }
        BLConstants.single();
        return ProcessNotes.create(session, piid, null, -1L, cWorkItemId, notes, notesThreadName, 5);
    }

    public static ProcessNotes create(Session session, long piid, String workStepName, long wiid, long cWorkItemId, String notes, String notesThreadName, int notesContext) throws RemoteException {
        block5: {
            block4: {
                BLConstants.single();
                if (notesContext < 1) break block4;
                BLConstants.single();
                if (notesContext <= 5) break block5;
            }
            throw new BizLogicClientException("BizLogic_ERR_3882", new Object[]{notesContext, piid, workStepName, wiid, cWorkItemId, notes, notesThreadName});
        }
        if (notes == null || notes.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3893", new Object[]{piid, workStepName, wiid, cWorkItemId, notesThreadName, notesContext});
        }
        HashMap<String, Object> processNotesInfo = new HashMap<String, Object>();
        BLConstants.single();
        processNotesInfo.put("WORKSTEPNAME", workStepName);
        BLConstants.single();
        processNotesInfo.put("WORKITEMID", wiid);
        BLConstants.single();
        processNotesInfo.put("CWORKITEM_ID", cWorkItemId);
        BLConstants.single();
        processNotesInfo.put("CSTEP_ID", -1L);
        BLConstants.single();
        processNotesInfo.put("THREAD_NAME", notesThreadName);
        BLConstants.single();
        BLConstants.single();
        processNotesInfo.put("NOTES_TYPE", 1);
        BLConstants.single();
        processNotesInfo.put("NOTES_CONTEXT", notesContext);
        ProcessInstanceSB piSB = ProcessNotes.getProcessInstanceRef();
        return piSB.createProcessNotes(session, piid, notes, processNotesInfo);
    }

    public ProcessNotes replyByCWorkItem(long cWorkItemId, String replyNotes) throws RemoteException {
        if (this.isRemoved) {
            throw new BizLogicClientException("BizLogic_ERR_893", new Object[]{"reply"});
        }
        BLConstants.single();
        Long origcwiid = (Long)this.notesAttributes.get("CWORKITEM_ID");
        if (origcwiid != null && origcwiid != -1L && origcwiid != cWorkItemId) {
            throw new BizLogicClientException("BizLogic_ERR_3884", new Object[]{cWorkItemId, origcwiid});
        }
        HashMap<String, Object> replyNotesInfo = new HashMap<String, Object>();
        replyNotesInfo.putAll(this.notesAttributes);
        BLConstants.single();
        replyNotesInfo.put("CWORKITEM_ID", cWorkItemId);
        BLConstants.single();
        replyNotesInfo.remove("NOTES_USER");
        BLConstants.single();
        replyNotesInfo.remove("CWORKITEM_NAME");
        BLConstants.single();
        replyNotesInfo.remove("NOTES_ID");
        BLConstants.single();
        replyNotesInfo.put("REFERENCE_ID", new Long(this.getNotesID()));
        ProcessInstanceSB piSB = ProcessNotes.getProcessInstanceRef();
        long piid = this.getProcessInstanceID();
        return piSB.createProcessNotes(this.session, piid, replyNotes, replyNotesInfo);
    }

    public ProcessNotes replyByWorkItem(long wiid, String replyNotes) throws RemoteException {
        if (this.isRemoved) {
            throw new BizLogicClientException("BizLogic_ERR_893", new Object[]{"reply"});
        }
        BLConstants.single();
        Long origwiid = (Long)this.notesAttributes.get("WORKITEMID");
        if (origwiid != null && origwiid != -1L && origwiid != wiid) {
            throw new BizLogicClientException("BizLogic_ERR_3883", new Object[]{wiid, origwiid});
        }
        HashMap<String, Object> replyNotesInfo = new HashMap<String, Object>();
        replyNotesInfo.putAll(this.notesAttributes);
        BLConstants.single();
        replyNotesInfo.put("WORKITEMID", wiid);
        BLConstants.single();
        replyNotesInfo.remove("NOTES_USER");
        BLConstants.single();
        replyNotesInfo.remove("WORKITEMNAME");
        BLConstants.single();
        replyNotesInfo.remove("NOTES_ID");
        BLConstants.single();
        replyNotesInfo.put("REFERENCE_ID", new Long(this.getNotesID()));
        long piid = this.getProcessInstanceID();
        ProcessInstanceSB piSB = ProcessNotes.getProcessInstanceRef();
        return piSB.createProcessNotes(this.session, piid, replyNotes, replyNotesInfo);
    }

    public void update(String newNotes) throws RemoteException {
        if (this.isRemoved) {
            throw new BizLogicClientException("BizLogic_ERR_893", new Object[]{"update"});
        }
        String userWhoIsUpdating = this.session.getUser();
        if (!userWhoIsUpdating.equals(this.getUser())) {
            throw new BizLogicClientException("BizLogic_ERR_889", new Object[]{this.getNotesID(), userWhoIsUpdating, this.getUser()});
        }
        ProcessInstanceSB piSB = ProcessNotes.getProcessInstanceRef();
        long timeOfUpdation = piSB.updateProcessNotes(this.session, this.notesID, newNotes);
        BLConstants.single();
        this.notesAttributes.put("NOTES", newNotes);
        BLConstants.single();
        this.notesAttributes.put("LAST_MODIFIED_TIME", timeOfUpdation);
    }

    public void remove() throws RemoteException {
        long piid = this.getProcessInstanceID();
        ProcessInstanceSB piSB = ProcessNotes.getProcessInstanceRef();
        piSB.removeProcessNotes(this.session, piid, this.notesID);
        this.isRemoved = true;
    }

    private long getWorkstepID() {
        BLConstants.single();
        return this.getLongField("WORKSTEPID", "workstep id");
    }

    private static synchronized ProcessInstanceSB getProcessInstanceRef() throws RemoteException {
        if (pisbRemoteRef != null) {
            return pisbRemoteRef;
        }
        pisbRemoteRef = (ProcessInstanceSB)BLProcess.getRemoteRef(null, ProcessInstanceSBHome.class);
        return pisbRemoteRef;
    }
}

