/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.VoteCriteria;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VoteResult
implements Serializable {
    static final long serialVersionUID = 7523387728271931576L;
    private HashMap attributes = null;
    private VoteCriteria voteCriteria = null;
    private HashMap voteDetails = null;
    private HashMap validVotes = new HashMap();
    private HashMap invalidVotes = new HashMap();
    private HashMap votes = null;
    private Object majorityChoice = null;
    private int majorityChoiceCount = -1;

    public VoteResult() {
        this(null);
    }

    VoteResult(HashMap attrs) {
        if (attrs != null) {
            this.attributes = attrs;
            BLConstants.single();
            this.voteDetails = (HashMap)this.attributes.get("VOTEDETAILS");
            BLConstants.single();
            this.voteCriteria = (VoteCriteria)this.attributes.get("VOTECRITERIA");
            BLConstants.single();
            this.votes = (HashMap)this.voteDetails.get("VOTES");
            try {
                this.analyzeVotes();
            }
            catch (BizLogicClientException bex) {
                throw new RuntimeException("Error in VoteResult.<init>", bex);
            }
        }
    }

    public HashMap getAttributes() throws BizLogicClientException {
        if (this.attributes == null) {
            throw new BizLogicClientException("BizLogic_ERR_6023", (Object)"VoteResult.getAttributes");
        }
        return this.attributes;
    }

    private HashMap getVoteDetails() throws BizLogicClientException {
        if (this.voteDetails == null) {
            throw new BizLogicClientException("BizLogic_ERR_6023", (Object)"VoteResult.getVoteDetails");
        }
        return this.voteDetails;
    }

    public VoteCriteria getVoteCriteria() throws BizLogicClientException {
        if (this.voteCriteria == null) {
            throw new BizLogicClientException("BizLogic_ERR_6023", (Object)"VoteResult.getVoteCriteria");
        }
        return this.voteCriteria;
    }

    public long getProcessInstanceID() throws BizLogicClientException {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long pidObj = (Long)hashMap.get("PROCESSINSTANCEID");
        if (pidObj != null) {
            return pidObj;
        }
        return -1L;
    }

    public long getWorkstepID() throws BizLogicClientException {
        HashMap hashMap = this.getAttributes();
        BLConstants.single();
        Long wsidObj = (Long)hashMap.get("WORKSTEPID");
        if (wsidObj != null) {
            return wsidObj;
        }
        return -1L;
    }

    private void analyzeVotes() throws BizLogicClientException {
        List voteChoices = this.getChoices();
        if (this.votes != null) {
            if (voteChoices != null) {
                this.validVotes = new HashMap();
                this.invalidVotes = new HashMap();
                for (String user : this.votes.keySet()) {
                    Object dsValue = this.votes.get(user);
                    if (dsValue != null && voteChoices.contains(dsValue)) {
                        this.validVotes.put(user, dsValue);
                        continue;
                    }
                    this.invalidVotes.put(user, dsValue);
                }
            } else {
                this.validVotes = this.votes;
            }
        }
    }

    public int getExpectedCount() throws BizLogicClientException {
        HashMap hashMap = this.getVoteDetails();
        BLConstants.single();
        Integer expCnt = (Integer)hashMap.get("EXPECTED_COUNT");
        if (expCnt != null) {
            return expCnt;
        }
        return -1;
    }

    public int getTotalCount() throws BizLogicClientException {
        HashMap hashMap = this.getVoteDetails();
        BLConstants.single();
        Integer totCnt = (Integer)hashMap.get("TOTAL_COUNT");
        if (totCnt != null) {
            return totCnt;
        }
        return -1;
    }

    public int getActualCount() throws BizLogicClientException {
        return this.getVotes().size();
    }

    public Map getValidVotes() {
        return this.validVotes;
    }

    public Map getValidVotes(Object choice) throws BizLogicClientException {
        List voteChoices = this.getChoices();
        HashMap valVotes = new HashMap();
        if (voteChoices != null && !voteChoices.contains(choice)) {
            return valVotes;
        }
        if (this.validVotes != null) {
            for (Map.Entry me : this.validVotes.entrySet()) {
                String user = (String)me.getKey();
                Object dsValue = me.getValue();
                if (dsValue == null || !dsValue.equals(choice)) continue;
                valVotes.put(user, dsValue);
            }
        }
        return valVotes;
    }

    public Map getInvalidVotes() {
        return this.invalidVotes;
    }

    public Map getVotes() throws BizLogicClientException {
        if (this.votes == null) {
            throw new BizLogicClientException("BizLogic_ERR_6023", (Object)"VoteResult.getVotes");
        }
        return this.votes;
    }

    public double getVotePercentage() throws BizLogicClientException {
        int voteCount = this.getActualCount();
        return (double)(100 * voteCount) / (double)this.getTotalCount();
    }

    private void findMajorityChoice() throws BizLogicClientException {
        Map choiceMap = this.getVoteCountByChoices();
        if (choiceMap == null || choiceMap.isEmpty()) {
            return;
        }
        new HashMap();
        for (Map.Entry me : choiceMap.entrySet()) {
            Object obj = me.getKey();
            int value = (Integer)me.getValue();
            if (value <= this.majorityChoiceCount) continue;
            this.majorityChoice = obj;
            this.majorityChoiceCount = value;
        }
    }

    public Object getMajorityChoice() {
        if (this.majorityChoice == null) {
            try {
                this.findMajorityChoice();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.majorityChoice;
    }

    public int getMajorityChoiceCount() {
        return this.majorityChoiceCount;
    }

    public Map getMajorityVotes() throws BizLogicClientException {
        return this.getValidVotes(this.getMajorityChoice());
    }

    public List getChoices() throws BizLogicClientException {
        List choiceList = null;
        VoteCriteria vc = this.getVoteCriteria();
        if (vc.isMappedChoices()) {
            Map map = this.getVotes();
            BLConstants.single();
            choiceList = (List)map.get("@@CHOICES@@");
        } else {
            choiceList = vc.getChoices();
        }
        return choiceList;
    }

    public Map getVoteCountByChoices() throws BizLogicClientException {
        HashMap choiceMap = new HashMap();
        List voteChoices = this.getChoices();
        if (voteChoices == null || voteChoices.isEmpty()) {
            return choiceMap;
        }
        for (int ix = 0; ix < voteChoices.size(); ++ix) {
            Integer val = this.getValidVotes(voteChoices.get(ix)).size();
            choiceMap.put(voteChoices.get(ix), val);
        }
        return choiceMap;
    }
}

