/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLCollection;
import com.savvion.sbm.bizlogic.server.svo.BLCollectionOperation;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ResultData;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WorkStepInstanceList
extends BLCollection
implements BLCollectionOperation {
    WorkStepInstanceList(Session session, Vector list) {
        this.session = session;
        if (list != null) {
            this.list = list;
        }
    }

    public static WorkStepInstanceList getList(Session session) throws RemoteException {
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)BLProcess.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsisb.getList(session, null, null);
    }

    public static WorkStepInstanceList getList(Session session, long ptID) throws RemoteException {
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)BLProcess.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsisb.getList(session, new long[]{ptID}, null);
    }

    public static WorkStepInstanceList getList(Session session, int[] states) throws RemoteException {
        if (states == null || states.length == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4532", new Object[]{"WorkStep Instance states", states});
        }
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)BLProcess.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsisb.getList(session, null, states);
    }

    public static WorkStepInstanceList getList(Session session, long[] ptids, long[] piids, int[] states) throws RemoteException {
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)BLProcess.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsisb.getList(session, ptids, piids, states);
    }

    public static WorkStepInstanceList getListForInstances(Session session, long[] piids, int[] states) throws RemoteException {
        if (piids == null || piids.length == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4532", new Object[]{"Process Instance IDs", piids});
        }
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)BLProcess.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsisb.getList(session, null, piids, states);
    }

    public static WorkStepInstanceList getListForTemplates(Session session, long[] ptids, int[] states) throws RemoteException {
        if (ptids == null || ptids.length == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4532", new Object[]{"Process Template IDs", ptids});
        }
        WorkStepInstanceSB wsisb = (WorkStepInstanceSB)BLProcess.getRemoteRef(WorkStepInstanceSBHome.class);
        return wsisb.getList(session, ptids, null, states);
    }

    @Override
    public void save() throws RemoteException {
        List<Map<String, Object>> modifiedAttributes = this.getModifiedAttrs();
        WorkStepInstance.updateAttributes(this.session, modifiedAttributes, true);
        this.clearModifiedAttrs();
    }

    @Override
    public void complete() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 16;
        List<Map<String, Object>> invalidList = this.getWorkStepsInState(integerArray);
        if (!invalidList.isEmpty()) {
            List<String> invalidStrList = this.getStringList(invalidList);
            throw new BizLogicClientException("BizLogic_ERR_3760", new Object[]{"complete", invalidStrList, "W_SUSPENDED"});
        }
        Integer[] integerArray2 = new Integer[1];
        BLConstants.single();
        integerArray2[0] = 21;
        List<Map<String, Object>> validList = this.getWorkStepsNotInState(integerArray2);
        if (!validList.isEmpty()) {
            ResultData<List<Map<String, Object>>> result = ((WorkStepInstanceSB)this.getRemoteRef()).complete(this.session, validList, true);
            if (!result.isSuccessful()) {
                List completedWS = (List)result.getReturnValue();
                BLConstants.single();
                this.setWSState(21, completedWS);
                this.throwEx(completedWS, "WorkStepInstanceList", "complete", result.getError());
            } else {
                BLConstants.single();
                this.setState(21);
            }
        }
    }

    @Override
    public void suspend() throws RemoteException {
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 16;
        List<Map<String, Object>> validList = this.getWorkStepsNotInState(integerArray);
        if (!validList.isEmpty()) {
            ResultData<List<Map<String, Object>>> result = ((WorkStepInstanceSB)this.getRemoteRef()).suspend(this.session, validList, true);
            if (!result.isSuccessful()) {
                List completedWS = (List)result.getReturnValue();
                BLConstants.single();
                this.setWSState(16, completedWS);
                this.throwEx(completedWS, "WorkStepInstanceList", "suspend", result.getError());
            } else {
                BLConstants.single();
                this.setState(16);
            }
        }
    }

    @Override
    public void resume() throws RemoteException {
        Integer[] integerArray = new Integer[2];
        BLConstants.single();
        integerArray[0] = 16;
        BLConstants.single();
        integerArray[1] = 62;
        List<Map<String, Object>> validList = this.getWorkStepsInState(integerArray);
        if (!validList.isEmpty()) {
            ResultData<List<Map<String, Object>>> result = ((WorkStepInstanceSB)this.getRemoteRef()).resume(this.session, validList, true);
            if (!result.isSuccessful()) {
                List resumedWS = (List)result.getReturnValue();
                this.refresh(resumedWS);
                this.throwEx(resumedWS, "WorkStepInstanceList", "resume", result.getError());
            } else {
                this.refresh();
            }
        }
    }

    @Override
    public void remove() {
        new BizLogicClientException("BizLogic_ERR_1599", new Object[]{"WorkStepInstanceList:remove()"});
    }

    @Override
    public Vector getIDList() {
        Vector idList = new Vector();
        WorkStepInstance wsi = null;
        HashMap<String, Long> hm = null;
        for (int ix = this.list.size() - 1; ix >= 0; --ix) {
            wsi = (WorkStepInstance)this.list.elementAt(ix);
            hm = new HashMap<String, Long>();
            BLConstants.single();
            hm.put("PROCESSINSTANCEID", wsi.getProcessInstanceID());
            BLConstants.single();
            hm.put("WORKSTEPID", wsi.getID());
            idList.addElement(hm);
        }
        return idList;
    }

    protected List<Map<String, Object>> getModifiedAttrs() {
        HashMap modifiedAttrs = null;
        HashMap wsiAttrs = null;
        WorkStepInstance wsi = null;
        ArrayList<Map<String, Object>> attributesList = new ArrayList<Map<String, Object>>();
        for (Object wsiObj : this.list) {
            wsi = (WorkStepInstance)wsiObj;
            modifiedAttrs = wsi.getModifiedAttributes();
            if (modifiedAttrs == null || modifiedAttrs.isEmpty()) continue;
            wsiAttrs = (HashMap)modifiedAttrs.clone();
            BLConstants.single();
            wsiAttrs.put("PROCESSINSTANCEID", wsi.getProcessInstanceID());
            BLConstants.single();
            wsiAttrs.put("WORKSTEPID", wsi.getID());
            attributesList.add(wsiAttrs);
        }
        return attributesList;
    }

    private void clearModifiedAttrs() {
        HashMap modifiedAttrs = null;
        WorkStepInstance wsi = null;
        for (Object wsiObj : this.list) {
            wsi = (WorkStepInstance)wsiObj;
            modifiedAttrs = wsi.getModifiedAttributes();
            if (modifiedAttrs == null) continue;
            modifiedAttrs.clear();
        }
    }

    public void skip() throws RemoteException {
        Integer[] integerArray = new Integer[3];
        BLConstants.single();
        integerArray[0] = 16;
        BLConstants.single();
        integerArray[1] = 60;
        BLConstants.single();
        integerArray[2] = 63;
        List<Map<String, Object>> invalidList = this.getWorkStepsNotInState(integerArray);
        if (!invalidList.isEmpty()) {
            List<String> invalidStrList = this.getStringList(invalidList);
            throw new BizLogicClientException("BizLogic_ERR_3759", new Object[]{"skip", invalidStrList, "W_SUSPENDED or W_MESSAGE_WAIT or W_SKIPPED"});
        }
        Integer[] integerArray2 = new Integer[1];
        BLConstants.single();
        integerArray2[0] = 63;
        List<Map<String, Object>> validList = this.getWorkStepsNotInState(integerArray2);
        if (!validList.isEmpty()) {
            ResultData<List<Map<String, Object>>> result = ((WorkStepInstanceSB)this.getRemoteRef()).skip(this.session, validList, true);
            if (!result.isSuccessful()) {
                List skippedWS = (List)result.getReturnValue();
                BLConstants.single();
                this.setWSState(63, skippedWS);
                this.throwEx(skippedWS, "WorkStepInstanceList", "skip", result.getError());
            } else {
                BLConstants.single();
                this.setState(63);
            }
        }
    }

    private List<Map<String, Object>> getWorkStepsInState(Integer ... states) {
        ArrayList<Map<String, Object>> wsList = new ArrayList<Map<String, Object>>();
        List<Integer> statesList = Arrays.asList(states);
        for (int i = 0; i < this.list.size(); ++i) {
            WorkStepInstance ws = (WorkStepInstance)this.list.get(i);
            if (!statesList.contains(ws.getState())) continue;
            HashMap<String, Object> wsAttrs = new HashMap<String, Object>();
            BLConstants.single();
            wsAttrs.put("PROCESSINSTANCEID", ws.getProcessInstanceID());
            BLConstants.single();
            wsAttrs.put("WORKSTEPID", ws.getID());
            BLConstants.single();
            wsAttrs.put("WORKSTEPNAME", ws.getName());
            wsList.add(wsAttrs);
        }
        return wsList;
    }

    private List<Map<String, Object>> getWorkStepsNotInState(Integer ... states) {
        ArrayList<Map<String, Object>> wsList = new ArrayList<Map<String, Object>>();
        List<Integer> statesList = Arrays.asList(states);
        for (int i = 0; i < this.list.size(); ++i) {
            WorkStepInstance ws = (WorkStepInstance)this.list.get(i);
            if (statesList.contains(ws.getState())) continue;
            HashMap<String, Object> wsAttrs = new HashMap<String, Object>();
            BLConstants.single();
            wsAttrs.put("PROCESSINSTANCEID", ws.getProcessInstanceID());
            BLConstants.single();
            wsAttrs.put("WORKSTEPID", ws.getID());
            BLConstants.single();
            wsAttrs.put("WORKSTEPNAME", ws.getName());
            wsList.add(wsAttrs);
        }
        return wsList;
    }

    private void refresh() throws RemoteException {
        for (int ix = 0; ix < this.list.size(); ++ix) {
            WorkStepInstance wsi = (WorkStepInstance)this.list.get(ix);
            wsi.refresh();
        }
    }

    private void refresh(List<Map<String, Object>> wsList) throws RemoteException {
        if (wsList == null || wsList.isEmpty()) {
            return;
        }
        for (Map<String, Object> ws : wsList) {
            if (ws == null) continue;
            BLConstants.single();
            if (!ws.containsKey("PROCESSINSTANCEID")) continue;
            BLConstants.single();
            if (!ws.containsKey("WORKSTEPID")) continue;
            BLConstants.single();
            long piid = (Long)ws.get("PROCESSINSTANCEID");
            BLConstants.single();
            long wsid = (Long)ws.get("WORKSTEPID");
            for (int ix = 0; ix < this.list.size(); ++ix) {
                WorkStepInstance wsi = (WorkStepInstance)this.list.get(ix);
                if (wsi.getProcessInstanceID() != piid || wsi.getID() != wsid) continue;
                wsi.refresh();
            }
        }
    }

    private void setWSState(int state, List<Map<String, Object>> worksteps) {
        if (worksteps == null || worksteps.isEmpty()) {
            return;
        }
        for (Map<String, Object> ws : worksteps) {
            if (ws == null) continue;
            BLConstants.single();
            if (!ws.containsKey("PROCESSINSTANCEID")) continue;
            BLConstants.single();
            if (!ws.containsKey("WORKSTEPID")) continue;
            BLConstants.single();
            long piid = (Long)ws.get("PROCESSINSTANCEID");
            BLConstants.single();
            long wsid = (Long)ws.get("WORKSTEPID");
            for (int ix = 0; ix < this.list.size(); ++ix) {
                WorkStepInstance workstep = (WorkStepInstance)this.list.get(ix);
                if (workstep.getProcessInstanceID() != piid || workstep.getID() != wsid) continue;
                workstep.setState(state);
            }
        }
    }

    private List<String> getStringList(List<Map<String, Object>> wsList) {
        ArrayList<String> wsStrList = new ArrayList<String>();
        if (wsList == null || wsList.isEmpty()) {
            return wsStrList;
        }
        for (Map<String, Object> ws : wsList) {
            if (ws == null) continue;
            BLConstants.single();
            if (!ws.containsKey("PROCESSINSTANCEID")) continue;
            BLConstants.single();
            if (!ws.containsKey("WORKSTEPID")) continue;
            BLConstants.single();
            long piid = (Long)ws.get("PROCESSINSTANCEID");
            BLConstants.single();
            String wsName = (String)ws.get("WORKSTEPNAME");
            StringBuilder sb = new StringBuilder();
            sb.append("PROCESSINSTANCEID=").append(piid);
            sb.append(":WORKSTEPNAME=").append(wsName);
            wsStrList.add(sb.toString());
        }
        return wsStrList;
    }
}

