/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.common.documentrepository.EvaluateXPath;
import com.savvion.common.documentrepository.XPathExpression;
import com.savvion.ejb.bizlogic.manager.BizLogicManager;
import com.savvion.ejb.bizlogic.manager.BizLogicManagerHome;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.svo.DataSlotType;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.jax.XMLUtil;
import com.savvion.sbm.util.jax.XPathUtil;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Document;

public class XML
implements DataSlotType {
    static final long serialVersionUID = -5922814736195093539L;
    private static final String TYPE = "XML";
    private static final String GET_XPATH_VALUES = "getXPathValue(session, xpath[])";
    private static final String GET_XPATH_VALUE = "getXPathValue(session, xpath)";
    private static final String GET_XPATH_VALUE_NS = "getXPathValue(session, xpath)";
    private static final String SET_XPATH_VALUE = "setXPathValue(session, xpath, value)";
    private static final String SET_XPATH_VALUE_MAP = "setXPathValue(session, xpathMap)";
    private static final String SET_XPATH_VALUE_NS = "setXPathValue(session, xpath, value, nsMap)";
    private long docid = -1L;
    private long collectionid = -1L;
    private String content = null;
    private String docName = null;
    private boolean isContentLoaded = false;
    private boolean isContentUpdated = false;
    private boolean isModified = false;
    private transient Map<String, Object> XPathValues = new HashMap<String, Object>();

    public XML(String content) {
        this.content = content;
        this.isContentLoaded = true;
        this.isContentUpdated = true;
        this.isModified = true;
    }

    public XML(long id) {
        this.docid = id;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public long getID() {
        return this.docid;
    }

    public long getCollectionID(String session) throws RemoteException {
        if (this.docid <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_1596", new Object[]{"Get Collection ID", String.valueOf(this.docid)});
        }
        if (this.collectionid <= 0L) {
            BizLogicManager blmanager = this.getBLManagerRemoteRef();
            this.collectionid = blmanager.getXMLCollectionID(session, this.docid);
        }
        return this.collectionid;
    }

    public long getCollectionID(Session session) throws RemoteException {
        if (this.docid <= 0L) {
            throw new BizLogicClientException("BizLogic_ERR_1596", new Object[]{"Get Collection ID", String.valueOf(this.docid)});
        }
        if (this.collectionid <= 0L) {
            BLServer blserver = this.getBLServerRemoteRef();
            this.collectionid = blserver.getXMLCollectionID(session, this.docid);
        }
        return this.collectionid;
    }

    public String getContent(String session) throws RemoteException {
        if (!this.isContentLoaded && this.docid > 0L) {
            BizLogicManager blmanager = this.getBLManagerRemoteRef();
            this.content = blmanager.getXMLContent(session, this.docid);
            this.isContentLoaded = true;
        }
        return this.content;
    }

    public String getContent() {
        if (!this.isContentLoaded && this.docid > 0L) {
            throw new RuntimeException("getContent() method without session  can be invoked on non-persistent XML object");
        }
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.isContentLoaded = true;
        this.isContentUpdated = true;
        this.isModified = true;
    }

    public void setName(String dname) {
        this.docName = dname;
        this.isModified = true;
    }

    public String getName() {
        return this.docName;
    }

    public boolean isContentUpdated() {
        return this.isContentUpdated;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getContent(Session session) throws RemoteException {
        if (!this.isContentLoaded && this.docid > 0L) {
            BLServer blserver = this.getBLServerRemoteRef();
            this.content = blserver.getXMLContent(session, this.docid);
            this.isContentLoaded = true;
        }
        return this.content;
    }

    public Map<String, Object> getXPathValue(String session, String[] xpath) throws Exception {
        return this.evaluateXPath(this.getContent(session), xpath);
    }

    public Map<String, Object> getXPathValue(Session session, String[] xpath) throws Exception {
        return this.evaluateXPath(this.getContent(session), xpath);
    }

    private Map<String, Object> evaluateXPath(String content, String[] xpath) throws Exception {
        if (content == null || content.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3753", new Object[]{GET_XPATH_VALUES, content, this.docid, this.collectionid, this.docName});
        }
        if (xpath == null || xpath.length == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath expressions", xpath, this.getName()});
        }
        XPathExpression exp = null;
        HashMap<String, XPathExpression> bulkEvl = new HashMap<String, XPathExpression>();
        HashMap<String, Object> results = new HashMap<String, Object>(xpath.length);
        Map<String, Object> xPathValues = this.getXPathCache();
        for (int ix = 0; ix < xpath.length; ++ix) {
            Object result = xPathValues.get(xpath[ix]);
            if (result == null) {
                exp = new XPathExpression(this.collectionid, xpath[ix], xpath[ix]);
                bulkEvl.put(xpath[ix], exp);
                continue;
            }
            results.put(xpath[ix], result);
        }
        int size = bulkEvl.size();
        if (size > 0) {
            HashMap bulkResults = EvaluateXPath.evaluateXPaths((String)content, bulkEvl);
            xPathValues.putAll(bulkResults);
            results.putAll(bulkResults);
        }
        return results;
    }

    public String[] getXPath() {
        throw new BizLogicClientException("BizLogic_ERR_1599", (Object)"getXPath()");
    }

    public Map getXPathValue() {
        throw new BizLogicClientException("BizLogic_ERR_1599", (Object)"getXPathValue()");
    }

    public String getXPathValue(String session, String xpath) throws Exception {
        return this.evaluateXPath(this.getContent(session), xpath);
    }

    public String getXPathValue(Session session, String xpath) throws Exception {
        return this.evaluateXPath(this.getContent(session), xpath);
    }

    private String evaluateXPath(String content, String xpath) throws Exception {
        if (content == null || content.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3753", new Object[]{"getXPathValue(session, xpath)", content, this.docid, this.collectionid, this.docName});
        }
        if (xpath == null || xpath.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath expression", xpath, this.getName()});
        }
        Map<String, Object> xPathValues = this.getXPathCache();
        String result = (String)xPathValues.get(xpath);
        if (result == null) {
            result = EvaluateXPath.evaluateXPath((String)content, (String)xpath);
            xPathValues.put(xpath, result);
        }
        return result;
    }

    public String getXPathValue(Session session, String xpath, Map<String, String> nsMap) throws Exception {
        if (xpath == null || xpath.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath expression", xpath, this.getName()});
        }
        try {
            String content = this.getContent(session);
            if (content == null || content.trim().length() == 0) {
                throw new BizLogicClientException("BizLogic_ERR_3753", new Object[]{"getXPathValue(session, xpath)", content, this.docid, this.collectionid, this.docName});
            }
            Map<String, Object> xPathValues = this.getXPathCache();
            String result = (String)xPathValues.get(xpath);
            if (result == null) {
                Document doc = XMLUtil.getDocument((String)content, (boolean)false);
                result = XPathUtil.evaluateToString((Document)doc, (String)xpath, nsMap, null);
                xPathValues.put(xpath, result);
            }
            return result;
        }
        catch (Throwable th) {
            throw new BizLogicClientException("BizLogic_ERR_4519", new Object[]{this.getID(), xpath, "XML.getXPathValue(sess, xpath, nsMap)"}, th);
        }
    }

    private Map<String, Object> getXPathCache() {
        if (this.XPathValues == null) {
            this.XPathValues = new HashMap<String, Object>();
        }
        return this.XPathValues;
    }

    public String toString() {
        return Long.valueOf(this.docid).toString();
    }

    private BLServer getBLServerRemoteRef() {
        try {
            SBMHomeFactory sbmHome = SBMHomeFactory.self();
            BLServerHome home = (BLServerHome)sbmHome.lookupHome(BLServerHome.class);
            BLServer ref = home.create();
            return ref;
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{""}, (Throwable)e);
        }
    }

    private BizLogicManager getBLManagerRemoteRef() {
        try {
            SBMHomeFactory sbmHome = SBMHomeFactory.self();
            BizLogicManagerHome home = (BizLogicManagerHome)sbmHome.lookupHome(ServiceLocator.self().getAppServerID(), "BizLogicManager", BizLogicManagerHome.class);
            BizLogicManager ref = home.create();
            return ref;
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{""}, (Throwable)e);
        }
    }

    public static XML getInstance(String content) {
        return new XML(content);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XML) {
            XML anotherXml = (XML)obj;
            long id = anotherXml.getID();
            if (id == -1L || this.docid == -1L) {
                return false;
            }
            return id == this.docid;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getID());
    }

    public void setXPathValue(Session session, String xpath, String value) {
        if (xpath == null || xpath.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath expression", xpath, this.getName()});
        }
        if (value == null) {
            throw new RuntimeException("Invalid XPath value: null: setXPathValue(session, xpath, value)");
        }
        try {
            String xmlContent = this.getContent(session);
            if (xmlContent == null || xmlContent.trim().length() == 0) {
                throw new BizLogicClientException("BizLogic_ERR_3753", new Object[]{SET_XPATH_VALUE, xmlContent, this.docid, this.collectionid, this.docName});
            }
            Document doc = XMLUtil.getDocument((String)xmlContent, (boolean)false);
            doc = XPathUtil.setNodeValue((Document)doc, (String)xpath, (String)value, null, null);
            this.setContent(XMLUtil.convertDOMToString((Document)doc, null));
        }
        catch (Throwable th) {
            throw new BizLogicClientException("BizLogic_ERR_7000", new Object[]{this.getID(), xpath, value, SET_XPATH_VALUE}, th);
        }
    }

    public void setXPathValue(Session session, Map<String, String> xpathMap) {
        if (xpathMap == null || xpathMap.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath expressions", xpathMap, this.getName()});
        }
        try {
            String xmlContent = this.getContent(session);
            if (xmlContent == null || xmlContent.trim().length() == 0) {
                throw new BizLogicClientException("BizLogic_ERR_3753", new Object[]{SET_XPATH_VALUE_MAP, xmlContent, this.docid, this.collectionid, this.docName});
            }
            Document doc = XMLUtil.getDocument((String)xmlContent, (boolean)false);
            doc = XPathUtil.setNodeValue((Document)doc, xpathMap, null, null);
            this.setContent(XMLUtil.convertDOMToString((Document)doc, null));
        }
        catch (Throwable th) {
            throw new BizLogicClientException("BizLogic_ERR_7001", new Object[]{this.getID(), xpathMap, SET_XPATH_VALUE_MAP}, th);
        }
    }

    public void setXPathValue(Session session, String xpath, String value, Map<String, String> nsMap) throws Exception {
        if (xpath == null || xpath.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath expression", xpath, this.getName()});
        }
        if (value == null) {
            throw new BizLogicClientException("BizLogic_ERR_4517", new Object[]{"XPath value", value, this.getName()});
        }
        try {
            String xmlContent = this.getContent(session);
            if (xmlContent == null || xmlContent.trim().length() == 0) {
                throw new BizLogicClientException("BizLogic_ERR_3753", new Object[]{SET_XPATH_VALUE_NS, xmlContent, this.docid, this.collectionid, this.docName});
            }
            Document doc = XMLUtil.getDocument((String)xmlContent, (boolean)false);
            doc = XPathUtil.setNodeValue((Document)doc, (String)xpath, (String)value, nsMap, null);
            this.setContent(XMLUtil.convertDOMToString((Document)doc, null));
        }
        catch (Throwable th) {
            throw new BizLogicClientException("BizLogic_ERR_4518", new Object[]{this.getID(), xpath, value, "XML.setXPathValue(sess, xpath, value, nsMap)"}, th);
        }
    }

    public boolean isNull() {
        return this.docid == -1L;
    }
}

