/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.core;

import com.savvion.sbm.bizlogic.server.WFDataSlotInstance;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.InvalidProcessStateException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EventUtil {
    public static Map<String, Object> removeInvalidDataslots(WFProcess ptObj, Map<String, Object> dsValues) {
        HashMap<String, Object> invalidDS = new HashMap<String, Object>();
        if (dsValues == null || dsValues.isEmpty()) {
            return invalidDS;
        }
        HashSet<String> keySet = new HashSet<String>(dsValues.keySet());
        for (String dsName : keySet) {
            if (ptObj.isValidateSlot(dsName)) continue;
            invalidDS.put(dsName, dsValues.remove(dsName));
        }
        return invalidDS;
    }

    public static Object removeMonitorDataslot(WFProcess ptObj, Map<String, Object> dsValues) {
        return dsValues.remove(ptObj.getMonitorDSName());
    }

    public static boolean isUniqueExternalInstanceId(String ptName, String eiIdDSName, String eiId) {
        if (!SMPConfig.self().isCheckBizStoreForUniqueId()) {
            return !WFDataSlotInstance.self().isProcessInstanceExist(ptName, eiId);
        }
        return !WFDataSlotInstance.self().isProcessInstanceExist(ptName, eiId) && !MPUtil.isProcessInstanceExist(ptName, eiIdDSName, eiId);
    }

    public static Object getEventDataSlotValue(BLExternalEvent event, String dsName) {
        return event.getEventData().get(dsName);
    }

    public static String removeParamFlag(String dsName) {
        if (dsName != null) {
            BLConstants.single();
            if (dsName.startsWith("@")) {
                return dsName.substring(1);
            }
        }
        return dsName;
    }

    public static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    public static void logDebug(String messageKey, String context, Object ... args) {
        if (MPUtil.isDebug()) {
            EventUtil.getLogger().debugKey(messageKey, context, args);
        }
    }

    public static ExceptionService<InvalidEventDataException> getInvalidEventDataES() {
        return MPService.self().getInvalidEventDataES();
    }

    public static ExceptionService<InvalidProcessStateException> getInvalidProcessStateES() {
        return MPService.self().getInvalidProcessStateES();
    }

    public static ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return MPService.self().getMonitoringProcessES();
    }

    public static InvalidEventDataException createInvalidEventDataEx(String errKey, String ctx, Object ... args) {
        return EventUtil.createInvalidEventDataEx(errKey, ctx, null, args);
    }

    public static InvalidEventDataException createInvalidEventDataEx(String errKey, String ctx, Throwable th, Object ... args) {
        return (InvalidEventDataException)((Object)EventUtil.getInvalidEventDataES().createException(errKey, ctx, args, th));
    }

    public static InvalidProcessStateException createInvalidProcessStateEx(String errKey, String ctx, Object ... args) {
        return EventUtil.createInvalidProcessStateEx(errKey, ctx, null, args);
    }

    public static InvalidProcessStateException createInvalidProcessStateEx(String errKey, String ctx, Throwable th, Object ... args) {
        return (InvalidProcessStateException)((Object)EventUtil.getInvalidProcessStateES().createException(errKey, ctx, args, th));
    }

    public static boolean isProcessInstanceExist(long piid) {
        return ProcessInstanceDAO.isProcessInstanceExist(piid);
    }

    public static Map<String, Object> removeNonOutputDataslots(WFProcess ptObj, long wsId, Map<String, Object> dsValues) {
        HashMap<String, Object> invalidDS = new HashMap<String, Object>();
        if (dsValues == null || dsValues.isEmpty()) {
            return invalidDS;
        }
        WFWorkstep wsObj = ptObj.getWorkstep(wsId);
        String[] outputSlotNames = wsObj.getOutputSlotsKeys();
        if (outputSlotNames.length == 0) {
            invalidDS.putAll(dsValues);
            dsValues.clear();
            return invalidDS;
        }
        List<String> outputSlotNamesList = Arrays.asList(outputSlotNames);
        HashSet<String> keySet = new HashSet<String>(dsValues.keySet());
        keySet.removeAll(outputSlotNamesList);
        for (String dsName : keySet) {
            invalidDS.put(dsName, dsValues.remove(dsName));
        }
        return invalidDS;
    }
}

