/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.gateway.jms;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.core.EventProcessor;
import com.savvion.sbm.bizlogic.smp.gateway.jms.util.JMSUtil;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.ExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.InvalidProcessStateException;
import com.savvion.sbm.bizlogic.smp.util.MPConstant;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.transaction.UserTransaction;

public class JMSService {
    private static List<String> msgKeyList = null;

    public JMSService() {
        JMSService.prepareKeyList();
    }

    public void processMessage(Message message) {
        UserTransaction utx = null;
        try {
            JMSService.validateMessage(message);
            ExternalEvent extEvent = null;
            if (message instanceof ObjectMessage) {
                extEvent = JMSService.getExternalEventFromObjMsg((ObjectMessage)message);
            } else if (message instanceof MapMessage) {
                extEvent = JMSService.getExternalEventFromMapMsg((MapMessage)message);
            } else {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW105", "JMSService.processMessage(Message)", new Object[]{message.getClass().getName(), JMSUtil.getEventCtx(message)}));
            }
            if (extEvent != null) {
                if (MPUtil.isDebug()) {
                    JMSService.getLogger().debugKey("BM_MPGW120", new Object[]{extEvent.getAttributes(), JMSUtil.getMessageData(message)});
                    JMSService.getLogger().debugKey("BM_MPGW121", new Object[]{MPUtil.getEventCtx(extEvent)});
                }
                if (SMPConfig.self().isInlineProcessAtGateway() && SMPConfig.self().isInlineProcessAtGatewayOfEventType(extEvent.getOperationType())) {
                    MPConstant.EventStatus eventStatus = this.processEvent((BLExternalEvent)extEvent, message);
                    if (MPConstant.EventStatus.isInvalidEventData(eventStatus)) {
                        return;
                    }
                    if (MPConstant.EventStatus.isSuccess(eventStatus)) {
                        if (SMPConfig.self().isExtEventHistoryEnabled()) {
                            extEvent.setProcessed(true);
                            if (MPUtil.isDebug()) {
                                JMSService.getLogger().debugKey("BM_MPGW205", new Object[]{MPUtil.getEventCtx(extEvent)});
                            }
                        } else {
                            return;
                        }
                    }
                }
                if (MPUtil.isDebug()) {
                    JMSService.getLogger().debugKey("BM_MPGW203", new Object[]{MPUtil.getEventCtx(extEvent)});
                }
                utx = TransactionService.getUserTransaction();
                utx.begin();
                MPService.self().getPersistenceService().storeEvent(extEvent);
                utx.commit();
                if (MPUtil.isDebug()) {
                    JMSService.getLogger().debugKey("BM_MPGW122", new Object[]{MPUtil.getEventCtx(extEvent)});
                }
            }
        }
        catch (Throwable th) {
            TransactionService.rollback(utx, (SBMLogger)JMSService.getLogger());
            MPUtil.handleException(th, message);
        }
    }

    private MPConstant.EventStatus processEvent(BLExternalEvent extEvent, Message message) {
        UserTransaction utx = null;
        try {
            if (MPUtil.isDebug()) {
                JMSService.getLogger().debugKey("BM_MPGW201", new Object[]{MPUtil.getEventCtx(extEvent)});
            }
            utx = TransactionService.getUserTransaction();
            utx.begin();
            EventProcessor.self().processEvent(extEvent, null);
            utx.commit();
            if (MPUtil.isDebug()) {
                JMSService.getLogger().debugKey("BM_MPGW202", new Object[]{MPUtil.getEventCtx(extEvent)});
            }
            return MPConstant.EventStatus.SUCCESS;
        }
        catch (InvalidEventDataException e) {
            TransactionService.rollback((UserTransaction)utx, (SBMLogger)JMSService.getLogger());
            MPUtil.handleInvalidEventDataEx(e, message);
            return MPConstant.EventStatus.INVALID_EVENT_DATA;
        }
        catch (InvalidProcessStateException e) {
            TransactionService.rollback((UserTransaction)utx, (SBMLogger)JMSService.getLogger());
        }
        catch (Throwable e) {
            TransactionService.rollback((UserTransaction)utx, (SBMLogger)JMSService.getLogger());
            JMSService.getLogger().warnKey("BM_MPGW204", "JMSService.processEvent(BLExternalEvent,Message)", e, new Object[0]);
        }
        return MPConstant.EventStatus.FAILED;
    }

    private static ExternalEvent getExternalEventFromObjMsg(ObjectMessage message) {
        if (message == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW101", "JMSService.getExternalEventFromObjMsg(ObjectMessage)"));
        }
        ExternalEvent extEvent = null;
        Map eventCtx = JMSUtil.getEventCtx((Message)message);
        try {
            extEvent = JMSService.prepareExtEvtFromMsgProperties((Message)message);
            Map payload = (Map)((Object)message.getObject());
            if (payload == null || payload.isEmpty()) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW106", "JMSService.getExternalEventFromObjMsg(ObjectMessage)", new Object[]{eventCtx}));
            }
            extEvent = JMSService.prepareExtEvtFromMsgPayload(extEvent, payload, eventCtx);
        }
        catch (InvalidEventDataException invalidEventDataEx) {
            throw invalidEventDataEx;
        }
        catch (MonitoringProcessException monitorProcessEx) {
            throw monitorProcessEx;
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW117", "JMSService.getExternalEventFromObjMsg(ObjectMessage)", new Object[]{eventCtx, message}, th));
        }
        return extEvent;
    }

    private static ExternalEvent getExternalEventFromMapMsg(MapMessage message) {
        if (message == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW101", "JMSService.getExternalEventFromMapMsg(MapMessage)"));
        }
        ExternalEvent extEvent = null;
        Map eventCtx = JMSUtil.getEventCtx((Message)message);
        try {
            extEvent = JMSService.prepareExtEvtFromMsgProperties((Message)message);
            Enumeration mapNames = message.getMapNames();
            HashMap<String, Object> payload = new HashMap<String, Object>();
            while (mapNames != null && mapNames.hasMoreElements()) {
                String name = (String)mapNames.nextElement();
                Object value = message.getObject(name);
                if (("DATASLOT".equals(name) || "CONTEXT".equals(name)) && value != null) {
                    if (value instanceof byte[]) {
                        value = MPUtil.convertByteArrToHashMap(message.getBytes(name), name, eventCtx);
                    } else {
                        throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW139", "JMSService.getExternalEventFromMapMsg(MapMessage)", new Object[]{name, value.getClass().getName(), eventCtx}));
                    }
                }
                payload.put(name, value);
            }
            if (payload == null || payload.isEmpty()) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW106", "JMSService.getExternalEventFromMapMsg(MapMessage)", new Object[]{eventCtx}));
            }
            extEvent = JMSService.prepareExtEvtFromMsgPayload(extEvent, payload, eventCtx);
        }
        catch (InvalidEventDataException invalidEventDataEx) {
            throw invalidEventDataEx;
        }
        catch (MonitoringProcessException monitorProcessEx) {
            throw monitorProcessEx;
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW117", "JMSService.getExternalEventFromMapMsg(MapMessage)", new Object[]{eventCtx, message}, th));
        }
        return extEvent;
    }

    private static ExternalEvent prepareExtEvtFromMsgProperties(Message message) {
        String piAlias;
        if (message == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW101", "JMSService.prepareExtEvtFromMsgProperties(Message)"));
        }
        BLExternalEvent extEvent = null;
        Map eventCtx = JMSUtil.getEventCtx(message);
        String eiid = JMSService.getStringProperty(message, "EXTERNAL_INSTANCE_ID", eventCtx, true);
        String processName = JMSService.getStringProperty(message, "PROCESS_NAME", eventCtx, true);
        String operationType = JMSService.getStringProperty(message, "OPERATION_TYPE", eventCtx, true);
        if (!MPUtil.isValidString(processName) || !MPUtil.isValidProcessTemplate(processName)) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW128", "JMSService.prepareExtEvtFromMsgProperties(Message)", new Object[]{processName, eventCtx}));
        }
        OperationType opType = OperationType.getType(operationType);
        if (opType == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW109", "JMSService.prepareExtEvtFromMsgProperties(Message)", new Object[]{operationType, OperationType.getValidValues(), eventCtx}));
        }
        if (opType.isWorkstep()) {
            String workstepName = JMSService.getStringProperty(message, "WORKSTEP_NAME", eventCtx, true);
            if (!MPUtil.isValidWorkstep(processName, workstepName)) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW206", "JMSService.prepareExtEvtFromMsgProperties(Message)", new Object[]{workstepName, processName, eventCtx}));
            }
            extEvent = new BLExternalEvent(eiid, processName, opType, workstepName);
        } else {
            extEvent = new BLExternalEvent(eiid, processName, opType);
        }
        String notifyEmailIds = JMSService.getStringProperty(message, "NOTIFY_EMAILS", eventCtx, false);
        if (MPUtil.isValidString(notifyEmailIds)) {
            List<String> emailId = MPUtil.convertToStringList(notifyEmailIds);
            extEvent.setEmailId(emailId);
        }
        if (MPUtil.isValidString(piAlias = JMSService.getStringProperty(message, "INSTANCE_ALIAS", eventCtx, false))) {
            extEvent.setInstanceAlias(piAlias);
        }
        return extEvent;
    }

    private static ExternalEvent prepareExtEvtFromMsgPayload(ExternalEvent extEvent, Map<String, Object> payload, Map<String, Object> eventCtx) {
        if (payload != null && !payload.isEmpty()) {
            for (String mapKey : msgKeyList) {
                Object value = payload.get(mapKey);
                if ("SENDER".equals(mapKey)) {
                    JMSService.validateString(value, "SENDER", eventCtx);
                    if (!MPUtil.isValidString((String)value)) {
                        throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW136", "JMSService.prepareExtEvtFromMsgPayload(ExternalEvent,Map,Map)", new Object[]{"SENDER", eventCtx}));
                    }
                    eventCtx.put("SENDER", value);
                    extEvent.setSender(((String)value).trim());
                    continue;
                }
                if ("CREATE_TIME".equals(mapKey)) {
                    eventCtx.put("CREATE_TIME", value);
                    long createTime = MPUtil.getCreateTime(value, "CREATE_TIME", eventCtx);
                    extEvent.setCreateTime(createTime);
                    continue;
                }
                if ("CATEGORY".equals(mapKey)) {
                    if (value == null || !(value instanceof String)) continue;
                    extEvent.setCategory(((String)value).trim());
                    continue;
                }
                if ("PRIORITY".equals(mapKey)) {
                    if (value == null || !(value instanceof String)) continue;
                    extEvent.setPriority(((String)value).trim());
                    continue;
                }
                if ("PERFORMER".equals(mapKey)) {
                    if (value == null || !(value instanceof String)) continue;
                    extEvent.setPerformer(((String)value).trim());
                    continue;
                }
                if ("LOOP_COUNTER".equals(mapKey)) {
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        extEvent.setLoopCounter((Integer)value);
                        continue;
                    }
                    if (value instanceof Long && (Long)value <= Integer.MAX_VALUE) {
                        extEvent.setLoopCounter((int)((Long)value).longValue());
                        continue;
                    }
                    JMSService.getLogger().warnKey("BM_MPGW129", "JMSService.prepareExtEvtFromMsgPayload(ExternalEvent,Map,Map)", new Object[]{"LOOP_COUNTER", value, eventCtx});
                    continue;
                }
                if ("START_TIME".equals(mapKey)) {
                    long startTime;
                    if (value == null || (startTime = JMSService.getTime(value, "START_TIME", eventCtx)) <= 0L) continue;
                    extEvent.setStartTime(startTime);
                    continue;
                }
                if ("END_TIME".equals(mapKey)) {
                    long endTime;
                    if (value == null || (endTime = JMSService.getTime(value, "END_TIME", eventCtx)) <= 0L) continue;
                    extEvent.setEndTime(endTime);
                    continue;
                }
                if ("DURATION".equals(mapKey)) {
                    if (value == null) continue;
                    if (value instanceof Long) {
                        long duration = (Long)value;
                        if (duration > 315360000L) {
                            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW137", "JMSService.prepareExtEvtFromMsgPayload(ExternalEvent,Map,Map)", new Object[]{duration, "DURATION", 315360000L, eventCtx}));
                        }
                        extEvent.setDuration(duration);
                        continue;
                    }
                    if (value instanceof Integer) {
                        int duration = (Integer)value;
                        if ((long)duration > 315360000L) {
                            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW137", "JMSService.prepareExtEvtFromMsgPayload(ExternalEvent,Map,Map)", new Object[]{duration, "DURATION", 315360000L, eventCtx}));
                        }
                        extEvent.setDuration(duration);
                        continue;
                    }
                    JMSService.getLogger().warnKey("BM_MPGW129", "JMSService.prepareExtEvtFromMsgPayload(ExternalEvent,Map,Map)", new Object[]{"DURATION", value, eventCtx});
                    continue;
                }
                if ("DATASLOT".equals(mapKey)) {
                    if (value == null || !(value instanceof Map)) continue;
                    extEvent.setEventData((Map)value);
                    continue;
                }
                if ("CONTEXT".equals(mapKey)) {
                    if (value == null || !(value instanceof Map)) continue;
                    extEvent.setEventContext((Map)value);
                    continue;
                }
                JMSService.getLogger().warnKey("BM_MPGW116", new Object[]{mapKey, eventCtx});
            }
        }
        return extEvent;
    }

    private static void validateMessage(Message message) throws JMSException {
        if (message == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW101", "JMSService.validateMessage(Message)"));
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            Serializable msgPayload = objMsg.getObject();
            if (msgPayload == null) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW106", "JMSService.validateMessage(Message)", new Object[]{JMSUtil.getEventCtx((Message)objMsg)}));
            }
            if (!(msgPayload instanceof Map)) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW107", "JMSService.validateMessage(Message)", new Object[]{msgPayload.getClass().getName(), JMSUtil.getEventCtx(message)}));
            }
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            Enumeration msgBodyKeys = mapMsg.getMapNames();
            if (msgBodyKeys == null || !msgBodyKeys.hasMoreElements()) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW138", "JMSService.validateMessage(Message)", new Object[]{JMSUtil.getEventCtx(message)}));
            }
        } else {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW105", "JMSService.validateMessage(Message)", new Object[]{message.getClass().getName(), JMSUtil.getEventCtx(message)}));
        }
    }

    private static void validateString(Object object, String context, Map eventCtx) {
        if (object == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW115", "JMSService.validateString(Object,String)", new Object[]{context, eventCtx}));
        }
        if (!(object instanceof String)) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW102", "JMSService.validateString(Object,String)", new Object[]{context, object, object.getClass().getName(), eventCtx}));
        }
    }

    private static String getStringProperty(Message message, String propertyName, Map eventCtx, boolean isRequired) {
        if (message == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW101", "JMSService.getStringProperty()"));
        }
        Object propValue = null;
        try {
            propValue = message.getObjectProperty(propertyName);
        }
        catch (Throwable th) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW131", "JMSService.getJMSStringProperty()", new Object[]{propertyName, eventCtx}, th));
        }
        if (propValue != null) {
            if (propValue instanceof String) {
                if (((String)propValue).trim().length() == 0 && isRequired) {
                    throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW136", "JMSService.getStringProperty()", new Object[]{propertyName, eventCtx}));
                }
                return ((String)propValue).trim();
            }
            if (isRequired) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW132", "JMSService.getStringProperty()", new Object[]{propertyName, propValue, propValue.getClass().getName(), eventCtx}));
            }
            if (SMPConfig.self().logWarningMessage()) {
                JMSService.getLogger().warnKey("BM_MPGW133", "JMSService.getStringProperty()", new Object[]{propertyName, propValue, propValue.getClass().getName(), eventCtx});
            }
        }
        return null;
    }

    private static long getTime(Object object, String context, Map eventCtx) {
        long timeValue = 0L;
        if (object == null) {
            return timeValue;
        }
        timeValue = MPUtil.getValidTime(object, context, eventCtx, false);
        return timeValue;
    }

    private static synchronized List<String> prepareKeyList() {
        msgKeyList = new ArrayList<String>();
        msgKeyList.add("SENDER");
        msgKeyList.add("CATEGORY");
        msgKeyList.add("PRIORITY");
        msgKeyList.add("PERFORMER");
        msgKeyList.add("LOOP_COUNTER");
        msgKeyList.add("CREATE_TIME");
        msgKeyList.add("START_TIME");
        msgKeyList.add("END_TIME");
        msgKeyList.add("DURATION");
        msgKeyList.add("DATASLOT");
        msgKeyList.add("CONTEXT");
        return msgKeyList;
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }
}

