/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.gateway.jms.util;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.util.BMJMSService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.ShutdownUtil;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;

public class JMSUtil {
    private static JMSUtil instance = null;
    private BMJMSService bmJmsService = null;
    private Destination evtQueue = null;
    private Connection connection = null;

    private JMSUtil() {
        ShutdownUtil.registerShutdownHook((Object)this, (String)"closeAll");
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JMSUtil self() {
        if (null != instance) return instance;
        Class<JMSUtil> clazz = JMSUtil.class;
        synchronized (JMSUtil.class) {
            if (null != instance) return instance;
            instance = new JMSUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        try {
            this.bmJmsService = SBMUtil.self().getBMJMSService();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)JMSUtil.getMonitoringPrcExSvc().createException("BM_MPGW112", "JMSUtil.init()", null, th));
        }
        this.evtQueue = this.getEventQueueDestination();
        this.connection = this.getConnection();
    }

    public static void close(Session sess) {
        try {
            if (sess != null) {
                sess.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void closeAll() {
        try {
            this.connection.close();
        }
        catch (Throwable e) {
            try {
                JMSUtil.getLogger().errorKey("BM_MPGW225", "JMSUtil.closeAll()", e, new Object[0]);
            }
            catch (Throwable th) {
                LoggerUtil.logSOP((Object)("Error while trying to close connection in JMSUtil.closeAll(): " + e.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination getEventQueueDestination() {
        try {
            if (null != this.evtQueue) {
                return this.evtQueue;
            }
            Class<JMSUtil> clazz = JMSUtil.class;
            synchronized (JMSUtil.class) {
                if (null == this.evtQueue) {
                    this.evtQueue = this.bmJmsService.lookupDestination("jms/BMExternalEventQueue");
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)JMSUtil.getMonitoringPrcExSvc().createException("BM_MPGW113", "JMSUtil.init()", new Object[]{"jms/BMExternalEventQueue"}, th));
        }
        {
            return this.evtQueue;
        }
    }

    public void repostMessage(Message message) throws JMSException {
        try {
            this.bmJmsService.sendMessage(this.evtQueue, message);
        }
        catch (Throwable th) {
            this.evtQueue = null;
            this.evtQueue = this.getEventQueueDestination();
            this.bmJmsService.sendMessage(this.evtQueue, message);
        }
    }

    public boolean repostIfBizLogicNotReady(Message message) {
        if (!BLControl.isServerReady()) {
            try {
                MPUtil.sleep(60000L);
                if (!BLControl.isServerReady()) {
                    JMSUtil.getLogger().warnKey("BM_MPGW229", new Object[]{JMSUtil.getEventCtx(message)});
                    JMSUtil.self().repostMessage(message);
                    return true;
                }
            }
            catch (Throwable e) {
                throw (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW230", "JMSUtil.repostIfBizLogicNotReady()", new Object[]{JMSUtil.getEventCtx(message)}, e));
            }
        }
        return false;
    }

    public static Map<String, Object> getInvalidEvent(Message message, InvalidEventDataException invalidEvtDataEx) {
        HashMap<String, Object> invalidEvent = new HashMap<String, Object>();
        invalidEvent.put("REASON", invalidEvtDataEx.getMessage());
        if (message == null) {
            return invalidEvent;
        }
        try {
            String opTypeAsStr;
            if (!(message instanceof ObjectMessage) && !(message instanceof MapMessage)) {
                StringBuilder sb = new StringBuilder(invalidEvtDataEx.getMessage());
                Map msgCtx = JMSUtil.getEventCtx(message);
                sb.append(" Message data: " + msgCtx);
                invalidEvent.put("REASON", sb.toString());
                invalidEvent.put("MESSAGE", msgCtx);
                return invalidEvent;
            }
            if (JMSUtil.isBulkMessage(message)) {
                HashMap<String, Object> msg = new HashMap<String, Object>();
                Map msgCtx = JMSUtil.getEventCtx(message);
                Object payload = null;
                if (message instanceof ObjectMessage) {
                    payload = ((ObjectMessage)message).getObject();
                } else if (message instanceof MapMessage) {
                    MapMessage mapMessage = (MapMessage)message;
                    payload = mapMessage.getObject("EVENT_LIST");
                    payload = MPUtil.convertByteArrToList(mapMessage.getBytes("EVENT_LIST"), "EVENT_LIST", msgCtx);
                }
                msg.put("EVENT_CONTEXT", msgCtx);
                msg.put("PAYLOAD", payload);
                invalidEvent.put("MESSAGE", msg);
                return invalidEvent;
            }
            HashMap<String, Object> msgData = new HashMap<String, Object>();
            Object value = message.getObjectProperty("EXTERNAL_INSTANCE_ID");
            if (value != null && value instanceof String) {
                invalidEvent.put("EXTERNAL_INSTANCE_ID", value);
            }
            msgData.put("EXTERNAL_INSTANCE_ID", value);
            value = message.getObjectProperty("PROCESS_NAME");
            if (value != null && value instanceof String) {
                invalidEvent.put("PROCESS_NAME", value);
            }
            msgData.put("PROCESS_NAME", value);
            value = message.getObjectProperty("OPERATION_TYPE");
            msgData.put("OPERATION_TYPE", value);
            if (value != null && value instanceof String && OperationType.isValidType(opTypeAsStr = (String)value)) {
                OperationType opType = OperationType.getType(opTypeAsStr);
                invalidEvent.put("OPERATION_TYPE", opType.getId());
            }
            if ((value = message.getObjectProperty("WORKSTEP_NAME")) != null && value instanceof String) {
                invalidEvent.put("WORKSTEP_NAME", value);
            }
            msgData.put("WORKSTEP_NAME", value);
            value = message.getObjectProperty("NOTIFY_EMAILS");
            if (value != null && value instanceof String) {
                invalidEvent.put("NOTIFY_EMAILS", value);
            }
            if (message instanceof ObjectMessage) {
                ObjectMessage objMsg = (ObjectMessage)message;
                Serializable payload = objMsg.getObject();
                if (payload != null && payload instanceof Map) {
                    Map map = (Map)((Object)payload);
                    Object objValue = map.get("SENDER");
                    if (objValue instanceof String) {
                        invalidEvent.put("SENDER", objValue);
                    } else {
                        msgData.put("SENDER", objValue);
                    }
                    objValue = map.get("CREATE_TIME");
                    if (objValue instanceof Long) {
                        invalidEvent.put("CREATE_TIME", objValue);
                    } else {
                        msgData.put("CREATE_TIME", objValue);
                    }
                    msgData.put("CATEGORY", map.get("CATEGORY"));
                    msgData.put("PRIORITY", map.get("PRIORITY"));
                    msgData.put("PERFORMER", map.get("PERFORMER"));
                    msgData.put("LOOP_COUNTER", map.get("LOOP_COUNTER"));
                    msgData.put("START_TIME", map.get("START_TIME"));
                    msgData.put("END_TIME", map.get("END_TIME"));
                    msgData.put("DURATION", map.get("DURATION"));
                    msgData.put("NOTIFY_EMAILS", message.getObjectProperty("NOTIFY_EMAILS"));
                    msgData.put("INSTANCE_ALIAS", map.get("INSTANCE_ALIAS"));
                    invalidEvent.put("MESSAGE", msgData);
                }
            } else if (message instanceof MapMessage) {
                MapMessage mapMsg = (MapMessage)message;
                Object objValue = mapMsg.getObject("SENDER");
                if (objValue instanceof String) {
                    invalidEvent.put("SENDER", objValue);
                } else {
                    msgData.put("SENDER", objValue);
                }
                objValue = mapMsg.getObject("CREATE_TIME");
                if (objValue instanceof Long) {
                    invalidEvent.put("CREATE_TIME", objValue);
                } else {
                    msgData.put("CREATE_TIME", objValue);
                }
                msgData.put("CATEGORY", mapMsg.getObject("CATEGORY"));
                msgData.put("PRIORITY", mapMsg.getObject("PRIORITY"));
                msgData.put("PERFORMER", mapMsg.getObject("PERFORMER"));
                msgData.put("LOOP_COUNTER", mapMsg.getObject("LOOP_COUNTER"));
                msgData.put("START_TIME", mapMsg.getObject("START_TIME"));
                msgData.put("END_TIME", mapMsg.getObject("END_TIME"));
                msgData.put("DURATION", mapMsg.getObject("DURATION"));
                msgData.put("NOTIFY_EMAILS", message.getObjectProperty("NOTIFY_EMAILS"));
                msgData.put("INSTANCE_ALIAS", mapMsg.getObject("INSTANCE_ALIAS"));
                invalidEvent.put("MESSAGE", msgData);
            }
        }
        catch (Throwable th) {
            JMSUtil.getLogger().errorKey("BM_MPGW111", "JMSUtil.getInvalidEvent(Message,invalidEvtDataEx)", th, new Object[]{invalidEvent});
        }
        return invalidEvent;
    }

    public static boolean isBulkMessage(Message message) {
        boolean isBulkMsg = false;
        try {
            isBulkMsg = message.getBooleanProperty("BULK_MESSAGE");
        }
        catch (Throwable e) {
            JMSUtil.getLogger().errorKey("BM_MPGW216", "JMSUtil.isBulkMessage()", e, new Object[]{JMSUtil.getEventCtx(message)});
        }
        return isBulkMsg;
    }

    public static Map getEventCtx(Message message) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        if (message != null) {
            try {
                ctx.put("JMSMessageID", message.getJMSMessageID());
                ctx.put("JMSTimestamp", message.getJMSTimestamp());
                Enumeration properties = message.getPropertyNames();
                while (properties.hasMoreElements()) {
                    String propName = (String)properties.nextElement();
                    ctx.put(propName, message.getObjectProperty(propName));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ctx;
    }

    public static Map getMessageData(Message message) {
        LinkedHashMap<String, Object> msgData = new LinkedHashMap<String, Object>();
        if (message != null) {
            msgData.put("MESSAGE_TYPE", message.getClass().getName());
            msgData.put("MESSAGE_PROPERTIES", JMSUtil.getEventCtx(message));
            try {
                if (message instanceof ObjectMessage) {
                    ObjectMessage objMsg = (ObjectMessage)message;
                    Serializable msgPayload = objMsg.getObject();
                    if (msgPayload == null) {
                        msgData.put("MESSAGE_PAYLOAD", "Payload is null");
                    } else {
                        msgData.put("MESSAGE_PAYLOAD_TYPE", msgPayload.getClass().getName());
                        msgData.put("MESSAGE_PAYLOAD", msgPayload);
                    }
                } else if (message instanceof MapMessage) {
                    MapMessage mapMsg = (MapMessage)message;
                    Enumeration mapKeys = mapMsg.getMapNames();
                    if (mapKeys == null || !mapKeys.hasMoreElements()) {
                        msgData.put("MESSAGE_PAYLOAD", "Payload is null or empty");
                    } else {
                        HashMap<String, Object> payload = new HashMap<String, Object>();
                        while (mapKeys.hasMoreElements()) {
                            String msgKey = (String)mapKeys.nextElement();
                            payload.put(msgKey, mapMsg.getObject(msgKey));
                        }
                        msgData.put("MESSAGE_PAYLOAD", payload);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return msgData;
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringPrcExSvc() {
        return MPService.self().getMonitoringProcessES();
    }

    public static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    public Session getSession() throws JMSException {
        Session session = null;
        try {
            session = SBMUtil.self().getBMJMSService().createSession(this.connection);
        }
        catch (Throwable th) {
            this.connection = null;
            this.connection = this.getConnection();
            session = SBMUtil.self().getBMJMSService().createSession(this.connection);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Connection getConnection() {
        try {
            if (null != this.connection) return this.connection;
            Class<JMSUtil> clazz = JMSUtil.class;
            synchronized (JMSUtil.class) {
                if (null != this.connection) return this.connection;
                this.connection = SBMUtil.self().getBMJMSService().createConnection(null, ServiceLocator.self().getPrincipal(), ServiceLocator.self().getCredentials());
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.connection;
            }
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)JMSUtil.getMonitoringPrcExSvc().createException("BM_MPGW220", "JMSUtil.getConnection()", th));
        }
    }
}

