/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.gateway.rest;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.util.InvalidEventDataException;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.util.logger.SBMLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class JSONUtil {
    public static final String JSON_KEY_RECEIPT = "RECEIPT";
    public static final String JSON_KEY_RECEIPT_RECEIVED_AT = "RECEIVED_AT";
    public static final String JSON_KEY_RECEIPT_RECEIVED_TIME = "RECEIVED_TIME";
    public static final String JSON_KEY_RECEIPT_RECEIVED_CTR = "RECEIVED_CTR";
    public static final String JSON_KEY_PROPERTIES = "PROPERTIES";
    public static final String JSON_KEY_PROPERTIES_EXTERNAL_INSTANCE_ID = "EXTERNAL_INSTANCE_ID";
    public static final String JSON_KEY_PROPERTIES_PROCESS_NAME = "PROCESS_NAME";
    public static final String JSON_KEY_PROPERTIES_OPERATION_TYPE = "OPERATION_TYPE";
    public static final String JSON_KEY_PROPERTIES_WORKSTEP_NAME = "WORKSTEP_NAME";
    public static final String JSON_KEY_PROPERTIES_NOTIFY_EMAILS = "NOTIFY_EMAILS";
    public static final String JSON_KEY_PROPERTIES_INSTANCE_ALIAS = "INSTANCE_ALIAS";
    public static final String JSON_KEY_BODY = "BODY";
    public static final String JSON_KEY_BODY_SENDER = "SENDER";
    public static final String JSON_KEY_BODY_CATEGORY = "CATEGORY";
    public static final String JSON_KEY_BODY_PRIORITY = "PRIORITY";
    public static final String JSON_KEY_BODY_PERFORMER = "PERFORMER";
    public static final String JSON_KEY_BODY_LOOP_COUNTER = "LOOP_COUNTER";
    public static final String JSON_KEY_BODY_CREATE_TIME = "CREATE_TIME";
    public static final String JSON_KEY_BODY_START_TIME = "START_TIME";
    public static final String JSON_KEY_BODY_END_TIME = "END_TIME";
    public static final String JSON_KEY_BODY_DURATION = "DURATION";
    public static final String JSON_KEY_BODY_CONTEXT = "CONTEXT";
    public static final String JSON_KEY_BODY_DATASLOT = "DATASLOT";
    private static final String CONTEXT_MAP_KEY_RECEIPT_RECEIVED_AT = "RECEIPT.RECEIVED_AT";
    private static final String CONTEXT_MAP_KEY_RECEIPT_RECEIVED_TIME = "RECEIPT.RECEIVED_TIME";
    private static final String CONTEXT_MAP_KEY_RECEIPT_RECEIVED_CTR = "RECEIPT.RECEIVED_CTR";
    private static final String CONTEXT_MAP_KEY_PROPERTIES = "PROPERTIES.";

    public static void validateJSON(JSONObject extEventJSON) {
        if (extEventJSON == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW141", "RESTService.validateJSON(extEventJSON)"));
        }
        if (extEventJSON.keySet().size() == 0) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW142", "RESTService.validateJSON(extEventJSON)"));
        }
    }

    public static BLExternalEvent getExternalEventFromJSON(JSONObject extEventJSON) {
        Map<String, Object> eventCtx = JSONUtil.getEventCtxFromJSON(extEventJSON);
        try {
            JSONObject extEventPropertiesJSON = extEventJSON.getJSONObject(JSON_KEY_PROPERTIES);
            BLExternalEvent extEvent = JSONUtil.processJSONProperties(extEventPropertiesJSON, eventCtx);
            JSONObject extEventBodyJSON = extEventJSON.getJSONObject(JSON_KEY_BODY);
            return JSONUtil.processJSONBody(extEventBodyJSON, eventCtx, extEvent);
        }
        catch (InvalidEventDataException invalidEventDataEx) {
            throw invalidEventDataEx;
        }
        catch (MonitoringProcessException monitorProcessEx) {
            throw monitorProcessEx;
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)MPUtil.getMonitoringProcessES().createException("BM_MPGW144", "RESTService.convertTOExternalEvent(extEventJSONString)", new Object[]{eventCtx, extEventJSON}, th));
        }
    }

    public static Map<String, Object> getEventCtxFromJSON(JSONObject extEventJSON) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        if (extEventJSON != null) {
            try {
                JSONObject extEventContextJSON = extEventJSON.getJSONObject(JSON_KEY_RECEIPT);
                ctx.put(CONTEXT_MAP_KEY_RECEIPT_RECEIVED_AT, extEventContextJSON.getString(JSON_KEY_RECEIPT_RECEIVED_AT));
                ctx.put(CONTEXT_MAP_KEY_RECEIPT_RECEIVED_TIME, extEventContextJSON.getInt(JSON_KEY_RECEIPT_RECEIVED_TIME));
                ctx.put(CONTEXT_MAP_KEY_RECEIPT_RECEIVED_CTR, extEventContextJSON.getInt(JSON_KEY_RECEIPT_RECEIVED_CTR));
                JSONObject extEventPropertiesJSON = extEventJSON.getJSONObject(JSON_KEY_PROPERTIES);
                for (Object key : extEventPropertiesJSON.keySet()) {
                    ctx.put(CONTEXT_MAP_KEY_PROPERTIES + key, extEventJSON.get(key));
                }
            }
            catch (Throwable th) {
                JSONUtil.getLogger().errorKey("BM_MPGW155", "JSONUtil.getEventCtxFromJSON(JSONObject)", th, new Object[]{extEventJSON});
            }
        }
        return ctx;
    }

    public static Map<String, Object> getInvalidEvent(JSONObject extEventJSON, String invalidEventExceptionMessage) {
        HashMap<String, Object> invalidEvent = new HashMap<String, Object>();
        invalidEvent.put("REASON", invalidEventExceptionMessage);
        if (extEventJSON == null) {
            return invalidEvent;
        }
        try {
            JSONObject extEventBodyJSON;
            Object objValue;
            String opTypeAsStr;
            HashMap<String, Object> msgData = new HashMap<String, Object>();
            JSONObject extEventPropertiesJSON = extEventJSON.getJSONObject(JSON_KEY_PROPERTIES);
            Object value = extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_EXTERNAL_INSTANCE_ID);
            if (value != null && value instanceof String) {
                invalidEvent.put(JSON_KEY_PROPERTIES_EXTERNAL_INSTANCE_ID, value);
            }
            msgData.put(JSON_KEY_PROPERTIES_EXTERNAL_INSTANCE_ID, value);
            value = extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_PROCESS_NAME);
            if (value != null && value instanceof String) {
                invalidEvent.put(JSON_KEY_PROPERTIES_PROCESS_NAME, value);
            }
            msgData.put(JSON_KEY_PROPERTIES_PROCESS_NAME, value);
            value = extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_OPERATION_TYPE);
            if (value != null && value instanceof String && OperationType.isValidType(opTypeAsStr = (String)value)) {
                OperationType opType = OperationType.getType(opTypeAsStr);
                invalidEvent.put(JSON_KEY_PROPERTIES_OPERATION_TYPE, opType.getId());
            }
            msgData.put(JSON_KEY_PROPERTIES_OPERATION_TYPE, value);
            value = extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_WORKSTEP_NAME);
            if (value != null && value instanceof String) {
                invalidEvent.put(JSON_KEY_PROPERTIES_WORKSTEP_NAME, value);
            }
            msgData.put(JSON_KEY_PROPERTIES_WORKSTEP_NAME, value);
            value = extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_NOTIFY_EMAILS);
            if (value != null && value instanceof String) {
                invalidEvent.put(JSON_KEY_PROPERTIES_NOTIFY_EMAILS, value);
            }
            if ((objValue = (extEventBodyJSON = extEventJSON.getJSONObject(JSON_KEY_BODY)).get(JSON_KEY_BODY_SENDER)) instanceof String) {
                invalidEvent.put(JSON_KEY_BODY_SENDER, objValue);
            } else {
                msgData.put(JSON_KEY_BODY_SENDER, objValue);
            }
            objValue = extEventBodyJSON.get(JSON_KEY_BODY_CREATE_TIME);
            if (objValue instanceof Long) {
                invalidEvent.put(JSON_KEY_BODY_CREATE_TIME, objValue);
            } else {
                msgData.put(JSON_KEY_BODY_CREATE_TIME, objValue);
            }
            msgData.put(JSON_KEY_BODY_CATEGORY, extEventBodyJSON.get(JSON_KEY_BODY_CATEGORY));
            msgData.put(JSON_KEY_BODY_PRIORITY, extEventBodyJSON.get(JSON_KEY_BODY_PRIORITY));
            msgData.put(JSON_KEY_BODY_PERFORMER, extEventBodyJSON.get(JSON_KEY_BODY_PERFORMER));
            msgData.put(JSON_KEY_BODY_LOOP_COUNTER, extEventBodyJSON.get(JSON_KEY_BODY_LOOP_COUNTER));
            msgData.put(JSON_KEY_BODY_START_TIME, extEventBodyJSON.get(JSON_KEY_BODY_START_TIME));
            msgData.put(JSON_KEY_BODY_END_TIME, extEventBodyJSON.get(JSON_KEY_BODY_END_TIME));
            msgData.put(JSON_KEY_BODY_DURATION, extEventBodyJSON.get(JSON_KEY_BODY_DURATION));
            msgData.put(JSON_KEY_PROPERTIES_NOTIFY_EMAILS, extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_NOTIFY_EMAILS));
            msgData.put(JSON_KEY_PROPERTIES_INSTANCE_ALIAS, extEventPropertiesJSON.get(JSON_KEY_PROPERTIES_INSTANCE_ALIAS));
            invalidEvent.put("MESSAGE", msgData);
        }
        catch (Throwable th) {
            JSONUtil.getLogger().errorKey("BM_MPGW111", "RESTService.getInvalidEvent(JSONObject)", th, new Object[]{invalidEvent});
        }
        return invalidEvent;
    }

    private static BLExternalEvent processJSONProperties(JSONObject extEventPropertiesJSON, Map<String, Object> eventCtx) {
        String piAlias;
        if (extEventPropertiesJSON == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW145", "RESTService.processJSONProperties(JSONObject)"));
        }
        BLExternalEvent extEvent = null;
        String eiid = JSONUtil.getStringProperty(extEventPropertiesJSON, JSON_KEY_PROPERTIES_EXTERNAL_INSTANCE_ID, eventCtx, true);
        String processName = JSONUtil.getStringProperty(extEventPropertiesJSON, JSON_KEY_PROPERTIES_PROCESS_NAME, eventCtx, true);
        if (!MPUtil.isValidString(processName) || !MPUtil.isValidProcessTemplate(processName)) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW128", "RESTService.processJSONProperties(JSONObject)", new Object[]{processName, eventCtx}));
        }
        String operationType = JSONUtil.getStringProperty(extEventPropertiesJSON, JSON_KEY_PROPERTIES_OPERATION_TYPE, eventCtx, true);
        OperationType opType = OperationType.getType(operationType);
        if (opType == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW109", "RESTService.processJSONProperties(JSONObject)", new Object[]{operationType, OperationType.getValidValues(), eventCtx}));
        }
        if (opType.isWorkstep()) {
            String workstepName = JSONUtil.getStringProperty(extEventPropertiesJSON, JSON_KEY_PROPERTIES_WORKSTEP_NAME, eventCtx, true);
            if (!MPUtil.isValidWorkstep(processName, workstepName)) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW206", "RESTService.processJSONProperties(JSONObject)", new Object[]{workstepName, processName, eventCtx}));
            }
            extEvent = new BLExternalEvent(eiid, processName, opType, workstepName);
        } else {
            extEvent = new BLExternalEvent(eiid, processName, opType);
        }
        String notifyEmailIds = JSONUtil.getStringProperty(extEventPropertiesJSON, JSON_KEY_PROPERTIES_NOTIFY_EMAILS, eventCtx, false);
        if (MPUtil.isValidString(notifyEmailIds)) {
            List<String> emailId = MPUtil.convertToStringList(notifyEmailIds);
            extEvent.setEmailId(emailId);
        }
        if (MPUtil.isValidString(piAlias = JSONUtil.getStringProperty(extEventPropertiesJSON, JSON_KEY_PROPERTIES_INSTANCE_ALIAS, eventCtx, false))) {
            extEvent.setInstanceAlias(piAlias);
        }
        return extEvent;
    }

    private static BLExternalEvent processJSONBody(JSONObject extEventBodyJSON, Map<String, Object> eventCtx, BLExternalEvent extEvent) {
        HashMap<String, Object> extEventBodyMap = new HashMap<String, Object>();
        for (Object keyObject : extEventBodyJSON.keySet()) {
            String key = (String)keyObject;
            HashMap<String, Object> value = extEventBodyJSON.get(key);
            if ((JSON_KEY_BODY_DATASLOT.equals(key) || JSON_KEY_BODY_CONTEXT.equals(key)) && value != null) {
                if (value instanceof JSONObject) {
                    value = JSONUtil.convertJSONObjectToHashMap((JSONObject)value, key, eventCtx);
                } else {
                    throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW146", "RESTService.processJSONBody(JSONObject)", new Object[]{key, value.getClass().getName(), eventCtx}));
                }
            }
            extEventBodyMap.put(key, value);
        }
        if (extEventBodyMap != null && !extEventBodyMap.isEmpty()) {
            extEvent = JSONUtil.populateExtEvtFromBodyMap(extEvent, extEventBodyMap, eventCtx);
            return extEvent;
        }
        throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW147", "RESTService.processJSONBody(JSONObject)", new Object[]{eventCtx}));
    }

    private static BLExternalEvent populateExtEvtFromBodyMap(BLExternalEvent extEvent, Map<String, Object> extEventBodyMap, Map<String, Object> eventCtx) {
        if (extEventBodyMap != null && !extEventBodyMap.isEmpty()) {
            for (String mapKey : extEventBodyMap.keySet()) {
                Object value = extEventBodyMap.get(mapKey);
                if (JSON_KEY_BODY_SENDER.equals(mapKey)) {
                    JSONUtil.validateString(value, JSON_KEY_BODY_SENDER, eventCtx);
                    if (!MPUtil.isValidString((String)value)) {
                        throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW136", "RESTService.populateExtEvtFromBodyMap(BLExternalEvent,Map,Map)", new Object[]{JSON_KEY_BODY_SENDER, eventCtx}));
                    }
                    eventCtx.put(JSON_KEY_BODY_SENDER, value);
                    extEvent.setSender(((String)value).trim());
                    continue;
                }
                if (JSON_KEY_BODY_CREATE_TIME.equals(mapKey)) {
                    eventCtx.put(JSON_KEY_BODY_CREATE_TIME, value);
                    long createTime = MPUtil.getCreateTime(value, JSON_KEY_BODY_CREATE_TIME, eventCtx);
                    extEvent.setCreateTime(createTime);
                    continue;
                }
                if (JSON_KEY_BODY_CATEGORY.equals(mapKey)) {
                    if (value == null || !(value instanceof String)) continue;
                    extEvent.setCategory(((String)value).trim());
                    continue;
                }
                if (JSON_KEY_BODY_PRIORITY.equals(mapKey)) {
                    if (value == null || !(value instanceof String)) continue;
                    extEvent.setPriority(((String)value).trim());
                    continue;
                }
                if (JSON_KEY_BODY_PERFORMER.equals(mapKey)) {
                    if (value == null || !(value instanceof String)) continue;
                    extEvent.setPerformer(((String)value).trim());
                    continue;
                }
                if (JSON_KEY_BODY_LOOP_COUNTER.equals(mapKey)) {
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        extEvent.setLoopCounter((Integer)value);
                        continue;
                    }
                    if (value instanceof Long && (Long)value <= Integer.MAX_VALUE) {
                        extEvent.setLoopCounter((int)((Long)value).longValue());
                        continue;
                    }
                    JSONUtil.getLogger().warnKey("BM_MPGW129", "RESTService.populateExtEvtFromBodyMap(BLExternalEvent,Map,Map)", new Object[]{JSON_KEY_BODY_LOOP_COUNTER, value, eventCtx});
                    continue;
                }
                if (JSON_KEY_BODY_START_TIME.equals(mapKey)) {
                    long startTime;
                    if (value == null || (startTime = JSONUtil.getTime(value, JSON_KEY_BODY_START_TIME, eventCtx)) <= 0L) continue;
                    extEvent.setStartTime(startTime);
                    continue;
                }
                if (JSON_KEY_BODY_END_TIME.equals(mapKey)) {
                    long endTime;
                    if (value == null || (endTime = JSONUtil.getTime(value, JSON_KEY_BODY_END_TIME, eventCtx)) <= 0L) continue;
                    extEvent.setEndTime(endTime);
                    continue;
                }
                if (JSON_KEY_BODY_DURATION.equals(mapKey)) {
                    if (value == null) continue;
                    if (value instanceof Long) {
                        long duration = (Long)value;
                        if (duration > 315360000L) {
                            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW148", "RESTService.populateExtEvtFromBodyMap(BLExternalEvent,Map,Map)", new Object[]{duration, JSON_KEY_BODY_DURATION, 315360000L, eventCtx}));
                        }
                        extEvent.setDuration(duration);
                        continue;
                    }
                    if (value instanceof Integer) {
                        int duration = (Integer)value;
                        if ((long)duration > 315360000L) {
                            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW148", "RESTService.populateExtEvtFromBodyMap(BLExternalEvent,Map,Map)", new Object[]{duration, JSON_KEY_BODY_DURATION, 315360000L, eventCtx}));
                        }
                        extEvent.setDuration(duration);
                        continue;
                    }
                    JSONUtil.getLogger().warnKey("BM_MPGW129", "RESTService.populateExtEvtFromBodyMap(BLExternalEvent,Map,Map)", new Object[]{JSON_KEY_BODY_DURATION, value, eventCtx});
                    continue;
                }
                if (JSON_KEY_BODY_DATASLOT.equals(mapKey)) {
                    if (value == null || !(value instanceof Map)) continue;
                    extEvent.setEventData((Map)value);
                    continue;
                }
                if (JSON_KEY_BODY_CONTEXT.equals(mapKey)) {
                    if (value == null || !(value instanceof Map)) continue;
                    extEvent.setEventContext((Map)value);
                    continue;
                }
                JSONUtil.getLogger().warnKey("BM_MPGW116", new Object[]{mapKey, eventCtx});
            }
        }
        return extEvent;
    }

    private static String getStringProperty(JSONObject extEventPropertiesJSON, String propertyName, Map<String, Object> eventCtx, boolean isRequired) {
        if (extEventPropertiesJSON == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW145", "RESTService.getStringProperty(JSONObject)"));
        }
        String propValue = null;
        try {
            propValue = extEventPropertiesJSON.getString(propertyName);
            if (propValue.trim().length() == 0 && isRequired) {
                throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW136", "RESTService.getStringProperty(JSONObject)", new Object[]{propertyName, eventCtx}));
            }
            return propValue.trim();
        }
        catch (Throwable th) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW149", "RESTService.getStringProperty(JSONObject)", new Object[]{propertyName, eventCtx}, th));
        }
    }

    private static HashMap<String, Object> convertJSONObjectToHashMap(JSONObject jsonObject, String name, Map<String, Object> eventCtx) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object keyObject : jsonObject.keySet()) {
            String key = (String)keyObject;
            Cloneable valueObject = jsonObject.get(key);
            if (valueObject instanceof JSONArray) {
                JSONArray valueArray = (JSONArray)valueObject;
                ArrayList<String> valueList = new ArrayList<String>();
                for (Object valueArrayItem : valueArray) {
                    valueList.add(valueArrayItem.toString());
                }
                valueObject = valueList;
            } else if (valueObject instanceof JSONObject) {
                JSONObject valueInnerObject = (JSONObject)valueObject;
                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                for (Object valueMapKey : valueInnerObject.keySet()) {
                    valueMap.put(valueMapKey.toString(), valueInnerObject.get(valueMapKey));
                }
                valueObject = valueMap;
            }
            result.put(key, valueObject);
        }
        return result;
    }

    private static void validateString(Object object, String context, Map<String, Object> eventCtx) {
        if (object == null) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW150", "RESTService.validateString(Object,String)", new Object[]{context, eventCtx}));
        }
        if (!(object instanceof String)) {
            throw (InvalidEventDataException)((Object)MPUtil.getInvalidEventDataES().createException("BM_MPGW151", "RESTService.validateString(Object,String)", new Object[]{context, object, object.getClass().getName(), eventCtx}));
        }
    }

    private static long getTime(Object object, String context, Map<String, Object> eventCtx) {
        long timeValue = 0L;
        if (object == null) {
            return timeValue;
        }
        timeValue = MPUtil.getValidTime(object, context, eventCtx, false);
        return timeValue;
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }
}

