/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.persistence.dao;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.core.EventUtil;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.ExternalEvent;
import com.savvion.sbm.bizlogic.smp.model.OperationType;
import com.savvion.sbm.bizlogic.smp.persistence.MPDBConstant;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.bizlogic.util.BLObjectInputStream;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExternalEventDAO
extends DBService {
    private static final String BM_MPCM125 = "BM_MPCM125";
    public static String createEventSQL;
    public static String updateReadyToProcessSQL;
    public static String updateIsProcessedSQL;
    public static String updateRetryCounterSQL;
    public static String getReadyToProcessEventSQL;
    private static String findEventID;
    private static String removeEventForProcessTemplate;
    private static String removeEventForProcessEiid;
    private static String removeEventForWorkStep;
    private static String selectEventAttributes;
    private static String selectProcessedEventIds;
    private static String selectProcessedEvents;
    private static String updateProcessContext;
    private static final String[] CREATE_LIST;
    private static final String[] GETREADY_TOPROCESS_EVENTLIST;
    private static List<String> validColumnsForUpdate;
    private static String getEventsForWorkstepSQL;

    private static synchronized void init() {
        validColumnsForUpdate = new ArrayList<String>();
        validColumnsForUpdate.add("BL_PROCESS_TEMPLATE_ID");
        validColumnsForUpdate.add("BL_PROCESS_INSTANCE_ID");
        validColumnsForUpdate.add("BL_WORKSTEP_ID");
        validColumnsForUpdate.add("BL_LOOP_COUNTER");
    }

    public static void create(Connection conn, ExternalEvent externalEvent) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.create(ExternalEvent)"));
        }
        if (externalEvent == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM114", "ExternalEventDAO.create(ExternalEvent)"));
        }
        String ctx = MPUtil.getEventCtx(externalEvent);
        String key = null;
        Object value = null;
        PreparedStatement pstmtCreateEvent = null;
        try {
            pstmtCreateEvent = conn.prepareStatement(createEventSQL);
            for (int ix = 1; ix < CREATE_LIST.length; ++ix) {
                key = CREATE_LIST[ix];
                if (key.equalsIgnoreCase("EXTERNAL_INSTANCE_ID")) {
                    value = externalEvent.getExternalInstanceId();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    Object eiid = value;
                    if (eiid.length() > 128) {
                        throw EventUtil.createInvalidEventDataEx("BM_MPCM134", "ExternalEventDAO.create(Connection, ExternalEvent)", "EXTERNAL_INSTANCE_ID", value, 128, MPUtil.getEventCtx(externalEvent));
                    }
                    pstmtCreateEvent.setString(ix, (String)eiid);
                    continue;
                }
                if (key.equalsIgnoreCase("OPERATION_TYPE")) {
                    value = externalEvent.getOperationType();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 4);
                        continue;
                    }
                    OperationType opType = (OperationType)((Object)value);
                    pstmtCreateEvent.setInt(ix, opType.getId());
                    continue;
                }
                if (key.equalsIgnoreCase("SENDER")) {
                    value = externalEvent.getSender();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    pstmtCreateEvent.setString(ix, (String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("CATEGORY")) {
                    value = externalEvent.getCategory();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    Object categoryVal = value;
                    if (((String)categoryVal).length() > 128) {
                        categoryVal = ((String)categoryVal).substring(0, 128);
                        if (SMPConfig.self().logWarningMessage()) {
                            ExternalEventDAO.getLogger().warnKey("BM_MPCM123", "ExternalEventDAO.create(Connection, ExternalEvent)", new Object[]{"CATEGORY", value, categoryVal, 128, MPUtil.getEventCtx(externalEvent)});
                        }
                    }
                    pstmtCreateEvent.setString(ix, (String)categoryVal);
                    continue;
                }
                if (key.equalsIgnoreCase("PRIORITY")) {
                    value = externalEvent.getPriority();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    String priorityVal = value;
                    if (priorityVal.length() > 32) {
                        priorityVal = priorityVal.substring(0, 32);
                        if (SMPConfig.self().logWarningMessage()) {
                            ExternalEventDAO.getLogger().warnKey("BM_MPCM123", "ExternalEventDAO.create(Connection, ExternalEvent)", new Object[]{"PRIORITY", value, priorityVal, 32, MPUtil.getEventCtx(externalEvent)});
                        }
                    }
                    pstmtCreateEvent.setString(ix, priorityVal);
                    continue;
                }
                if (key.equalsIgnoreCase("PROCESS_NAME")) {
                    value = externalEvent.getProcessName();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    pstmtCreateEvent.setString(ix, (String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("WORKSTEP_NAME")) {
                    value = externalEvent.getWorkstepName();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    pstmtCreateEvent.setString(ix, (String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("PERFORMER")) {
                    value = externalEvent.getPerformer();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    String perfVal = value;
                    if (perfVal.length() > 64 && SMPConfig.self().logWarningMessage()) {
                        ExternalEventDAO.getLogger().warnKey("BM_MPCM123", "ExternalEventDAO.create(Connection, ExternalEvent)", new Object[]{"PERFORMER", value, perfVal, 64, MPUtil.getEventCtx(externalEvent)});
                    }
                    pstmtCreateEvent.setString(ix, perfVal);
                    continue;
                }
                if (key.equalsIgnoreCase("LOOP_COUNTER")) {
                    value = externalEvent.getLoopCounter();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 4);
                        continue;
                    }
                    pstmtCreateEvent.setInt(ix, (Integer)value);
                    continue;
                }
                if (key.equalsIgnoreCase("CREATE_TIME")) {
                    value = externalEvent.getCreateTime();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, -5);
                        continue;
                    }
                    pstmtCreateEvent.setLong(ix, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("START_TIME")) {
                    value = externalEvent.getStartTime();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, -5);
                        continue;
                    }
                    pstmtCreateEvent.setLong(ix, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("END_TIME")) {
                    value = externalEvent.getEndTime();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, -5);
                        continue;
                    }
                    pstmtCreateEvent.setLong(ix, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("DURATION")) {
                    value = externalEvent.getDuration();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, -5);
                        continue;
                    }
                    pstmtCreateEvent.setLong(ix, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("NOTIFY_EMAILS")) {
                    value = ExternalEventDAO.getMaxLengthIds(externalEvent.getEmailId());
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    pstmtCreateEvent.setString(ix, (String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("INSTANCE_ALIAS")) {
                    value = externalEvent.getInstanceAlias();
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    String instAlias = value;
                    if (instAlias.length() > 64) {
                        instAlias = instAlias.substring(0, 64);
                        if (SMPConfig.self().logWarningMessage()) {
                            ExternalEventDAO.getLogger().warnKey("BM_MPCM123", "ExternalEventDAO.create(Connection, ExternalEvent)", new Object[]{"INSTANCE_ALIAS", value, instAlias, 64, MPUtil.getEventCtx(externalEvent)});
                        }
                    }
                    pstmtCreateEvent.setString(ix, instAlias);
                    continue;
                }
                if (key.equalsIgnoreCase("RECEIVED_TIME")) {
                    long dbTime = MPUtil.getSystemTimeFromDB(conn);
                    pstmtCreateEvent.setLong(ix, dbTime);
                    continue;
                }
                if (key.equalsIgnoreCase("CONTEXT")) {
                    value = ExternalEventDAO.getContextData(externalEvent);
                    if (MPUtil.isDebug()) {
                        ExternalEventDAO.getLogger().debugKey("BM_MPCM133", new Object[]{MPUtil.getEventCtx(externalEvent), externalEvent.getAttributes()});
                    }
                    if (value == null) {
                        pstmtCreateEvent.setNull(ix, -3);
                        continue;
                    }
                    byte[] contextAsByteArr = MPUtil.convertToBytes(value);
                    ByteArrayInputStream contextAsInStream = new ByteArrayInputStream(contextAsByteArr);
                    pstmtCreateEvent.setBinaryStream(ix, (InputStream)contextAsInStream, contextAsInStream.available());
                    continue;
                }
                if (key.equalsIgnoreCase("READY_TO_PROCESS")) {
                    OperationType opType = externalEvent.getOperationType();
                    if (opType == null) {
                        pstmtCreateEvent.setNull(ix, 12);
                        continue;
                    }
                    if (opType.isCreateInstance() || opType.isUpdateDataslot()) {
                        pstmtCreateEvent.setInt(ix, 1);
                        continue;
                    }
                    pstmtCreateEvent.setInt(ix, 0);
                    continue;
                }
                if (!key.equalsIgnoreCase("IS_PROCESSED")) continue;
                if (externalEvent.isProcessed()) {
                    pstmtCreateEvent.setInt(ix, 1);
                    continue;
                }
                pstmtCreateEvent.setInt(ix, 0);
            }
            if (MPUtil.isDebug()) {
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{createEventSQL, ctx});
            }
            pstmtCreateEvent.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM119", "ExternalEventDAO.create(conn, ExternalEvent)", new Object[]{ctx}, th));
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtCreateEvent, null);
        }
    }

    public static void updateStatusAsReadyToProcess(Connection conn, long eventId) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.updateProcessedStatus(long)"));
        }
        PreparedStatement pstmtUpdateStatus = null;
        try {
            pstmtUpdateStatus = conn.prepareStatement(updateReadyToProcessSQL);
            pstmtUpdateStatus.setLong(1, eventId);
            if (MPUtil.isDebug()) {
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{updateReadyToProcessSQL, eventId});
            }
            pstmtUpdateStatus.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM128", "ExternalEventDAO.updateStatusAsReadyToProcess(conn, long)", new Object[]{eventId}, th));
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtUpdateStatus, null);
        }
    }

    public static void updateEventStatus(Connection conn, long eventId, boolean isProcessed) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.updateEventStatus(conn,long,boolean)"));
        }
        PreparedStatement pstmtUpdateStatus = null;
        try {
            pstmtUpdateStatus = conn.prepareStatement(updateIsProcessedSQL);
            if (isProcessed) {
                pstmtUpdateStatus.setInt(1, 1);
            } else {
                pstmtUpdateStatus.setInt(1, 0);
            }
            pstmtUpdateStatus.setLong(2, eventId);
            if (MPUtil.isDebug()) {
                ArrayList<Comparable<Boolean>> params = new ArrayList<Comparable<Boolean>>();
                params.add(Boolean.valueOf(isProcessed));
                params.add(Long.valueOf(eventId));
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{updateIsProcessedSQL, params});
            }
            pstmtUpdateStatus.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM129", "ExternalEventDAO.updateEventStatus(conn,long,boolean)", new Object[]{eventId}, th));
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtUpdateStatus, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BLExternalEvent> getReadyToProcessList(Connection conn, int batchSize, boolean sortEvents) {
        PreparedStatement pstmt = null;
        List<BLExternalEvent> eventList = null;
        ResultSet rs = null;
        String sqlParams = "Max Rows | Fetch Size: " + batchSize;
        try {
            pstmt = ExternalEventDAO.getPreparedStatement(conn, getReadyToProcessEventSQL, sqlParams, batchSize, sortEvents, "ExternalEventDAO.getReadyToProcessList()");
            rs = pstmt.executeQuery();
            eventList = ExternalEventDAO.populateEvents(rs);
        }
        catch (MonitoringProcessException e) {
            try {
                throw e;
                catch (Throwable th) {
                    throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM503", "ExternalEventDAO.getReadyToProcessList(conn,long)", new Object[]{getReadyToProcessEventSQL, sqlParams}, th));
                }
            }
            catch (Throwable throwable) {
                ExternalEventDAO.clean(rs, pstmt, null);
                throw throwable;
            }
        }
        ExternalEventDAO.clean((ResultSet)rs, (Statement)pstmt, null);
        return eventList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<BLExternalEvent> getEventsForWorkstep(Connection conn, String eiid, String ptName, String wsName, int loopCounter, OperationType[] operations, int batchSize, boolean sortEvents) {
        PreparedStatement pstmt = null;
        List<BLExternalEvent> eventList = null;
        ResultSet rs = null;
        String sqlParams = ExternalEventDAO.getSQLParams(eiid, ptName, wsName, loopCounter, operations, batchSize);
        String sqlQuery = null;
        try {
            sqlQuery = ExternalEventDAO.appendOperationsToSQL(getEventsForWorkstepSQL, operations);
            pstmt = ExternalEventDAO.getPreparedStatement(conn, sqlQuery, sqlParams, batchSize, sortEvents, "ExternalEventDAO.getEventsForWorkstep()");
            int pstmtIndex = 0;
            pstmt.setString(++pstmtIndex, ptName);
            pstmt.setString(++pstmtIndex, eiid);
            pstmt.setString(++pstmtIndex, wsName);
            pstmt.setInt(++pstmtIndex, loopCounter);
            if (null != operations && operations.length > 0) {
                for (OperationType operation : operations) {
                    pstmt.setInt(++pstmtIndex, operation.getId());
                }
            }
            rs = pstmt.executeQuery();
            eventList = ExternalEventDAO.populateEvents(rs);
        }
        catch (MonitoringProcessException e) {
            try {
                throw e;
                catch (Throwable th) {
                    throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM503", "ExternalEventDAO.getEventsForWorkstep()", new Object[]{sqlQuery, sqlParams}, th));
                }
            }
            catch (Throwable throwable) {
                ExternalEventDAO.clean(rs, pstmt, null);
                throw throwable;
            }
        }
        ExternalEventDAO.clean((ResultSet)rs, (Statement)pstmt, null);
        return eventList;
    }

    private static String getSQLParams(String eiid, String ptName, String wsName, int loopCounter, OperationType[] operations, int batchSize) {
        String sqlParams = null;
        if (MPUtil.isDebug()) {
            sqlParams = ExternalEventDAO.getLogger().getMessage("BM_MPCM504", new Object[]{batchSize, eiid, ptName, wsName, loopCounter, null != operations ? Arrays.asList(operations) : "NONE"});
        }
        return sqlParams;
    }

    private static String appendOperationsToSQL(String query, OperationType[] operations) {
        StringBuilder sql = new StringBuilder(query);
        if (null != operations && operations.length > 0) {
            sql.append(" AND ");
            sql.append("OPERATION_TYPE");
            sql.append(" IN ( ");
            for (int idx = 0; idx < operations.length; ++idx) {
                sql.append("?");
                if (idx >= operations.length - 1) continue;
                sql.append(" , ");
            }
            sql.append(") ");
        }
        return sql.toString();
    }

    private static PreparedStatement getPreparedStatement(Connection conn, String sqlQuery, String sqlParams, int batchSize, boolean sortEvents, String context) throws SQLException {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", context));
        }
        PreparedStatement pstmt = null;
        if (sortEvents) {
            StringBuilder sb = new StringBuilder(sqlQuery);
            sb.append(" ORDER BY ").append("CREATE_TIME");
            sqlQuery = sb.toString();
        }
        pstmt = conn.prepareStatement(sqlQuery);
        pstmt.setMaxRows(batchSize);
        pstmt.setFetchSize(batchSize);
        if (MPUtil.isDebug()) {
            ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{sqlQuery, sqlParams});
        }
        return pstmt;
    }

    private static List<BLExternalEvent> populateEvents(ResultSet rs) throws Throwable {
        ArrayList<BLExternalEvent> eventList = new ArrayList<BLExternalEvent>();
        String ctx = null;
        try {
            while (rs.next()) {
                Object obj;
                BLExternalEvent event = null;
                long eventId = rs.getLong("EVENT_ID");
                String eiid = rs.getString("EXTERNAL_INSTANCE_ID");
                int opTypeAsInt = rs.getInt("OPERATION_TYPE");
                String processName = rs.getString("PROCESS_NAME");
                String workstepName = rs.getString("WORKSTEP_NAME");
                OperationType opType = OperationType.getType(opTypeAsInt);
                if (opType == null) {
                    throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPGW109", "ExternalEventDAO.getReadyToProcessList(conn, batchSize)", new Object[]{opTypeAsInt, OperationType.getValidIds(), MPUtil.getEventCtx(eiid, processName, null, workstepName)}));
                }
                if (opType.isWorkstep()) {
                    event = new BLExternalEvent(eiid, processName, opType, workstepName);
                    event.setBLWorkStepId(rs.getLong("BL_WORKSTEP_ID"));
                    event.setBLLoopCounter(rs.getLong("BL_LOOP_COUNTER"));
                } else {
                    event = new BLExternalEvent(eiid, processName, opType);
                }
                ctx = MPUtil.getEventCtx(eiid, processName, opType.getDescription(), workstepName);
                event.setEventId(eventId);
                event.setBLProcessTemplateId(rs.getLong("BL_PROCESS_TEMPLATE_ID"));
                event.setBLProcessInstanceId(rs.getLong("BL_PROCESS_INSTANCE_ID"));
                event.setReadyToProcessInt(rs.getInt("READY_TO_PROCESS"));
                event.setProcessedInt(rs.getInt("IS_PROCESSED"));
                event.setEvtReceivedTime(rs.getLong("RECEIVED_TIME"));
                event.setSender(rs.getString("SENDER"));
                event.setCategory(rs.getString("CATEGORY"));
                event.setPriority(rs.getString("PRIORITY"));
                event.setPerformer(rs.getString("PERFORMER"));
                event.setLoopCounter(rs.getInt("LOOP_COUNTER"));
                event.setCreateTime(rs.getLong("CREATE_TIME"));
                event.setStartTime(rs.getLong("START_TIME"));
                event.setEndTime(rs.getLong("END_TIME"));
                event.setDuration(rs.getLong("DURATION"));
                event.setEmailId(MPUtil.convertToStringList(rs.getString("NOTIFY_EMAILS")));
                event.setInstanceAlias(rs.getString("INSTANCE_ALIAS"));
                event.setRetryCounter(rs.getLong("RETRY_COUNTER"));
                InputStream inStream = rs.getBinaryStream("CONTEXT");
                if (inStream != null && (obj = MPUtil.convertToObject(inStream)) instanceof Map) {
                    Map context = (Map)obj;
                    Object value = context.get("CONTEXT");
                    if (value != null && value instanceof Map) {
                        event.setEventContext((Map)value);
                    }
                    if ((value = context.get("DATASLOT")) != null && value instanceof Map) {
                        event.setEventData((Map)value);
                    }
                }
                eventList.add(event);
                if (!MPUtil.isDebug()) continue;
                ExternalEventDAO.getLogger().debugKey("BM_MPCM127", new Object[]{MPUtil.getEventCtx(event)});
            }
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM130", "ExternalEventDAO.getReadyToProcessList(conn,long)", new Object[]{ctx}, th));
        }
        return eventList;
    }

    public static void incrementRetryCounter(Connection conn, long eventId, long retryInterval) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.incrementRetryCounter(long)"));
        }
        PreparedStatement pstmtUpdateRetryCtr = null;
        try {
            Timestamp retryTime = new Timestamp(ExternalEventDAO.getSystemTimeFromDB((Connection)conn) + retryInterval);
            pstmtUpdateRetryCtr = conn.prepareStatement(updateRetryCounterSQL);
            pstmtUpdateRetryCtr.setTimestamp(1, retryTime);
            pstmtUpdateRetryCtr.setLong(2, eventId);
            if (MPUtil.isDebug()) {
                ArrayList<Comparable<Date>> params = new ArrayList<Comparable<Date>>();
                params.add(retryTime);
                params.add(Long.valueOf(eventId));
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{updateRetryCounterSQL, params});
            }
            pstmtUpdateRetryCtr.executeUpdate();
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM131", "ExternalEventDAO.incrementRetryCounter(conn,long)", new Object[]{eventId}, th));
            }
            catch (Throwable throwable) {
                ExternalEventDAO.clean(null, pstmtUpdateRetryCtr, null);
                throw throwable;
            }
        }
        ExternalEventDAO.clean(null, (Statement)pstmtUpdateRetryCtr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEventExist(Connection conn, String processName, String eiid, String wsName, int loopcounter) {
        boolean evtExist;
        ResultSet rs;
        PreparedStatement pstmtGeteventID;
        block6: {
            if (conn == null) {
                throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.isEventExist"));
            }
            pstmtGeteventID = null;
            rs = null;
            evtExist = false;
            try {
                pstmtGeteventID = conn.prepareStatement(findEventID);
                if (MPUtil.isDebug()) {
                    StringBuilder ctx = new StringBuilder(processName).append(" ").append(eiid).append(" ").append(wsName).append(" ").append(loopcounter);
                    ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{findEventID, ctx.toString()});
                }
                pstmtGeteventID.setString(1, processName);
                pstmtGeteventID.setString(2, eiid);
                pstmtGeteventID.setString(3, wsName);
                pstmtGeteventID.setInt(4, loopcounter);
                rs = pstmtGeteventID.executeQuery();
                if (!rs.next()) break block6;
                evtExist = true;
            }
            catch (Throwable th) {
                try {
                    MPUtil.handleThrowable("BM_MPCM201", "ExternalEventDAO.isEventExist", new Object[]{processName, eiid, wsName, loopcounter}, th);
                }
                catch (Throwable throwable) {
                    ExternalEventDAO.clean(rs, (Statement)pstmtGeteventID, null);
                    throw throwable;
                }
                ExternalEventDAO.clean((ResultSet)rs, (Statement)pstmtGeteventID, null);
            }
        }
        ExternalEventDAO.clean((ResultSet)rs, (Statement)pstmtGeteventID, null);
        return evtExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProcessContext(Connection conn, String processName, String eiid, String wsName, int loopcounter, HashMap<String, Object> modifiedAttrs) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.update"));
        }
        PreparedStatement pstmtUpdateBLValues = null;
        int attrsCount = modifiedAttrs.size();
        StringBuilder sb = new StringBuilder(500);
        sb.append("UPDATE ").append("BIZEVENT_EXTERNAL");
        sb.append(" SET ");
        Iterator<String> keySet = modifiedAttrs.keySet().iterator();
        String key = null;
        Object value = null;
        int counter = 0;
        while (keySet.hasNext()) {
            key = keySet.next();
            sb.append(key);
            sb.append(" = ? ");
            if (counter != attrsCount - 1) {
                sb.append(", ");
            }
            ++counter;
        }
        sb.append(" WHERE ");
        sb.append("PROCESS_NAME");
        sb.append(" = ? AND ");
        sb.append("EXTERNAL_INSTANCE_ID");
        sb.append(" = ? AND ");
        sb.append("WORKSTEP_NAME");
        sb.append(" = ? AND ");
        sb.append(" ( ").append("LOOP_COUNTER").append(" = 0 OR ");
        sb.append(" ( ").append("LOOP_COUNTER").append(" > 0 AND ");
        sb.append("LOOP_COUNTER").append(" = ?").append(" ) )");
        String updateBLValues = sb.toString();
        try {
            pstmtUpdateBLValues = conn.prepareStatement(updateBLValues);
            if (MPUtil.isDebug()) {
                StringBuilder ctx = new StringBuilder(processName).append(" ").append(eiid).append(" ").append(wsName).append(" ").append(loopcounter);
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{updateBLValues, ctx.toString()});
            }
            keySet = modifiedAttrs.keySet().iterator();
            key = null;
            value = null;
            counter = 1;
            while (keySet.hasNext()) {
                key = keySet.next();
                value = modifiedAttrs.get(key);
                if (key.equalsIgnoreCase("BL_PROCESS_TEMPLATE_ID") || key.equalsIgnoreCase("BL_PROCESS_INSTANCE_ID") || key.equalsIgnoreCase("BL_WORKSTEP_ID")) {
                    if (value == null) {
                        pstmtUpdateBLValues.setNull(counter++, -5);
                        continue;
                    }
                    pstmtUpdateBLValues.setLong(counter++, (Long)value);
                    continue;
                }
                if (!key.equalsIgnoreCase("BL_LOOP_COUNTER") && !key.equalsIgnoreCase("READY_TO_PROCESS")) continue;
                if (value == null) {
                    pstmtUpdateBLValues.setNull(counter++, 4);
                    continue;
                }
                pstmtUpdateBLValues.setInt(counter++, (Integer)value);
            }
            pstmtUpdateBLValues.setString(counter++, processName);
            pstmtUpdateBLValues.setString(counter++, eiid);
            pstmtUpdateBLValues.setString(counter++, wsName);
            pstmtUpdateBLValues.setInt(counter, loopcounter);
            pstmtUpdateBLValues.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM202", "ExternalEventDAO.update", new Object[]{processName, eiid, wsName, loopcounter}, th);
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtUpdateBLValues, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateProcessContext(Connection conn, long eventId, HashMap<String, Object> modifiedAttrs) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.updateProcessContext"));
        }
        PreparedStatement pstmtUpdateProcessCtx = null;
        int attrsCount = modifiedAttrs.size();
        StringBuilder sb = new StringBuilder(500);
        sb.append("UPDATE ").append("BIZEVENT_EXTERNAL");
        sb.append(" SET ");
        Iterator<String> keySet = modifiedAttrs.keySet().iterator();
        String key = null;
        Object value = null;
        int counter = 0;
        while (keySet.hasNext()) {
            key = keySet.next();
            sb.append(key);
            sb.append(" = ? ");
            if (counter != attrsCount - 1) {
                sb.append(", ");
            }
            ++counter;
        }
        sb.append(" WHERE ");
        sb.append("EVENT_ID");
        sb.append(" = ?");
        String updateProcessCtx = sb.toString();
        try {
            pstmtUpdateProcessCtx = conn.prepareStatement(updateProcessCtx);
            if (MPUtil.isDebug()) {
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, new Object[]{updateProcessCtx, eventId});
            }
            keySet = modifiedAttrs.keySet().iterator();
            key = null;
            value = null;
            counter = 1;
            while (keySet.hasNext()) {
                key = keySet.next();
                value = modifiedAttrs.get(key);
                if (key.equalsIgnoreCase("BL_PROCESS_TEMPLATE_ID") || key.equalsIgnoreCase("BL_PROCESS_INSTANCE_ID") || key.equalsIgnoreCase("BL_WORKSTEP_ID")) {
                    if (value == null) {
                        pstmtUpdateProcessCtx.setNull(counter++, -5);
                        continue;
                    }
                    pstmtUpdateProcessCtx.setLong(counter++, (Long)value);
                    continue;
                }
                if (!key.equalsIgnoreCase("BL_LOOP_COUNTER") && !key.equalsIgnoreCase("READY_TO_PROCESS")) continue;
                if (value == null) {
                    pstmtUpdateProcessCtx.setNull(counter++, 4);
                    continue;
                }
                pstmtUpdateProcessCtx.setInt(counter++, (Integer)value);
            }
            pstmtUpdateProcessCtx.setLong(counter, eventId);
            pstmtUpdateProcessCtx.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM222", "ExternalEventDAO.updateProcessContext", new Object[]{eventId}, th);
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtUpdateProcessCtx, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, long piid, long wsid, int loopcounter) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.remove(long, long, int)"));
        }
        PreparedStatement pstmtRemoveeventforws = null;
        try {
            pstmtRemoveeventforws = conn.prepareStatement(removeEventForWorkStep);
            pstmtRemoveeventforws.setLong(1, piid);
            pstmtRemoveeventforws.setLong(2, wsid);
            pstmtRemoveeventforws.setInt(3, loopcounter);
            if (MPUtil.isDebug()) {
                StringBuilder ctx = new StringBuilder().append(piid).append(" ").append(wsid).append(" ").append(loopcounter);
                MPService.self().getLogger().debugKey(BM_MPCM125, new Object[]{removeEventForWorkStep, ctx.toString()});
            }
            pstmtRemoveeventforws.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM213", "MonitorWaitWorkStepDAO.remove(long, long, int)", new Object[]{piid, wsid, loopcounter}, th);
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtRemoveeventforws, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, String processName, String eiid) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "MonitorWaitWorkStepDAO.remove(String, String)"));
        }
        PreparedStatement pstmtRemoveeventforprocesseiid = null;
        try {
            pstmtRemoveeventforprocesseiid = conn.prepareStatement(removeEventForProcessEiid);
            pstmtRemoveeventforprocesseiid.setString(1, processName);
            pstmtRemoveeventforprocesseiid.setString(2, eiid);
            pstmtRemoveeventforprocesseiid.setInt(3, 0);
            if (MPUtil.isDebug()) {
                StringBuilder ctx = new StringBuilder(processName).append(" ").append(eiid);
                MPService.self().getLogger().debugKey(BM_MPCM125, new Object[]{removeEventForProcessEiid, ctx});
            }
            pstmtRemoveeventforprocesseiid.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM212", "MonitorWaitWorkStepDAO.remove(String, String)", new Object[]{processName, eiid}, th);
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtRemoveeventforprocesseiid, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Connection conn, String processName) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.remove(String)"));
        }
        PreparedStatement pstmtRemoveeventforpt = null;
        try {
            pstmtRemoveeventforpt = conn.prepareStatement(removeEventForProcessTemplate);
            pstmtRemoveeventforpt.setString(1, processName);
            pstmtRemoveeventforpt.setInt(2, 0);
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey(BM_MPCM125, new Object[]{removeEventForProcessTemplate, processName});
            }
            pstmtRemoveeventforpt.executeUpdate();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM211", "ExternalEventDAO.remove(String)", new Object[]{processName}, th);
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmtRemoveeventforpt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getAttributes(Connection conn, Map<String, Object> whereAttributes) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.getAttributes(Map)"));
        }
        ArrayList<Map<String, Object>> eventList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> eventAttributes = null;
        PreparedStatement pstmtSelectEventAttributes = null;
        ResultSet rs = null;
        StringBuilder selectAttrs = new StringBuilder(selectEventAttributes);
        Iterator<String> keySet = whereAttributes.keySet().iterator();
        String key = null;
        int counter = 0;
        if (whereAttributes != null && !whereAttributes.isEmpty()) {
            selectAttrs.append(" WHERE ");
        }
        while (keySet.hasNext()) {
            key = keySet.next();
            selectAttrs.append(key);
            selectAttrs.append(" = ?");
            if (counter != whereAttributes.size() - 1) {
                selectAttrs.append(" AND ");
            }
            ++counter;
        }
        try {
            pstmtSelectEventAttributes = conn.prepareStatement(selectAttrs.toString());
            keySet = whereAttributes.keySet().iterator();
            key = null;
            Object value = null;
            counter = 1;
            while (keySet.hasNext()) {
                key = keySet.next();
                value = whereAttributes.get(key);
                if (key.equalsIgnoreCase("EXTERNAL_INSTANCE_ID") || key.equalsIgnoreCase("SENDER") || key.equalsIgnoreCase("CATEGORY") || key.equalsIgnoreCase("PRIORITY") || key.equalsIgnoreCase("PROCESS_NAME") || key.equalsIgnoreCase("WORKSTEP_NAME") || key.equalsIgnoreCase("PERFORMER")) {
                    if (value == null) {
                        pstmtSelectEventAttributes.setNull(counter++, 12);
                        continue;
                    }
                    pstmtSelectEventAttributes.setString(counter++, (String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("OPERATION_TYPE") || key.equalsIgnoreCase("LOOP_COUNTER") || key.equalsIgnoreCase("IS_PROCESSED")) {
                    if (value == null) {
                        pstmtSelectEventAttributes.setNull(counter++, 4);
                        continue;
                    }
                    pstmtSelectEventAttributes.setInt(counter++, (Integer)value);
                    continue;
                }
                if (key.equalsIgnoreCase("CREATE_TIME") || key.equalsIgnoreCase("START_TIME") || key.equalsIgnoreCase("END_TIME") || key.equalsIgnoreCase("DURATION") || key.equalsIgnoreCase("RECEIVED_TIME")) {
                    if (value == null) {
                        pstmtSelectEventAttributes.setNull(counter++, -5);
                        continue;
                    }
                    pstmtSelectEventAttributes.setLong(counter++, (Long)value);
                    continue;
                }
                if (!key.equalsIgnoreCase("NOTIFY_EMAILS") && !key.equalsIgnoreCase("INSTANCE_ALIAS")) continue;
                if (value == null) {
                    pstmtSelectEventAttributes.setNull(counter++, 12);
                    continue;
                }
                pstmtSelectEventAttributes.setString(counter++, (String)value);
            }
            if (MPUtil.isDebug()) {
                MPService.self().getLogger().debugKey(BM_MPCM125, new Object[]{selectAttrs.toString(), whereAttributes});
            }
            rs = pstmtSelectEventAttributes.executeQuery();
            while (rs.next()) {
                eventAttributes = new HashMap<String, Object>();
                eventAttributes.put("EVENT_ID", rs.getLong("EVENT_ID"));
                eventAttributes.put("EXTERNAL_INSTANCE_ID", rs.getString("EXTERNAL_INSTANCE_ID"));
                eventAttributes.put("OPERATION_TYPE", rs.getInt("OPERATION_TYPE"));
                eventAttributes.put("SENDER", rs.getString("SENDER"));
                eventAttributes.put("CATEGORY", rs.getString("CATEGORY"));
                eventAttributes.put("PRIORITY", rs.getString("PRIORITY"));
                eventAttributes.put("PROCESS_NAME", rs.getString("PROCESS_NAME"));
                eventAttributes.put("WORKSTEP_NAME", rs.getString("WORKSTEP_NAME"));
                eventAttributes.put("PERFORMER", rs.getString("PERFORMER"));
                eventAttributes.put("LOOP_COUNTER", rs.getInt("LOOP_COUNTER"));
                eventAttributes.put("CREATE_TIME", rs.getLong("CREATE_TIME"));
                eventAttributes.put("START_TIME", rs.getLong("START_TIME"));
                eventAttributes.put("END_TIME", rs.getLong("END_TIME"));
                eventAttributes.put("NOTIFY_EMAILS", rs.getString("NOTIFY_EMAILS"));
                eventAttributes.put("INSTANCE_ALIAS", rs.getString("INSTANCE_ALIAS"));
                eventAttributes.put("RECEIVED_TIME", rs.getLong("RECEIVED_TIME"));
                InputStream inStream = null;
                try {
                    inStream = rs.getBinaryStream("CONTEXT");
                    eventAttributes.put("CONTEXT", ExternalEventDAO.getContextInfo(inStream));
                }
                finally {
                    ExternalEventDAO.clean((InputStream)inStream, null, null, null);
                }
                eventList.add(eventAttributes);
            }
        }
        catch (Throwable th) {
            try {
                MPUtil.handleThrowable("BM_MPCM217", "ExternalEventDAO.getAttributes(Map)", new Object[]{whereAttributes}, th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ExternalEventDAO.clean(rs, (Statement)pstmtSelectEventAttributes, null);
            }
        }
        ExternalEventDAO.clean((ResultSet)rs, (Statement)pstmtSelectEventAttributes, null);
        return eventList;
    }

    public static synchronized void initSQLStatements() {
        createEventSQL = ExternalEventDAO.createEventSQL();
        selectProcessedEventIds = ExternalEventDAO.createSelectProcessedEventIdsSQL();
        selectProcessedEvents = ExternalEventDAO.createSelectProcessedEventsSQL();
        updateReadyToProcessSQL = ExternalEventDAO.createUpdateReadyToProcessSQL();
        updateIsProcessedSQL = ExternalEventDAO.createUpdateIsProcessedSQL();
        updateRetryCounterSQL = ExternalEventDAO.createUpdateRetryCounterSQL();
        String commonSQL = ExternalEventDAO.getCreateEventSQL();
        getReadyToProcessEventSQL = ExternalEventDAO.createReadyToProcesssEventSql(commonSQL);
        getEventsForWorkstepSQL = ExternalEventDAO.createGetEventsForWorkstepSQL(commonSQL);
        findEventID = ExternalEventDAO.createFindEventIdSQL();
        removeEventForWorkStep = ExternalEventDAO.createRemoveEventForWorkStepSQL();
        removeEventForProcessEiid = ExternalEventDAO.createRemoveEventForProcessEiidSQL();
        removeEventForProcessTemplate = ExternalEventDAO.createRemoveEventForProcessTemplateSQL();
        selectEventAttributes = ExternalEventDAO.createSelectEventAttributesSQL();
        updateProcessContext = ExternalEventDAO.createupdateProcessContextSQL();
    }

    private static String createEventSQL() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("INSERT INTO ").append("BIZEVENT_EXTERNAL");
        builder.append(" (");
        int index = 1;
        if (SBMDatabase.self().isOracle() || SBMDatabase.self().isOpenEdge()) {
            index = 0;
        }
        for (int ix = index; ix < CREATE_LIST.length; ++ix) {
            builder.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            builder.append(", ");
        }
        if (SBMDatabase.self().isOracle() || SBMDatabase.self().isOpenEdge()) {
            builder.append(") VALUES (").append(MPDBConstant.EXT_EVENTID_SEQ).append(",").append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else {
            builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        return builder.toString();
    }

    private static String createSelectProcessedEventIdsSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT ").append("EVENT_ID");
        builder.append(" FROM ").append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ").append("IS_PROCESSED").append(" = 1");
        return builder.toString();
    }

    private static String createSelectProcessedEventsSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT ");
        builder.append("EVENT_ID").append(", ");
        builder.append("EXTERNAL_INSTANCE_ID").append(", ");
        builder.append("OPERATION_TYPE").append(", ");
        builder.append("SENDER").append(", ");
        builder.append("CATEGORY").append(", ");
        builder.append("PRIORITY").append(", ");
        builder.append("PROCESS_NAME").append(", ");
        builder.append("WORKSTEP_NAME").append(", ");
        builder.append("PERFORMER").append(", ");
        builder.append("LOOP_COUNTER").append(", ");
        builder.append("CREATE_TIME").append(", ");
        builder.append("START_TIME").append(", ");
        builder.append("END_TIME").append(", ");
        builder.append("DURATION").append(", ");
        builder.append("NOTIFY_EMAILS").append(", ");
        builder.append("INSTANCE_ALIAS").append(", ");
        builder.append("RECEIVED_TIME").append(", ");
        builder.append("BL_PROCESS_TEMPLATE_ID").append(", ");
        builder.append("BL_PROCESS_INSTANCE_ID").append(", ");
        builder.append("BL_WORKSTEP_ID").append(", ");
        builder.append("BL_LOOP_COUNTER").append(", ");
        builder.append("IS_PROCESSED").append(", ");
        builder.append("READY_TO_PROCESS").append(", ");
        builder.append("RETRY_COUNTER").append(", ");
        builder.append("CONTEXT");
        builder.append(" FROM ").append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ").append("IS_PROCESSED").append(" = 1");
        return builder.toString();
    }

    private static String createUpdateReadyToProcessSQL() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("UPDATE ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" SET ");
        builder.append("READY_TO_PROCESS");
        builder.append(" = 1 ");
        builder.append("WHERE ");
        builder.append("EVENT_ID");
        builder.append(" = ?");
        return builder.toString();
    }

    private static String createUpdateIsProcessedSQL() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("UPDATE ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" SET ");
        builder.append("IS_PROCESSED");
        builder.append(" = ? ");
        builder.append("WHERE ");
        builder.append("EVENT_ID");
        builder.append(" = ?");
        return builder.toString();
    }

    private static String createUpdateRetryCounterSQL() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("UPDATE ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" SET ");
        builder.append("RETRY_COUNTER");
        builder.append(" = ");
        builder.append("RETRY_COUNTER");
        builder.append(" + 1, ");
        builder.append("NEXT_RETRY_TIME");
        builder.append(" = ? ");
        builder.append(" WHERE ");
        builder.append("EVENT_ID");
        builder.append(" = ?");
        return builder.toString();
    }

    private static String getCreateEventSQL() {
        StringBuilder builder = new StringBuilder(200);
        builder.append(" SELECT ");
        for (int ix = 0; ix < GETREADY_TOPROCESS_EVENTLIST.length; ++ix) {
            builder.append(GETREADY_TOPROCESS_EVENTLIST[ix]);
            if (ix == GETREADY_TOPROCESS_EVENTLIST.length - 1) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ");
        builder.append("IS_PROCESSED");
        builder.append(" = 0");
        builder.append(" AND ").append(" (").append("RETRY_COUNTER").append(" = 0 OR (RETRY_COUNTER > 0 AND NEXT_RETRY_TIME <= ");
        builder.append(ExternalEventDAO.getDBTimeQueryString()).append(" ))");
        return builder.toString();
    }

    private static String createReadyToProcesssEventSql(String commonSQL) {
        StringBuilder builder = new StringBuilder(commonSQL);
        builder.append(" AND ");
        builder.append("READY_TO_PROCESS");
        builder.append(" = 1");
        return builder.toString();
    }

    private static String createGetEventsForWorkstepSQL(String commonSQL) {
        StringBuilder builder = new StringBuilder(commonSQL);
        builder.append(" AND ");
        builder.append("READY_TO_PROCESS");
        builder.append(" = 0");
        builder.append(" AND ");
        builder.append("PROCESS_NAME").append(" = ? ").append(" AND ");
        builder.append("EXTERNAL_INSTANCE_ID").append(" = ? ").append(" AND ");
        builder.append("WORKSTEP_NAME").append(" = ? ").append(" AND ");
        builder.append(" (").append("LOOP_COUNTER").append(" = 0 OR ");
        builder.append(" (").append("LOOP_COUNTER").append(" > 0 AND ");
        builder.append("LOOP_COUNTER").append(" = ? ").append(" ) )");
        return builder.toString();
    }

    private static String createFindEventIdSQL() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("SELECT ");
        builder.append("EVENT_ID");
        builder.append(" FROM ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ");
        builder.append("PROCESS_NAME").append(" = ? AND ");
        builder.append("EXTERNAL_INSTANCE_ID").append(" = ? AND ");
        builder.append("WORKSTEP_NAME").append(" = ? AND ");
        builder.append(" ( ").append("LOOP_COUNTER").append(" = 0 OR ");
        builder.append(" ( ").append("LOOP_COUNTER").append(" > 0 AND ");
        builder.append("LOOP_COUNTER").append(" = ?").append(" ) )");
        return builder.toString();
    }

    private static String createRemoveEventForWorkStepSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ");
        builder.append("BL_PROCESS_INSTANCE_ID").append(" = ? AND ");
        builder.append("BL_WORKSTEP_ID").append(" = ? AND ");
        builder.append("BL_LOOP_COUNTER").append(" = ?");
        return builder.toString();
    }

    private static String createRemoveEventForProcessEiidSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ");
        builder.append("PROCESS_NAME").append(" = ? AND ");
        builder.append("EXTERNAL_INSTANCE_ID").append(" = ? AND ");
        builder.append("IS_PROCESSED").append(" = ?");
        return builder.toString();
    }

    private static String createRemoveEventForProcessTemplateSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append("BIZEVENT_EXTERNAL");
        builder.append(" WHERE ");
        builder.append("PROCESS_NAME").append(" = ? AND ");
        builder.append("IS_PROCESSED").append(" = ?");
        return builder.toString();
    }

    private static String createSelectEventAttributesSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        for (int ix = 0; ix < CREATE_LIST.length; ++ix) {
            builder.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            builder.append(", ");
        }
        builder.append(" FROM ");
        builder.append("BIZEVENT_EXTERNAL");
        return builder.toString();
    }

    private static String createupdateProcessContextSQL() {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append("BIZEVENT_EXTERNAL");
        builder.append(" SET ");
        builder.append("BL_PROCESS_INSTANCE_ID").append(" = ?").append(", ");
        builder.append("BL_WORKSTEP_ID").append(" = ?").append(", ");
        builder.append("BL_LOOP_COUNTER").append(" = ?").append(", ");
        builder.append("BL_PROCESS_TEMPLATE_ID").append(" = ?").append(", ");
        builder.append("READY_TO_PROCESS").append(" = ?");
        return builder.toString();
    }

    public static void printSQLStatements() {
        String initStatement = "Init SQL Statement: ";
        ExternalEventDAO.getLogger().debug((Object)"ExternalEventDAO:");
        ExternalEventDAO.getLogger().debug((Object)(initStatement + createEventSQL));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + selectProcessedEventIds));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + selectProcessedEvents));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + updateReadyToProcessSQL));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + updateIsProcessedSQL));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + updateRetryCounterSQL));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + getReadyToProcessEventSQL));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + findEventID));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + removeEventForProcessTemplate));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + removeEventForProcessEiid));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + removeEventForWorkStep));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + selectEventAttributes));
        ExternalEventDAO.getLogger().debug((Object)(initStatement + updateProcessContext));
    }

    private static Map<String, Object> getContextData(ExternalEvent externalEvent) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        if (externalEvent != null) {
            Map<String, Object> mapData = externalEvent.getEventData();
            if (mapData != null && !mapData.isEmpty()) {
                contextData.put("DATASLOT", mapData);
            }
            if ((mapData = externalEvent.getEventContext()) != null && !mapData.isEmpty()) {
                contextData.put("CONTEXT", mapData);
            }
        }
        return contextData;
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return MPService.self().getMonitoringProcessES();
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    private static String getMaxLengthIds(List<String> emailId) {
        String delimitIds = MPUtil.getListAsDelimitedStr(emailId);
        if (!MPUtil.isValidString(delimitIds)) {
            return null;
        }
        if (delimitIds.length() <= 512) {
            return delimitIds;
        }
        int endIndex = delimitIds.lastIndexOf(",", 512);
        String truncatedIds = delimitIds.substring(0, endIndex);
        if (SMPConfig.self().logWarningMessage()) {
            ExternalEventDAO.getLogger().warnKey("BM_MPCM123", "ExternalEventDAO.getMaxLengthIds(List<String>)", new Object[]{"NOTIFY_EMAILS", delimitIds, truncatedIds, 512});
        }
        return truncatedIds;
    }

    private static HashMap getContextInfo(InputStream inStream) {
        if (inStream == null) {
            return null;
        }
        HashMap context = null;
        try {
            BLObjectInputStream objStream = new BLObjectInputStream(inStream);
            context = (HashMap)objStream.readObject();
        }
        catch (Throwable th) {
            MPUtil.handleThrowable("BM_MPCM218", "ExternalEventDAO.getContextInfo", null, th);
        }
        return context;
    }

    public static List<Long> getProcessedEventIds(Connection conn, int batchSize) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.getProcessedEventIds()"));
        }
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Long> processedEvt = new ArrayList<Long>();
        try {
            stmt = conn.createStatement();
            stmt.setMaxRows(batchSize);
            stmt.setFetchSize(batchSize);
            if (MPUtil.isDebug()) {
                ExternalEventDAO.getLogger().debugKey("BM_MPCM005", "ExternalEventDAO.getProcessedEventIds()", new Object[]{selectProcessedEventIds});
            }
            rs = stmt.executeQuery(selectProcessedEventIds);
            while (rs.next()) {
                processedEvt.add(rs.getLong("EVENT_ID"));
            }
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM002", "ExternalEventDAO.getProcessedEventIds()", th));
            }
            catch (Throwable throwable) {
                ExternalEventDAO.clean(rs, (Statement)stmt, null);
                throw throwable;
            }
        }
        ExternalEventDAO.clean((ResultSet)rs, (Statement)stmt, null);
        return processedEvt;
    }

    public static List<BLExternalEvent> getProcessedEvents(Connection conn, int batchSize) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.getProcessedEvents()"));
        }
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<BLExternalEvent> blExtEventList = new ArrayList<BLExternalEvent>();
        BLExternalEvent blExtEvent = null;
        try {
            stmt = conn.createStatement();
            stmt.setMaxRows(batchSize);
            stmt.setFetchSize(batchSize);
            if (MPUtil.isDebug()) {
                ExternalEventDAO.getLogger().debugKey("BM_MPCM005", "ExternalEventDAO.getProcessedEvents()", new Object[]{selectProcessedEvents});
            }
            rs = stmt.executeQuery(selectProcessedEvents);
            while (rs.next()) {
                OperationType opType = OperationType.getType(rs.getInt("OPERATION_TYPE"));
                String eiid = rs.getString("EXTERNAL_INSTANCE_ID");
                String processName = rs.getString("PROCESS_NAME");
                if (opType.isWorkstep()) {
                    String workstepName = rs.getString("WORKSTEP_NAME");
                    blExtEvent = new BLExternalEvent(eiid, processName, opType, workstepName);
                } else {
                    blExtEvent = new BLExternalEvent(eiid, processName, opType);
                }
                blExtEvent.setEventId(rs.getLong("EVENT_ID"));
                blExtEvent.setSender(rs.getString("SENDER"));
                blExtEvent.setCategory(rs.getString("CATEGORY"));
                blExtEvent.setPriority(rs.getString("PRIORITY"));
                blExtEvent.setPerformer(rs.getString("PERFORMER"));
                blExtEvent.setLoopCounter(rs.getInt("LOOP_COUNTER"));
                blExtEvent.setCreateTime(rs.getLong("CREATE_TIME"));
                blExtEvent.setStartTime(rs.getLong("START_TIME"));
                blExtEvent.setEndTime(rs.getLong("END_TIME"));
                blExtEvent.setDuration(rs.getLong("DURATION"));
                blExtEvent.setEmailId(MPUtil.convertToStringList(rs.getString("NOTIFY_EMAILS")));
                blExtEvent.setInstanceAlias(rs.getString("INSTANCE_ALIAS"));
                blExtEvent.setEvtReceivedTime(rs.getLong("RECEIVED_TIME"));
                blExtEvent.setBLProcessInstanceId(rs.getLong("BL_PROCESS_INSTANCE_ID"));
                blExtEvent.setBLProcessTemplateId(rs.getLong("BL_PROCESS_TEMPLATE_ID"));
                blExtEvent.setBLWorkStepId(rs.getLong("BL_WORKSTEP_ID"));
                blExtEvent.setBLLoopCounter(rs.getLong("BL_LOOP_COUNTER"));
                blExtEvent.setProcessed(rs.getBoolean("IS_PROCESSED"));
                blExtEvent.setReadyToProcessInt(rs.getInt("READY_TO_PROCESS"));
                blExtEvent.setRetryCounter(rs.getLong("RETRY_COUNTER"));
                blExtEvent.setEventContext((Map)MPUtil.convertToObject(rs.getBinaryStream("CONTEXT")));
                blExtEventList.add(blExtEvent);
            }
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM002", "ExternalEventDAO.getProcessedEvents()", th));
            }
            catch (Throwable throwable) {
                ExternalEventDAO.clean(rs, (Statement)stmt, null);
                throw throwable;
            }
        }
        ExternalEventDAO.clean((ResultSet)rs, (Statement)stmt, null);
        return blExtEventList;
    }

    public static void deleteEventsById(Connection conn, List<Long> eventIds) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.deleteEventsById()"));
        }
        if (eventIds == null || eventIds.isEmpty()) {
            return;
        }
        if (eventIds.size() > 900) {
            int cnt = 0;
            ArrayList<Long> eventBatch = new ArrayList<Long>();
            for (long eventId : eventIds) {
                eventBatch.add(eventId);
                if (++cnt != 900) continue;
                ExternalEventDAO.deleteEvents(conn, eventBatch);
                eventBatch = new ArrayList();
                cnt = 0;
            }
            if (!eventBatch.isEmpty()) {
                ExternalEventDAO.deleteEvents(conn, eventBatch);
            }
        } else {
            ExternalEventDAO.deleteEvents(conn, eventIds);
        }
    }

    private static void deleteEvents(Connection conn, List<Long> eventIds) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.deleteEventsById()"));
        }
        if (eventIds == null || eventIds.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" DELETE ").append(" FROM ").append("BIZEVENT_EXTERNAL");
        sb.append(" WHERE ").append("EVENT_ID").append(" IN (");
        String comma = "";
        for (Long evtId : eventIds) {
            sb.append(comma).append(" ? ");
            comma = ",";
        }
        sb.append(") ");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sb.toString());
            int index = 1;
            for (Long evtId : eventIds) {
                pstmt.setLong(index, evtId);
                ++index;
            }
            if (MPUtil.isDebug()) {
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, "ExternalEventDAO.deleteEventsById()", new Object[]{sb.toString(), eventIds});
            }
            pstmt.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM004", "ExternalEventDAO.deleteEventsById()", new Object[]{eventIds}, th));
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmt, null);
        }
    }

    public static void updateEventById(long eventId, Connection conn, Map<String, Object> modifiedAttrs) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "ExternalEventDAO.updateEventById()"));
        }
        if (modifiedAttrs == null || modifiedAttrs.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" UPDATE ").append("BIZEVENT_EXTERNAL");
        sb.append(" SET ");
        Set<Map.Entry<String, Object>> entries = modifiedAttrs.entrySet();
        String comma = "";
        for (Map.Entry<String, Object> entry : entries) {
            if (!ExternalEventDAO.isValidColumnforUpdate(entry.getKey())) {
                throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM009", "ExternalEventDAO.updateEventById()", new Object[]{entry.getKey(), modifiedAttrs}));
            }
            sb.append(comma).append(entry.getKey()).append(" = ? ");
            comma = ", ";
        }
        sb.append(" WHERE ").append("EVENT_ID").append(" = ? ");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sb.toString());
            int counter = 1;
            for (Map.Entry<String, Object> entry : entries) {
                String key = entry.getKey();
                if (!key.equalsIgnoreCase("BL_PROCESS_INSTANCE_ID") && !key.equalsIgnoreCase("BL_PROCESS_TEMPLATE_ID") && !key.equalsIgnoreCase("BL_WORKSTEP_ID") && !key.equalsIgnoreCase("BL_LOOP_COUNTER")) continue;
                Object value = entry.getValue();
                if (value != null) {
                    pstmt.setLong(counter++, (Long)value);
                    continue;
                }
                pstmt.setNull(counter++, -5);
            }
            pstmt.setLong(counter, eventId);
            if (MPUtil.isDebug()) {
                ArrayList<Object> params = new ArrayList<Object>(modifiedAttrs.values());
                params.add(eventId);
                ExternalEventDAO.getLogger().debugKey(BM_MPCM125, "ExternalEvent.updateEventById()", new Object[]{sb.toString(), params});
            }
            pstmt.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)ExternalEventDAO.getMonitoringProcessES().createException("BM_MPCM010", "ExternalEvent.updateEventById()", new Object[]{modifiedAttrs, eventId}, th));
        }
        finally {
            ExternalEventDAO.clean(null, (Statement)pstmt, null);
        }
    }

    private static boolean isValidColumnforUpdate(String columnName) {
        return validColumnsForUpdate.contains(columnName);
    }

    static {
        CREATE_LIST = new String[]{"EVENT_ID", "EXTERNAL_INSTANCE_ID", "OPERATION_TYPE", "SENDER", "CATEGORY", "PRIORITY", "PROCESS_NAME", "WORKSTEP_NAME", "PERFORMER", "LOOP_COUNTER", "CREATE_TIME", "START_TIME", "END_TIME", "DURATION", "NOTIFY_EMAILS", "INSTANCE_ALIAS", "RECEIVED_TIME", "CONTEXT", "READY_TO_PROCESS", "IS_PROCESSED"};
        GETREADY_TOPROCESS_EVENTLIST = new String[]{"EVENT_ID", "EXTERNAL_INSTANCE_ID", "OPERATION_TYPE", "SENDER", "CATEGORY", "PRIORITY", "PROCESS_NAME", "WORKSTEP_NAME", "PERFORMER", "LOOP_COUNTER", "CREATE_TIME", "START_TIME", "END_TIME", "DURATION", "NOTIFY_EMAILS", "INSTANCE_ALIAS", "RECEIVED_TIME", "CONTEXT", "BL_PROCESS_TEMPLATE_ID", "BL_PROCESS_INSTANCE_ID", "BL_WORKSTEP_ID", "BL_LOOP_COUNTER", "IS_PROCESSED", "READY_TO_PROCESS", "RETRY_COUNTER"};
        validColumnsForUpdate = null;
        ExternalEventDAO.init();
    }
}

