/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.persistence.dao;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.model.BLExternalEvent;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.logger.SBMLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class HistoryEventDAO
extends DBService {
    private static String insertEventsById = null;
    private static String insertEvents = null;
    private static String deleteEventsByCreateTime = null;
    private static final String[] SELECT_LIST = new String[]{"EVENT_ID", "EXTERNAL_INSTANCE_ID", "OPERATION_TYPE", "SENDER", "CATEGORY", "PRIORITY", "PROCESS_NAME", "WORKSTEP_NAME", "PERFORMER", "LOOP_COUNTER", "CREATE_TIME", "START_TIME", "END_TIME", "DURATION", "NOTIFY_EMAILS", "INSTANCE_ALIAS", "RECEIVED_TIME", "BL_PROCESS_TEMPLATE_ID", "BL_PROCESS_INSTANCE_ID", "BL_WORKSTEP_ID", "BL_LOOP_COUNTER", "RETRY_COUNTER", "CONTEXT"};

    private static synchronized void initSql() {
        String comma = "";
        StringBuilder sb = new StringBuilder();
        sb.append(" INSERT INTO ").append("BIZEVENT_EXTERNAL_HISTORY").append(" (");
        for (String column : SELECT_LIST) {
            sb.append(comma).append(column);
            comma = ", ";
        }
        sb.append(") ");
        sb.append(" SELECT ");
        comma = "";
        for (String column : SELECT_LIST) {
            sb.append(comma).append(column);
            comma = ", ";
        }
        sb.append(" FROM ").append("BIZEVENT_EXTERNAL");
        sb.append(" WHERE ").append("EVENT_ID").append(" IN (");
        insertEventsById = sb.toString();
        comma = "";
        sb = new StringBuilder();
        sb.append(" INSERT INTO ").append("BIZEVENT_EXTERNAL_HISTORY").append(" (");
        for (String column : SELECT_LIST) {
            sb.append(comma).append(column);
            comma = ", ";
        }
        sb.append(") ").append(" VALUES ");
        sb.append(" (");
        for (int i = 0; i < SELECT_LIST.length - 1; ++i) {
            sb.append(" ? ").append(", ");
        }
        sb.append(" ? ").append(") ");
        insertEvents = sb.toString();
        sb = new StringBuilder();
        sb.append(" DELETE ").append(" FROM ").append("BIZEVENT_EXTERNAL_HISTORY");
        sb.append(" WHERE ").append("CREATE_TIME").append(" < ");
        sb.append("?");
        deleteEventsByCreateTime = sb.toString();
    }

    public static void printSQLStatements() {
        String initStatement = "Init SQL Statement: ";
        HistoryEventDAO.getLogger().debug((Object)"BizEventExtHistoryDAO:");
        HistoryEventDAO.getLogger().debug((Object)(initStatement + insertEventsById));
        HistoryEventDAO.getLogger().debug((Object)(initStatement + insertEvents));
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    public static void insertEventsById(Connection conn, List<Long> processedEvt) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "BizEventExtHistoryDAO.insertEventsById()"));
        }
        if (processedEvt == null || processedEvt.isEmpty()) {
            return;
        }
        if (processedEvt.size() > 900) {
            int cnt = 0;
            ArrayList<Long> eventBatch = new ArrayList<Long>();
            for (long eventId : processedEvt) {
                eventBatch.add(eventId);
                if (++cnt != 900) continue;
                HistoryEventDAO.insertEventsInBatch(conn, eventBatch);
                eventBatch = new ArrayList();
                cnt = 0;
            }
            if (!eventBatch.isEmpty()) {
                HistoryEventDAO.insertEventsInBatch(conn, eventBatch);
            }
        } else {
            HistoryEventDAO.insertEventsInBatch(conn, processedEvt);
        }
    }

    private static void insertEventsInBatch(Connection conn, List<Long> processedEvt) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "BizEventExtHistoryDAO.insertEventsById()"));
        }
        if (processedEvt == null || processedEvt.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        String comma = "";
        StringBuilder sb = new StringBuilder(insertEventsById);
        for (Long evtId : processedEvt) {
            sb.append(comma).append(" ? ");
            comma = ",";
        }
        sb.append(") ");
        try {
            pstmt = conn.prepareStatement(sb.toString());
            int indx = 1;
            for (Long evtId : processedEvt) {
                pstmt.setLong(indx, evtId);
                ++indx;
            }
            if (MPUtil.isDebug()) {
                HistoryEventDAO.getLogger().debugKey("BM_MPCM125", "BizEventExtHistoryDAO.insertEventsById()", new Object[]{sb.toString(), processedEvt});
            }
            pstmt.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM003", "BizEventExtHistoryDAO.insertEventsById()", new Object[]{processedEvt}, th));
        }
        finally {
            HistoryEventDAO.clean(null, (Statement)pstmt, null);
        }
    }

    public static void insertEvents(Connection conn, List<BLExternalEvent> processedEvt) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "BizEventExtHistoryDAO.insertEvents()"));
        }
        if (processedEvt == null || processedEvt.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(insertEvents);
            for (BLExternalEvent evnt : processedEvt) {
                pstmt.setLong(1, evnt.getEventId());
                pstmt.setString(2, evnt.getExternalInstanceId());
                pstmt.setLong(3, evnt.getOperationType().getId());
                pstmt.setString(4, evnt.getSender());
                pstmt.setString(5, evnt.getCategory());
                pstmt.setString(6, evnt.getPriority());
                pstmt.setString(7, evnt.getProcessName());
                pstmt.setString(8, evnt.getWorkstepName());
                pstmt.setString(9, evnt.getPerformer());
                pstmt.setInt(10, evnt.getLoopCounter());
                pstmt.setLong(11, evnt.getCreateTime());
                pstmt.setLong(12, evnt.getStartTime());
                pstmt.setLong(13, evnt.getEndTime());
                pstmt.setLong(14, evnt.getDuration());
                pstmt.setString(15, MPUtil.getListAsDelimitedStr(evnt.getEmailId()));
                pstmt.setString(16, evnt.getInstanceAlias());
                pstmt.setLong(17, evnt.getEvtReceivedTime());
                pstmt.setLong(18, evnt.getBLProcessTemplateId());
                pstmt.setLong(19, evnt.getBLProcessInstanceId());
                pstmt.setLong(20, evnt.getBLWorkStepId());
                pstmt.setLong(21, evnt.getBLLoopCounter());
                pstmt.setLong(22, evnt.getRetryCounter());
                pstmt.setBytes(23, MPUtil.convertToBytes(evnt.getEventContext()));
                pstmt.addBatch();
            }
            if (MPUtil.isDebug()) {
                HistoryEventDAO.getLogger().debugKey("BM_MPCM125", "BizEventExtHistoryDAO.insertEvents()", new Object[]{insertEvents, processedEvt});
            }
            pstmt.executeBatch();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM003", "BizEventExtHistoryDAO.insertEvents()", new Object[]{processedEvt}, th));
        }
        finally {
            HistoryEventDAO.clean(null, (Statement)pstmt, null);
        }
    }

    public static void deleteEventsByCreateTime(Connection conn, Timestamp createTime) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "HistoryEventDAO.deleteEventsByCreateTime()"));
        }
        if (createTime == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(deleteEventsByCreateTime);
            pstmt.setLong(1, createTime.getTime());
            if (MPUtil.isDebug()) {
                HistoryEventDAO.getLogger().debugKey("BM_MPCM125", "HistoryEventDAO.deleteEventsByCreateTime()", new Object[]{deleteEventsByCreateTime, createTime.getTime()});
            }
            int recordsDeleted = pstmt.executeUpdate();
            HistoryEventDAO.getLogger().infoKey("BM_MPCM224", "HistoryEventDAO.deleteEventsByCreateTime()", new Object[]{recordsDeleted});
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)HistoryEventDAO.getMonitoringProcessES().createException("BM_MPCM223", "HistoryEventDAO.deleteEventsByCreateTime()", new Object[]{createTime.getTime()}, th));
            }
            catch (Throwable throwable) {
                HistoryEventDAO.clean(null, pstmt, null);
                throw throwable;
            }
        }
        HistoryEventDAO.clean(null, (Statement)pstmt, null);
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return MPService.self().getMonitoringProcessES();
    }

    static {
        HistoryEventDAO.initSql();
    }
}

