/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent.be;

import com.savvion.sbm.bizlogic.storeevent.BSControl;
import com.savvion.sbm.bizlogic.storeevent.BSProcessTemplate;
import com.savvion.sbm.bizlogic.storeevent.BSUtil;
import com.savvion.sbm.bizlogic.storeevent.BizLogicEventMap;
import com.savvion.sbm.util.CommonEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

public class BEProcessTemplate {
    private static final String SQL_DELETE_ANALYSIS = "DELETE FROM ANALYSIS WHERE TEMPLATE_NAME = ?";
    private static final String SQL_DELETE_DASHBOARD_WIDGET = "DELETE FROM PORTAL_DASHBOARD_WIDGETS WHERE DASHBOARD_WIDGET_APPNAME = ?";
    private static final String SQL_DELETE_DASHBOARD_URLWIDGET = "DELETE FROM PORTAL_DASHBOARD_URL_WIDGET WHERE WIDGET_ID IN ( SELECT WIDGET_ID FROM PORTAL_WIDGETS WHERE WIDGET_APPNAME = ? )";
    private static final String SQL_DELETE_PORTAL_WIDGET = "DELETE FROM PORTAL_WIDGETS WHERE WIDGET_APPNAME = ?";

    public static void onRemove(CommonEvent eventObj) {
        try {
            long ptid = BizLogicEventMap.getProcessTemplateID(eventObj);
            String ptName = BSProcessTemplate.getName(ptid);
            BEProcessTemplate.deleteAnalysisForPT(ptName);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    private static void deleteAnalysisForPT(String ptName) {
        BEProcessTemplate.deleteAnalysis(ptName);
    }

    private static void deleteAnalysis(String ptName) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = BSControl.util.getBSConnection();
            ps = conn.prepareStatement(SQL_DELETE_ANALYSIS);
            ps.setString(1, ptName);
            ps.executeUpdate();
        }
        catch (Throwable th) {
            String message = BSControl.logger.getMessage("BizStore_MSG_1613", new Object[]{SQL_DELETE_ANALYSIS, ptName, th.getMessage()});
            BSControl.logger.error((Object)message);
            throw new RuntimeException(message, th);
        }
        finally {
            BSUtil.clean(null, (Statement)ps, (Connection)conn);
        }
    }

    private static void deleteAnalysisWidgets(String ptName) {
        BEProcessTemplate.deleteDashboardWidgets(ptName);
        BEProcessTemplate.deleteDashboardURLWidgets(ptName);
        BEProcessTemplate.deletePortalWidget(ptName);
    }

    private static void deletePortalWidget(String ptName) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = BSControl.util.getBSConnection();
            ps = conn.prepareStatement(SQL_DELETE_PORTAL_WIDGET);
            ps.setString(1, ptName);
            ps.executeUpdate();
        }
        catch (Throwable th) {
            String message = BSControl.logger.getMessage("BizStore_MSG_1613", new Object[]{SQL_DELETE_PORTAL_WIDGET, ptName, th.getMessage()});
            BSControl.logger.error((Object)message);
            throw new RuntimeException(message, th);
        }
        finally {
            BSUtil.clean(null, (Statement)ps, (Connection)conn);
        }
    }

    private static void deleteDashboardWidgets(String ptName) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = BSControl.util.getBSConnection();
            ps = conn.prepareStatement(SQL_DELETE_DASHBOARD_WIDGET);
            ps.setString(1, ptName);
            ps.executeUpdate();
        }
        catch (Throwable th) {
            String message = BSControl.logger.getMessage("BizStore_MSG_1613", new Object[]{SQL_DELETE_DASHBOARD_WIDGET, ptName, th.getMessage()});
            BSControl.logger.error((Object)message);
            throw new RuntimeException(message, th);
        }
        finally {
            BSUtil.clean(null, (Statement)ps, (Connection)conn);
        }
    }

    private static void deleteDashboardURLWidgets(String ptName) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = BSControl.util.getBSConnection();
            ps = conn.prepareStatement(SQL_DELETE_DASHBOARD_URLWIDGET);
            ps.setString(1, ptName);
            ps.executeUpdate();
        }
        catch (Throwable th) {
            String message = BSControl.logger.getMessage("BizStore_MSG_1613", new Object[]{SQL_DELETE_DASHBOARD_URLWIDGET, ptName, th.getMessage()});
            BSControl.logger.error((Object)message);
            throw new RuntimeException(message, th);
        }
        finally {
            BSUtil.clean(null, (Statement)ps, (Connection)conn);
        }
    }
}

