/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent.mconsole;

import com.savvion.sbm.bizlogic.server.ejb.ServiceLocal;
import com.savvion.sbm.bizlogic.server.ejb.ServiceLocalHome;
import com.savvion.sbm.bizlogic.storeevent.mconsole.ConsoleTable;
import com.savvion.sbm.bizlogic.storeevent.mconsole.MConsole;
import com.savvion.sbm.bizlogic.storeevent.mconsole.SbmApp;
import com.savvion.sbm.util.SBMConstants;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMDAOService;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.ServiceDAO;
import com.savvion.sbm.util.ServiceLocator;
import com.savvion.sbm.util.TransactionService;
import com.savvion.sbm.util.logger.SBMLogger;
import com.savvion.util.DBUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.transaction.UserTransaction;

public class PopulatorDaemon
extends SBMDAOService {
    private int sleepTime;
    private String dbVendor;
    private String ebmsappsDir;
    private final String SLEEP_TIME_KEY = "persistence.populator.sleepTime";
    private final String DATABASE_KEY = "sbm.db.default";
    private final String EBMSAPPS_KEY = "sbm.application.home";
    private final int sleepTime_def = 300;
    private final int minSleepTime = 30000;
    private final String db_def = "oracle";
    private final String ebmsapps_def = "c:/sbm/ebmsapps";
    private Connection connection;
    private String dsName;
    private final String populatorClassName = ".externalperformers.TablePopulator";
    private final String iMethodName = "insert";
    private final String uMethodName = "update";
    private final String readAllTablesMethodName = "setReadAllTables";
    private final Class[] paramTypes = new Class[]{Connection.class, String.class, String.class, Integer.class};
    private Vector appObjs;
    private Vector oldApps;
    private Vector currApps;
    private Vector appNames;
    private static int counter;
    private final Object synObj = new Object();
    private static ServiceLocal serviceLocal;
    private static boolean isCluster;
    private static ServiceDAO serviceObj;
    private static UserTransaction utx;
    private static long onExceptionSleeptime;
    private static long errorCount;
    private boolean multibyteSchema;
    private final String getAppQuery = "select distinct pt.PROCESS_TEMPLATE_ID, pt.PROCESS_TEMPLATE_NAME from PROCESSINSTANCE pi, PROCESSTEMPLATE pt where pi.STATUS='PI_ACTIVATED' and pi.PROCESS_TEMPLATE_ID=pt.PROCESS_TEMPLATE_ID";
    private final String delAppAvgDura = "DELETE FROM STAT_APP_AVG_DURATION   where PROCESS_TEMPLATE_ID = ";
    private final String delAppPriority = "DELETE FROM STAT_APP_PRIORITY       where PROCESS_TEMPLATE_ID = ";
    private final String delAppDueInfo = "DELETE FROM STAT_APP_DUE_INFO       where PROCESS_TEMPLATE_ID = ";
    private final String delAppHistory = "DELETE FROM STAT_APP_STATUS_HISTORY where PROCESS_TEMPLATE_ID = ";
    private final String delWiDueInfo = "DELETE FROM STAT_WI_DUE_INFO        where PROCESS_TEMPLATE_ID = ";

    public PopulatorDaemon(Properties props) throws Exception {
        counter = 0;
        this.init(props);
    }

    private final Connection getConnection() throws SQLException {
        return PopulatorDaemon.getConnection((String)this.dsName);
    }

    private void init(Properties props) throws Exception {
        try {
            utx = ServiceLocator.self().getUserTransaction();
            isCluster = ServiceLocator.self().isCluster();
            this.dsName = ServiceLocator.self().getProperty("SBMCommon.JDBCDataSource.JNDIName");
            if (isCluster) {
                serviceObj = new ServiceDAO(this.dsName, "MCONSOLE");
            }
            this.sleepTime = this.getIntProperty(props, "persistence.populator.sleepTime", 300) * 1000;
            this.dbVendor = props.getProperty("sbm.db.default", "oracle");
            this.multibyteSchema = Boolean.parseBoolean(props.getProperty("sbm.db.multibyteschema"));
            this.ebmsappsDir = props.getProperty("sbm.application.home", "c:/sbm/ebmsapps");
            if (this.sleepTime < 30000) {
                this.sleepTime = 30000;
                MConsole.logger.warnKey("MConsole_MSG_504", new Object[]{30000});
            }
            MConsole.logger.debugKey("MConsole_MSG_001", new Object[]{this.sleepTime, this.dbVendor, this.ebmsappsDir});
            if (serviceLocal == null || isCluster) {
                PopulatorDaemon.getServiceBeanRef();
            }
            try {
                utx.begin();
                this.connection = this.getConnection();
                this.oldApps = this.getActivatedApplications();
                this.setAppObjects(this.getAppList());
                utx.commit();
            }
            catch (Exception ex) {
                TransactionService.rollback((UserTransaction)utx);
                MConsole.logger.errorKey("MConsole_MSG_1524", "PopulatorDaemon.init()", (Throwable)ex, new Object[]{ex.getMessage()});
            }
            finally {
                PopulatorDaemon.clean(null, null, (Connection)this.connection);
                this.connection = null;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            PopulatorDaemon.clean(null, null, (Connection)this.connection);
            this.connection = null;
        }
    }

    private Vector getAppList() {
        Iterator appIter = this.oldApps.iterator();
        Vector<SbmApp> appList = new Vector<SbmApp>();
        int index = 0;
        while (appIter.hasNext()) {
            String appId = (String)appIter.next();
            String appName = (String)this.appNames.elementAt(index);
            SbmApp app = new SbmApp(appName, appId, this, counter);
            appList.addElement(app);
            ++index;
        }
        return appList;
    }

    public void process() {
        MConsole.logger.infoKey("MConsole_MSG_505", new Object[]{this.sleepTime / 1000});
        errorCount = -1L;
        while (!MConsole.isMConsoleStopping()) {
            try {
                ++errorCount;
                this.populateTables();
                ++counter;
            }
            catch (Exception e) {
                PopulatorDaemon.handleError(e);
            }
            this.resetErrorCount();
            this.sleep();
        }
        PopulatorDaemon.clean(null, null, (Connection)this.connection);
        this.connection = null;
    }

    public void populateTables() throws Exception {
        MConsole.logger.debugKey("MConsole_MSG_006", new Object[]{new Date()});
        try {
            utx.begin();
            this.connection = this.getConnection();
            if (isCluster) {
                serviceObj.lock();
            }
            this.populateConsoleTables();
            utx.commit();
            MConsole.logger.debugKey("MConsole_MSG_007", new Object[]{new Date()});
        }
        catch (Exception ex) {
            try {
                utx.rollback();
            }
            catch (Throwable th) {
                MConsole.logger.errorKey("MConsole_MSG_1523", new Object[]{"PopulatorDaemon", "populateTables"}, (Throwable)ex);
            }
            throw ex;
        }
        finally {
            PopulatorDaemon.clean(null, null, (Connection)this.connection);
            this.connection = null;
        }
    }

    private static void handleError(Exception ex) {
        if (errorCount == 0L) {
            MConsole.logger.errorKey("MConsole_MSG_1521", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        if (errorCount > 0L) {
            MConsole.logger.errorKey("MConsole_MSG_1521", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
    }

    private void resetErrorCount() {
        if (errorCount > 0L) {
            MConsole.logger.infoKey("MConsole_MSG_506");
        }
        errorCount = -1L;
    }

    private void sleep() {
        try {
            if (errorCount > 0L) {
                this.sleep(onExceptionSleeptime);
            } else {
                this.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateConsoleTables() throws Exception {
        Object object = this.synObj;
        synchronized (object) {
            MConsole.logger.debugKey("MConsole_MSG_003", new Object[]{counter});
            long bTime = new Date().getTime();
            this.getActivatedApplications();
            this.checkRemovedApplications();
            this.checkNewApplications();
            for (SbmApp app : this.getAppObjects()) {
                try {
                    app.populateTables(counter);
                }
                catch (Exception e) {
                    MConsole.logger.errorKey("MConsole_MSG_1001", "PopulatorDaemon.populateConsoleTables()", (Throwable)e, new Object[]{e.getMessage()});
                    throw e;
                }
            }
            long eTime = new Date().getTime();
            MConsole.logger.debugKey("MConsole_MSG_004", new Object[]{counter, eTime - bTime});
        }
    }

    private static void getServiceBeanRef() throws Exception {
        SBMHomeFactory factory = SBMHomeFactory.self();
        ServiceLocalHome home = (ServiceLocalHome)factory.lookupLocalHome(ServiceLocalHome.class);
        serviceLocal = home.create();
    }

    private Vector getActivatedApplications() throws Exception {
        Vector<String> activatedApps = new Vector<String>();
        this.appNames = new Vector();
        activatedApps.addElement("0");
        this.appNames.addElement("common");
        if (this.connection == null) {
            this.oldApps = this.currApps;
            this.currApps = activatedApps;
            return activatedApps;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.connection.createStatement();
            rs = stmt.executeQuery("select distinct pt.PROCESS_TEMPLATE_ID, pt.PROCESS_TEMPLATE_NAME from PROCESSINSTANCE pi, PROCESSTEMPLATE pt where pi.STATUS='PI_ACTIVATED' and pi.PROCESS_TEMPLATE_ID=pt.PROCESS_TEMPLATE_ID");
            while (rs.next()) {
                String appName = rs.getString(2);
                String appId = rs.getString(1);
                if (appId == null) continue;
                activatedApps.addElement(appId);
                this.appNames.addElement(appName);
            }
            this.oldApps = this.currApps;
            this.currApps = activatedApps;
        }
        catch (SQLException e) {
            try {
                MConsole.logger.errorKey("MConsole_MSG_1508", "PopulatorDaemon.getActivatedApplications()", (Throwable)e, new Object[]{e.getMessage()});
                throw e;
            }
            catch (Throwable throwable) {
                PopulatorDaemon.clean(rs, (Statement)stmt, null);
                throw throwable;
            }
        }
        PopulatorDaemon.clean((ResultSet)rs, (Statement)stmt, null);
        return activatedApps;
    }

    private void checkRemovedApplications() throws Exception {
        Vector<SbmApp> appList = new Vector<SbmApp>();
        for (SbmApp app : this.getAppObjects()) {
            boolean isRemoved = true;
            for (String currId : this.currApps) {
                if (!app.getId().equals(currId)) continue;
                isRemoved = false;
                break;
            }
            if (isRemoved) {
                app.removeTables();
                app.deleteStatusRows();
                continue;
            }
            appList.addElement(app);
        }
        this.setAppObjects(appList);
    }

    private void checkNewApplications() {
        Vector<SbmApp> debutApps = new Vector<SbmApp>();
        Iterator currIter = this.currApps.iterator();
        int index = 0;
        while (currIter.hasNext()) {
            String currId = (String)currIter.next();
            boolean isNew = true;
            for (SbmApp app : this.getAppObjects()) {
                if (!currId.equals(app.getId())) continue;
                isNew = false;
                break;
            }
            if (isNew) {
                String currName = (String)this.appNames.elementAt(index);
                SbmApp app = new SbmApp(currName, currId, this, counter);
                debutApps.addElement(app);
            }
            ++index;
        }
        for (int i = 0; i < debutApps.size(); ++i) {
            SbmApp app = (SbmApp)debutApps.elementAt(i);
            this.addAppObject(app);
        }
    }

    public void createTablesInDB(Vector tableList) throws Exception {
        if (this.connection == null || tableList == null) {
            return;
        }
        for (ConsoleTable table : tableList) {
            try {
                boolean isExist;
                if (isCluster) {
                    serviceObj.lock();
                }
                if (isExist = PopulatorDaemon.checkTableExists((String)this.dsName, (String)table.getName())) continue;
                MConsole.logger.debugKey("MConsole_MSG_008", new Object[]{table.getName()});
                this.executeDDLStmt(table.getSchema());
                if (!SBMDatabase.self().isDualDbUser()) continue;
                String strGrant = SBMDatabase.getSqlGrantStatement((String)table.getName(), (String)SBMDatabase.self().getAppUserRole());
                this.executeDDLStmt(strGrant);
            }
            catch (EJBException ee) {
                SQLException se = (SQLException)ee.getCausedByException();
                MConsole.logger.errorKey("MConsole_MSG_1509", "PopulatorDaemon.createTablesInDB()", (Throwable)se, new Object[]{se.getMessage()});
                throw se;
            }
        }
    }

    public void dropTablesInDB(Vector tableList) throws Exception {
        if (this.connection == null || tableList == null) {
            return;
        }
        for (ConsoleTable table : tableList) {
            try {
                boolean isExist = PopulatorDaemon.checkTableExists((String)this.dsName, (String)table.getName());
                if (!isExist) continue;
                MConsole.logger.debugKey("MConsole_MSG_009", new Object[]{table.getName()});
                this.executeDDLStmt("drop table " + table.getName());
            }
            catch (EJBException ee) {
                SQLException se = (SQLException)ee.getCausedByException();
                MConsole.logger.errorKey("MConsole_MSG_1511", "PopulatorDaemon.dropTablesInDB()", (Throwable)se, new Object[]{se.getMessage()});
                throw se;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStatusRowsInDB(String id) {
        if (this.connection == null || id == null || "0".equals(id)) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
        }
        catch (SQLException e) {
            MConsole.logger.errorKey("MConsole_MSG_1520", "PopulatorDaemon.deleteStatusRowsInDB()", (Throwable)e, new Object[]{e.getMessage()});
            return;
        }
        try {
            stmt.executeUpdate("DELETE FROM STAT_APP_AVG_DURATION   where PROCESS_TEMPLATE_ID = " + id);
            stmt.executeUpdate("DELETE FROM STAT_APP_PRIORITY       where PROCESS_TEMPLATE_ID = " + id);
            stmt.executeUpdate("DELETE FROM STAT_APP_DUE_INFO       where PROCESS_TEMPLATE_ID = " + id);
            stmt.executeUpdate("DELETE FROM STAT_APP_STATUS_HISTORY where PROCESS_TEMPLATE_ID = " + id);
            stmt.executeUpdate("DELETE FROM STAT_WI_DUE_INFO        where PROCESS_TEMPLATE_ID = " + id);
        }
        catch (Exception ex) {
            MConsole.logger.errorKey("MConsole_MSG_1520", "PopulatorDaemon.deleteStatusRowsInDB()", (Throwable)ex, new Object[]{ex.getMessage()});
        }
        finally {
            PopulatorDaemon.clean(null, (Statement)stmt, null);
        }
    }

    public void populateTablesInDB(Vector tableList, int currCounter) throws Exception {
        for (ConsoleTable table : tableList) {
            table.populate(this.connection, currCounter);
        }
    }

    public int getCounter() {
        return counter;
    }

    public Connection getDBConnection() {
        return this.connection;
    }

    public void setDBConnection(Connection con) {
        this.connection = con;
    }

    public String getDBVendor() {
        return this.dbVendor;
    }

    public String getPopClassName() {
        return ".externalperformers.TablePopulator";
    }

    public Class[] getParamTypes() {
        return this.paramTypes;
    }

    public String getIMethodName() {
        return "insert";
    }

    public String getUMethodName() {
        return "update";
    }

    public String getReadAllTablesMethodName() {
        return "setReadAllTables";
    }

    public String getEbmsapps() {
        return this.ebmsappsDir;
    }

    public Vector getAppObjects() {
        return this.appObjs;
    }

    public void setAppObjects(Vector appList) {
        this.appObjs = appList;
    }

    public void addAppObject(SbmApp app) {
        this.appObjs.addElement(app);
    }

    private int getIntProperty(Properties props, String key, int defVal) {
        int value;
        try {
            value = Integer.valueOf(props.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            value = defVal;
        }
        return value;
    }

    private final void executeDDLStmt(String sql) throws Exception {
        if (this.isMultibyteSchema()) {
            SBMLogger pdLogger = null;
            if (MConsole.logger != null) {
                pdLogger = (SBMLogger)MConsole.logger.clone();
                SBMConstants.self().getClass();
                pdLogger.setMessageFile("SBMMessages", MConsole.class.getClassLoader());
            }
            sql = DBUtil.convertToMB((String)sql, (String)this.dbVendor, (SBMLogger)pdLogger);
        }
        if (SBMControl.dbmap.isDDLAutocommit()) {
            serviceLocal.executeDDL(sql);
            return;
        }
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            stmt.executeUpdate(sql);
        }
        finally {
            PopulatorDaemon.clean(null, (Statement)stmt, null);
        }
    }

    public void sleep(long timeInterval) throws InterruptedException {
        SBMControl.consts.getClass();
        long time = timeInterval % 30000L;
        if (time > 0L) {
            Thread.sleep(time);
        }
        while (!MConsole.isMConsoleStopping() && time < timeInterval) {
            SBMControl.consts.getClass();
            Thread.sleep(30000L);
            SBMControl.consts.getClass();
            time += 30000L;
        }
    }

    public boolean isMultibyteSchema() {
        return this.multibyteSchema;
    }

    static {
        serviceLocal = null;
        isCluster = false;
        serviceObj = null;
        utx = null;
        onExceptionSleeptime = 90000L;
        errorCount = -1L;
    }
}

