/*
 * Decompiled with CFR 0.152.
 */
package com.tdiinc.BizLogic.Server;

import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.util.SBMUtil;
import com.tdiinc.BizLogic.Server.PAKClientData;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class PAKClientWorkitem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -958132656182997291L;
    private static String WISEP = "::";
    private static String SSEP = "#";
    private static String SPSEP = "!";
    public static final int CREATED = 25;
    public static final int AVAILABLE = 27;
    public static final int ASSIGNED = 28;
    public static final int TERMINATED = 29;
    public static final int SUSPENDED = 32;
    public static final int WAIT = 43;
    private String name;
    private String PTname;
    private String PIname;
    private int status;
    private String priority;
    private String PIcreator;
    private long timeStarted;
    private long timeAssigned;
    private long duration;
    private long duedate;
    private String instruction;
    private boolean isassigned;
    private String performer;
    private Vector availableFor;
    private Object performingApp;
    private String wsname;
    private String ptDisplayName;
    private boolean isStartWI = false;
    private PAKClientData[] attachedData;
    private WorkItem wi = null;
    private long ptid = -1L;
    private long piid = -1L;
    private long wiid = -1L;

    public Object clone() {
        try {
            PAKClientWorkitem clonedObj = (PAKClientWorkitem)super.clone();
            PAKClientData[] clonedAttachedData = null;
            if (this.attachedData != null && this.attachedData.length > 0) {
                clonedAttachedData = new PAKClientData[this.attachedData.length];
                int i = 0;
                for (PAKClientData clData : this.attachedData) {
                    clonedAttachedData[i] = (PAKClientData)clData.clone();
                    ++i;
                }
                clonedObj.attachedData = clonedAttachedData;
            }
            return clonedObj;
        }
        catch (Throwable th) {
            throw new RuntimeException("Unable to Clone the PAKClientWorkitem Object", th);
        }
    }

    public PAKClientWorkitem(long piid, long wiid, String n, int s, String p, long st, long as, long d, String inst, boolean ia, Vector af, PAKClientData[] i, Object pa) {
        this(piid, wiid, n, s, p, st, as, d, inst, ia, af, i, pa, st);
    }

    public PAKClientWorkitem(long piid, long wiid, String n, int s, String p, long st, long as, long d, String inst, boolean ia, Vector af, PAKClientData[] i, Object pa, long dd) {
        this.piid = piid;
        this.wiid = wiid;
        this.name = n;
        this.status = s;
        this.priority = p;
        this.timeStarted = st;
        this.timeAssigned = as;
        this.duration = d;
        this.instruction = inst;
        this.isassigned = ia;
        this.availableFor = af;
        this.attachedData = (PAKClientData[])SBMUtil.arrayCopy((Object[])i);
        this.performingApp = pa;
        this.duedate = dd;
    }

    public PAKClientWorkitem(long piid, long wiid, String ProcessName, PAKClientData[] i, Object pa) {
        this.piid = piid;
        this.wiid = wiid;
        this.PTname = ProcessName;
        this.attachedData = (PAKClientData[])SBMUtil.arrayCopy((Object[])i);
        this.performingApp = pa;
        this.isStartWI = true;
    }

    public PAKClientWorkitem(long piid, long wiid, String ProcessName, PAKClientData[] i, Object pa, String inst, String p) {
        this.piid = piid;
        this.wiid = wiid;
        this.PTname = ProcessName;
        this.attachedData = (PAKClientData[])SBMUtil.arrayCopy((Object[])i);
        this.performingApp = pa;
        this.isStartWI = true;
        this.priority = p;
        this.instruction = inst;
    }

    public PAKClientWorkitem(long piid, long wiid, String ProcessName, String WSName, PAKClientData[] i, Object pa, String inst, String p) {
        this.piid = piid;
        this.wiid = wiid;
        this.PTname = ProcessName;
        this.attachedData = (PAKClientData[])SBMUtil.arrayCopy((Object[])i);
        this.performingApp = pa;
        this.isStartWI = true;
        this.priority = p;
        this.instruction = inst;
        this.wsname = WSName;
    }

    public void setPriority(String p) {
        if (!this.isStartWI) {
            return;
        }
        this.priority = p;
    }

    public void setPerformer(String p) {
        this.performer = p;
    }

    public void setDuedate(long d) {
        this.duedate = d;
    }

    public void setCreator(String c) {
        this.PIcreator = c;
    }

    public void setPTname(String p) {
        this.PTname = p;
    }

    public void setPIname(String p) {
        this.PIname = p;
    }

    public void setTemplateId(long ptid) {
        this.ptid = ptid;
    }

    public long getTemplateId() {
        return this.ptid;
    }

    public String getCreator() {
        return this.PIcreator;
    }

    public String getPerformer() {
        return this.performer;
    }

    public String getName() {
        return this.name;
    }

    public int getStatus() {
        return this.status;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getTimeStarted() {
        return new Date(this.timeStarted).toString();
    }

    public String getInstruction() {
        if (this.instruction == null && this.wi != null) {
            try {
                this.instruction = this.wi.getInstruction();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.instruction;
    }

    public String getTimeAssigned() {
        return new Date(this.timeAssigned).toString();
    }

    public boolean isAssigned() {
        return this.isassigned;
    }

    public Vector getAvailableFor() {
        return this.availableFor;
    }

    public Object getPerformingApp() {
        if (this.performingApp == null && this.wi != null) {
            try {
                this.performingApp = this.wi.getPerformingApp();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.performingApp;
    }

    public PAKClientData[] getAttachedData() {
        return this.attachedData;
    }

    public long getDuration() {
        if (this.duration != 0L && this.wi != null) {
            try {
                this.duration = this.wi.getDuration();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.duration;
    }

    public long getStartTime() {
        return this.timeStarted;
    }

    public long getAssignTime() {
        return this.timeAssigned;
    }

    public long getDueTime() {
        return this.duedate;
    }

    public String getDueDate() {
        return new Date(this.duedate).toString();
    }

    public String getProcessName() {
        return this.PTname;
    }

    public String getPTname() {
        return this.PTname;
    }

    public String getPIname() {
        return this.PIname;
    }

    public String getPIprefix() {
        return this.PIname.substring(0, this.PIname.lastIndexOf(SSEP));
    }

    public String getPILabel() {
        String PIprefix = this.getPIprefix();
        int index = PIprefix.lastIndexOf(SPSEP);
        if (index == -1) {
            return PIprefix + " (" + this.getInstanceID() + ")";
        }
        return PIprefix.substring(index + SPSEP.length()) + " (" + this.getInstanceID() + ")";
    }

    public String getInstanceID() {
        return this.PIname.substring(this.PIname.lastIndexOf(SSEP) + SSEP.length());
    }

    public String getTaskName() {
        if (this.wsname == null) {
            this.wsname = this.name.substring(this.name.indexOf(WISEP) + WISEP.length());
        }
        return this.wsname;
    }

    public void setProcessDisplayName(String displayName) {
        this.ptDisplayName = displayName;
    }

    public String getProcessDisplayName() {
        return this.ptDisplayName;
    }

    public void setWorkitem(WorkItem wi) {
        this.wi = wi;
    }

    public WorkItem getWorkitem() {
        return this.wi;
    }

    public long getProcessInstanceID() {
        return this.piid;
    }

    public long getWorkItemID() {
        return this.wiid;
    }
}

