/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.EmailAdapterReceiverInterface;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMControl;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.logger.SBMLogger;
import com.tdiinc.common.Emailer.SendEmailRef;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class EmailAdapterReceiver
implements EmailAdapterReceiverInterface {
    protected SendEmailRef sendEmail = null;
    protected static Object msgObj;
    private String messageType = "MimeMessage";
    private String serverID = "";
    private SBMLogger logFileHandler = null;
    private BLServer blBean = null;
    private String mailServer = "";
    protected Hashtable processContextData;
    protected Hashtable updatedOutputDSList;

    public EmailAdapterReceiver(String mailServer) throws Exception {
        if (BLUtil.sendEmailClass != null) {
            Constructor oConstructor = BLUtil.sendEmailClass.getConstructor(String.class);
            Object sendEmailClassObject = oConstructor.newInstance(new String(mailServer));
            this.sendEmail = (SendEmailRef)sendEmailClassObject;
            this.mailServer = mailServer;
        }
    }

    @Override
    public final void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public final String getMessageType() {
        return this.messageType;
    }

    @Override
    public final synchronized void setMessageObject(Object emailMessage) {
        msgObj = emailMessage;
    }

    @Override
    public final Object getMessageObject() {
        return msgObj;
    }

    @Override
    public final void setLogFileHandler() {
        this.logFileHandler = BLControl.logger;
    }

    @Override
    public final Object getLogFileHandler() {
        return this.logFileHandler;
    }

    @Override
    public final void setServerID(String serverID) {
        this.serverID = serverID;
    }

    @Override
    public final String getServerID() {
        return this.serverID;
    }

    @Override
    public abstract void processMessage() throws Exception;

    @Override
    public void completeTask() throws Exception {
        try {
            BLServerHome blBeanHome = (BLServerHome)SBMHomeFactory.self().lookupHome(BLServerHome.class);
            this.blBean = blBeanHome.create();
        }
        catch (Throwable th) {
            this.bounceEmailBack("Can not connect to BizLogic Server, please try again later");
            LoggerUtil.logSOP((Object)("Connection Exception: " + this.serverID + th.getMessage()));
            throw new Exception("Connect Exception: Can not connect to BizLogic Server " + this.serverID + ".");
        }
        String wiName = null;
        String performerName = null;
        boolean isAssignedTask = false;
        Map.Entry entry2 = null;
        String key = null;
        for (Map.Entry entry2 : this.processContextData.entrySet()) {
            key = (String)entry2.getKey();
            BLConstants.single();
            if (key.equalsIgnoreCase("WORKITEMNAME")) {
                wiName = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (key.equalsIgnoreCase("PERFORMERNAME")) {
                performerName = (String)entry2.getValue();
                continue;
            }
            BLConstants.single();
            if (!key.equalsIgnoreCase("ISASSIGNTASKEMAIL")) continue;
            isAssignedTask = "true".equalsIgnoreCase(entry2.getValue().toString());
        }
        try {
            Session session = this.blBean.connect(SBMControl.util.getGuestUser(), SBMControl.util.getGuestPasswd());
            WorkItem wi = this.blBean.getWorkItem(session, wiName);
            if (!wi.getEmailSupport()) {
                this.bounceEmailBack("You cannot complete this task through email. Please read\nyour email again carefully.\n************************************************************\n\n");
            }
            if (isAssignedTask) {
                if (this.updatedOutputDSList != null && !this.updatedOutputDSList.isEmpty()) {
                    wi.complete(new HashMap(this.updatedOutputDSList));
                } else {
                    wi.complete();
                }
            } else if (!wi.isAssigned()) {
                wi.assign(performerName);
            } else {
                this.bounceEmailBack("Workitem: " + wiName + " is already assigned.");
            }
        }
        catch (BizLogicClientException e) {
            this.bounceEmailBack("Can not process your email successfully, please check it and try again.");
        }
        catch (Throwable th) {
            LoggerUtil.logStackTrace((String)"Exception in <EmailAdapterReceiver:completeTask()>", (Throwable)th, null);
        }
    }

    public void bounceEmailBack(String message) {
        try {
            if (this.sendEmail != null) {
                this.sendEmail.reply(message, msgObj);
            }
        }
        catch (Throwable th) {
            LoggerUtil.logStackTrace((String)"Exception in <EmailAdapterReceiver:bounceEmailBack()>", (Throwable)th, null);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void clean() {
    }
}

