/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.email.EmailComposer;
import com.savvion.sbm.bizlogic.email.EmailData;
import com.savvion.sbm.bizlogic.email.EmailTemplate;
import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.bizlogic.email.HtmlComposer;
import com.savvion.sbm.bizlogic.email.REManager;
import com.savvion.sbm.bizlogic.message.BLMessage;
import com.savvion.sbm.bizlogic.message.EmailMessage;
import com.savvion.sbm.bizlogic.server.Notify;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.PerformerUtil;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class EmailManager {
    private static final String DOC_FILE_NAMES = "DOC_FILE_NAMES";
    private static final String ATTACHMENTS = "ATTACHMENTS";
    private static final String PERFORMER = "PERFORMER";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void assignWorkItem(EmailData emailData) throws Exception {
        Session session;
        BLServer server;
        block4: {
            server = null;
            session = null;
            try {
                server = BLClientUtil.getBizLogicServer();
                session = server.connect(SBMUtil.self().getGuestUser(), SBMUtil.self().getGuestPasswd());
                long wiid = emailData.getWorkItemId();
                WorkItem wi = WorkItem.get(session, wiid);
                EmailManager.validateReplyFromAvailPerformer(emailData, wi.getWorkStepName(), wi.getProcessInstanceName(), wi.getAvailablePerformers());
                String performerId = emailData.getPerformer();
                if (!wi.isAssigned()) {
                    wi.assign(performerId);
                    if (EmailUtil.self().isDebug()) {
                        EmailUtil.self().debug("EMAIL_MSG_025", new Object[]{String.valueOf(wiid), performerId});
                    }
                    break block4;
                }
                EmailUtil.self().warn("EMAIL_MSG_120", new Object[]{String.valueOf(wiid), emailData.getPerformer(), wi.getPerformer()});
                EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_119", new Object[]{wi.getPerformer()});
            }
            catch (Throwable throwable) {
                EmailUtil.disconnect(server, session);
                throw throwable;
            }
        }
        EmailUtil.disconnect(server, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void completeWorkItem(EmailData emailData, List outputDs) throws Exception {
        Session session;
        BLServer server;
        block4: {
            server = null;
            session = null;
            try {
                server = BLClientUtil.getBizLogicServer();
                session = server.connect(SBMUtil.self().getGuestUser(), SBMUtil.self().getGuestPasswd());
                long wiid = emailData.getWorkItemId();
                WorkItem wi = WorkItem.get(session, wiid);
                EmailManager.validateReplyFromAssignedPerformer(emailData, wi.getWorkStepName(), wi.getProcessInstanceName(), wi.getPerformer());
                HashMap dataslots = new HashMap();
                dataslots.putAll(emailData.getDocumentDataSlots());
                dataslots.putAll(emailData.getNonDocumentDataSlots());
                wi.complete(dataslots);
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().debug("EMAIL_MSG_014", new Object[]{String.valueOf(wiid)});
                }
                EmailManager.deleteTemporaryFiles(emailData);
                if (!BLControl.util.sendWICompleteEmail) break block4;
                String performer = wi.getPerformer();
                String wiName = wi.getName();
                String address = emailData.getSender();
                Locale recipientLocale = SBMUtil.self().getUserLocale(performer, true);
                EmailComposer.self().notifyTaskCompleted(wiName, performer, address, recipientLocale);
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().debug("EMAIL_MSG_019", new Object[]{wiName, performer, address});
                }
            }
            catch (Throwable throwable) {
                EmailUtil.disconnect(server, session);
                throw throwable;
            }
        }
        EmailUtil.disconnect(server, session);
    }

    private static void validateReplyFromAvailPerformer(EmailData emailData, String wsName, String piName, Vector blAvailablePerformers) {
        String performerId = emailData.getPerformer();
        String action = "assign";
        if (!blAvailablePerformers.contains(performerId)) {
            boolean isValidPerformerId = false;
            for (Object availablePerf : blAvailablePerformers) {
                List members;
                if (!BLControl.queueManager.isQueue((String)availablePerf) || !(members = BLControl.queueManager.getQueueMembers((String)availablePerf)).contains(performerId)) continue;
                isValidPerformerId = true;
                break;
            }
            if (!isValidPerformerId) {
                EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_129", new Object[]{performerId, action});
                return;
            }
        }
        EmailManager.validateSenderEmailId(emailData, performerId, action);
    }

    private static void validateReplyFromAssignedPerformer(EmailData emailData, String wsName, String piName, String blPerformer) {
        String performerId = emailData.getPerformer();
        String action = "complete";
        if (!blPerformer.equals(performerId)) {
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_129", new Object[]{performerId, action});
            return;
        }
        EmailManager.validateSenderEmailId(emailData, performerId, action);
    }

    private static void validateSenderEmailId(EmailData emailData, String performerId, String action) {
        String senderID;
        String performerEmailID = PerformerUtil.getUserEmailAddress((String)performerId);
        if (EmailUtil.isValidProperty(performerEmailID) && (senderID = emailData.getSender()) != null && senderID.toLowerCase().indexOf(performerEmailID.toLowerCase()) == -1) {
            EmailUtil.self().replyAndDeleteMessage("EMAIL_MSG_129", new Object[]{senderID, action});
        }
    }

    private static void deleteTemporaryFiles(EmailData emailData) {
        List attachmentURLs = emailData.getAttachmentURLs();
        if (null == attachmentURLs || attachmentURLs.isEmpty()) {
            return;
        }
        for (int idx = 0; idx < attachmentURLs.size(); ++idx) {
            String fileURL = (String)attachmentURLs.get(idx);
            try {
                URL url = new URL(fileURL);
                File cf = new File(url.getPath());
                boolean deleted = cf.delete();
                if (!EmailUtil.self().isDebug() || !deleted) continue;
                EmailUtil.self().debug("EMAIL_MSG_018", new Object[]{fileURL});
                continue;
            }
            catch (Throwable th) {
                if (!EmailUtil.self().isDebug()) continue;
                EmailUtil.self().debug("EMAIL_MSG_116", new Object[]{fileURL, th.getMessage()});
            }
        }
    }

    public static boolean sendAvailableTask(WFProcessContext pCtx, long wiid, String toAddress, String availablePerformerId) {
        return EmailManager.sendTask(pCtx, wiid, toAddress, null, availablePerformerId);
    }

    public static boolean sendAssignedTask(WFProcessContext pCtx, long wiid, String toAddress, String warning) {
        return EmailManager.sendTask(pCtx, wiid, toAddress, warning, null);
    }

    private static boolean sendTask(WFProcessContext pCtx, long wiid, String toAddress, String warning, String performerId) {
        Map emailData;
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().logSeperator();
        }
        if ((emailData = EmailManager.prepareEmailData(pCtx, wiid, toAddress, warning, performerId)) == null || emailData.isEmpty()) {
            return false;
        }
        boolean sendMail = EmailManager.sendMail(emailData, toAddress, wiid, warning);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().logSeperator();
        }
        return sendMail;
    }

    public static Map prepareEmailData(WFProcessContext pCtx, long wiid, String toAddress) {
        return EmailManager.prepareEmailData(pCtx, wiid, toAddress, null, null);
    }

    public static Map prepareEmailData(WFProcessContext pCtx, long wiid, String toAddress, String warning, String performerId) {
        String subject;
        String fileName;
        URL url;
        if (null == toAddress) {
            EmailUtil.self().throwEmailException("EMAIL_MSG_211", new String[]{String.valueOf(wiid)});
        }
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        long wsid = wieb.getWorkStepID();
        WFProcess pt = pCtx.getProcess();
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        String ptName = pCtx.getProcessTemplateName();
        String wsName = ws.getName();
        String performer = null;
        int wiState = wieb.getState();
        BLConstants.single();
        if (wiState != 28) {
            BLConstants.single();
            if (wiState != 27) {
                EmailUtil.self().throwEmailException("EMAIL_MSG_230", new Object[]{wsName, String.valueOf(wiState)});
            }
        }
        if (EmailUtil.isEmpty(performerId)) {
            performerId = performer = wieb.getPerformer();
        } else {
            performer = performerId;
        }
        String[] dsNames = ws.getSlotKeys();
        String[] inpDSNames = EmailManager.getInputDataSlotNames(ws);
        String[] outDSNames = ws.getOutputSlotsKeys();
        if (!(dsNames != null && dsNames.length != 0 || EmailUtil.isSendNotificationEmail(ws))) {
            EmailUtil.self().warn("EMAIL_MSG_127", new Object[]{wiid, pCtx.getProcessInstanceName(), wsName});
            return null;
        }
        Map context = EmailManager.getEmailContext(pCtx, wieb, ws, wiid, performerId);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().printMap("Process Context", context);
        }
        EmailTemplate template = EmailManager.getTemplate(pCtx, ptName, wsName, wiState);
        HashMap attachmentData = EmailManager.getEmailAttachments(pCtx, wsName, wsid, wiid, performer, template);
        Map docFileNames = (Map)attachmentData.get(DOC_FILE_NAMES);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().printMap("Document Dataslot Files", docFileNames);
        }
        ArrayList attachments = (ArrayList)attachmentData.get(ATTACHMENTS);
        Map dsValues = EmailManager.getDSValues(pCtx, ws.getID(), dsNames, docFileNames);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().printMap("DataSlot Values", dsValues);
        }
        Map dsChoices = EmailManager.getDSChoices(pt, outDSNames);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().printMap("DataSlot Choices", dsChoices);
        }
        List mandatoryFields = EmailManager.getMandatoryOutputDS(pCtx, outDSNames);
        if (template.isHtml()) {
            String dsText = EmailManager.composeDSText(pt, template, dsNames, outDSNames, dsValues, mandatoryFields);
            context.put("PCTX.ALL_WS_DATASLOTS", dsText);
        } else {
            String inputDSText = EmailManager.composeInputDSText(pt, template, inpDSNames, dsValues);
            String outputDSText = EmailManager.composeOutputDSText(pt, template, outDSNames, dsValues, mandatoryFields);
            context.put("PCTX.INPUT_DATASLOTS", inputDSText);
            context.put("PCTX.OUTPUT_DATASLOTS", outputDSText);
        }
        context.put("EMAIL.SUBJECT_PATTERN", EmailUtil.self().getSubjectPattern());
        dsValues.putAll(context);
        Map mailData = REManager.self().prepareTemplate(template, dsValues, dsChoices, wiState, performerId);
        if (EmailUtil.self().sendContentAsAttachment() && (url = EmailManager.storeHtmlToFile(mailData, fileName = performer + "_" + wiid + ".html")) != null) {
            attachments.add(url);
        }
        if (EmailUtil.self().isDebug() && !EmailUtil.self().sendContentAsAttachment()) {
            fileName = performer + "_" + wiid + ".html";
            EmailManager.storeHtmlToFile(mailData, fileName);
        }
        subject = null == (subject = (String)mailData.get("EMAIL.SUBJECT")) ? EmailManager.getDefaultSubject(wsName, wiid, wiState) : EmailUtil.self().getSubjectPattern() + subject;
        mailData.put("EMAIL.SUBJECT", subject);
        mailData.put(PERFORMER, performer);
        if (EmailUtil.isEmpty(warning)) {
            mailData.put(ATTACHMENTS, attachments);
        }
        return mailData;
    }

    private static URL storeHtmlToFile(Map mailData, String fileName) {
        EmailTemplate template = (EmailTemplate)mailData.get("EMAIL_TEMPLATE");
        URL url = null;
        if (template != null && template.isHtml()) {
            String content = template.getContent();
            String target = EmailUtil.self().getAttachmentFolder() + fileName;
            try {
                String urlString = FileUtil.saveContent((String)content, (File)new File(target), (String)SBMUtil.self().getMailCharset());
                url = new URL(urlString);
                if (EmailUtil.self().isDebug()) {
                    EmailUtil.self().debug("EMAIL_MSG_044", new Object[]{urlString});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return url;
    }

    private static List getMandatoryOutputDS(WFProcessContext pCtx, String[] dsNames) {
        ArrayList<String> mandatoryDS = new ArrayList<String>();
        if (!EmailUtil.self().isCheckRequiredDSEnabled()) {
            return mandatoryDS;
        }
        if (dsNames == null) {
            return mandatoryDS;
        }
        WFProcess pt = pCtx.getProcess();
        for (int ix = 0; ix < dsNames.length; ++ix) {
            String dsName = dsNames[ix];
            WFDataslot ds = pt.getDataslot(dsName);
            if (!ds.isRequired()) continue;
            mandatoryDS.add(dsName);
        }
        return mandatoryDS;
    }

    private static String[] getInputDataSlotNames(WFWorkstep ws) {
        String[] inputSlots = ws.getInputSlotsKeys();
        if (inputSlots == null || inputSlots.length == 0) {
            return inputSlots;
        }
        String[] outputSlots = ws.getOutputSlotsKeys();
        if (outputSlots == null || outputSlots.length == 0) {
            return inputSlots;
        }
        ArrayList<String> inputds = new ArrayList<String>();
        List<String> outputds = Arrays.asList(outputSlots);
        for (int i = 0; i < inputSlots.length; ++i) {
            if (outputds.contains(inputSlots[i])) continue;
            inputds.add(inputSlots[i]);
        }
        return inputds.toArray(new String[0]);
    }

    private static HashMap getEmailAttachments(WFProcessContext pCtx, String wsName, long wsid, long wiid, String performer, EmailTemplate template) {
        ArrayList attachment = new ArrayList();
        HashMap<String, String> docFileNames = new HashMap<String, String>();
        Hashtable<String, DocumentDS> inputDocs = WFWorkstepInstance.single().getDocumentsForInputDocDS(pCtx, wsid);
        HashMap<String, DocumentDS> combinedDocs = new HashMap<String, DocumentDS>(inputDocs);
        Hashtable<String, DocumentDS> outputDocs = WFWorkstepInstance.single().getDocumentsForOutputDocDS(pCtx, wsid);
        if (EmailUtil.self().isFillOutputValues()) {
            combinedDocs.putAll(outputDocs);
        } else {
            for (String docDSName : outputDocs.keySet()) {
                combinedDocs.remove(docDSName);
            }
        }
        Set docDSNames = combinedDocs.keySet();
        if (!(docDSNames == null || docDSNames.isEmpty() || template.hasInputDSToken() || template.hasOutputDSToken() || template.hasAllDSToken())) {
            Set<String> replaceTokens = template.getReplaceTokens();
            docDSNames.retainAll(replaceTokens);
        }
        for (Map.Entry docDSEntry : combinedDocs.entrySet()) {
            String slotName = (String)docDSEntry.getKey();
            DocumentDS docDS = (DocumentDS)docDSEntry.getValue();
            List docs = docDS.getDocuments(performer);
            if (EmailUtil.self().isDebug()) {
                String lineSep = EmailUtil.self().getLineSeperator();
                EmailUtil.self().debug("EMAIL_MSG_039", new Object[]{String.valueOf(wiid), slotName, wsName, lineSep, docs});
            }
            if (EmailUtil.self().isAttachDocumentEnabled()) {
                attachment.addAll(docs);
            }
            ArrayList<String> dsNames = new ArrayList<String>();
            for (int i = 0; i < docs.size(); ++i) {
                dsNames.add(((Document)docs.get(i)).getName());
            }
            String fileNames = EmailUtil.self().getCSValues(dsNames);
            docFileNames.put(slotName, fileNames);
        }
        HashMap<String, Cloneable> docInfo = new HashMap<String, Cloneable>();
        docInfo.put(ATTACHMENTS, attachment);
        docInfo.put(DOC_FILE_NAMES, docFileNames);
        return docInfo;
    }

    private static Map getEmailContext(WFProcessContext pCtx, WorkItemEBLocal wieb, WFWorkstep ws, long wiid, String performerId) {
        String encryptedWIId = EmailUtil.getEncryptedValue(String.valueOf(wiid));
        String securityKey = EmailUtil.encryptSecurityKey(String.valueOf(wiid));
        String startDate = EmailUtil.formatWsDate(wieb.getTimeStarted());
        String dueDate = EmailUtil.formatWsDate(wieb.getDueDate());
        String priority = SBMUtil.self().getStringPriority(wieb.getPriority());
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_023", new Object[]{String.valueOf(wiid), encryptedWIId, securityKey});
        }
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("PCTX.ENC.WI_ID", encryptedWIId);
        context.put("EMAIL.SKEY", securityKey);
        context.put("PCTX.WI_ID", String.valueOf(wieb.getId()));
        context.put("PCTX.TEMPLATE_ID", String.valueOf(wieb.getProcessTemplateID()));
        context.put("PCTX.INSTANCE_ID", String.valueOf(wieb.getProcessInstanceID()));
        context.put("PCTX.WS_ID", String.valueOf(wieb.getWorkStepID()));
        context.put("PCTX.TEMPLATE_NAME", pCtx.getProcessTemplateName());
        String instanceName = EmailUtil.mangleInstanceName(pCtx.getProcessInstanceName());
        context.put("PCTX.INSTANCE_NAME", instanceName);
        context.put("PCTX.WS_NAME", ws.getName());
        context.put("PCTX.WI_PERFORMER", wieb.getPerformer());
        context.put("PCTX.WS_INSTRUCTION", ws.getInstruction());
        context.put("PCTX.BIZSITE_LOGIN_URL", EmailUtil.self().getBizSoloTaskURL(wieb.getName(), wieb.getId()));
        context.put("EMAIL.USER", performerId);
        String encPerformerId = "";
        if (!EmailUtil.isEmpty(performerId)) {
            encPerformerId = EmailUtil.getEncryptedValue(performerId);
        }
        context.put("EMAIL.ENC.USER", encPerformerId);
        context.put("EMAIL.TYPE", String.valueOf(wieb.getState()));
        context.put("EMAIL.BLEMAIL_ID", EmailUtil.self().getFromEmailId());
        context.put("PCTX.WS_START_DATE", startDate);
        context.put("PCTX.WS_DUE_DATE", dueDate);
        context.put("PCTX.WS_PRIORITY", priority);
        return context;
    }

    public static Map getDSValues(WFProcessContext pCtx, long wsid, String[] dsNames, Map docFileNames) {
        WFProcess pt = pCtx.getProcess();
        HashMap dsData = pCtx.getSlotValue(wsid, dsNames);
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        for (int ix = 0; ix < dsNames.length; ++ix) {
            String dsName = dsNames[ix];
            Object value = dsData.get(dsName);
            if (dsName.startsWith("@")) {
                dsValues.put(dsName, value.toString());
                continue;
            }
            WFDataslot ds = pt.getDataslot(dsName);
            if (value != null && !"<NULL>".equals(value.toString().trim())) {
                if (ds.isDocument()) {
                    dsValues.put(dsName, docFileNames.get(dsName));
                    continue;
                }
                if (ds.isList()) {
                    value = EmailUtil.self().getCSValues((Vector)value);
                    dsValues.put(dsName, value);
                    continue;
                }
                if (ds.isDecimal()) {
                    Decimal dValue = (Decimal)value;
                    if (dValue.isNull()) {
                        dsValues.put(dsName, "");
                        continue;
                    }
                    dsValues.put(dsName, dValue.toString());
                    continue;
                }
                if (ds.isDate()) {
                    DateTime dtValue = (DateTime)value;
                    if (dtValue.isNull()) {
                        dsValues.put(dsName, "");
                        continue;
                    }
                    String strDate = EmailUtil.getFormattedDate(dtValue.getTime());
                    dsValues.put(dsName, strDate);
                    continue;
                }
                if (ds.isLong()) {
                    Long lValue = (Long)value;
                    if (-1L == lValue) {
                        dsValues.put(dsName, "");
                        continue;
                    }
                    dsValues.put(dsName, String.valueOf(lValue));
                    continue;
                }
                if (ds.isDouble()) {
                    Double dblValue = (Double)value;
                    if (Math.abs(dblValue - -1.0) < 1.0E-8) {
                        dsValues.put(dsName, "");
                        continue;
                    }
                    dsValues.put(dsName, String.valueOf(dblValue));
                    continue;
                }
                if (ds.isXML()) {
                    XML xml = (XML)value;
                    if (-1L == xml.getID()) {
                        dsValues.put(dsName, "");
                        continue;
                    }
                    String xmlContents = EmailManager.getXMLContent(pCtx.getServerSession(), xml);
                    dsValues.put(dsName, xmlContents);
                    continue;
                }
                if (ds.isMap()) {
                    SBMUtil.self();
                    value = SBMUtil.convertMapToString((Map)((Map)value));
                    dsValues.put(dsName, value);
                    continue;
                }
                dsValues.put(dsName, value.toString());
                continue;
            }
            dsValues.put(dsName, "");
        }
        return dsValues;
    }

    private static String getXMLContent(Session session, XML xmlDs) {
        String xmlContent = "";
        try {
            xmlContent = xmlDs.getContent(session);
        }
        catch (Throwable th) {
            EmailUtil.self().throwEmailException("EMAIL_MSG_235", new Object[0]);
        }
        return xmlContent;
    }

    public static Map getDSChoices(WFProcess pt, String[] dsNames) {
        HashMap<String, String> dsChoices = new HashMap<String, String>(dsNames.length);
        for (int ix = 0; ix < dsNames.length; ++ix) {
            String dsName = dsNames[ix];
            WFDataslot ds = pt.getDataslot(dsName);
            if (!ds.hasChoices()) continue;
            StringBuilder choice = new StringBuilder("(choices: ");
            String csChoices = EmailUtil.self().getCSValues(ds.getChoices());
            choice.append(csChoices);
            choice.append(")");
            dsChoices.put(dsName, choice.toString());
        }
        return dsChoices;
    }

    private static HtmlComposer createHtmlComposer(WFProcess pt, String[] dsNames, Map dsValues) {
        ArrayList<String> dataslots = new ArrayList<String>();
        LinkedHashMap metaData = new LinkedHashMap();
        for (int i = 0; i < dsNames.length; ++i) {
            String dsName = dsNames[i];
            if (dsName.startsWith("@")) {
                metaData.put(dsName, null);
                continue;
            }
            dataslots.add(dsName);
        }
        String[] dsarr = dataslots.toArray(new String[dataslots.size()]);
        HashMap userDS = pt.getDataSlotMetaData(dsarr);
        metaData.putAll(userDS);
        return EmailUtil.self().createHtmlComposer(metaData, dsValues);
    }

    private static String composeDSText(WFProcess pt, EmailTemplate template, String[] dsNames, String[] outDSNames, Map dsValues, List mandatoryFields) {
        if (null == dsNames || null == dsValues || dsNames.length == 0) {
            return "";
        }
        List<Object> outDSList = null;
        outDSList = null != outDSNames && outDSNames.length > 0 ? Arrays.asList(outDSNames) : new ArrayList();
        HtmlComposer composer = EmailManager.createHtmlComposer(pt, dsNames, dsValues);
        composer.setOutputFields(outDSList);
        composer.setMandatoryFields(mandatoryFields);
        composer.setSampleDateTimePattern(SBMUtil.self().getSampleDateTimePattern());
        return composer.create();
    }

    private static String composeInputDSText(WFProcess pt, EmailTemplate template, String[] inpDSNames, Map dsValues) {
        if (null == inpDSNames || null == dsValues || inpDSNames.length == 0) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        if (!template.isHtml()) {
            for (int idx = 0; idx < inpDSNames.length; ++idx) {
                Object dsValue = dsValues.get(inpDSNames[idx]);
                if (null == dsValue || "<NULL>".equals(dsValue.toString().trim())) {
                    dsValue = "";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(EmailUtil.self().getEmailVarNamePrefix());
                sb.append(inpDSNames[idx]);
                sb.append(EmailUtil.self().getEmailVarNameSuffix());
                sb.append(EmailUtil.self().getEmailVarSeperator());
                sb.append(EmailUtil.self().getEmailVarInputPrefix());
                sb.append(dsValue);
                sb.append(EmailUtil.self().getEmailVarInputSuffix());
                sb.append(EmailUtil.self().getLineSeperator());
                text.append(sb.toString());
            }
        }
        return EmailManager.getDSValuesWithHeader(EmailTemplate.getEtlInputDSHeader(), text.toString());
    }

    private static String composeOutputDSText(WFProcess pt, EmailTemplate template, String[] outDSNames, Map dsValues, List mandatoryDS) {
        if (null == outDSNames || null == dsValues || outDSNames.length == 0) {
            return "";
        }
        StringBuilder text = new StringBuilder();
        boolean fillOutputValues = EmailUtil.self().isFillOutputValues();
        if (!template.isHtml()) {
            for (int idx = 0; idx < outDSNames.length; ++idx) {
                String dsValue;
                String dsName = outDSNames[idx];
                StringBuilder sb = new StringBuilder();
                sb.append(EmailUtil.self().getEmailVarNamePrefix());
                sb.append(dsName);
                sb.append(EmailUtil.self().getEmailVarNameSuffix());
                sb.append(EmailUtil.self().getEmailVarSeperator());
                sb.append(EmailUtil.self().getEmailVarOutputPrefix());
                if (fillOutputValues && !EmailUtil.isDataSlotEmpty(dsValue = (String)dsValues.get(dsName))) {
                    sb.append(dsValue);
                }
                sb.append(EmailUtil.self().getEmailVarOutputSuffix());
                if (mandatoryDS != null && mandatoryDS.contains(dsName)) {
                    sb.append("*");
                }
                sb.append(EmailUtil.self().getLineSeperator());
                text.append(sb.toString());
            }
        }
        return EmailManager.getDSValuesWithHeader(EmailTemplate.getEtlOutputDSHeader(), text.toString());
    }

    public static EmailTemplate getTemplate(WFProcessContext pCtx, String ptName, String wsName, int wiState) {
        EmailTemplate template = EmailManager.getPerformingAppTemplate(pCtx, ptName, wsName, wiState);
        if (template == null) {
            template = EmailUtil.self().getCustomTemplate(ptName, wsName, wiState);
        }
        if (template == null) {
            WFWorkstep ws = pCtx.getProcess().getWorkstep(wsName);
            if (EmailUtil.isSendNotificationEmail(ws)) {
                return EmailUtil.self().getDefaultNotificationTemplate(wiState);
            }
            template = EmailUtil.self().getDefaultTemplate(wiState);
        }
        if (template == null) {
            BLConstants.single();
            if (28 == wiState) {
                EmailUtil.self().throwEmailException("EMAIL_MSG_245", new Object[]{EmailUtil.self().getDefaultTemplatePath()});
            } else {
                EmailUtil.self().throwEmailException("EMAIL_MSG_246", new Object[]{EmailUtil.self().getDefaultTemplatePath()});
            }
        }
        return template;
    }

    private static EmailTemplate getPerformingAppTemplate(WFProcessContext pCtx, String ptName, String wsName, int wiState) {
        WFWorkstep ws = pCtx.getProcess().getWorkstep(wsName);
        Object performingApp = ws.getPerformingApp();
        if (performingApp == null) {
            return null;
        }
        String perfApp = performingApp.toString();
        if (perfApp.startsWith("@")) {
            Object dsValue = pCtx.getSlotValue(perfApp.substring("@".length()));
            if (dsValue == null) {
                return null;
            }
            perfApp = dsValue.toString();
        }
        if (!perfApp.matches(".+_assigned\\.[he]tl")) {
            EmailUtil.self().warn("EMAIL_MSG_125", new Object[]{perfApp});
            return null;
        }
        BLConstants.single();
        if (27 == wiState) {
            String origPerfApp = perfApp;
            perfApp = perfApp.replaceAll("_assigned\\.", "_available\\.");
            if (EmailUtil.self().isDebug()) {
                EmailUtil.self().debug("EMAIL_MSG_042", new Object[]{origPerfApp, perfApp, wsName, ptName});
            }
        }
        return EmailUtil.self().getPerformingAppTemplate(ptName, wsName, perfApp);
    }

    static boolean hasDataSlot(String[] dsNames, String dsName) {
        for (int ix = 0; ix < dsNames.length; ++ix) {
            if (!dsNames[ix].equals(dsName)) continue;
            return true;
        }
        return false;
    }

    private static boolean sendMail(Map mailData, String toAddress, long wiid, String warning) {
        boolean result;
        EmailMessage msg = EmailManager.prepareMessage(toAddress, mailData, wiid, warning);
        if (EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_028", new Object[]{toAddress, String.valueOf(wiid)});
        }
        if (!(result = Notify.self().send((BLMessage)msg))) {
            EmailUtil.self().error("EMAIL_MSG_213", new Object[]{toAddress, String.valueOf(wiid)});
        }
        return result;
    }

    private static EmailMessage prepareMessage(String toAddress, Map mailData, long wiid, String warning) {
        Hashtable htmlImages;
        String subject;
        String performer = (String)mailData.get(PERFORMER);
        ArrayList attachments = (ArrayList)mailData.get(ATTACHMENTS);
        String[] fromAddress = new String[]{EmailUtil.self().getFromEmailId()};
        EmailTemplate template = (EmailTemplate)mailData.get("EMAIL_TEMPLATE");
        String actualContent = template.getContent();
        String content = null;
        if (!EmailUtil.isEmpty(warning)) {
            content = warning;
            content = content + template.getLineSeperator();
            content = content + actualContent;
        } else {
            content = actualContent;
        }
        if (null == content || content.length() == 0) {
            EmailUtil.self().throwEmailException("EMAIL_MSG_210", new Object[]{performer, String.valueOf(wiid)});
        }
        if ((subject = (String)mailData.get("EMAIL.SUBJECT")).indexOf(":") != -1 && EmailUtil.self().isDebug()) {
            EmailUtil.self().debug("EMAIL_MSG_115", new Object[]{performer, String.valueOf(wiid)});
        }
        String ccCSList = (String)mailData.get("EMAIL.CC");
        String bccCSList = (String)mailData.get("EMAIL.BCC");
        String[] ccAddress = null;
        if (null != ccCSList && ccCSList.trim().length() > 0) {
            ccAddress = ccCSList.split(",");
        }
        String[] bccAddress = null;
        if (null != bccCSList && bccCSList.trim().length() > 0) {
            bccAddress = bccCSList.split(",");
        }
        EmailMessage msg = new EmailMessage(subject, content, attachments, fromAddress, new String[]{toAddress}, ccAddress, bccAddress, SBMUtil.self().getMailCharset());
        msg.setContentType(template.getContentType());
        if (template.isHtml() && (htmlImages = template.getHtmlImages()) != null) {
            msg.setHtmlImages(htmlImages);
        }
        return msg;
    }

    private static String getDefaultSubject(String wsName, long wiid, int wiState) {
        StringBuilder subject = new StringBuilder();
        String state = null;
        BLConstants.single();
        state = 28 == wiState ? " Assigned Task" : " Available Task";
        subject.append(EmailUtil.self().getSubjectPattern());
        subject.append(state);
        subject.append(" <").append(wsName).append(" (");
        subject.append(String.valueOf(wiid)).append(")>");
        return subject.toString();
    }

    private static String getDSValuesWithHeader(String etlDSheader, String text) {
        if (!EmailUtil.isEmpty(text)) {
            return etlDSheader + text;
        }
        return text;
    }
}

