/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.email;

import com.savvion.sbm.bizlogic.email.CIDGenerator;
import com.savvion.sbm.bizlogic.email.EmailException;
import com.savvion.sbm.bizlogic.email.EmailUtil;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.LoggerUtil;
import com.savvion.sbm.util.SBMUtil;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Attribute;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.AndFilter;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class EmailTemplate
implements Serializable {
    private static final long serialVersionUID = -4578893552986486899L;
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String HTML_LINE_SEPERATOR = "<br>";
    public static final String CID_PREFIX = "cid:";
    public static final char QUOTE = '\"';
    public static final String IMAGE_TAG = "IMG";
    public static final String SRC_ATTRIBUTE = "src";
    public static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static String ETL_FOOTER = "";
    private static String HTML_FOOTER = "";
    private static String HTML_HEADER = "";
    private static Hashtable COMMON_HTML_IMAGES = null;
    private String url;
    private String content = "";
    private String contentType;
    private boolean applyAppenders = false;
    private Hashtable htmlImages = null;
    private static String ETL_INPUTDS_HEADER = "";
    private static String ETL_OUTPUTDS_HEADER = "";
    Set<String> replaceTokens = new HashSet<String>();

    public EmailTemplate(String _url) {
        this.url = _url;
        if (_url != null) {
            if (EmailUtil.isValidHtmlTemplateUrl(_url)) {
                this.contentType = TEXT_HTML;
                this.htmlImages = new Hashtable();
                this.content = EmailTemplate.parseHtml(this.url, this.htmlImages);
            } else {
                this.contentType = TEXT_PLAIN;
                this.content = FileUtil.getString((String)this.url, (String)SBMUtil.self().getMailCharset());
            }
        }
        if (!this.applyAppenders) {
            this.formatContent();
        }
        this.content = this.content.trim();
        this.prepareReplaceTokens();
    }

    public EmailTemplate(String contents, String type, boolean applyAppender) {
        this.content = contents;
        this.applyAppenders = applyAppender;
        if (!TEXT_PLAIN.equals(type) && !TEXT_HTML.equals(type)) {
            throw new IllegalArgumentException("Invalid Content Type <" + type + "> specified !");
        }
        this.contentType = type;
        if (this.applyAppenders) {
            this.formatContent();
        }
        this.content = this.content.trim();
        this.prepareReplaceTokens();
    }

    public EmailTemplate(String contents, String type) {
        this(contents, type, true);
    }

    private void formatContent() {
        if (this.isPlainText()) {
            this.content = this.content + LINE_SEPERATOR + ETL_FOOTER;
        } else {
            String txtBefore = "";
            String txtAfter = "";
            int idx = this.content.toLowerCase().indexOf("<head>");
            if (idx == -1) {
                throw new RuntimeException("Malformed HTML, <head> tag is missing !");
            }
            txtBefore = this.content.substring(0, idx);
            txtAfter = this.content.substring(idx + "<head>".length(), this.content.length());
            this.content = txtBefore + "<head>" + LINE_SEPERATOR + HTML_HEADER + txtAfter;
            idx = this.content.toLowerCase().lastIndexOf("</body>");
            if (idx == -1) {
                throw new RuntimeException("Malformed HTML, <\body> tag is missing !");
            }
            txtBefore = this.content.substring(0, idx);
            txtAfter = this.content.substring(idx, this.content.length());
            this.content = txtBefore + HTML_FOOTER + txtAfter;
            if (this.htmlImages == null) {
                this.htmlImages = new Hashtable();
            }
            if (COMMON_HTML_IMAGES != null) {
                this.htmlImages.putAll(COMMON_HTML_IMAGES);
            }
        }
        this.applyAppenders = true;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContent() {
        return this.content;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isHtml() {
        return TEXT_HTML.equalsIgnoreCase(this.contentType);
    }

    public boolean isPlainText() {
        return TEXT_PLAIN.equalsIgnoreCase(this.contentType);
    }

    public boolean isApplyAppenders() {
        return this.applyAppenders;
    }

    public void setApplyAppenders(boolean isFormatted) {
        this.applyAppenders = isFormatted;
    }

    public String getLineSeperator() {
        if (this.isHtml()) {
            return HTML_LINE_SEPERATOR;
        }
        return LINE_SEPERATOR;
    }

    public static synchronized void setEtlFooter(String etlFooterPath) {
        ETL_FOOTER = FileUtil.getString((String)etlFooterPath, (String)SBMUtil.self().getMailCharset());
    }

    public static synchronized void setHtmlFooter(String htmlFooterPath) {
        COMMON_HTML_IMAGES = new Hashtable();
        try {
            HTML_FOOTER = EmailTemplate.parseHtml(htmlFooterPath, COMMON_HTML_IMAGES);
        }
        catch (Exception e) {
            HTML_FOOTER = FileUtil.getString((String)htmlFooterPath, (String)SBMUtil.self().getMailCharset());
            String message = "Unable to parse Footer HTML <" + htmlFooterPath + "> ";
            if (EmailUtil.logger == null) {
                LoggerUtil.logSOP((Object)message);
                e.printStackTrace();
            }
            EmailUtil.logger.error((Object)message, (Throwable)e);
        }
    }

    public static synchronized void setHtmlHeader(String htmlHeaderPath) {
        HTML_HEADER = FileUtil.getString((String)htmlHeaderPath, (String)SBMUtil.self().getMailCharset());
    }

    private static String parseHtml(String absFileUrl, Hashtable parsedImages) {
        NodeList html;
        String htmlText = FileUtil.getString((String)absFileUrl, (String)SBMUtil.self().getMailCharset());
        Lexer lexer = new Lexer(htmlText);
        Parser parser = new Parser(lexer);
        try {
            parser.setEncoding(SBMUtil.self().getMailCharset());
            html = parser.parse(null);
        }
        catch (ParserException parserException) {
            throw new EmailException("Email Template <" + absFileUrl + "> is not parsable !", parserException);
        }
        boolean parseRecursively = true;
        HasAttributeFilter attribFilter = null;
        TagNameFilter tagFilter = null;
        AndFilter filter = null;
        NodeList tags = null;
        tagFilter = new TagNameFilter(IMAGE_TAG);
        attribFilter = new HasAttributeFilter(SRC_ATTRIBUTE);
        filter = new AndFilter((NodeFilter)tagFilter, (NodeFilter)attribFilter);
        tags = html.extractAllNodesThatMatch((NodeFilter)filter, parseRecursively);
        for (int ix = 0; tags != null && ix < tags.size(); ++ix) {
            ImageTag tag = (ImageTag)tags.elementAt(ix);
            String srcAttribValue = tag.getAttribute(SRC_ATTRIBUTE);
            if (EmailUtil.isEmpty(srcAttribValue) || EmailUtil.isHTTPUrl(srcAttribValue) || srcAttribValue.startsWith(CID_PREFIX)) continue;
            String srcAttribURL = tag.getPage().getAbsoluteURL(srcAttribValue);
            try {
                URL url = EmailUtil.getAbsoluteURL(absFileUrl, srcAttribURL);
                String cid = null;
                if (parsedImages.containsKey(url)) {
                    cid = (String)parsedImages.get(url);
                } else {
                    cid = CIDGenerator.generate("img");
                    parsedImages.put(url, cid);
                }
                tag.setAttribute(new Attribute(SRC_ATTRIBUTE, EmailTemplate.prepareCIDUrl(cid), '\"'));
                continue;
            }
            catch (MalformedURLException mfe) {
                String message = "Because of incorrect/malformed image URL, image <" + srcAttribValue + "> is skipped in Email Template <" + absFileUrl + ">";
                if (EmailUtil.logger == null) {
                    LoggerUtil.logSOP((Object)message);
                    mfe.printStackTrace();
                    continue;
                }
                EmailUtil.logger.error((Object)message, (Throwable)mfe);
            }
        }
        return html.toHtml();
    }

    public void setHtmlImages(Hashtable htmlImages) {
        this.htmlImages = htmlImages;
    }

    public Hashtable getHtmlImages() {
        return this.htmlImages;
    }

    public static String prepareCIDUrl(String value) {
        return CID_PREFIX + value;
    }

    public static synchronized void setEtlInputDSHeader(String etlDSHeader) {
        ETL_INPUTDS_HEADER = etlDSHeader;
    }

    public static synchronized void setEtlOutputDSHeader(String etlDSHeader) {
        ETL_OUTPUTDS_HEADER = etlDSHeader;
    }

    public static String getEtlInputDSHeader() {
        return ETL_INPUTDS_HEADER;
    }

    public static String getEtlOutputDSHeader() {
        return ETL_OUTPUTDS_HEADER;
    }

    private void prepareReplaceTokens() {
        Pattern tokenPattern = Pattern.compile("(\\$)(\\{)((\\S)*)(\\})");
        Matcher m = tokenPattern.matcher(this.content);
        while (m.find()) {
            this.replaceTokens.add(m.group(3));
        }
    }

    public boolean hasInputDSToken() {
        return this.replaceTokens.contains("PCTX.INPUT_DATASLOTS");
    }

    public boolean hasOutputDSToken() {
        return this.replaceTokens.contains("PCTX.OUTPUT_DATASLOTS");
    }

    public boolean hasAllDSToken() {
        return this.replaceTokens.contains("PCTX.ALL_WS_DATASLOTS");
    }

    public Set<String> getReplaceTokens() {
        return this.replaceTokens;
    }
}

