/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.dao;

import com.savvion.sbm.bizlogic.messaging.subscriber.BLBizMessage;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.DBConstants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BLMessagesDAO
extends BLDAOService {
    private static final String GET_MESSAGE_LIST_FORMAT = "%s %s.%s %s %s %s.%s = ? AND %s.%s = ? AND %s.%s = ? AND %s.%s = %s.%s ORDER BY %s.%s";
    private static final String GET_MESSAGE_COUNT_WITHOUT_GROUP_BY_FORMAT = "%s %s, COUNT(*) %s %s %s.%s = ? AND %s.%s = ? AND %s.%s = %s.%s AND %s.%s = %s.%s AND %s.%s = %s.%s AND %s.%s = %s.%s";
    private static final String GET_MESSAGE_COUNT_WITH_LOOP_COUNTER = "%s %s, COUNT(*) %s %s %s.%s = ? AND %s.%s = ? AND %s.%s = ? AND %s.%s = %s.%s GROUP BY %s";
    private static final String GET_MESSAGE_COUNT_FORMAT = "%s GROUP BY %s";
    private static final String GET_MESSAGE_COUNT_BY_STATE = "%s AND %s.%s = ? GROUP BY %s";
    private static final String REMOVE_MESSAGES_FORMAT = "%s %s %s NOT IN (%s)";
    private static final String SELECT_DISTINCT_FROM = "SELECT DISTINCT %s FROM %s";
    private static final String REMOVE_BY_MESSAGE_NAMES_FORMAT = "%s AND %s IN (SELECT %s FROM %s WHERE %s";
    private static final String GET_WORKSTEP_MESSAGES_PART1_FORMAT = "SELECT %s.%s, %s.%s, %s.%s, %s.%s, %s.%s FROM %s %s, %s %s, %s %s WHERE ";
    private static final String GET_WORKSTEP_MESSAGES_PART2_FORMAT = " %s.%s = %s.%s AND %s.%s = %s.%s ORDER BY %s.%s, %s.%s ";
    private static final String GET_WAITING_SUBSCRIBERS_WITH_MESSAGES_FORMAT = "SELECT DISTINCT %s.%s, %s.%s %s %s %s.%s = %s.%s AND %s.%s = %s.%s AND %s.%s = %s.%s AND %s.%s = ?";
    private static final String[] CREATEMESSAGE_TABLELIST;
    private static final String[] CREATEMESSAGE_WS_TABLELIST;
    private static final String[] CREATE_DISCARDMESSAGE_TABLELIST;
    public static String createMessage;
    public static String createDiscardMessage;
    public static String createMessageWS;
    public static String getMessageList;
    public static String getMessageCount;
    public static String getMessageCountWithLoopCounter;
    public static String getMessageCountByState;
    public static String removeTargets;
    public static String removeMessages;
    public static String removeByMessageNames;
    public static String removeByProcessInstance;
    public static String getWorkstepMessagesPart1;
    public static String getWorkstepMessagesPart2;
    public static String getWaitingSubscribersWithMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(List targetList, BLBizMessage message) {
        if (targetList == null || targetList.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmtCreateMessage = null;
        PreparedStatement pstmtCreateMessageWS = null;
        long messageId = -1L;
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtCreateMessage = conn.prepareStatement(createMessage);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", createMessage, new Object[0]);
            }
            messageId = BLControl.util.msgSeq.getNextNumber();
            message.setID(messageId);
            pstmtCreateMessage.setLong(1, messageId);
            pstmtCreateMessage.setString(2, message.getMessageName());
            ByteArrayInputStream is = new ByteArrayInputStream(BLMessagesDAO.convertToBytes((Object)message));
            pstmtCreateMessage.setBinaryStream(3, (InputStream)is, is.available());
            pstmtCreateMessage.executeUpdate();
            pstmtCreateMessageWS = conn.prepareStatement(createMessageWS);
            for (int ix = 0; ix < targetList.size(); ++ix) {
                HashMap target = (HashMap)targetList.get(ix);
                long piid = (Long)target.get("PROCESSINSTANCEID");
                long wsid = (Long)target.get("WORKSTEPID");
                int loopCounter = (Integer)target.get("LOOPCOUNTER");
                pstmtCreateMessageWS.setLong(1, piid);
                pstmtCreateMessageWS.setLong(2, wsid);
                pstmtCreateMessageWS.setInt(3, loopCounter);
                pstmtCreateMessageWS.setLong(4, messageId);
                pstmtCreateMessageWS.executeUpdate();
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th, (String)("BLMessageDAO.create(PKey: " + messageId + ")"));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(null, (Statement)pstmtCreateMessage, null);
                BLMessagesDAO.clean(null, pstmtCreateMessageWS, (Connection)conn);
            }
        }
        BLMessagesDAO.clean(null, (Statement)pstmtCreateMessage, null);
        BLMessagesDAO.clean(null, (Statement)pstmtCreateMessageWS, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDiscardedMessage(BLBizMessage message, String discardReason, String stackTrace) {
        if (message == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmtCreateDiscardMessage = null;
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtCreateDiscardMessage = conn.prepareStatement(createDiscardMessage);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", createDiscardMessage, new Object[0]);
            }
            pstmtCreateDiscardMessage.setString(1, message.getMessageName());
            ByteArrayInputStream is = new ByteArrayInputStream(BLMessagesDAO.convertToBytes((Object)message));
            pstmtCreateDiscardMessage.setBinaryStream(2, (InputStream)is, is.available());
            pstmtCreateDiscardMessage.setString(3, BLMessagesDAO.getValueBySize(discardReason, 512));
            pstmtCreateDiscardMessage.setString(4, BLMessagesDAO.getValueBySize(stackTrace, 2048));
            pstmtCreateDiscardMessage.executeUpdate();
        }
        catch (Throwable th) {
            BLMessagesDAO.handle((Throwable)th, (String)("BLMessageDAO.createDiscardedMessage(" + message.getMessageName() + ")"));
        }
        finally {
            BLMessagesDAO.clean(null, (Statement)pstmtCreateDiscardMessage, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMessageCountWithLoopCounter(long piid, long wsid, int loopCounter) {
        Connection conn = null;
        PreparedStatement pstmtGetMessageCountWithLoopCounter = null;
        ResultSet rs = null;
        HashMap<String, Integer> messageCount = new HashMap<String, Integer>();
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtGetMessageCountWithLoopCounter = conn.prepareStatement(getMessageCountWithLoopCounter);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getMessageCountWithLoopCounter, new Object[0]);
            }
            pstmtGetMessageCountWithLoopCounter.setLong(1, piid);
            pstmtGetMessageCountWithLoopCounter.setLong(2, wsid);
            pstmtGetMessageCountWithLoopCounter.setInt(3, loopCounter);
            rs = pstmtGetMessageCountWithLoopCounter.executeQuery();
            while (rs.next()) {
                String msgName = rs.getString(1);
                int count = rs.getInt(2);
                messageCount.put(msgName, count);
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(rs, (Statement)pstmtGetMessageCountWithLoopCounter, (Connection)conn);
            }
        }
        BLMessagesDAO.clean((ResultSet)rs, (Statement)pstmtGetMessageCountWithLoopCounter, (Connection)conn);
        return messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMessageCount(long piid, long wsid) {
        Connection conn = null;
        PreparedStatement pstmtGetMessageCount = null;
        ResultSet rs = null;
        HashMap<String, Integer> messageCount = new HashMap<String, Integer>();
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtGetMessageCount = conn.prepareStatement(getMessageCount);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getMessageCount, new Object[0]);
            }
            pstmtGetMessageCount.setLong(1, piid);
            pstmtGetMessageCount.setLong(2, wsid);
            rs = pstmtGetMessageCount.executeQuery();
            while (rs.next()) {
                String msgName = rs.getString(1);
                int count = rs.getInt(2);
                messageCount.put(msgName, count);
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(rs, (Statement)pstmtGetMessageCount, (Connection)conn);
            }
        }
        BLMessagesDAO.clean((ResultSet)rs, (Statement)pstmtGetMessageCount, (Connection)conn);
        return messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getMessageCount(long piid, long wsid, int state) {
        Connection conn = null;
        PreparedStatement pstmtGetMessageCount = null;
        ResultSet rs = null;
        HashMap<String, Integer> messageCounts = new HashMap<String, Integer>();
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtGetMessageCount = conn.prepareStatement(getMessageCountByState);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getMessageCountByState, new Object[0]);
            }
            pstmtGetMessageCount.setLong(1, piid);
            pstmtGetMessageCount.setLong(2, wsid);
            pstmtGetMessageCount.setInt(3, state);
            rs = pstmtGetMessageCount.executeQuery();
            while (rs.next()) {
                String msgName = rs.getString(1);
                int count = rs.getInt(2);
                messageCounts.put(msgName, count);
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(rs, (Statement)pstmtGetMessageCount, (Connection)conn);
            }
        }
        BLMessagesDAO.clean((ResultSet)rs, (Statement)pstmtGetMessageCount, (Connection)conn);
        return messageCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getMessageList(long piid, long wsid, int loopCounter) {
        ArrayList<BLBizMessage> messageList = new ArrayList<BLBizMessage>();
        Connection conn = null;
        PreparedStatement pstmtGetMessageList = null;
        ResultSet rs = null;
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtGetMessageList = conn.prepareStatement(getMessageList);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getMessageList, new Object[0]);
            }
            pstmtGetMessageList.setLong(1, piid);
            pstmtGetMessageList.setLong(2, wsid);
            pstmtGetMessageList.setInt(3, loopCounter);
            rs = pstmtGetMessageList.executeQuery();
            while (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                BLBizMessage message = (BLBizMessage)BLMessagesDAO.convertToObject((InputStream)is);
                messageList.add(message);
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(rs, (Statement)pstmtGetMessageList, (Connection)conn);
            }
        }
        BLMessagesDAO.clean((ResultSet)rs, (Statement)pstmtGetMessageList, (Connection)conn);
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(long piid, long wsid, int loopCounter) {
        Connection conn = null;
        PreparedStatement pstmtRemoveMessage = null;
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtRemoveMessage = conn.prepareStatement(removeTargets);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeTargets, new Object[0]);
            }
            pstmtRemoveMessage.setLong(1, piid);
            pstmtRemoveMessage.setLong(2, wsid);
            pstmtRemoveMessage.setLong(3, loopCounter);
            pstmtRemoveMessage.executeUpdate();
        }
        catch (Throwable th) {
            BLMessagesDAO.handle((Throwable)th);
        }
        finally {
            BLMessagesDAO.clean(null, (Statement)pstmtRemoveMessage, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByMessageNames(long piid, long wsid, int loopCounter, String[] msgNames) {
        Connection conn = null;
        PreparedStatement pstmtRemoveMessage = null;
        StringBuilder sb = new StringBuilder(removeByMessageNames);
        sb.append(BLMessagesDAO.getSQLCondition((String[])msgNames));
        sb.append(")");
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtRemoveMessage = conn.prepareStatement(sb.toString());
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", sb.toString(), new Object[0]);
            }
            pstmtRemoveMessage.setLong(1, piid);
            pstmtRemoveMessage.setLong(2, wsid);
            pstmtRemoveMessage.setLong(3, loopCounter);
            pstmtRemoveMessage.executeUpdate();
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                BLMessagesDAO.clean(null, pstmtRemoveMessage, (Connection)conn);
                throw throwable;
            }
            BLMessagesDAO.clean(null, (Statement)pstmtRemoveMessage, (Connection)conn);
        }
        BLMessagesDAO.clean(null, (Statement)pstmtRemoveMessage, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeByProcessInstance(long piid) {
        Connection conn = null;
        PreparedStatement pstmtRemoveByProcessInstance = null;
        PreparedStatement pstmtRemoveMessages = null;
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtRemoveByProcessInstance = conn.prepareStatement(removeByProcessInstance);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeByProcessInstance, new Object[0]);
            }
            pstmtRemoveByProcessInstance.setLong(1, piid);
            pstmtRemoveByProcessInstance.executeUpdate();
            pstmtRemoveMessages = conn.prepareStatement(removeMessages);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", removeMessages, new Object[0]);
            }
            pstmtRemoveMessages.executeUpdate();
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, null);
                BLMessagesDAO.clean(null, pstmtRemoveMessages, (Connection)conn);
            }
        }
        BLMessagesDAO.clean(null, (Statement)pstmtRemoveByProcessInstance, null);
        BLMessagesDAO.clean(null, (Statement)pstmtRemoveMessages, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<Long>> getWaitingSubscribersWithMessages() {
        HashMap<Long, List<Long>> subscribers = new HashMap<Long, List<Long>>();
        Connection conn = null;
        PreparedStatement pstmtGetWaitingSubscribers = null;
        ResultSet rs = null;
        try {
            conn = BLMessagesDAO.getConnection();
            pstmtGetWaitingSubscribers = conn.prepareStatement(getWaitingSubscribersWithMessages);
            BLConstants.single();
            pstmtGetWaitingSubscribers.setLong(1, 60L);
            rs = pstmtGetWaitingSubscribers.executeQuery();
            while (rs.next()) {
                long piid = rs.getLong(1);
                long wsid = rs.getLong(2);
                ArrayList<Long> worksteps = (ArrayList<Long>)subscribers.get(piid);
                if (worksteps == null) {
                    worksteps = new ArrayList<Long>();
                    subscribers.put(piid, worksteps);
                }
                worksteps.add(wsid);
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(rs, (Statement)pstmtGetWaitingSubscribers, (Connection)conn);
            }
        }
        BLMessagesDAO.clean((ResultSet)rs, (Statement)pstmtGetWaitingSubscribers, (Connection)conn);
        return subscribers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HashMap<String, Object>> getWorkstepMessages(long piid) {
        ArrayList<HashMap<String, Object>> messageList = new ArrayList<HashMap<String, Object>>();
        Connection conn = null;
        PreparedStatement pstmtGetWorkstepMessages = null;
        ResultSet rs = null;
        try {
            StringBuilder sb = new StringBuilder(getWorkstepMessagesPart1);
            if (piid > 0L) {
                Object[] objectArray = new Object[2];
                DBConstants.TableAliasConstants cfr_ignored_0 = BLControl.dbconsts.tabalias;
                objectArray[0] = "BLWSMSG";
                DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
                objectArray[1] = "PROCESS_INSTANCE_ID";
                sb.append(BLMessagesDAO.composeSQL((String)" %s.%s = ? AND ", (Object[])objectArray));
            }
            sb.append(getWorkstepMessagesPart2);
            conn = BLMessagesDAO.getConnection();
            String getWorkstepMessages = sb.toString();
            pstmtGetWorkstepMessages = conn.prepareStatement(getWorkstepMessages);
            if (BLControl.util.DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_1185", getWorkstepMessages, new Object[0]);
            }
            if (piid > 0L) {
                pstmtGetWorkstepMessages.setLong(1, piid);
            }
            rs = pstmtGetWorkstepMessages.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("PROCESSTEMPLATEID", rs.getLong(1));
                hm.put("PROCESSINSTANCEID", rs.getLong(2));
                hm.put("WORKSTEPID", rs.getLong(3));
                hm.put("MESSAGE_ID", rs.getLong(4));
                hm.put("MESSAGE_NAME", rs.getString(5));
                messageList.add(hm);
            }
        }
        catch (Throwable th) {
            try {
                BLMessagesDAO.handle((Throwable)th);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BLMessagesDAO.clean(rs, pstmtGetWorkstepMessages, conn);
            }
        }
        BLMessagesDAO.clean((ResultSet)rs, (Statement)pstmtGetWorkstepMessages, (Connection)conn);
        return messageList;
    }

    public static synchronized void initSQLStatements() {
        BLMessagesDAO.initSQLStatementCreateMessage();
        BLMessagesDAO.initSQLStatementCreateMessageWS();
        BLMessagesDAO.initSQLStatementCreateDiscardMessage();
        BLMessagesDAO.initSQLStatementGetMessageList();
        String getMessageCountWithoutGroupBy = BLMessagesDAO.createGetMessageCountWithoutGroupBy();
        BLMessagesDAO.initSQLStatementGetMessageCountWithLoopCounter();
        BLMessagesDAO.initSQLStatementGetMessageCount(getMessageCountWithoutGroupBy);
        BLMessagesDAO.initSQLStatementGetMessageCountByState(getMessageCountWithoutGroupBy);
        BLMessagesDAO.initSQLStatementRemoveTargets();
        BLMessagesDAO.initSQLStatementRemoveMessages();
        BLMessagesDAO.initSQLStatementRemoveByProcessInstance();
        BLMessagesDAO.initSQLStatementRemoveByMessageNames();
        BLMessagesDAO.initSQLStatementGetWorkstepMessagesPart1();
        BLMessagesDAO.initSQLStatementGetWorkstepMessagesPart2();
        BLMessagesDAO.initSQLStatementGetWaitingSubscribersWithMessages();
        BLMessagesDAO.printSQLStatements();
    }

    private static void initSQLStatementCreateMessage() {
        createMessage = BLMessagesDAO.composeInsertStatement((String)"BIZLOGIC_MESSAGES", (String[])CREATEMESSAGE_TABLELIST);
    }

    private static void initSQLStatementCreateMessageWS() {
        createMessageWS = BLMessagesDAO.composeInsertStatement((String)"BIZLOGIC_WORKSTEP_MESSAGES", (String[])CREATEMESSAGE_WS_TABLELIST);
    }

    private static void initSQLStatementCreateDiscardMessage() {
        createDiscardMessage = BLMessagesDAO.composeInsertStatement((String)"BIZLOGIC_DISCARDED_MESSAGES", (String[])CREATE_DISCARDMESSAGE_TABLELIST);
    }

    private static void initSQLStatementGetMessageList() {
        getMessageList = BLMessagesDAO.composeSQL((String)GET_MESSAGE_LIST_FORMAT, (Object[])new Object[]{" SELECT ", "BLMSG", "MESSAGE", BLMessagesDAO.composeFromStatement((String[])new String[]{"BIZLOGIC_MESSAGES", "BIZLOGIC_WORKSTEP_MESSAGES"}, (String[])new String[]{"BLMSG", "BLWSMSG"}), " WHERE ", "BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", "BLWSMSG", "LOOPCOUNTER", "BLMSG", "MESSAGE_ID", "BLWSMSG", "MESSAGE_ID", "BLMSG", "MESSAGE_ID"});
    }

    private static String createGetMessageCountWithoutGroupBy() {
        return BLMessagesDAO.composeSQL((String)GET_MESSAGE_COUNT_WITHOUT_GROUP_BY_FORMAT, (Object[])new Object[]{" SELECT ", "MESSAGE_NAME", BLMessagesDAO.composeFromStatement((String[])new String[]{"BIZLOGIC_MESSAGES", "BIZLOGIC_WORKSTEP_MESSAGES", "BIZLOGIC_WORKSTEPINSTANCE"}, (String[])new String[]{"BLMSG", "BLWSMSG", "BLWSI"}), " WHERE ", "BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", "BLMSG", "MESSAGE_ID", "BLWSMSG", "MESSAGE_ID", "BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSI", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", "BLWSI", "WORKSTEP_ID", "BLWSMSG", "LOOPCOUNTER", "BLWSI", "LOOPCOUNTER"});
    }

    private static void initSQLStatementGetMessageCountWithLoopCounter() {
        String messageCountWithLoopCounterFrom = BLMessagesDAO.composeFromStatement((String[])new String[]{"BIZLOGIC_MESSAGES", "BIZLOGIC_WORKSTEP_MESSAGES"}, (String[])new String[]{"BLMSG", "BLWSMSG"});
        getMessageCountWithLoopCounter = BLMessagesDAO.composeSQL((String)GET_MESSAGE_COUNT_WITH_LOOP_COUNTER, (Object[])new Object[]{" SELECT ", "MESSAGE_NAME", messageCountWithLoopCounterFrom, " WHERE ", "BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", "BLWSMSG", "LOOPCOUNTER", "BLMSG", "MESSAGE_ID", "BLWSMSG", "MESSAGE_ID", "MESSAGE_NAME"});
    }

    private static void initSQLStatementGetMessageCount(String getMessageCountWithoutGroupBy) {
        getMessageCount = BLMessagesDAO.composeSQL((String)GET_MESSAGE_COUNT_FORMAT, (Object[])new Object[]{getMessageCountWithoutGroupBy, "MESSAGE_NAME"});
    }

    private static void initSQLStatementGetMessageCountByState(String getMessageCountWithoutGroupBy) {
        getMessageCountByState = BLMessagesDAO.composeSQL((String)GET_MESSAGE_COUNT_BY_STATE, (Object[])new Object[]{getMessageCountWithoutGroupBy, "BLWSI", "STATUS", "MESSAGE_NAME"});
    }

    private static void initSQLStatementRemoveTargets() {
        removeTargets = BLMessagesDAO.composeRemoveStatement((String)"BIZLOGIC_WORKSTEP_MESSAGES", (String[])new String[]{"PROCESS_INSTANCE_ID", "WORKSTEP_ID", "LOOPCOUNTER"});
    }

    private static void initSQLStatementRemoveMessages() {
        removeMessages = BLMessagesDAO.composeSQL((String)REMOVE_MESSAGES_FORMAT, (Object[])new Object[]{BLMessagesDAO.composeRemoveStatement((String)"BIZLOGIC_MESSAGES", (String[])new String[0]), " WHERE ", "MESSAGE_ID", BLMessagesDAO.composeSQL((String)SELECT_DISTINCT_FROM, (Object[])new Object[]{"MESSAGE_ID", "BIZLOGIC_WORKSTEP_MESSAGES"})});
    }

    private static void initSQLStatementRemoveByProcessInstance() {
        removeByProcessInstance = BLMessagesDAO.composeRemoveStatement((String)"BIZLOGIC_WORKSTEP_MESSAGES", (String[])new String[]{"PROCESS_INSTANCE_ID"});
    }

    private static void initSQLStatementRemoveByMessageNames() {
        removeByMessageNames = BLMessagesDAO.composeSQL((String)REMOVE_BY_MESSAGE_NAMES_FORMAT, (Object[])new Object[]{BLMessagesDAO.composeRemoveStatement((String)"BIZLOGIC_WORKSTEP_MESSAGES", (String[])new String[]{"PROCESS_INSTANCE_ID", "WORKSTEP_ID", "LOOPCOUNTER"}), "MESSAGE_ID", "MESSAGE_ID", "BIZLOGIC_MESSAGES", "MESSAGE_NAME"});
    }

    private static void initSQLStatementGetWorkstepMessagesPart1() {
        getWorkstepMessagesPart1 = BLMessagesDAO.composeSQL((String)GET_WORKSTEP_MESSAGES_PART1_FORMAT, (Object[])new Object[]{"BLPI", "PROCESS_TEMPLATE_ID", "BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", "BLWSMSG", "MESSAGE_ID", "BLMSG", "MESSAGE_NAME", "BIZLOGIC_PROCESSINSTANCE", "BLPI", "BIZLOGIC_WORKSTEP_MESSAGES", "BLWSMSG", "BIZLOGIC_MESSAGES", "BLMSG"});
    }

    private static void initSQLStatementGetWorkstepMessagesPart2() {
        getWorkstepMessagesPart2 = BLMessagesDAO.composeSQL((String)GET_WORKSTEP_MESSAGES_PART2_FORMAT, (Object[])new Object[]{"BLWSMSG", "PROCESS_INSTANCE_ID", "BLPI", "PROCESS_INSTANCE_ID", "BLWSMSG", "MESSAGE_ID", "BLMSG", "MESSAGE_ID", "BLPI", "PROCESS_TEMPLATE_ID", "BLWSMSG", "PROCESS_INSTANCE_ID"});
    }

    private static void initSQLStatementGetWaitingSubscribersWithMessages() {
        String fromClause = BLMessagesDAO.composeFromStatement((String[])new String[]{"BIZLOGIC_WORKSTEPINSTANCE", "BIZLOGIC_WORKSTEP_MESSAGES"}, (String[])new String[]{"BLWSI", "BLWSMSG"});
        getWaitingSubscribersWithMessages = BLMessagesDAO.composeSQL((String)GET_WAITING_SUBSCRIBERS_WITH_MESSAGES_FORMAT, (Object[])new Object[]{"BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", fromClause, " WHERE ", "BLWSMSG", "PROCESS_INSTANCE_ID", "BLWSI", "PROCESS_INSTANCE_ID", "BLWSMSG", "WORKSTEP_ID", "BLWSI", "WORKSTEP_ID", "BLWSMSG", "LOOPCOUNTER", "BLWSI", "LOOPCOUNTER", "BLWSI", "STATUS"});
    }

    private static void printSQLStatements() {
        if (BLControl.util.DEBUG_DAO) {
            BLControl.logger.debug((Object)"BLMessagesDAO:");
            BLControl.logger.debugKey("BizLogic_ERR_1199", createMessage, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createMessageWS, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", createDiscardMessage, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMessageList, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMessageCount, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMessageCountWithLoopCounter, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getMessageCountByState, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeMessages, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeTargets, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByProcessInstance, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", removeByMessageNames, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWorkstepMessagesPart1 + getWorkstepMessagesPart2, new Object[0]);
            BLControl.logger.debugKey("BizLogic_ERR_1199", getWaitingSubscribersWithMessages, new Object[0]);
        }
    }

    private static String getValueBySize(String value, int maxSize) {
        if (value == null || value.trim().length() == 0 || value.trim().length() <= maxSize) {
            return value;
        }
        return value.substring(0, maxSize);
    }

    static {
        String[] stringArray = new String[3];
        DBConstants.ColConstants cfr_ignored_0 = BLControl.dbconsts.col;
        stringArray[0] = "MESSAGE_ID";
        DBConstants.ColConstants cfr_ignored_1 = BLControl.dbconsts.col;
        stringArray[1] = "MESSAGE_NAME";
        DBConstants.ColConstants cfr_ignored_2 = BLControl.dbconsts.col;
        stringArray[2] = "MESSAGE";
        CREATEMESSAGE_TABLELIST = stringArray;
        String[] stringArray2 = new String[4];
        DBConstants.ColConstants cfr_ignored_3 = BLControl.dbconsts.col;
        stringArray2[0] = "PROCESS_INSTANCE_ID";
        DBConstants.ColConstants cfr_ignored_4 = BLControl.dbconsts.col;
        stringArray2[1] = "WORKSTEP_ID";
        DBConstants.ColConstants cfr_ignored_5 = BLControl.dbconsts.col;
        stringArray2[2] = "LOOPCOUNTER";
        DBConstants.ColConstants cfr_ignored_6 = BLControl.dbconsts.col;
        stringArray2[3] = "MESSAGE_ID";
        CREATEMESSAGE_WS_TABLELIST = stringArray2;
        String[] stringArray3 = new String[4];
        DBConstants.ColConstants cfr_ignored_7 = BLControl.dbconsts.col;
        stringArray3[0] = "MESSAGE_NAME";
        DBConstants.ColConstants cfr_ignored_8 = BLControl.dbconsts.col;
        stringArray3[1] = "MESSAGE";
        DBConstants.ColConstants cfr_ignored_9 = BLControl.dbconsts.col;
        stringArray3[2] = "REASON";
        DBConstants.ColConstants cfr_ignored_10 = BLControl.dbconsts.col;
        stringArray3[3] = "EX_STACK_TRACE";
        CREATE_DISCARDMESSAGE_TABLELIST = stringArray3;
    }
}

