/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.messaging.subscriber;

import com.savvion.sbm.bizlogic.messaging.BLMessageException;
import com.savvion.sbm.bizlogic.messaging.MsgErrorHandler;
import com.savvion.sbm.bizlogic.messaging.subscriber.BizMessage;
import com.savvion.sbm.messaging.core.MDService;
import com.savvion.sbm.messaging.svo.MessageDescriptor;
import com.savvion.sbm.messaging.svo.MessageProperty;
import com.savvion.sbm.util.jax.XMLUtil;
import com.savvion.sbm.util.jax.XPathUtil;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Document;

public abstract class BLBizMessage
implements BizMessage {
    static final long serialVersionUID = 8962403666079845519L;
    private transient MessageDescriptor msgDescr;
    private transient Document payloadDoc;
    protected long id = -1L;

    public abstract boolean isSerializable();

    @Override
    public MessageDescriptor getMessageDescriptor() {
        if (this.msgDescr == null) {
            String msgName = this.getMessageName();
            this.msgDescr = MDService.self().getMessageDescriptor(msgName);
        }
        return this.msgDescr;
    }

    protected String evaluateXPath(String propName) {
        MessageProperty msgProp = this.getMessageDescriptor().getProperty(propName);
        if (msgProp == null) {
            return null;
        }
        String xpath = msgProp.getXPath();
        if (xpath == null || xpath.trim().length() == 0 || !xpath.startsWith("/")) {
            return null;
        }
        String payload = this.getPayload();
        try {
            if (payload != null) {
                return XPathUtil.evaluateToString((Document)this.getPayloadDocument(), (String)xpath, (Map)this.getMessageDescriptor().getNamespaces(), (QName)XPathConstants.NODESET);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    protected Document getPayloadDocument() throws Exception {
        if (this.payloadDoc != null) {
            return this.payloadDoc;
        }
        String payload = this.getPayload();
        this.payloadDoc = XMLUtil.getDocument((String)payload, (boolean)false);
        return this.payloadDoc;
    }

    protected BLMessageException propertyNotFound(String propType, String propName, Exception ex) {
        return MsgErrorHandler.createEx("BizLogic_ERR_3610", "BizJMSMessage.propertyNotFound", new Object[]{propType, propName, this.getMessageName()}, ex);
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }
}

