/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.svo.Application;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.SBMUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationManager {
    public static ProcessTemplate createVersionAndGetTemplate(Session session, String xmlDefinition, boolean activate) {
        WFProcess pt = ApplicationManager.createAppVersion(session, xmlDefinition, activate);
        return ApplicationManager.getActiveVersion(session, pt.getAppName());
    }

    public static Application createVersion(Session session, String xmlDefinition, boolean activate) {
        WFProcess pt = ApplicationManager.createAppVersion(session, xmlDefinition, activate);
        return ApplicationManager.getApplication(session, pt.getAppName());
    }

    private static WFProcess createAppVersion(Session session, String xmlDefinition, boolean activate) {
        long newptID = ProcessControl.createProcessTemplate(session, xmlDefinition, false);
        WFProcess newPT = ProcessControl.getProcessTemplate(newptID);
        String appName = newPT.getAppName();
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("Bizlogic_ERR_3206", "ApplicationManager.createVersion", new Object[]{newPT.getName(), newptID, appName});
        }
        ProcessControl.removeProcessTemplateFromCache(newptID);
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("Bizlogic_ERR_3207", "ApplicationManager.createVersion", new Object[]{newPT.getName(), new Long(newptID), appName});
        }
        if (ApplicationManager.isApplicationExist(appName)) {
            Application appsvo = ApplicationManager.getApplication(session, appName);
            ProcessTemplate lastVersion = appsvo.getLastVersion();
            long lastVersionID = lastVersion.getID();
            WFProcess lastVersionPT = ProcessControl.getProcessTemplate(lastVersionID);
            if (BLControl.util.DEBUG_CREATE) {
                BLControl.logger.debugKey("Bizlogic_ERR_3210", "ApplicationManager.createVersion", new Object[]{lastVersionPT.getName(), new Long(lastVersionID)});
            }
            if (lastVersionPT.isActivated() || lastVersionPT.isSuspendedBySeqVersion()) {
                if (lastVersionPT.isActivated()) {
                    ProcessControl.suspendProcessTemplateBySeqVer(lastVersionID);
                    if (BLControl.util.DEBUG_CREATE) {
                        BLControl.logger.debugKey("Bizlogic_ERR_3211", "ApplicationManager.createVersion", new Object[]{lastVersionPT.getName(), new Long(lastVersionID)});
                    }
                }
                newPT.setParentID(lastVersionID);
            } else {
                throw new BizLogicException("Bizlogic_ERR_3718", "ApplicationManager.createVersion", new Object[]{lastVersion.getName(), appName, lastVersion.getStateDescription()});
            }
        }
        ProcessControl.addProcessTemplateToCache(newptID, newPT);
        if (activate) {
            ProcessControl.activateProcessTemplate(newptID);
        }
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("Bizlogic_ERR_3212", "ApplicationManager.createVersion", new Object[]{newPT.getName(), new Long(newptID), appName});
        }
        return newPT;
    }

    public static Map getCommonDataSlots(Session session, String appName) {
        Map commonDS = new HashMap();
        Application app = SVOFactory.getApplication(session, appName);
        long[] ptIDs = app.getProcessTemplateIDs();
        if (ptIDs == null || ptIDs.length == 0) {
            return commonDS;
        }
        if (ptIDs.length == 1) {
            return ProcessControl.getProcessTemplate(ptIDs[0]).getDataSlotsType();
        }
        Map previousMap = null;
        HashMap currentMap = null;
        for (int idx = 0; idx < ptIDs.length; ++idx) {
            WFProcess pt = ProcessControl.getProcessTemplate(ptIDs[idx]);
            if (idx == 0) {
                previousMap = pt.getDataSlotsType();
                continue;
            }
            currentMap = pt.getDataSlotsType();
            commonDS = SBMUtil.getCommonEntries((Map)previousMap, (Map)currentMap);
            if (commonDS.isEmpty()) {
                return commonDS;
            }
            previousMap = commonDS;
        }
        return commonDS;
    }

    public static Application getApplication(Session session, String appName) {
        return SVOFactory.getApplication(session, appName);
    }

    public static ArrayList getApplicationList(Session session) {
        return SVOFactory.getApplicationList(session);
    }

    public static boolean isApplicationExist(String appName) {
        if (appName == null) {
            if (BLControl.util.DEBUG_CREATE) {
                BLControl.logger.debugKey("Bizlogic_ERR_3208", "ApplicationManager.isApplicationExist", new Object[]{appName});
            }
            return false;
        }
        Collection ptCollection = ProcessControl.getVersions(appName);
        if (ptCollection == null || ptCollection.isEmpty()) {
            if (BLControl.util.DEBUG_CREATE) {
                BLControl.logger.debugKey("Bizlogic_ERR_3208", "ApplicationManager.isApplicationExist", new Object[]{appName});
            }
            return false;
        }
        if (BLControl.util.DEBUG_CREATE) {
            BLControl.logger.debugKey("Bizlogic_ERR_3209", "ApplicationManager.isApplicationExist", new Object[]{appName});
        }
        return true;
    }

    public static ProcessTemplate getActiveVersion(Session session, String appName) {
        WFProcess activePT = ProcessControl.getActiveProcessTemplate(appName);
        if (activePT == null) {
            return null;
        }
        return SVOFactory.getProcessTemplate(session, activePT);
    }

    public static Map<String, Map<String, List<WorkStepTemplate>>> getWorkstepTemplates(Session session, int wsType) {
        HashMap<String, Map<String, List<WorkStepTemplate>>> appWorksteps = new HashMap<String, Map<String, List<WorkStepTemplate>>>();
        ArrayList appNames = new ArrayList(ProcessControl.getAppNames());
        for (String appName : appNames) {
            Map<String, List<WorkStepTemplate>> ptWorksteps = ApplicationManager.getWorkstepTemplates(session, appName, wsType);
            appWorksteps.put(appName, ptWorksteps);
        }
        return appWorksteps;
    }

    public static Map<String, List<WorkStepTemplate>> getWorkstepTemplates(Session session, String appName, int wsType) {
        if (appName == null || appName.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4629", "ApplicationManager.getWorkstepTemplates");
        }
        if (!BLClientUtil.self().isValidWSType(wsType)) {
            throw new BizLogicException("BizLogic_ERR_4701", "ApplicationManager.getWorkstepTemplates", new Object[]{wsType});
        }
        HashMap<String, List<WorkStepTemplate>> ptWorksteps = new HashMap<String, List<WorkStepTemplate>>();
        List<WFProcess> ptList = ProcessControl.getAllProcessTemplates(appName);
        for (WFProcess pt : ptList) {
            String ptName = pt.getName();
            List<WorkStepTemplate> worksteps = SVOFactory.getWorkStepTemplateList(session, pt, wsType);
            ptWorksteps.put(ptName, worksteps);
        }
        return ptWorksteps;
    }
}

