/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.ObjectSqlMap;
import com.savvion.sbm.bizlogic.server.SqlQueryMap;
import com.savvion.sbm.bizlogic.server.WFDataslot;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.dao.BODAO;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.IBatisHandler;
import com.savvion.sbm.util.SBMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BOManager {
    private static BOManager self = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BOManager self() {
        if (self != null) return self;
        Class<BOManager> clazz = BOManager.class;
        synchronized (BOManager.class) {
            if (self != null) return self;
            self = new BOManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    private BOManager() {
    }

    private static IBatisHandler getIBatis(WFProcessContext pctx) {
        try {
            return IBatisHandler.getInstance((WFProcessContext)pctx);
        }
        catch (RuntimeException ex) {
            BLControl.logger.error((Object)ex);
            throw ex;
        }
    }

    public static synchronized void refresh() {
        self = null;
        IBatisHandler.clean();
    }

    public static synchronized void clean() {
        self = null;
        IBatisHandler.clean();
    }

    private static void invokeInsertQuery(WFProcessContext pCtx, SqlQueryMap sqm) throws Exception {
        Map params = BOManager.getQueryInputParams(pCtx, sqm);
        String sqlId = sqm.getSqlId();
        if (sqm.isPKAutoGenerated()) {
            BOManager.executeJDBCInsert(pCtx, sqm, params);
        } else {
            BOManager.getIBatis(pCtx).getSqlMap().insert(sqlId, (Object)params);
        }
    }

    private static void invokeInsertQuery(WFProcessContext pCtx, SqlQueryMap sqm, Object value) throws Exception {
        BOManager.validatePassedBO(sqm, value);
        String sqlId = sqm.getSqlId();
        if (sqm.isPKAutoGenerated()) {
            BOManager.executeJDBCInsert(pCtx, sqm, value);
        } else {
            BOManager.getIBatis(pCtx).getSqlMap().insert(sqlId, value);
        }
    }

    private static void validatePassedBO(SqlQueryMap sqm, Object value) throws Exception {
        if (value == null) {
            throw new BizLogicException("BizLogic_ERR_4653", "BOManager.validatePassedBO()");
        }
        String parameterClassStr = sqm.getParameterClass();
        Class<?> parameterClass = Class.forName(parameterClassStr, true, BOManager.class.getClassLoader());
        boolean isInstance = parameterClass.isInstance(value);
        if (!isInstance) {
            throw new BizLogicException("BizLogic_ERR_4654", "BOManager.validatePassedBO()", new Object[]{value.getClass().getName(), parameterClassStr.trim()});
        }
    }

    private static void executeJDBCInsert(WFProcessContext pCtx, SqlQueryMap sqm, Object paramObj) {
        Map qParamMap = BOManager.getIBatis(pCtx).getSqlAndParams(sqm.getSqlId(), paramObj);
        String autoGenColumn = sqm.getPKColumnName();
        String pkMappedDSName = sqm.getPKMappedDataSlotName();
        long autoGeneratedPK = BODAO.executeInsert(qParamMap, autoGenColumn);
        pCtx.updateSlotValue(pkMappedDSName, autoGeneratedPK);
    }

    private static Object invokeSelectQuery(WFProcessContext pCtx, SqlQueryMap sqm, String javaClassName) throws Exception {
        Map params = BOManager.getQueryInputParams(pCtx, sqm);
        String sqlId = sqm.getSqlId();
        return BOManager.getIBatis(pCtx).getSqlMap().queryForObject(sqlId, (Object)params, BOManager.createNewInstance(javaClassName));
    }

    private static Object createNewInstance(String javaClassName) throws Exception {
        Class<?> resultClass = Class.forName(javaClassName, true, BOManager.class.getClassLoader());
        return resultClass.newInstance();
    }

    private static Object invokeDefaultSelectQuery(WFProcessContext pCtx, ObjectSqlMap osm, String javaClassName) throws Exception {
        Object result = null;
        SqlQueryMap sqm = osm.getDefaultSelectQuery();
        if (sqm != null) {
            result = BOManager.invokeSelectQuery(pCtx, sqm, javaClassName);
        }
        return result;
    }

    private static void invokeUpdateQuery(WFProcessContext pCtx, SqlQueryMap sqm, Object value) throws Exception {
        String sqlId = sqm.getSqlId();
        BOManager.getIBatis(pCtx).getSqlMap().update(sqlId, value);
    }

    private static void invokeDefaultUpdateQuery(WFProcessContext pCtx, ObjectSqlMap osm, Object value) throws Exception {
        SqlQueryMap sqm = osm.getDefaultUpdateQuery();
        BOManager.invokeUpdateQuery(pCtx, sqm, value);
    }

    private static void invokeDeleteQuery(WFProcessContext pCtx, SqlQueryMap sqm) throws Exception {
        Map params = BOManager.getQueryInputParams(pCtx, sqm);
        String sqlId = sqm.getSqlId();
        BOManager.getIBatis(pCtx).getSqlMap().delete(sqlId, (Object)params);
    }

    private static void invokeDefaultDeleteQuery(WFProcessContext pCtx, ObjectSqlMap osm) throws Exception {
        SqlQueryMap sqm = osm.getDefaultDeleteQuery();
        if (sqm != null) {
            BOManager.invokeDeleteQuery(pCtx, sqm);
        }
    }

    private static Map getQueryInputParams(WFProcessContext pCtx, SqlQueryMap sqm) {
        Map params = sqm.getParams();
        String[] mappedDS = sqm.getMappedValueList();
        if (params == null || mappedDS == null || mappedDS.length == 0) {
            return params;
        }
        HashMap mapValues = pCtx.getSlotValue(mappedDS);
        for (Map.Entry entry : params.entrySet()) {
            String sval;
            String pName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || !(value instanceof String) || !BLUtil.isParameter((String)(sval = (String)value)) || sval.length() <= 1) continue;
            sval = BLUtil.getParameter((String)sval);
            Object mapValue = mapValues.get(sval);
            params.put(pName, mapValue);
        }
        if (BLUtil.self().isDebugBizObject()) {
            BLControl.logger.debugKey("BizLogic_ERR_3526", new Object[]{sqm.getSqlId(), pCtx.getProcessInstanceID(), params});
        }
        return params;
    }

    void createSqlObjects(WFProcessContext pCtx, HashMap sqlObjects) {
        for (Map.Entry entry : sqlObjects.entrySet()) {
            SqlQueryMap sqm;
            String dsName = (String)entry.getKey();
            Object dsValue = entry.getValue();
            WFDataslot ds = pCtx.getProcess().getDataslot(dsName);
            if (!ds.isObject() || !ds.isSqlMap() || (sqm = ds.getSqlMap().getDefaultInsertQuery()) == null) continue;
            try {
                String parameterClass = sqm.getParameterClass();
                if (parameterClass != null && parameterClass.trim().length() > 0) {
                    BOManager.invokeInsertQuery(pCtx, sqm, dsValue);
                } else {
                    BOManager.invokeInsertQuery(pCtx, sqm);
                }
            }
            catch (Exception ex) {
                throw BOManager.createException(pCtx, ds, sqm, "BizLogic_ERR_3528", ex);
            }
            if (!BLUtil.self().isDebugBizObject()) continue;
            BOManager.printDebugMsg(pCtx, ds, sqm, "BizLogic_ERR_3527");
        }
    }

    Object getSqlObject(WFProcessContext pCtx, WFDataslot ds) {
        SqlQueryMap sqm;
        Object value = null;
        if (ds.isSqlMap() && (sqm = ds.getSqlMap().getDefaultSelectQuery()) != null) {
            try {
                value = BOManager.invokeSelectQuery(pCtx, sqm, ds.getJavaClassName());
            }
            catch (Exception ex) {
                throw BOManager.createException(pCtx, ds, sqm, "BizLogic_ERR_3528", ex);
            }
            if (BLUtil.self().isDebugBizObject()) {
                BOManager.printDebugMsg(pCtx, ds, sqm, "BizLogic_ERR_3527");
            }
        }
        return value;
    }

    Object getSqlObject(WFProcessContext pCtx, WFDataslot ds, long wsid) {
        String sqlId = null;
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (ws != null) {
            sqlId = ws.getInputSlotQueryId(ds.getName());
        }
        if (ds.isSqlMap()) {
            SqlQueryMap sqm = null;
            sqm = sqlId != null ? ds.getSqlMap().getQueryMap(sqlId) : ds.getSqlMap().getDefaultSelectQuery();
            if (sqm != null) {
                Object value = null;
                try {
                    value = BOManager.invokeSelectQuery(pCtx, sqm, ds.getJavaClassName());
                }
                catch (Exception ex) {
                    throw BOManager.createException(pCtx, ds, sqm, "BizLogic_ERR_3528", ex);
                }
                if (BLUtil.self().isDebugBizObject()) {
                    BOManager.printDebugMsg(pCtx, ds, sqm, "BizLogic_ERR_3527");
                }
                return value;
            }
        }
        return null;
    }

    boolean updateSqlObject(WFProcessContext pCtx, long wsid, WFDataslot ds, Object value) {
        String sqlId = null;
        WFWorkstep ws = pCtx.getCurrentWorkStep();
        if (ws == null && wsid > 0L) {
            ws = pCtx.getWorkstep(wsid);
        }
        if (ws != null) {
            sqlId = ws.getOutputSlotQueryId(ds.getName());
        }
        if (ds.isSqlMap()) {
            SqlQueryMap sqm = null;
            sqm = sqlId != null ? ds.getSqlMap().getQueryMap(sqlId) : ds.getSqlMap().getDefaultUpdateQuery();
            if (sqm != null) {
                try {
                    BOManager.invokeUpdateQuery(pCtx, sqm, value);
                }
                catch (Exception ex) {
                    throw BOManager.createException(pCtx, ds, sqm, "BizLogic_ERR_3528", ex);
                }
                if (BLUtil.self().isDebugBizObject()) {
                    BOManager.printDebugMsg(pCtx, ds, sqm, "BizLogic_ERR_3527");
                }
                return true;
            }
        }
        return false;
    }

    void deleteInstanceSqlObjects(WFProcessContext pCtx) {
        ArrayList dslist = pCtx.getProcess().getInstanceObjectDataSlots();
        for (int ix = 0; ix < dslist.size(); ++ix) {
            SqlQueryMap sqm;
            WFDataslot ds = (WFDataslot)dslist.get(ix);
            if (!ds.isSqlMap() || (sqm = ds.getSqlMap().getDefaultDeleteQuery()) == null) continue;
            try {
                BOManager.invokeDeleteQuery(pCtx, sqm);
            }
            catch (Exception ex) {
                throw BOManager.createException(pCtx, ds, sqm, "BizLogic_ERR_3528", ex);
            }
            if (!BLUtil.self().isDebugBizObject()) continue;
            BOManager.printDebugMsg(pCtx, ds, sqm, "BizLogic_ERR_3527");
        }
    }

    private static final BizLogicException createException(WFProcessContext pCtx, WFDataslot ds, SqlQueryMap sqm, String msgId, Throwable tex) {
        String msg = BOManager.getMessage(pCtx, ds, sqm, msgId);
        if (tex != null) {
            String stackTrace = SBMUtil.getStackTrace((Throwable)tex);
            msg = msg + " NestedException:\n" + stackTrace;
        }
        BizLogicException bex = new BizLogicException(msg);
        return bex;
    }

    private static final String getMessage(WFProcessContext pCtx, WFDataslot ds, SqlQueryMap sqm, String msgId) {
        Long piid = pCtx.getProcessInstanceID();
        WFWorkstep ws = pCtx.getCurrentWorkStep();
        String wsName = "";
        if (ws != null) {
            wsName = ws.getName();
        }
        Object[] bctx = new Object[]{sqm.getSqlId(), piid, wsName, ds.getName()};
        String msg = null;
        try {
            msg = BLUtil.getMessage((String)msgId, (Object[])bctx);
        }
        catch (Throwable th) {
            msg = "Failed to get msgkey: " + msgId + "    " + SBMUtil.getStackTrace((Throwable)th);
        }
        return msg;
    }

    private static final void printDebugMsg(WFProcessContext pCtx, WFDataslot ds, SqlQueryMap sqm, String msgId) {
        String msg = BOManager.getMessage(pCtx, ds, sqm, msgId);
        BLControl.logger.debug((Object)msg);
    }
}

