/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.WFLink;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.util.TreeMap;
import java.util.Vector;

public class WFConnectorWS
extends WFWorkstep {
    static final long serialVersionUID = 631990596421298094L;

    public WFConnectorWS(int type, String n) {
        this.setName(n);
        this.setType(type);
    }

    protected String getAdditinalStatus() {
        WFLink c;
        int x;
        String tmp = "";
        for (x = 0; x < this.hasIncoming.size(); ++x) {
            c = (WFLink)this.hasIncoming.elementAt(x);
            tmp = tmp + "       " + c.toString() + "\n";
        }
        for (x = 0; x < this.hasOutgoing.size(); ++x) {
            c = (WFLink)this.hasOutgoing.elementAt(x);
            tmp = tmp + "       " + c.toString() + "\n";
        }
        return tmp;
    }

    @Override
    protected void validateWSData() {
        if (this.isExclusive()) {
            this.validateExclusive();
        }
    }

    private void validateExclusive() {
        Vector wflinks;
        TreeMap<Integer, WFLink> map = new TreeMap<Integer, WFLink>();
        WFLink defaultLink = null;
        for (Object obj : this.hasOutgoing) {
            WFLink link = (WFLink)obj;
            if (link.isDefault()) {
                if (defaultLink == null) {
                    defaultLink = link;
                    continue;
                }
                throw new BizLogicException("BizLogic_ERR_3682", "WFConnectorWS:validateExclusive", new Object[]{this.parentProcess.getName(), this.getName()});
            }
            int index = link.getIndex();
            if (map.containsKey(index)) {
                throw new BizLogicException("BizLogic_ERR_3678", "WFConnectorWS:validateExclusive", new Object[]{this.parentProcess.getName(), this.getName(), link.getName(), index});
            }
            map.put(index, link);
        }
        if (defaultLink == null) {
            throw new BizLogicException("BizLogic_ERR_3681", "WFConnectorWS:validateExclusive", new Object[]{this.parentProcess.getName(), this.getName()});
        }
        int defLinkIndex = 0;
        Integer maxIndex = (Integer)map.lastKey();
        if (maxIndex != null) {
            defLinkIndex = maxIndex + 1;
        }
        defaultLink.setIndex(defLinkIndex);
        map.put(defLinkIndex, defaultLink);
        this.hasOutgoing = wflinks = new Vector(map.values());
    }
}

