/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.server.ExtBOConfig;
import com.savvion.sbm.bizlogic.server.ObjectSqlMap;
import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAppObject;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessInstance;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BCLService;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.dms.svo.Document;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.dcl.FCLService;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class WFDataslot
extends WFAppObject {
    static final long serialVersionUID = 2827501362122168087L;
    String type;
    private Object value;
    private Object defaultValue;
    int size = -1;
    boolean multiLine = false;
    Object appendWith = null;
    Vector choices = null;
    boolean isPublic = true;
    String mime = "";
    boolean BizManageAccess = false;
    boolean BizSiteAccess = false;
    WFProcess parentProcess;
    String[] objConstrArgType = null;
    Object[] objConstrArgValue = null;
    Vector objConstrGlobalDSName = null;
    transient WFDataslot[] objConstrGlobalDS = null;
    int[] objConstrGlobalDSindex = null;
    private transient Constructor cnstr = null;
    String javaClassName;
    ObjectSqlMap objSqlMap;
    boolean required = false;
    String label = null;
    boolean global = false;
    int scale = -1;
    int precision = -1;
    long xmlCollectionID = -1L;
    transient HashMap dsvalue = null;
    String storageFormat = null;
    boolean editableByAuthor = false;
    boolean isMonitorDS = false;
    boolean canResetToNull = true;
    ExtBOConfig boPersistenceConfig = null;

    public WFDataslot(String name, String type, Object defaultValue, String choices, String storageType) {
        this.setName(name);
        this.setType(type);
        this.setStorageFormat(storageType);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        if (defaultValue != null) {
            if (this.isList()) {
                this.value = this.getEmptyCollection();
                ((Collection)this.value).addAll((Vector)defaultValue);
            } else if (this.isSet()) {
                this.value = this.renderStringToCollection(defaultValue.toString());
            } else if (this.isString() || this.isURL()) {
                if (((String)defaultValue).indexOf("|") != -1) {
                    Object[] objectArray = new Object[4];
                    objectArray[0] = name;
                    objectArray[1] = type;
                    objectArray[2] = defaultValue;
                    objectArray[3] = "|";
                    throw new BizLogicException("BizLogic_ERR_645", "WFDataslot.WFDataslot", objectArray);
                }
            }
        }
        this.setChoices(choices);
    }

    public void setMultiLine(boolean m) {
        this.multiLine = m;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public String getType4DB() {
        if (this.type.equals("STRING") && this.multiLine) {
            return "STRING_MULTI";
        }
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object val) {
        this.defaultValue = val;
    }

    public void setSqlMap(ObjectSqlMap sqlmap) {
        this.objSqlMap = sqlmap;
    }

    public ObjectSqlMap getSqlMap() {
        return this.objSqlMap;
    }

    public boolean isSqlMap() {
        return this.getType().equals("OBJECT") && this.objSqlMap != null;
    }

    public String getMime() {
        return this.mime;
    }

    public void setMime(String m) {
        this.mime = m;
    }

    public Vector getChoices() {
        return this.choices;
    }

    private void setChoices(String c) {
        if (c == null || c.trim().isEmpty()) {
            this.choices = null;
            return;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(c, "|,");
        while (tok.hasMoreTokens()) {
            v.addElement(tok.nextToken());
        }
        this.setChoices(v);
    }

    private void setChoices(Vector c) {
        block3: {
            block2: {
                String string = this.getType();
                BLConstants.single();
                if (string.equals("DOCUMENT")) break block2;
                String string2 = this.getType();
                BLConstants.single();
                if (!string2.equals("OBJECT")) break block3;
            }
            throw new BizLogicException("BizLogic_ERR_1644", "WFDataslot.setChoices", new Object[]{this.getName(), this.getType()});
        }
        this.choices = c;
    }

    public boolean hasChoices() {
        return this.choices != null && !this.choices.isEmpty();
    }

    public void setAppendWith(Object o) {
        this.appendWith = o;
    }

    public void setEditableByAuthor(boolean isEditableByAuthor) {
        this.editableByAuthor = isEditableByAuthor;
    }

    public synchronized void setObjConstrGlobalDS() {
        if (this.objConstrGlobalDS == null) {
            WFDataslot ds = null;
            String dsname = null;
            this.objConstrGlobalDS = new WFDataslot[this.objConstrGlobalDSindex.length];
            for (int itr = 0; itr < this.objConstrGlobalDSindex.length; ++itr) {
                dsname = (String)this.objConstrGlobalDSName.get(itr);
                this.objConstrGlobalDS[itr] = ds = this.parentProcess.getDataslot(dsname);
            }
        }
    }

    Object defaultValue(Object value) {
        if (this.type.equals("LONG")) {
            return -1L;
        }
        if (this.type.equals("DOUBLE")) {
            return -1.0;
        }
        if (this.type.equals("BOOLEAN")) {
            return Boolean.FALSE;
        }
        if (this.type.equals("XML")) {
            try {
                XML xml = new XML(-1L);
                return xml;
            }
            catch (Throwable xml) {}
        } else {
            if (this.type.equals("DATETIME")) {
                Timestamp ts = null;
                DateTime dt = new DateTime(ts);
                return dt;
            }
            if (this.type.equals("DECIMAL")) {
                try {
                    Decimal d = new Decimal(null, this.precision, this.scale);
                    return d;
                }
                catch (Throwable throwable) {}
            } else {
                if (this.type.equals("DOCUMENT")) {
                    return value;
                }
                if (this.type.equals("CURRENCY")) {
                    // empty if block
                }
            }
        }
        return null;
    }

    public void checkType(String pname, Object v) {
        String dsname = this.getName();
        if (this.type.equals("STRING") && !(v instanceof String)) {
            throw new BizLogicException("BizLogic_ERR_507", "WFDataslot.checkType", (Object[])new String[]{pname, dsname});
        }
        if (this.type.equals("LONG") && !(v instanceof Long)) {
            throw new BizLogicException("BizLogic_ERR_508", "WFDataslot.checkType", (Object[])new String[]{pname, dsname});
        }
        if (this.type.equals("DOUBLE") && !(v instanceof Double)) {
            throw new BizLogicException("BizLogic_ERR_509", "WFDataslot.checkType", (Object[])new String[]{pname, dsname});
        }
        if (this.type.equals("BOOLEAN") && !(v instanceof Boolean)) {
            throw new BizLogicException("BizLogic_ERR_510", "WFDataslot.checkType", (Object[])new String[]{pname, dsname});
        }
        if (this.type.equals("URL") && !(v instanceof String)) {
            throw new BizLogicException("BizLogic_ERR_511", "WFDataslot.checkType", (Object[])new String[]{pname, dsname});
        }
        if (this.type.equals("DATETIME") && !(v instanceof DateTime)) {
            throw new BizLogicException("BizLogic_ERR_4821", "WFDataslot.checkType", new Object[]{pname, dsname, "DateTime", v, v == null ? null : v.getClass().getName()});
        }
        if (this.type.equals("DECIMAL") && !(v instanceof Decimal)) {
            throw new BizLogicException("BizLogic_ERR_4822", "WFDataslot.checkType", new Object[]{pname, dsname, "Decimal", v, v == null ? null : v.getClass().getName()});
        }
        if (this.type.equals("XML") && !(v instanceof XML)) {
            throw new BizLogicException("BizLogic_ERR_4823", "WFDataslot.checkType", new Object[]{pname, dsname, "XML", v, v == null ? null : v.getClass().getName()});
        }
        if (this.type.equals("DOCUMENT") && !this.isValidDocumentType(v)) {
            String value = null;
            if (v != null && (value = v.toString()) != null && value.length() > 100) {
                value = value.substring(0, 100);
            }
            throw new BizLogicException("BizLogic_ERR_1640", "WFDataslot.checkType", new Object[]{pname, dsname, "DocumentDS, File, File[], Map<String, byte[]>, Document, List<Document>", value, v == null ? null : v.getClass().getName()});
        }
    }

    private boolean isValidDocumentType(Object doc) {
        if (doc == null) {
            return false;
        }
        return doc instanceof DocumentDS || doc instanceof File || doc instanceof File[] || doc instanceof Map || doc instanceof Document || WFDataslot.isDocumentList(doc);
    }

    public Object truncateValue(String pname, Object data) {
        if (!BLUtil.self().isTruncateDSValue() || data == null) {
            return data;
        }
        if (this.isString() && BLUtil.self().isTruncateDSValue() && ((String)data).length() > this.size) {
            data = BLUtil.trim(null, null, (String)((String)data), (int)this.size, (boolean)false);
            BLControl.logger.warnKey("BizLogic_ERR_1137", new Object[]{"String", this.getName(), pname, this.size, data});
        }
        return data;
    }

    public void checkSize(Object data) {
        if (this.size == -1) {
            return;
        }
        if (data != null) {
            if (this.isDocument() && !BLUtil.isStringObject((Object)data)) {
                return;
            }
            if (this.isString() || this.isURL()) {
                BLUtil.checkDataLength((String)this.getName(), (String)((String)data), (String)this.type, (int)this.size);
            }
        }
    }

    public Object convertToObjectValue(String v) {
        String pName = this.getParentProcess().getName();
        if (this.isLong()) {
            try {
                return Long.valueOf(v);
            }
            catch (NumberFormatException nfe) {
                throw new BizLogicException("BizLogic_ERR_1676", "WFDataslot.convertToObjectValue", new Object[]{v, pName, this.getName()});
            }
        }
        if (this.isDouble()) {
            try {
                return Double.valueOf(v);
            }
            catch (NumberFormatException nfe) {
                throw new BizLogicException("BizLogic_ERR_1676", "WFDataslot.convertToObjectValue", new Object[]{v, pName, this.getName()});
            }
        }
        if (this.isBoolean()) {
            if ("TRUE".equalsIgnoreCase(v) || "YES".equalsIgnoreCase(v) || "OK".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("FALSE".equalsIgnoreCase(v) || "NO".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
            throw new BizLogicException("BizLogic_ERR_602", "WFDataslot.convertToObjectValue", (Object[])new String[]{pName + "::" + this.getName(), v});
        }
        if (this.isDecimal()) {
            try {
                return new Decimal(v);
            }
            catch (NumberFormatException e) {
                throw new BizLogicException("BizLogic_ERR_1641", "WFDataslot.convertToObjectValue", (Object[])new String[]{pName, v, this.getName()});
            }
        }
        if (this.isDate()) {
            try {
                return new DateTime(v);
            }
            catch (ParseException e) {
                throw new BizLogicException("BizLogic_ERR_1643", "WFDataslot.convertToObjectValue", (Object[])new String[]{pName, this.getName(), v});
            }
        }
        if (this.isXML()) {
            return new XML(v);
        }
        if (this.isURL() && !SBMUtil.self().isValidURL(v)) {
            throw new BizLogicException("BizLogic_ERR_8111", "WFDataslot.convertToObjectValue", (Object[])new String[]{pName, this.getName(), v});
        }
        return v;
    }

    private void validateDecimal(String pName, Object v) {
        Decimal d = (Decimal)v;
        if (d.getValue() == null) {
            return;
        }
        try {
            d.validate(this.precision, this.scale);
        }
        catch (Exception e) {
            throw new BizLogicException("BizLogic_ERR_1642", "WFDataslot.validateDecimal", new Object[]{pName, d.getValue(), this.getName(), this.precision, this.scale}, (Throwable)e);
        }
    }

    public Object getValidatedValueForUpdate(Object v1) {
        Object v = v1;
        String pName = this.getParentProcess().getName();
        if (v == null || "<NULL>".equals(v.toString())) {
            return this.defaultValue(v);
        }
        if (this.getType().equals("URL")) {
            if (v instanceof String && ((String)v).trim().length() == 0) {
                return this.defaultValue(v);
            }
            if (v instanceof String && !((String)v).isEmpty()) {
                v = this.convertToObjectValue((String)v);
            }
            if (v instanceof URL) {
                v = v.toString();
            }
        } else if (v instanceof String) {
            v = this.convertToObjectValue((String)v);
        } else if (v instanceof Double) {
            if (this.getType().equals("LONG")) {
                v = new Long(((Double)v).longValue());
            } else if (this.getType().equals("DECIMAL")) {
                v = new Decimal((Double)v);
            }
        } else if (v instanceof BigDecimal) {
            if (this.getType().equals("DECIMAL")) {
                v = new Decimal((BigDecimal)v);
            }
        } else if (v instanceof Timestamp) {
            if (this.getType().equals("DATETIME")) {
                v = new DateTime((Timestamp)v);
            }
        } else if (v instanceof java.util.Date) {
            if (this.getType().equals("DATETIME")) {
                v = new DateTime(((java.util.Date)v).getTime());
            }
        } else if (v instanceof Date) {
            if (this.getType().equals("DATETIME")) {
                v = new DateTime(((Date)v).getTime());
            }
        } else if (v instanceof Calendar) {
            if (this.getType().equals("DATETIME")) {
                v = new DateTime((Calendar)v);
            }
        } else if (v instanceof Long) {
            if (this.getType().equals("DATETIME")) {
                v = new DateTime((Long)v);
            } else if (this.getType().equals("DOUBLE")) {
                v = new Double(((Long)v).longValue());
            } else if (this.getType().equals("DECIMAL")) {
                v = new Decimal(((Long)v).longValue());
            }
        }
        this.checkType(pName, v);
        this.checkSize(v);
        if (this.getType().equals("DECIMAL")) {
            this.validateDecimal(pName, v);
        } else if (this.getType().equals("OBJECT") && !(v instanceof Serializable)) {
            throw new BizLogicException("BizLogic_ERR_624", "WFDataslot:getValidatedValueForUpdate", (Object[])new String[]{this.getName(), v.getClass().getName()});
        }
        return v;
    }

    public void syncValueForReplace(Object v) {
        this.value = v;
    }

    void setValue(Object v) {
        this.value = v;
    }

    public final boolean isString() {
        return this.getType().equals("STRING");
    }

    public boolean isLong() {
        return this.getType().equals("LONG");
    }

    public boolean isDouble() {
        return this.getType().equals("DOUBLE");
    }

    public boolean isBoolean() {
        return this.getType().equals("BOOLEAN");
    }

    public boolean isDocument() {
        return this.getType().equals("DOCUMENT");
    }

    public final boolean isURL() {
        return this.getType().equals("URL");
    }

    public boolean isObject() {
        return this.getType().equals("OBJECT");
    }

    public boolean isXML() {
        return this.getType().equals("XML");
    }

    public boolean isDecimal() {
        return this.getType().equals("DECIMAL");
    }

    public boolean isCurrency() {
        return this.getType().equals("CURRENCY");
    }

    public boolean isDate() {
        return this.getType().equals("DATETIME");
    }

    public boolean isComplex() {
        return this.isDecimal() || this.isDate() || this.isMap() || this.isList() || this.isObject() || this.isXML() || this.isDocument();
    }

    public boolean isBlob() {
        return this.isMap() || this.isList() || this.isObject() || this.isSet();
    }

    public void setParentProcess(WFProcess p) {
        this.parentProcess = p;
    }

    public WFProcess getParentProcess() {
        return this.parentProcess;
    }

    String getValue4Event(Object dsvalue) {
        if (!this.isPublic) {
            return "Not Public";
        }
        String val = "";
        if (dsvalue != null) {
            val = dsvalue.toString();
        }
        return val;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean p) {
        this.isPublic = p;
    }

    public boolean getBizManageAccess() {
        return this.BizManageAccess;
    }

    public boolean getBizSiteAccess() {
        return this.BizSiteAccess;
    }

    public void setBizManageAccess(boolean p) {
        this.BizManageAccess = p;
    }

    public void setBizSiteAccess(boolean p) {
        this.BizSiteAccess = p;
    }

    public String toString() {
        String buf = "";
        buf = buf + this.getName() + "  Type : " + this.getType() + "\n";
        if (this.isPublic) {
            buf = this.isObject() && this.value != null ? buf + " Value : instance of " + this.javaClassName + "\n" : buf + " Value : " + this.value + "\n";
        }
        return buf;
    }

    public boolean isDateDSMappedToStartTime() {
        if (this.isDate() && this.defaultValue != null) {
            if (this.defaultValue.toString().equals("@" + "STARTTIME")) {
                return true;
            }
        }
        return false;
    }

    public boolean isValueMapped() {
        if (this.isString() && this.value != null) {
            if (this.value.toString().startsWith("@")) {
                return true;
            }
        }
        return false;
    }

    public boolean isValueMappedToCreator() {
        if (this.isString() && this.value != null) {
            if (this.value.toString().equals("@" + "CREATOR")) {
                return true;
            }
        }
        return false;
    }

    public boolean validate() {
        if (this.getName().length() > 32) {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.parentProcess.getName();
            objectArray[1] = this.getName();
            objectArray[2] = 32;
            throw new BizLogicException("BizLogic_ERR_616", "WFDataslot.validate", objectArray);
        }
        if (this.isValueMapped()) {
            String mappedTo = BLUtil.getParameter((String)((String)this.value));
            if (mappedTo.toUpperCase().startsWith("WORKSTEPPRIORITY:") || mappedTo.toUpperCase().startsWith("WORKSTEPDUEDATE:")) {
                if (mappedTo.indexOf(":") == mappedTo.length() - 1) {
                    throw new BizLogicException("BizLogic_ERR_1678", "WFDataslot.validate", new Object[]{this.parentProcess.getName(), this.getName()});
                }
                String wsName = mappedTo.substring(mappedTo.indexOf(":") + 1);
                this.parentProcess.getWorkstep(wsName);
            } else if (!"PROCESSPRIORITY".equalsIgnoreCase(mappedTo) && !"CREATOR".equalsIgnoreCase(mappedTo)) {
                throw new BizLogicException("BizLogic_ERR_1677", "WFDataslot.validate", new Object[]{(String)this.value, this.parentProcess.getName(), this.getName()});
            }
        }
        if (this.isObject()) {
            this.validateObjDS();
        }
        if (this.hasChoices()) {
            this.checkChoice();
        }
        return true;
    }

    private boolean validateObjDS() {
        if (this.isObject()) {
            try {
                FCLService service;
                Class cls;
                if (BLControl.util.DEBUG_CLASSLOADER) {
                    BLControl.logger.debug((Object)("WFDataslot.validateObjDS(): Trying to load class : " + this.javaClassName));
                }
                if (!SBMUtil.isClassSerializable((Class)(cls = (service = BCLService.getService((String)this.getParentProcess().getName())).loadClass(this.javaClassName)))) {
                    throw new BizLogicException("BizLogic_ERR_624", "WFDataslot.validateObjDS", new Object[]{this.getName(), cls.getName()});
                }
                if (this.objConstrArgType != null) {
                    String classType = null;
                    for (int itr = 0; itr < this.objConstrArgType.length; ++itr) {
                        classType = this.objConstrArgType[itr];
                        if (BLUtil.isPrimitiveType((String)classType) || "GlobalDS".equals(classType)) continue;
                        throw new BizLogicException("BizLogic_ERR_680", "WFDataslot.validateObjDS", new Object[]{this.getName(), this.getParentProcess().getName()});
                    }
                }
                if (this.objConstrGlobalDSName != null) {
                    if (this.isGlobal()) {
                        throw new BizLogicException("BizLogic_ERR_678", "WFDataslot.validateObjDS", new Object[]{this.getName(), this.getParentProcess().getName()});
                    }
                    for (int itr = 0; itr < this.objConstrGlobalDSName.size(); ++itr) {
                        String dsname = (String)this.objConstrGlobalDSName.get(itr);
                        WFDataslot ds = this.getParentProcess().getDataslot(dsname);
                        if (ds.isGlobal()) continue;
                        throw new BizLogicException("BizLogic_ERR_680", "WFDataslot.validateObjDS", new Object[]{ds.getName(), this.getName(), this.getParentProcess().getName()});
                    }
                }
                this.setObjDSConstructorMethod(cls);
                this.setObjDSConstructorMethod();
                return true;
            }
            catch (BizLogicException blex) {
                throw blex;
            }
            catch (Exception ex) {
                throw new BizLogicException("BizLogic_ERR_679", "WFDataslot.validateObjDS", new Object[]{this.getName(), this.parentProcess.getName()}, (Throwable)ex);
            }
        }
        return false;
    }

    public synchronized Constructor getConstructor() throws Exception {
        if (this.cnstr == null) {
            this.setObjDSConstructorMethod();
        }
        return this.cnstr;
    }

    private synchronized void setObjDSConstructorMethod() throws Exception {
        if (BLControl.util.DEBUG_CLASSLOADER) {
            BLControl.logger.debug((Object)("WFDataslot.setObjDSConstructorMethod(): Trying to load class : " + this.javaClassName));
        }
        FCLService service = BCLService.getService((String)this.getParentProcess().getName());
        Class cls = service.loadClass(this.javaClassName);
        this.setObjDSConstructorMethod(cls, this.getObjConstrArgClass());
    }

    private void setObjDSConstructorMethod(Class objClass) throws Exception {
        this.setObjDSConstructorMethod(objClass, this.getObjConstrArgClass());
    }

    private void setObjDSConstructorMethod(Class objClass, Class[] cls) {
        try {
            this.cnstr = objClass.getConstructor(cls);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_677", "setObjDSConstructorMethod(objClass, cls)", new Object[]{objClass.getName(), this.getName(), this.parentProcess.getName()}, th);
        }
    }

    private Class[] getObjConstrArgClass() throws Exception {
        Class[] cls = null;
        if (this.objConstrArgType != null) {
            cls = new Class[this.objConstrArgType.length];
            String type = null;
            for (int itr = 0; itr < this.objConstrArgType.length; ++itr) {
                String dsname;
                type = this.objConstrArgType[itr];
                if ("GlobalDS".equals(type) && (dsname = (String)this.objConstrArgValue[itr]) != null) {
                    WFDataslot ds = this.getParentProcess().getDataslot(dsname);
                    if (ds.isObject()) {
                        if (BLControl.util.DEBUG_CLASSLOADER) {
                            BLControl.logger.debug((Object)("WFDataslot.getObjConstrArgClass(): Trying to load class : " + ds.getJavaClassName()));
                        }
                        FCLService service = BCLService.getService((String)this.getParentProcess().getName());
                        cls[itr] = service.loadClass(ds.getJavaClassName());
                        continue;
                    }
                    if (ds.isXML()) {
                        cls[itr] = String.class;
                        continue;
                    }
                    if (ds.isDate()) {
                        cls[itr] = Timestamp.class;
                        continue;
                    }
                    if (ds.isDecimal()) {
                        cls[itr] = BigDecimal.class;
                        continue;
                    }
                    if (ds.isList() || ds.isSet() || ds.isMap()) {
                        cls[itr] = SBMUtil.load((String)ds.getStorageFormat(), (ClassLoader)this.getClass().getClassLoader());
                        continue;
                    }
                    if (ds.isDocument() || ds.isURL()) {
                        BLConstants.single();
                        type = "STRING";
                    } else {
                        type = ds.getType();
                    }
                }
                cls[itr] = SBMUtil.getPrimitiveClass((String)type);
            }
        }
        return cls;
    }

    public void setJavaClassName(String className) {
        this.javaClassName = className;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    void setValueToNull() {
        this.value = null;
        this.setStatus(33);
    }

    public void setRequired(boolean mandatory) {
        this.required = mandatory;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setLabel(String label) {
        if (label != null && label.trim().length() != 0) {
            label = label.trim();
            this.label = label.length() > 128 ? label.substring(0, 128) : label;
        }
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.getName();
        }
        return this.label;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isInstance() {
        return !this.global;
    }

    public void setGlobal(boolean g) {
        this.global = g;
    }

    public void setObjectDSConstrDatas(String[] objConstrArgType, Object[] objConstrArgValue, Vector objConstrGlobalDSName, int[] objConstrGlobalDSindex) {
        this.objConstrArgType = (String[])SBMUtil.arrayCopy((Object[])objConstrArgType);
        this.objConstrArgValue = SBMUtil.arrayCopy((Object[])objConstrArgValue);
        this.objConstrGlobalDSName = objConstrGlobalDSName;
        this.objConstrGlobalDSindex = SBMUtil.arrayCopy((int[])objConstrGlobalDSindex);
    }

    private List<Map<String, Object>> getConstructorData() {
        if (this.objConstrArgType == null || this.objConstrArgValue == null || this.objConstrArgType.length == 0 || this.objConstrArgValue.length == 0 || this.objConstrArgType.length != this.objConstrArgValue.length) {
            return null;
        }
        ArrayList<Map<String, Object>> constructorData = new ArrayList<Map<String, Object>>(this.objConstrArgType.length);
        for (int i = 0; i < this.objConstrArgType.length; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put(this.objConstrArgType[i], this.objConstrArgValue[i]);
            constructorData.add(map);
        }
        return constructorData;
    }

    public void setConstructorData(List<Map<String, Object>> data) {
    }

    /*
     * Unable to fully structure code
     */
    public HashMap getMetaData() {
        block14: {
            block13: {
                block12: {
                    block11: {
                        metaData = new HashMap<String, Object>();
                        type = this.getType();
                        metaData.put("DATASLOTTYPE", type);
                        metaData.put("DATASLOTISPUBLIC", this.isPublic);
                        choiceList = new Vector();
                        choiceList = this.choices;
                        metaData.put("DATASLOTCHOICES", choiceList);
                        metaData.put("DATASLOTBIZMANAGEACCESS", this.BizManageAccess);
                        metaData.put("LABEL", this.label);
                        metaData.put("REQUIRED", this.required);
                        metaData.put("DATASLOTMULTILINE", this.multiLine);
                        metaData.put("DATASLOTISGLOBAL", this.isGlobal());
                        metaData.put("ISMONITORDS", this.isMonitorDS());
                        if (type.equals("STRING")) ** GOTO lbl41
                        if (type.equals("URL")) ** GOTO lbl41
                        if (type.equals("DOCUMENT")) ** GOTO lbl41
                        if (type.equals("DECIMAL")) {
lbl41:
                            // 4 sources

                            metaData.put("DATASLOTSIZE", this.size);
                        } else {
                            metaData.put("DATASLOTSIZE", -1);
                        }
                        if (type.equals("OBJECT")) {
                            metaData.put("DATASLOTOBJECTTYPE", this.javaClassName);
                            metaData.put("DATASLOTCONSTRUCTORDATA", this.getConstructorData());
                            metaData.put("ISDATASLOTSQLMAP", this.isSqlMap());
                        }
                        if (type.equals("STRING")) break block11;
                        if (!type.equals("DOCUMENT")) break block12;
                    }
                    metaData.put("DATASLOTMULTILINE", this.multiLine);
                }
                if (type.equals("STRING")) {
                    metaData.put("DATASLOTAPPENDWITH", this.appendWith);
                }
                if (type.equals("DOCUMENT")) {
                    metaData.put("ISEDITABLEBYAUTHORONLY", this.editableByAuthor);
                }
                if (type.equals("DECIMAL")) break block13;
                if (!type.equals("CURRENCY")) break block14;
            }
            metaData.put("DATASLOTPRECISION", this.precision);
            metaData.put("DATASLOTSCALE", this.scale);
        }
        metaData.put("DATASLOTDEFAULTVALUE", this.defaultValue);
        return metaData;
    }

    public void setAttributes(HashMap changedMetaData) {
        if (this.getParentProcess().isSuspended()) {
            throw new BizLogicException("BizLogic_ERR_676", "WFDataslot.setAttributes(hm)", new Object[]{this.getName(), this.getParentProcess().getName()});
        }
        Iterator iMeta = changedMetaData.keySet().iterator();
        String metaName = null;
        Object metaValue = null;
        while (iMeta.hasNext()) {
            metaName = (String)iMeta.next();
            metaValue = changedMetaData.get(metaName);
            if (metaName.equals("DATASLOTAPPENDWITH")) {
                this.setAppendWith(metaValue);
                continue;
            }
            if (metaName.equals("DATASLOTBIZMANAGEACCESS")) {
                this.setBizManageAccess((Boolean)metaValue);
                continue;
            }
            if (metaName.equals("DATASLOTCHOICES")) {
                if (metaValue instanceof String) {
                    this.setChoices((String)metaValue);
                    continue;
                }
                this.setChoices((Vector)metaValue);
                continue;
            }
            if (metaName.equals("LABEL")) {
                this.setLabel(metaValue);
                continue;
            }
            if (metaName.equals("REQUIRED")) {
                this.setRequired((Boolean)metaValue);
                continue;
            }
            if (metaName.equals("DATASLOTCONSTRUCTORDATA")) {
                this.setConstructorData(metaValue);
                continue;
            }
            throw new BizLogicException("BizLogic_ERR_1679", "WFDataslot.setAttributes", new Object[]{metaName, this.parentProcess.getName(), this.getName()});
        }
        ProcessControl.updateProcessTemplate(this.parentProcess);
    }

    public String getMappedObject(String piname) {
        String mappedKey = null;
        if (this.value.toString().toUpperCase().startsWith("@" + "PROCESSPRIORITY")) {
            mappedKey = "PIPR_" + piname;
            return mappedKey;
        }
        if (this.value.toString().toUpperCase().startsWith("@" + "WORKSTEPPRIORITY:")) {
            mappedKey = "WSPR_";
            mappedKey = mappedKey + this.value.toString().substring(this.value.toString().indexOf(":") + 1);
            return mappedKey;
        }
        if (this.value.toString().toUpperCase().startsWith("@" + "WORKSTEPDUEDATE:")) {
            mappedKey = "WSDD_";
            mappedKey = mappedKey + this.value.toString().substring(this.value.toString().indexOf(":") + 1);
            return mappedKey;
        }
        return mappedKey;
    }

    public Object getAppendWith() {
        return this.appendWith;
    }

    public void setPrecision(int pcsn) {
        this.precision = pcsn;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setScale(int sc) {
        this.scale = sc;
    }

    public int getScale() {
        return this.scale;
    }

    public void setXMLCollectionID(long collectionID) {
        this.xmlCollectionID = collectionID;
    }

    public long getXMLCollectionID() {
        return this.xmlCollectionID;
    }

    protected Map<String, Object> getEventContext(Session sess, WFProcess process, Object value, int eventType) {
        Map eventContext = SBMUtil.getNewEventContext();
        if (!WFProcessInstance.checkAuditRequired(process, eventType)) {
            eventContext.put("AUDIT_DISABLED", true);
            return eventContext;
        }
        WFProcess pt = this.getParentProcess();
        eventContext.put("PROCESSTEMPLATEID", pt.getID());
        eventContext.put("PROCESSTEMPLATENAME", pt.getName());
        eventContext.put("DATASLOTNAME", this.getName());
        eventContext.put("DATASLOTTYPE", this.getType());
        eventContext.put("IS_GLOBAL", this.isGlobal());
        if (sess != null) {
            eventContext.put("SESSION_USER", sess.getUser());
        }
        if (this.isPublic()) {
            if (value == null) {
                value = "<NULL>";
            }
            eventContext.put("DATASLOTVALUE", value.toString());
        }
        if (BLControl.util.isPrintEvent()) {
            eventContext.put("NAME", this.getName());
        }
        eventContext.put("APP_NAME", pt.getAppName());
        return eventContext;
    }

    public final boolean isSet() {
        return this.getType().equals("SET");
    }

    public boolean isMap() {
        return this.getType().equals("MAP");
    }

    public final boolean isList() {
        return this.getType().equals("LIST");
    }

    public boolean isCollection() {
        return this.isSet() || this.isList() || this.isMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCollection(String dsType) {
        if (dsType.equals("LIST")) return true;
        if (dsType.equals("MAP")) return true;
        if (!dsType.equals("SET")) return false;
        return true;
    }

    private Object renderStringToCollection(String list) {
        ArrayList alist = BLUtil.parseStringList((String)list, (String)",");
        if (alist == null) {
            return null;
        }
        Object newInstance = this.getEmptyCollection();
        if (this.isMap()) {
            String entry = null;
            String key = null;
            String value = null;
            StringTokenizer st = null;
            for (int ix = 0; ix < alist.size(); ++ix) {
                entry = (String)alist.get(ix);
                st = new StringTokenizer(entry, "=");
                key = st.nextToken().trim();
                if (st.hasMoreTokens()) {
                    value = st.nextToken().trim();
                }
                ((Map)newInstance).put(key, value);
            }
        } else {
            ((Collection)newInstance).addAll(alist);
        }
        if (BLUtil.self().DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("The default value for collection dataslot <" + this.getName() + "> is " + newInstance.toString()));
        }
        return newInstance;
    }

    public final Object getEmptyCollection() {
        try {
            return Class.forName(this.storageFormat).newInstance();
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_762", "WFCollectionDataSlot::setStorageFormat", new Object[]{this.storageFormat, this.getName()}, th);
        }
    }

    public final void setStorageFormat(String storageFormat) {
        if (this.isCollection()) {
            this.storageFormat = storageFormat;
            this.getEmptyCollection();
        }
    }

    public String getStorageFormat() {
        return this.storageFormat;
    }

    public Object convertToCollectionValue(Object orgValue, Object value) {
        if (value == null) {
            return null;
        }
        Object collectionValue = value;
        if (this.isSet() || this.isList()) {
            if (value instanceof Collection) {
                if (!value.getClass().getName().equals(this.getStorageFormat())) {
                    collectionValue = this.getEmptyCollection();
                    ((Collection)collectionValue).addAll((Collection)value);
                }
            } else {
                collectionValue = orgValue;
                if (BLUtil.isNull((Object)collectionValue)) {
                    collectionValue = this.getEmptyCollection();
                }
                ((Collection)collectionValue).add(value);
            }
        } else if (this.isMap()) {
            if (value instanceof Map) {
                if (!value.getClass().getName().equals(this.getStorageFormat())) {
                    collectionValue = this.getEmptyCollection();
                    ((Map)collectionValue).putAll((Map)value);
                }
            } else if (value instanceof Map.Entry) {
                collectionValue = orgValue;
                if (BLUtil.isNull((Object)collectionValue)) {
                    collectionValue = this.getEmptyCollection();
                }
                Map.Entry entry = (Map.Entry)value;
                ((Map)collectionValue).put(entry.getKey(), entry.getValue());
            } else {
                throw new BizLogicException("BizLogic_ERR_781", "WFDataslot:convertToCollectionObject", new Object[]{this.getName(), "java.util.Map or java.util.Map.Entry"});
            }
        }
        if (BLUtil.self().DEBUG_ENGINE) {
            BLControl.logger.debug((Object)("The new value for collection dataslot <" + this.getName() + "> is " + collectionValue.toString()));
        }
        return collectionValue;
    }

    private void setType(String dsType) {
        block2: {
            block3: {
                if (dsType == null) break block2;
                if (dsType.equalsIgnoreCase("LONG")) break block3;
                if (dsType.equalsIgnoreCase("DOUBLE")) break block3;
                if (dsType.equalsIgnoreCase("STRING")) break block3;
                if (dsType.equalsIgnoreCase("DOCUMENT")) break block3;
                if (dsType.equalsIgnoreCase("URL")) break block3;
                if (dsType.equalsIgnoreCase("BOOLEAN")) break block3;
                if (dsType.equalsIgnoreCase("STRING_MULTI")) break block3;
                if (dsType.equalsIgnoreCase("DECIMAL")) break block3;
                if (dsType.equalsIgnoreCase("DATETIME")) break block3;
                if (dsType.equalsIgnoreCase("XML")) break block3;
                if (dsType.equalsIgnoreCase("CURRENCY")) break block3;
                if (dsType.equalsIgnoreCase("OBJECT")) break block3;
                if (dsType.equalsIgnoreCase("SET")) break block3;
                if (dsType.equalsIgnoreCase("LIST")) break block3;
                if (!dsType.equalsIgnoreCase("MAP")) break block2;
            }
            this.type = dsType;
            return;
        }
        throw new BizLogicException("BizLogic_ERR_761", "WFDataslot:setType", new Object[]{dsType});
    }

    private Collection getChoiceList() {
        return this.choices;
    }

    private void checkChoice() {
        this.checkChoice(this.value);
    }

    void checkChoice(Object dsValue) {
        if (!this.hasChoices() || BLUtil.isNull((Object)dsValue)) {
            return;
        }
        if (!WFDataslot.checkChoice(this.getChoiceList(), dsValue)) {
            throw new BizLogicException("BizLogic_ERR_513", "WFDataslot.checkChoices", new Object[]{this.getParentProcess().getName() + "::" + this.getName(), this.getName(), dsValue, this.choices});
        }
    }

    public static final boolean checkChoice(Collection choiceList, Object value) {
        if (BLUtil.isNull((Object)value)) {
            return true;
        }
        if (choiceList != null) {
            if (value instanceof Collection) {
                return choiceList.containsAll((Collection)value);
            }
            return choiceList.contains(value);
        }
        return false;
    }

    private void validateChoiceListDataSlot(String dsName) {
        WFDataslot ds = this.getParentProcess().getDataslot(dsName);
        if (!ds.isList() && !ds.isSet()) {
            throw new BizLogicException("BizLogic_ERR_763", "WFDataslot:validate()", new Object[]{this.getName()});
        }
    }

    public boolean isEditableByAuthor() {
        return this.editableByAuthor;
    }

    protected void setMonitorDS(boolean isMonitorDS) {
        this.isMonitorDS = isMonitorDS;
    }

    public boolean isMonitorDS() {
        return this.isMonitorDS;
    }

    public boolean canResetToNull() {
        return this.canResetToNull;
    }

    protected void setCanResetToNull(boolean canResetToNull) {
        this.canResetToNull = canResetToNull;
    }

    protected void setBOPersistenceConfig(ExtBOConfig config) {
        if (null == config && this.isObject()) {
            throw new BizLogicException("BizLogic_ERR_8088", "WFDataslot.setBOPersistenceConfig()", new Object[0]);
        }
        this.boPersistenceConfig = config;
    }

    public ExtBOConfig getBOPersistenceConfig() {
        if (null != this.boPersistenceConfig) {
            this.boPersistenceConfig.setLogger(BLControl.logger);
        }
        return this.boPersistenceConfig;
    }

    public boolean isExternalBO() {
        return null != this.boPersistenceConfig;
    }

    public static boolean isDocumentList(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof List)) {
            return false;
        }
        List list = (List)value;
        if (list.isEmpty()) {
            return false;
        }
        for (Object obj : list) {
            if (obj instanceof Document) continue;
            return false;
        }
        return true;
    }
}

