/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.messaging.MessageControl;
import com.savvion.sbm.bizlogic.messaging.publisher.MessagePublisher;
import com.savvion.sbm.bizlogic.server.WFMessagePublisherWS;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.Decimal;
import com.savvion.sbm.bizlogic.server.svo.XML;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.ProcessContext;
import com.savvion.sbm.messaging.core.ChannelService;
import com.savvion.sbm.messaging.core.MDService;
import com.savvion.sbm.messaging.svo.Channel;
import com.savvion.sbm.messaging.svo.MessageDescriptor;
import com.savvion.sbm.messaging.util.MessagingUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WFMessagePublisherInstance
extends WFWorkstepInstance {
    private static WFMessagePublisherInstance self = null;

    private WFMessagePublisherInstance() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WFMessagePublisherInstance self() {
        if (self != null) return self;
        Class<WFMessagePublisherInstance> clazz = WFMessagePublisherInstance.class;
        synchronized (WFMessagePublisherInstance.class) {
            if (self != null) return self;
            self = new WFMessagePublisherInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        WFMessagePublisherWS ws = (WFMessagePublisherWS)pCtx.getWorkstep(wsid);
        String handlerName = ws.getHandler();
        MessagePublisher handler = MessageControl.loadPublisherHandler(handlerName, ws.getProcessName(), false);
        String piName = pCtx.getProcessInstanceName();
        String wsName = ws.getName();
        try {
            HashMap outputDSValues = BLUtil.getServiceLocal().invokePublisherHandler(this.getContext(pCtx, wsid), handler);
            pCtx.updateSlotValue(outputDSValues);
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1536", "WFMessagePublisherInstance:execute()", new Object[]{piName, wsName, th.getMessage()}, th);
        }
        try {
            handler.destroy();
            if (BLControl.util.DEBUG_ENGINE) {
                this.debugHandlerLifeCycle("destroy", piName, wsName);
            }
        }
        catch (Throwable th) {
            BLControl.logger.warn((Object)"WFMessagePublisherInstance.execute()", th);
        }
        this.complete(pCtx, wsid);
    }

    public HashMap doInvoke(HashMap context, MessagePublisher handler) {
        String piName = (String)context.get("ProcessInstanceName");
        String wsName = (String)context.get("WorkstepName");
        try {
            handler.setContext(context);
            if (BLControl.util.DEBUG_ENGINE) {
                this.debugHandlerLifeCycle("setContext", piName, wsName);
            }
            handler.init();
            if (BLControl.util.DEBUG_ENGINE) {
                this.debugHandlerLifeCycle("init", piName, wsName);
            }
            Object message = handler.createMessage();
            if (BLControl.util.DEBUG_ENGINE) {
                this.debugHandlerLifeCycle("createMessage", piName, wsName);
            }
            HashMap outputDSValues = handler.publish(message);
            if (BLControl.util.DEBUG_ENGINE) {
                this.debugHandlerLifeCycle("publish", piName, wsName);
            }
            return outputDSValues;
        }
        catch (Throwable th) {
            throw new BizLogicException("BizLogic_ERR_1536", "WFMessagePublisherInstance:execute()", new Object[]{piName, wsName, th.getMessage()}, th);
        }
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        this.validateCompletion(pCtx, wsid);
        long piid = pCtx.getProcessInstanceID();
        if (!ProcessInstanceDAO.isProcessInstanceExist(piid)) {
            BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{piid, "publisher", wsid});
            return;
        }
        super.complete(pCtx, wsid);
        if (pCtx.getWorkstepInstanceEB(wsid).getState() != 21) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    private HashMap getContext(WFProcessContext pCtx, long wsid) {
        HashMap<String, Object> processContextMap = new HashMap<String, Object>(12);
        WFMessagePublisherWS ws = (WFMessagePublisherWS)pCtx.getWorkstep(wsid);
        WFProcess pt = pCtx.getProcess();
        String channelName = ws.getChannelName();
        Channel channel = ChannelService.self().getChannel(channelName);
        String messageName = ws.getMessageName();
        MessageDescriptor messageDescriptor = MDService.self().getMessageDescriptor(messageName);
        processContextMap.put("ProcessTemplateName", pt.getName());
        processContextMap.put("ProcessInstanceID", pCtx.getProcessInstanceID());
        processContextMap.put("ProcessInstanceName", pCtx.getProcessInstanceName());
        processContextMap.put("WorkstepID", ws.getID());
        processContextMap.put("WorkstepName", ws.getName());
        processContextMap.put("MappedInputDataslots", ws.getSlotMapping());
        processContextMap.put("MappedOutputDataslots", ws.getOutputSlotsMapping());
        processContextMap.put("DataslotTypes", pCtx.getSlotsType());
        HashMap<String, HashMap> contextMap = new HashMap<String, HashMap>();
        contextMap.put("ProcessContext", processContextMap);
        contextMap.put("InputSlots", this.getDSValuesMappedToMessage(pCtx, ws));
        ProcessContext processContext = new ProcessContext(contextMap);
        HashMap<String, Object> contextInfo = new HashMap<String, Object>(9);
        contextInfo.put("ProcessContext", processContext);
        contextInfo.put("PROCESSTEMPLATEID", new Long(pt.getID()));
        contextInfo.put("APPLICATIONNAME", pt.getAppName());
        contextInfo.put("LOGGER", BLControl.logger);
        contextInfo.put("DEBUG", BLControl.util.DEBUG_MESSAGING);
        contextInfo.put("CHANNEL", channel);
        contextInfo.put("MESSAGE_DESCRIPTOR", messageDescriptor);
        contextInfo.put("MESSAGE_MAPPING", ws.getMessageMapping());
        contextInfo.put("MESSAGE_MAPPED_DS_VALUES", this.getDSValuesMappedToMessage(pCtx, ws));
        return contextInfo;
    }

    private HashMap getDSValuesMappedToMessage(WFProcessContext pCtx, WFMessagePublisherWS ws) {
        List messageMapping = ws.getMessageMapping();
        ArrayList<String> dsNames = new ArrayList<String>();
        boolean hasComplexDS = false;
        for (int ix = 0; ix < messageMapping.size(); ++ix) {
            HashMap mapping = (HashMap)messageMapping.get(ix);
            String copyFrom = (String)mapping.get("COPY_FROM");
            if (!copyFrom.startsWith("@")) continue;
            if (!BLUtil.self().isSystemDataSlot(copyFrom)) {
                copyFrom = copyFrom.substring(1);
                if (!hasComplexDS) {
                    hasComplexDS = pCtx.getDataslot(copyFrom).isComplex();
                }
            }
            dsNames.add(copyFrom);
        }
        HashMap dsMap = pCtx.getSlotValue(dsNames.toArray(new String[0]));
        if (hasComplexDS) {
            this.handleComplexDS(pCtx, dsMap);
        }
        return dsMap;
    }

    private void debugHandlerLifeCycle(String handlerOperationName, String piName, String wsName) {
        BLControl.logger.debugKey("BizLogic_ERR_3138", "WFMessagePublisherInstance.debugHandlerLifeCycle", new Object[]{handlerOperationName, wsName, piName});
    }

    private void handleComplexDS(WFProcessContext pCtx, Map dsMap) {
        String[] dsNames = dsMap.keySet().toArray(new String[0]);
        for (int i = 0; i < dsNames.length; ++i) {
            if (BLUtil.self().isSystemDataSlot(dsNames[i])) continue;
            Object obj = dsMap.get(dsNames[i]);
            if (obj == null) {
                dsMap.put(dsNames[i], "<NULL>");
                continue;
            }
            if (pCtx.getDataslot(dsNames[i]).isXML()) {
                XML xds = (XML)obj;
                String content = null;
                try {
                    content = xds.getContent(BLControl.getServerSession());
                }
                catch (Exception e) {
                    throw new BizLogicException("BizLogic_ERR_3699", "WFMessagePublisherInstance.handleComplexDS()", new Object[]{xds.getName(), pCtx.getProcessInstanceName()}, (Throwable)e);
                }
                dsMap.put(dsNames[i], content);
                continue;
            }
            if (pCtx.getDataslot(dsNames[i]).isDecimal()) {
                Decimal decimal = (Decimal)obj;
                BigDecimal bd = decimal.getValue();
                if (bd == null) {
                    dsMap.put(dsNames[i], "<NULL>");
                    continue;
                }
                dsMap.put(dsNames[i], bd.toString());
                continue;
            }
            if (pCtx.getDataslot(dsNames[i]).isDate()) {
                DateTime dateTime = (DateTime)obj;
                Timestamp ts = dateTime.getValue();
                if (ts == null) {
                    dsMap.put(dsNames[i], "<NULL>");
                    continue;
                }
                dsMap.put(dsNames[i], ts.getTime());
                continue;
            }
            if (!pCtx.getDataslot(dsNames[i]).isComplex()) continue;
            String str = null;
            str = BLUtil.self().getDataTransformer().toString(obj);
            String encodedStr = MessagingUtil.encodeString((String)str, (String)"base64");
            dsMap.put(dsNames[i], encodedStr);
        }
    }

    @Override
    public void skip(WFProcessContext pCtx, long wsid) {
        super.skip(pCtx, wsid);
    }
}

