/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server;

import com.savvion.sbm.bizlogic.messaging.dao.BLMessagesDAO;
import com.savvion.sbm.bizlogic.messaging.subscriber.MessageManager;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.WFWorkstepInstance;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkStepInstanceEBLocal;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLJMSService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.Message;

public class WFMessageSubscriberInstance
extends WFWorkstepInstance {
    private static WFMessageSubscriberInstance self;

    private WFMessageSubscriberInstance() {
    }

    public static WFMessageSubscriberInstance self() {
        if (self == null) {
            self = new WFMessageSubscriberInstance();
        }
        return self;
    }

    @Override
    public void execute(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        HashMap messageCountInDB = BLMessagesDAO.getMessageCountWithLoopCounter(pCtx.getProcessInstanceID(), wsid, wsieb.getLoopCounter());
        WFWorkstep ws = pCtx.getWorkstep(wsid);
        if (WFMessageSubscriberInstance.hasRequiredMessageCount(ws, messageCountInDB)) {
            if (ws.isMessageSubscriberWS()) {
                this.sendMessage(pCtx, wsid);
            } else {
                long piid = pCtx.getProcessInstanceID();
                MessageManager.executeTargetInstance(piid, wsid, false);
            }
        } else {
            int previousState = wsieb.getPreviousState();
            int currentState = wsieb.getState();
            wsieb.setPreviousState(currentState);
            wsieb.setState(60);
            if (previousState != 60) {
                BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 60), (int)60);
            }
        }
    }

    public void sendMessage(WFProcessContext pCtx, long wsid) {
        long ptid = pCtx.getProcessTemplateID();
        long piid = pCtx.getProcessInstanceID();
        HashMap<String, Object> selectors = new HashMap<String, Object>(5);
        selectors.put("TYPE", "BLSUBSCRIBERWSMDB");
        selectors.put("PROCESSTEMPLATEID", ptid);
        selectors.put("PROCESSINSTANCEID", piid);
        selectors.put("WORKSTEPID", wsid);
        try {
            BLJMSService.self().sendMessage("blmswqueue", (Object)"", 1, selectors);
        }
        catch (Exception ex) {
            String piName = pCtx.getProcessInstanceName();
            String wsName = pCtx.getWorkStepInstanceName(wsid);
            throw new BizLogicException("BizLogic_ERR_714", "WFMessageSubscriberInstance.execute()", new Object[]{piName, wsName}, (Throwable)ex);
        }
    }

    public boolean processMessage(Message msg, String destName) {
        return this.processMessage(msg, destName, false);
    }

    public boolean processMessage(Message msg) {
        BLConstants.single();
        return this.processMessage(msg, "blmswqueue", true);
    }

    @Override
    public void complete(WFProcessContext pCtx, long wsid) {
        this.validateCompletion(pCtx, wsid);
        long piid = pCtx.getProcessInstanceID();
        if (!ProcessInstanceDAO.isProcessInstanceExist(piid)) {
            BLControl.logger.errorKey("BizLogic_ERR_862", new Object[]{piid, "message subscriber", wsid});
            return;
        }
        super.complete(pCtx, wsid);
        if (pCtx.getWorkstepInstanceEB(wsid).getState() != 21) {
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 21), (int)21);
        super.afterComplete(pCtx, wsid);
        if (!this.isSuspendedByCompensatory(pCtx, wsid)) {
            this.activateNextWorksteps(pCtx, wsid);
        }
    }

    @Override
    void validateCompletion(WFProcessContext pCtx, long wsid) {
        if (!this.isActivated(pCtx, wsid) && !this.isMessageWaitState(pCtx, wsid)) {
            throw new BizLogicException("BizLogic_ERR_814", "WFMessageSubscriberInstance.validateCompletion", new Object[]{pCtx.getProcessInstanceID(), pCtx.getWorkstep(wsid).getName()});
        }
    }

    @Override
    public void terminate(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        long stat = wsieb.getState();
        if (stat == 21L) {
            return;
        }
        super.terminate(pCtx, wsid);
    }

    public static void executeWaitWorksteps(Session session) {
        Map<Long, List<Long>> subscribers = BLMessagesDAO.getWaitingSubscribersWithMessages();
        Long[] piids = subscribers.keySet().toArray(new Long[subscribers.size()]);
        if (piids != null && piids.length > 0) {
            for (Long piid : piids) {
                List<Long> wsids = subscribers.get(piid);
                if (wsids == null || wsids.isEmpty()) continue;
                for (Long wsid : wsids) {
                    BLUtil.getServiceLocal().executeWaitWorkstep(session, piid, wsid);
                }
            }
        }
    }

    public void terminateAndActivateNext(WFProcessContext pCtx, long wsid) {
        pCtx.terminateWorkstep(wsid);
        this.activateNextWorksteps(pCtx, wsid);
    }

    public void doExecuteWaitWorkstep(Session session, long piid, long wsid) {
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        this.doExecuteWaitWorkstep(pCtx, wsid);
    }

    public void doExecuteWaitWorkstep(WFProcessContext pCtx, long wsid) {
        WorkStepInstanceEBLocal wsieb = pCtx.getWorkstepInstanceEB(wsid);
        wsieb.setPreviousState(wsieb.getState());
        wsieb.setState(18);
        WFMessageSubscriberInstance.self().execute(pCtx, wsid);
    }

    @Override
    public void skip(WFProcessContext pCtx, long wsid) {
        super.skip(pCtx, wsid);
    }

    @Override
    public void resume(WFProcessContext pCtx, long wsid) {
        if (this.isActivated(pCtx, wsid)) {
            BLControl.logger.warnKey("BizLogic_ERR_1670", new Object[]{pCtx.getWorkstep(wsid).getName(), pCtx.getProcessInstanceName()});
            return;
        }
        BLUtil.fireEvent(this.getEventContext(pCtx, wsid, 60), (int)60);
        this.doExecuteWaitWorkstep(pCtx, wsid);
    }
}

