/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.dao;

import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLDAOService;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BODAO
extends BLDAOService {
    private static Map<String, Integer> javaToSqlType = new HashMap<String, Integer>();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long executeInsert(Map<String, Object> queryParamMap, String autoGenColumn) {
        if (queryParamMap == null) throw new BizLogicException("BizLogic_ERR_4650", "BODAO.executeInsert()");
        if (queryParamMap.isEmpty()) {
            throw new BizLogicException("BizLogic_ERR_4650", "BODAO.executeInsert()");
        }
        if (autoGenColumn == null || autoGenColumn.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4648", "BODAO.executeInsert()", new Object[]{"The parameter autoGenColumn"});
        }
        String sql = (String)queryParamMap.get("SQL");
        Object[] params = (Object[])queryParamMap.get("PARAMS");
        String[] javaTypes = (String[])queryParamMap.get("JAVA_TYPE");
        if (sql == null || sql.trim().length() == 0) {
            throw new BizLogicException("BizLogic_ERR_4648", "BODAO.executeInsert()", new Object[]{"SQL statement"});
        }
        if (params == null || params.length == 0) {
            throw new BizLogicException("BizLogic_ERR_4648", "BODAO.executeInsert()", new Object[]{"Parameter array"});
        }
        if (javaTypes == null || javaTypes.length == 0) {
            throw new BizLogicException("BizLogic_ERR_4648", "BODAO.executeInsert()", new Object[]{"Java Type array"});
        }
        long autoGenVal = 0L;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = BODAO.getConnection();
            pstmt = conn.prepareStatement(sql, new String[]{autoGenColumn});
            if (params.length != javaTypes.length) throw new BizLogicException("BizLogic_ERR_4649", "BODAO.executeInsert()");
            for (int i = 0; i < params.length; ++i) {
                int index = i + 1;
                BODAO.setParameter(pstmt, index, javaTypes[i], params[i]);
            }
            if (BLUtil.self().isDebugBizObject() || BLUtil.self().DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_4656", new Object[]{sql.trim(), Arrays.toString(params)});
            }
            pstmt.executeUpdate();
            rs = pstmt.getGeneratedKeys();
            if (rs.next()) {
                autoGenVal = BODAO.convertToLong(rs.getObject(1));
            }
            if (BLUtil.self().isDebugBizObject() || BLUtil.self().DEBUG_DAO) {
                BLControl.logger.debugKey("BizLogic_ERR_4657", new Object[]{autoGenColumn, autoGenVal});
            }
        }
        catch (BizLogicException ble) {
            try {
                throw ble;
                catch (Throwable th) {
                    throw new BizLogicException("BizLogic_ERR_4651", "BODAO.executeInsert()", th);
                }
            }
            catch (Throwable throwable) {
                BODAO.clean(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        BODAO.clean((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return autoGenVal;
    }

    private static void setParameter(PreparedStatement stmt, int index, String javaType, Object value) throws SQLException {
        if (value != null) {
            stmt.setObject(index, value);
        } else {
            stmt.setNull(index, BODAO.getSQLType(javaType));
        }
    }

    private static int getSQLType(String javaType) {
        Integer sqlTypeInt = javaToSqlType.get(javaType);
        if (sqlTypeInt != null) {
            return sqlTypeInt;
        }
        return 1111;
    }

    private static long convertToLong(Object objVal) {
        long longVal = 0L;
        if (!(objVal instanceof Number)) {
            throw new BizLogicException("BizLogic_ERR_4652", "BODAO.convertToLong()", new Object[]{objVal.getClass().getName()});
        }
        longVal = ((Number)objVal).longValue();
        return longVal;
    }

    static {
        javaToSqlType.put("java.lang.String", 12);
        javaToSqlType.put("java.lang.Byte", -6);
        javaToSqlType.put("java.lang.Short", 5);
        javaToSqlType.put("java.lang.Integer", 4);
        javaToSqlType.put("java.lang.Long", -5);
        javaToSqlType.put("java.lang.Float", 7);
        javaToSqlType.put("java.lang.Double", 8);
        javaToSqlType.put("java.lang.Boolean", -7);
        javaToSqlType.put("java.sql.Date", 91);
        javaToSqlType.put("java.sql.Time", 92);
        javaToSqlType.put("java.sql.Timestamp", 93);
    }
}

