/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.ejb;

import com.savvion.sbm.bizlogic.server.ProcessControl;
import com.savvion.sbm.bizlogic.server.WFAtomicWS;
import com.savvion.sbm.bizlogic.server.WFCWorkItem;
import com.savvion.sbm.bizlogic.server.WFProcess;
import com.savvion.sbm.bizlogic.server.WFProcessContext;
import com.savvion.sbm.bizlogic.server.WFWorkItem;
import com.savvion.sbm.bizlogic.server.WFWorkstep;
import com.savvion.sbm.bizlogic.server.dao.BLLockDAO;
import com.savvion.sbm.bizlogic.server.dao.CWorkItemDAO;
import com.savvion.sbm.bizlogic.server.dao.ProcessInstanceTemplateDAO;
import com.savvion.sbm.bizlogic.server.dao.WorkItemDAO;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemEBLocal;
import com.savvion.sbm.bizlogic.server.svo.CWorkItem;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.SVOFactory;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.util.BLControl;
import com.savvion.sbm.bizlogic.util.BLUtil;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.bizlogic.util.SessionAdapter;
import com.savvion.sbm.bizlogic.util.SessionManager;
import com.savvion.sbm.util.ResultData;
import com.tdiinc.common.Emailer.OutGoingMailException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WorkItemSBBean
extends SessionAdapter {
    public HashMap getAttributes(Session session, long wiID) {
        SessionManager.validate((Session)session, (String)"WISB::getAttributes(s, wiID)");
        WorkItem wi = SVOFactory.getWorkItem(session, wiID);
        return wi.getAttributes();
    }

    public HashMap getQSWorkItemDataAttributes(Session session, long piid, long wsID, long wiID) {
        SessionManager.validate((Session)session, (String)"WISB::getQSWorkItemDataAttributes(s, piid, wsID, wiID)");
        return SVOFactory.getQSWorkItemDataAttributes(session, piid, wsID, wiID);
    }

    public void save(Session session, long wiID, HashMap modifiedAttribs) {
        SessionManager.validate((Session)session, (String)"WISB::save(s, wiID, modifiedAttribs)");
        this.saveWorkItem(session, wiID, modifiedAttribs);
    }

    public void save(Session session, HashMap modifiedAttribsByWIID) {
        SessionManager.validate((Session)session, (String)"WISB::save(s, wiID, modifiedAttribs)");
        if (modifiedAttribsByWIID != null && !modifiedAttribsByWIID.isEmpty()) {
            long wiid = 0L;
            HashMap modifiedAttrs = null;
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : modifiedAttribsByWIID.entrySet()) {
                wiid = (Long)entry2.getKey();
                modifiedAttrs = (HashMap)entry2.getValue();
                if (modifiedAttrs == null || modifiedAttrs.isEmpty()) continue;
                this.saveWorkItem(session, wiid, modifiedAttrs);
            }
        }
    }

    private void saveWorkItem(Session session, long wiid, HashMap modifiedAttribs) {
        if (modifiedAttribs.containsKey("INSTRUCTION")) {
            modifiedAttribs.remove("INSTRUCTION");
        }
        if (modifiedAttribs.containsKey("MILESTONE_NAME")) {
            modifiedAttribs.remove("MILESTONE_NAME");
        }
        if (modifiedAttribs.containsKey("MILESTONE_DESC")) {
            modifiedAttribs.remove("MILESTONE_DESC");
        }
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        pCtx.setWorkItemAttributes(wiid, modifiedAttribs);
    }

    public void assignNext(Session session, long wiID, String performer) {
        SessionManager.validate((Session)session, (String)"WISB::assignNext(s, wiID, performer)");
        BLLockDAO.workitem(wiID, "WorkItemSBBean.assign");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        try {
            pCtx.assignWorkItem(wiID, performer);
        }
        catch (OutGoingMailException ex) {
            BLControl.logger.errorKey("BizLogic_ERR_3568", "WorkItemSBBean.assignNext()", (Throwable)ex, new Object[]{pCtx.getProcessInstanceID(), wiID});
        }
    }

    public boolean assignNextIfAvailable(Session session, long wiID, String performer) {
        SessionManager.validate((Session)session, (String)"WISB::assignNextIfAvailable(s, wiID, performer)");
        BLLockDAO.workitem(wiID, "WorkItemSBBean.assign");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        return pCtx.assignWorkItemIfAvailable(wiID, performer);
    }

    public void assign(Session session, long wiID, String performer) {
        SessionManager.validate((Session)session, (String)"WISB::assign(s, wiID, performer)");
        WFWorkItem.self().assign(session, wiID, performer);
    }

    public ResultData<List<Long>> assign(Session session, List<Long> wiids, String performer, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"WISB::assign(s, wiids, performer, isMultiTrans)");
        return WFWorkItem.self().assign(session, wiids, performer, isMultiTrans);
    }

    public ResultData<List<Long>> assign(Session session, Map<Long, String> wiids, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"WISB::assign(s, wiids, isMultiTrans)");
        return WFWorkItem.self().assign(session, wiids, isMultiTrans);
    }

    public void reAssign(Session session, long wiID, String performer) {
        SessionManager.validate((Session)session, (String)"WISB::reAssign(s, wiID, performer)");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        pCtx.reAssignWorkItem(wiID, performer);
    }

    public Vector getAvailablePerformers(Session session, long wiID) {
        SessionManager.validate((Session)session, (String)"WISB::getAvailablePerformers(s, wiID)");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        return pCtx.getAvailableWorkItemPerformers(wiID);
    }

    public boolean isAvailablePerformer(Session session, long wiID, String performer) {
        SessionManager.validate((Session)session, (String)"WISB::isAvailablePerformer(s, wiID, performer)");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        return pCtx.isAvailableWorkItemPerformer(wiID, performer);
    }

    public boolean isAssignedPerformer(Session session, long wiID, String performer) {
        SessionManager.validate((Session)session, (String)"WISB::isAssignedPerformer(s, wiID, performer)");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        return pCtx.isAssignedWorkItemPerformer(wiID, performer);
    }

    public long create(Session session, long piID, String wsName, String performer, HashMap attributes, HashMap dsValues) {
        SessionManager.validate((Session)session, (String)"WISB::create(s, piID, wsName, performer, attributes, dsValues)");
        WFProcessContext pCtx = new WFProcessContext(session, piID);
        return pCtx.createWorkItem(piID, wsName, performer, attributes, dsValues);
    }

    public void suspend(Session session, long wiID, String reason) {
        SessionManager.validate((Session)session, (String)"WISB::suspend(s, wiID, reason)");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        pCtx.suspendWorkItem(wiID, reason);
    }

    public void resume(Session session, long wiID) {
        SessionManager.validate((Session)session, (String)"WISB::resume(s, wiID)");
        WFWorkItem.self().resumeByClient(session, wiID);
    }

    public void remove(Session session, long wiID) {
        SessionManager.validate((Session)session, (String)"WISB::remove(s, piID, wiID)");
        WFProcessContext pCtx = new WFProcessContext(session, wiID, true);
        pCtx.removeWorkItem(wiID);
    }

    public void complete(Session session, long wiID, HashMap dsValues) {
        SessionManager.validate((Session)session, (String)"WISB::complete(s, wiID, dsValues)");
        long piid = WorkItemDAO.getProcessInstanceId(wiID);
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.completeWorkItem(wiID, dsValues);
    }

    public void complete(Session session, long wiId, String wiPerformer, Map<String, Object> dsValues) {
        SessionManager.validate((Session)session, (String)"WISB::complete(s, wiId, wiPerformer, dsValues)");
        long piid = WorkItemDAO.getProcessInstanceId(wiId);
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.completeWorkItem(wiId, wiPerformer, dsValues);
    }

    public void complete(Session session, long wiId, String wiPerformer, Map<String, Object> dsValues, Hashtable<String, Object> resources) {
        SessionManager.validate((Session)session, (String)"WISB::complete(s, wiId, wiPerformer, dsValues, resources)");
        long piid = WorkItemDAO.getProcessInstanceId(wiId);
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (resources != null && !resources.isEmpty()) {
            pCtx.setResources(resources);
        }
        pCtx.completeWorkItem(wiId, wiPerformer, dsValues);
    }

    public void complete(Session session, long wiID, HashMap dsValues, Hashtable resources) {
        SessionManager.validate((Session)session, (String)"WISB::complete(s, wiID, dsValues, resources)");
        long piid = WorkItemDAO.getProcessInstanceId(wiID);
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.setResources(resources);
        pCtx.completeWorkItem(wiID, dsValues);
    }

    public void skip(Session session, long wiId) {
        SessionManager.validate((Session)session, (String)"WISB::skip(s, wiId)");
        WFProcessContext pCtx = new WFProcessContext(session, wiId, true);
        pCtx.skipWorkItem(wiId);
    }

    public WorkItem getWorkItem(Session session, long wiID) {
        SessionManager.validate((Session)session, (String)"WISB::getWorkItem(s, wiID)");
        return SVOFactory.getWorkItem(session, wiID);
    }

    public WorkItem getWorkItem(Session session, long wiID, boolean withDataSlot) {
        SessionManager.validate((Session)session, (String)"WISB::getWorkItem(s, wiID, withDataSlot)");
        return SVOFactory.getWorkItem(session, wiID, withDataSlot);
    }

    public WorkItemList getWorkItemList(Session session, String performer) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getWorkItemList(s, performer)");
        return SVOFactory.getWorkItemList(session, null, null, null, performer);
    }

    public WorkItemList getWorkItemList(Session session, long ptID, String performer) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getWorkItemList(s, ptID, performer)");
        return SVOFactory.getWorkItemList(session, new long[]{ptID}, null, null, performer);
    }

    public WorkItemList getWorkItemList(Session session, long piID) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getWorkItemList(s, piID)");
        return SVOFactory.getWorkItemList(session, null, new long[]{piID}, null, session.getUser());
    }

    public WorkItemList getSuspendedWorkItemList(Session session, String user) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getSuspendedWorkItemList(s, user)");
        int[] nArray = new int[1];
        nArray[0] = 32;
        return SVOFactory.getWorkItemList(session, null, null, nArray, user);
    }

    public WorkItemList getList(Session session, long[] ptids, long[] piids, int[] states) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getList(s, ptids, piids, states)");
        return SVOFactory.getWorkItemList(session, ptids, piids, states, session.getUser());
    }

    public WorkItemList getList(Session session, long piid, String wsName) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getList(s, piid, wsName)");
        return WFWorkItem.self().getWorkItemList(session, piid, wsName);
    }

    public ResultData<List<Long>> suspend(Session session, List<Long> idList) {
        SessionManager.validate((Session)session, (String)"WISB::suspend(s, idList)");
        return WFWorkItem.self().suspendByClient(session, idList);
    }

    public ResultData<List<Long>> resume(Session session, List<Long> idList) {
        SessionManager.validate((Session)session, (String)"WISB::resume(s, idList)");
        return WFWorkItem.self().resumeByClient(session, idList);
    }

    public ResultData<List<Long>> remove(Session session, List<Long> idList) {
        SessionManager.validate((Session)session, (String)"WISB::remove(s, idList)");
        return WFWorkItem.self().removeByClient(session, idList);
    }

    public ResultData<List<Long>> complete(Session session, List<Long> idList) {
        SessionManager.validate((Session)session, (String)"WISB::complete(s, idList)");
        return WFWorkItem.self().completeByClient(session, idList);
    }

    public ResultData<List<Long>> complete(Session session, List<Long> idList, Map<String, Object> dsValues, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"WISB::complete(s, idList, dsValues, isMultiTrans)");
        return WFWorkItem.self().completeByClient(session, idList, dsValues, isMultiTrans);
    }

    public DataSlotList getInputDataSlotList(Session session, long wiid, boolean withMetaData) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getInputDataSlotList(session, wiid, withMetaData)");
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        String[] inputDataSlotNameList = pCtx.getWorkstep(wieb.getWorkStepID()).getInputSlotsKeys();
        if (inputDataSlotNameList == null) {
            return null;
        }
        return SVOFactory.getDataSlotList(pCtx, wieb.getProcessTemplateID(), wieb.getProcessInstanceID(), wieb.getWorkStepID(), inputDataSlotNameList, withMetaData);
    }

    public DataSlotList getOutputDataSlotList(Session session, long wiid, boolean withMetaData) throws RemoteException {
        DataSlotList dsl = null;
        SessionManager.validate((Session)session, (String)"WISB::getOutputDataSlotList(session, wiid, withMetaData)");
        WFProcessContext pCtx = new WFProcessContext(session, wiid, true);
        WorkItemEBLocal wieb = pCtx.getWorkItemEB(wiid);
        String[] outputDataSlotNameList = pCtx.getWorkstep(wieb.getWorkStepID()).getOutputSlotsKeys();
        if (outputDataSlotNameList == null) {
            return null;
        }
        dsl = SVOFactory.getDataSlotList(pCtx, wieb.getProcessTemplateID(), wieb.getProcessInstanceID(), wieb.getWorkStepID(), outputDataSlotNameList, withMetaData);
        return dsl;
    }

    public HashMap getDataSlotList(Session session, long wiid, boolean withMetaData) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getDataSlotList(session, wiid, withMetaData)");
        WFProcessContext pCtx = new WFProcessContext(session, wiid, withMetaData);
        return SVOFactory.getWorkItemDataSlotList(pCtx, wiid, withMetaData);
    }

    public DataSlot getDataSlot(Session session, long wiid, String dsName) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getDataSlot(session, wiid, dsName)");
        WorkItemEBLocal wiEB = BLUtil.self().getWorkItemEB(wiid);
        WFProcess pt = ProcessControl.getProcessTemplate(wiEB.getProcessTemplateID());
        WFWorkstep ws = pt.getWorkstep(wiEB.getWorkStepID());
        if (ws.hasThisInput(dsName) || ws.hasThisOutput(dsName)) {
            return SVOFactory.getDataSlot(session, wiEB.getProcessInstanceID(), dsName);
        }
        throw new BizLogicException("BizLogic_ERR_1680", "WorkItemSB.getDataSlot", new Object[]{dsName, pt.getName() + ws.getName()});
    }

    public Map getEmailTemplateInstance(Session session, long wiid) {
        SessionManager.validate((Session)session, (String)"getEmailTemplateInstance(session,wiid)");
        return WFWorkItem.getEmailTemplateInstance(session, wiid);
    }

    public boolean getEmailSupport(Session session, long ptid, long piid, long parentid, long wsid) {
        SessionManager.validate((Session)session, (String)"WISB::getEmailSupport(session, ptid, piid, parentid, wsid)");
        WFWorkstep ws = null;
        if (parentid <= 0L) {
            ws = ProcessControl.getProcessTemplate(ptid).getWorkstep(wsid);
        } else {
            WFProcess pt = ProcessInstanceTemplateDAO.load(piid);
            ws = pt.getWorkstep(wsid);
        }
        if (ws.getType() == 102) {
            return ((WFAtomicWS)ws).getEmailSupport();
        }
        return false;
    }

    public void makeAvailable(Session session, long piid, long wiid, Vector performers) {
        SessionManager.validate((Session)session, (String)"WISB::makeAvailable(s,piid,wiid,performers)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        WorkItemEBLocal wiEB = BLUtil.self().getWorkItemEB(wiid);
        long wsid = wiEB.getWorkStepID();
        pCtx.makeAvailable(wsid, performers);
    }

    public ResultData<List<Long>> makeAvailable(Session session, List<Long> wiids, List<String> performers, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"WISB::makeAvailable(s,piid,wiid,performers)");
        return WFWorkItem.self().makeAvailable(session, wiids, performers, isMultiTrans);
    }

    public boolean isExist(Session session, long workItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"isExist(s, wiid)");
        return WorkItemDAO.isWorkItemExist(workItemId);
    }

    public boolean sendAssignedTask(Session session, long wiid) {
        SessionManager.validate((Session)session, (String)"sendAssignedTask(session,wiid)");
        return WFWorkItem.self().sendAssignedTask(session, wiid);
    }

    public void reAssign(Session session, List wiids, String performer, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"reAssign(session,wiids,performer,isMultiTrans)");
        WFWorkItem.self().reAssign(session, wiids, performer, isMultiTrans);
    }

    public ResultData<List<Long>> reAssign(Session session, Hashtable wiids, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"reAssign(session,wiids,isMultiTrans)");
        return WFWorkItem.self().reAssign(session, wiids, isMultiTrans);
    }

    public void reAssign(Session session, String fromPerformer, String toPerformer, boolean isMultiTrans) {
        SessionManager.validate((Session)session, (String)"reAssign(session,fromPerformer,toPerformer,isMultiTrans)");
        WFWorkItem.self().reAssign(session, fromPerformer, toPerformer, isMultiTrans);
    }

    public void markRead(Session session, long wiid, long readTime) {
        SessionManager.validate((Session)session, (String)"markRead(session, readTime)");
        WFWorkItem.self().markRead(session, wiid, readTime);
    }

    public long createCWorkItems(Session session, long parentWIID, List<String> collaborators, String taskNameAlias, Map<String, Object> cwiData) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::createCWorkItem(s, parentWIID, CWorkItemData)");
        WFProcessContext pCtx = new WFProcessContext(session, parentWIID, true);
        long taskID = pCtx.createCWorkItems(parentWIID, collaborators, taskNameAlias, cwiData);
        return taskID;
    }

    public CWorkItem getCWorkItem(Session session, long cWorkItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getCWorkItem(s, cWorkItemId)");
        return SVOFactory.getCWorkItem(session, cWorkItemId);
    }

    public boolean isExistCWorkItem(Session session, long workitemId, long cWorkItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::isExistCWorkItem(s, cWorkItemId)");
        return CWorkItemDAO.isCWorkItemExist(workitemId, cWorkItemId);
    }

    public Map<String, Object> getCWorkItemAttributes(Session session, long cWorkItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getCWorkItemAttrs(s, cWorkItemId)");
        CWorkItem cwi = SVOFactory.getCWorkItem(session, cWorkItemId);
        return cwi.getAttributes();
    }

    public DataSlotList getDataSlotList(Session session, long wiid, String[] dsNames, boolean withMetaData) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::getDSList(s, wiid, dsNames, withMetaData)");
        return WFWorkItem.self().getDataSlotList(session, wiid, dsNames, withMetaData);
    }

    public void reAssignCWorkItem(Session session, long piid, long cWorkItemId, String collaborator) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::reAssignCWorkItem(s, piid, cWorkItemId, collaborator)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.reAssignCWorkItem(cWorkItemId, collaborator);
    }

    public void declineCWorkItem(Session session, long piid, long cWorkItemId, String reason) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::declineCWorkItem(s, piid, cWorkItemId, reason)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.declineCWorkItem(cWorkItemId, reason);
    }

    public void assignCWorkItem(Session session, long piid, long cWorkItemId, String collaborator) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::assignCWorkItem(s, piid, cWorkItemId, collaborator)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.assignCWorkItem(cWorkItemId, collaborator);
    }

    public void suspendCWorkItem(Session session, long piid, long cWorkItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::suspendCWorkItem(s, piid, cWorkItemId)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.suspendCWorkItem(cWorkItemId);
    }

    public ResultData<List<Long>> suspendCWorkItem(Session session, List<Map<String, Long>> idList) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::suspendCWorkItem(s, piid, idList)");
        return WFCWorkItem.self().suspendByClient(session, idList);
    }

    public void resumeCWorkItem(Session session, long piid, long cWorkItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::resumeCWorkItem(s, piid, cWorkItemId)");
        WFCWorkItem.self().resumeByClient(session, piid, cWorkItemId);
    }

    public ResultData<List<Long>> resumeCWorkItem(Session session, List<Map<String, Long>> idList) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::resumeCWorkItem(s, piid, idList)");
        return WFCWorkItem.self().resumeByClient(session, idList);
    }

    public void terminateCWorkItem(Session session, long piid, long cWorkItemId) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::terminateCWorkItem(s, piid, cWorkItemId)");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        pCtx.terminateCWorkItem(cWorkItemId);
    }

    public ResultData<List<Long>> terminateCWorkItem(Session session, List<Map<String, Long>> idList) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::terminateCWorkItem(s, piid, idList)");
        return WFCWorkItem.self().terminateByClient(session, idList);
    }

    public void completeCWorkItem(Session session, long piid, long cWorkItemId, HashMap dsValues, HashMap modifiedAttrs, Hashtable resources) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::completeCWorkItem()");
        WFProcessContext pCtx = new WFProcessContext(session, piid);
        if (resources != null && !resources.isEmpty()) {
            pCtx.setResources(resources);
        }
        pCtx.completeCWorkItem(cWorkItemId, dsValues, modifiedAttrs);
    }

    public ResultData<List<Long>> completeCWorkItem(Session session, List<Map<String, Long>> idList) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::completeCWorkItem(s, piid, idList)");
        return WFCWorkItem.self().completeByClient(session, idList);
    }

    public void saveCWorkItem(Session session, long cWorkItemId, Map<String, Object> modifiedAttrs) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::saveCWorkItem(s, cwiID, modifiedAttrs)");
        WFCWorkItem.self().saveCWI(session, cWorkItemId, modifiedAttrs);
    }

    public void saveCWorkItem(Session session, Map<Long, Map<String, Object>> modifiedAttrs) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::saveCWorkItem(s, modifiedAttrs)");
        WFCWorkItem.self().saveCWI(session, modifiedAttrs);
    }

    public List<WorkItem> getWorkItems(Session session, List<Long> wiids) throws RemoteException {
        SessionManager.validate((Session)session, (String)"WISB::saveCWorkItem(s, wiids)");
        return WFWorkItem.self().getWorkItems(session, wiids);
    }
}

