/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSBHome;
import com.savvion.sbm.bizlogic.server.svo.Application;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.ServiceLocator;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.EJBHome;

public class ApplicationService {
    static final Application createVersion(Session ses, ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        return ApplicationService.createVersion(ses, ApplicationService.getContent(xmlContent));
    }

    static final Application createVersion(Session ses, String xmlFileName) throws BizLogicClientException, RemoteException {
        return ApplicationService.getProcessTemplateSB().createVersion(ses, xmlFileName, true);
    }

    static final Application create(Session ses, ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        return ApplicationService.create(ses, ApplicationService.getContent(xmlContent));
    }

    static final Application create(Session ses, String xmlFileName) throws BizLogicClientException, RemoteException {
        return ApplicationService.getProcessTemplateSB().createVersion(ses, xmlFileName, true);
    }

    static final Application create(Session ses, String appName, String xmlFileName) throws BizLogicClientException, RemoteException {
        if (appName == null || "".equals(appName)) {
            throw new BizLogicClientException("Bizlogic_ERR_3716", new Object[]{appName});
        }
        return ApplicationService.getProcessTemplateSB().createVersion(ses, xmlFileName, true);
    }

    static final ProcessTemplate createTemplateVersion(ProcessTemplate pt, ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        return ApplicationService.createTemplateVersion(pt, ApplicationService.getContent(xmlContent));
    }

    static final ProcessTemplate createTemplateVersion(ProcessTemplate pt, String xmlDefinition) throws BizLogicClientException, RemoteException {
        return pt.createVersion(xmlDefinition);
    }

    static final String getContentString(String xmlFileName) {
        return FileUtil.getString((String)xmlFileName);
    }

    static final String getContent(ByteArrayInputStream xmlContent) {
        return FileUtil.getString((ByteArrayInputStream)xmlContent);
    }

    static final ByteArrayInputStream getContent(String xmlFileName) {
        return FileUtil.getContent((String)xmlFileName);
    }

    static final ProcessTemplate replaceActiveTemplate(ProcessTemplate pt, ByteArrayInputStream xmlContent) throws BizLogicClientException, RemoteException {
        if (xmlContent != null) {
            return pt.replace(ApplicationService.getContent(xmlContent));
        }
        return pt.replace();
    }

    static final long[] getProcessTemplateIDs(ArrayList ptsvos) {
        if (ptsvos == null || ptsvos.isEmpty()) {
            return null;
        }
        long[] ptids = new long[ptsvos.size()];
        for (int i = 0; i < ptsvos.size(); ++i) {
            ProcessTemplate pt = (ProcessTemplate)ptsvos.get(i);
            ptids[i] = pt.getID();
        }
        return ptids;
    }

    static final String[] getProcessTemplateNames(ArrayList ptsvos) {
        if (ptsvos == null || ptsvos.isEmpty()) {
            return null;
        }
        String[] ptNames = new String[ptsvos.size()];
        for (int i = 0; i < ptsvos.size(); ++i) {
            ProcessTemplate pt = (ProcessTemplate)ptsvos.get(i);
            ptNames[i] = pt.getName();
        }
        return ptNames;
    }

    static final BLServer getBLServer() throws BizLogicClientException, RemoteException {
        return (BLServer)ApplicationService.getRemoteRef(BLServerHome.class);
    }

    static final ProcessTemplateSB getProcessTemplateSB() throws BizLogicClientException, RemoteException {
        return (ProcessTemplateSB)ApplicationService.getRemoteRef(ProcessTemplateSBHome.class);
    }

    static final Object getRemoteRef(Class homeClass) throws BizLogicClientException, RemoteException {
        return ApplicationService.getRemoteRef(null, homeClass);
    }

    static final Object getRemoteRef(String appServerID, Class homeClass) throws BizLogicClientException, RemoteException {
        SBMHomeFactory sbmHome = SBMHomeFactory.self();
        EJBHome home = null;
        Object remoteRef = null;
        for (int retryCnt = 1; retryCnt <= ServiceLocator.self().getLookupRetryCount(); ++retryCnt) {
            try {
                home = appServerID == null ? sbmHome.lookupHome(homeClass) : sbmHome.lookupHome(appServerID, homeClass);
                Method createMethod = homeClass.getMethod("create", new Class[0]);
                remoteRef = createMethod.invoke((Object)home, new Object[0]);
                break;
            }
            catch (Exception e) {
                if (retryCnt == ServiceLocator.self().getLookupRetryCount()) {
                    throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{homeClass.getName()}, (Throwable)e);
                }
                try {
                    Thread.sleep(ServiceLocator.LOOKUP_RETRY_INTERVAL);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                continue;
            }
        }
        return remoteRef;
    }
}

