/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotes;
import com.savvion.sbm.bizlogic.client.queryservice.QueryService;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.FileUtil;
import com.savvion.sbm.util.SBMHomeFactory;
import com.savvion.sbm.util.SBMUtil;
import com.savvion.sbm.util.ServiceLocator;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

public abstract class BLProcess
implements Serializable {
    protected long id;
    protected HashMap attributes = new HashMap();
    protected HashMap modifiedAttrs = new HashMap(10);
    protected transient EJBObject remoteRef;
    protected Session session;
    private boolean isClustering = false;
    protected boolean removed = false;
    private transient QueryService qs;

    BLProcess(Session session, long id, HashMap attrs) {
        this.session = session;
        this.id = id;
        if (attrs != null) {
            BLConstants.single();
            Object priority = attrs.get("PRIORITY");
            this.attributes = priority instanceof Integer ? this.convertPriorityToString(attrs) : attrs;
            if (attrs.get("QUERYSERVICESVO") == null) {
                this.isClustering = ServiceLocator.self().isCluster();
            } else {
                attrs.remove("QUERYSERVICESVO");
            }
        }
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    protected HashMap getModifiedAttributes() {
        return this.modifiedAttrs;
    }

    protected void setAttribute(Object key, Object value) {
        if (key == null) {
            return;
        }
        this.attributes.put(key, value);
        this.modifiedAttrs.put(key, value);
    }

    public int getState() {
        BLConstants.single();
        Integer val = (Integer)this.attributes.get("STATUS");
        return val;
    }

    public String getStateDescription() {
        int state = this.getState();
        return BLConstants.single().wfStates[state];
    }

    public boolean isActivated() throws BizLogicClientException, RemoteException {
        block3: {
            block2: {
                int state = this.getState();
                BLConstants consts = BLConstants.single();
                if (state == 18) break block2;
                if (state == 7) break block2;
                if (state != 2) break block3;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() throws BizLogicClientException {
        block3: {
            block2: {
                int state = this.getState();
                BLConstants consts = BLConstants.single();
                if (state == 16) break block2;
                if (state == 8) break block2;
                if (state == 32) break block2;
                if (state == 66) break block2;
                if (state != 4) break block3;
            }
            return true;
        }
        return false;
    }

    public long getStartTime() {
        BLConstants.single();
        return (Long)this.attributes.get("STARTTIME");
    }

    public String getPriority() {
        BLConstants.single();
        return (String)this.attributes.get("PRIORITY");
    }

    public void setPriority(String priority) throws BizLogicClientException {
        if (priority == null) {
            throw new BizLogicClientException("BizLogic_ERR_1592", new Object[]{"null"});
        }
        BLConstants.single();
        this.attributes.put("PRIORITY", priority.toLowerCase());
        BLConstants.single();
        this.modifiedAttrs.put("PRIORITY", priority.toLowerCase());
    }

    protected void setSession(Session ses) {
        this.session = ses;
    }

    public Object getSession() {
        return this.session;
    }

    protected final EJBObject getRemoteRef() throws BizLogicClientException, RemoteException {
        if (this.remoteRef == null || this.isClustering) {
            this.remoteRef = this.findRemoteRef();
        }
        return this.remoteRef;
    }

    protected static final Object getRemoteRef(Class homeClass) throws BizLogicClientException, RemoteException {
        return BLProcess.getRemoteRef(null, homeClass);
    }

    protected static final Object getRemoteRef(String appServerID, Class homeClass) throws BizLogicClientException, RemoteException {
        SBMHomeFactory sbmHome = SBMHomeFactory.self();
        EJBHome home = null;
        Object remoteRef = null;
        for (int retryCnt = 1; retryCnt <= ServiceLocator.self().getLookupRetryCount(); ++retryCnt) {
            try {
                home = appServerID == null ? sbmHome.lookupHome(homeClass) : sbmHome.lookupHome(appServerID, homeClass);
                Method createMethod = homeClass.getMethod("create", new Class[0]);
                remoteRef = createMethod.invoke((Object)home, new Object[0]);
                break;
            }
            catch (Exception e) {
                if (retryCnt == ServiceLocator.self().getLookupRetryCount()) {
                    throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{homeClass.getName()}, (Throwable)e);
                }
                try {
                    Thread.sleep(ServiceLocator.LOOKUP_RETRY_INTERVAL);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                continue;
            }
        }
        return remoteRef;
    }

    protected final boolean isDataSlot(String dsName, Collection dsNames) {
        if (dsName != null && !"".equals(dsName) && dsNames != null) {
            return dsNames.contains(dsName);
        }
        return false;
    }

    public final boolean isSystemDataSlot(String dsName) {
        if (dsName != null && !"".equals(dsName)) {
            BLConstants.single();
            if (dsName.startsWith("@")) {
                String string = dsName.trim();
                BLConstants.single();
                String name = string.substring("@".length());
                if ("CREATOR".equalsIgnoreCase(name) || "PROCESSNAME".equalsIgnoreCase(name) || "WORKSTEPNAME".equalsIgnoreCase(name) || "PRIORITY".equalsIgnoreCase(name) || "STARTTIME".equalsIgnoreCase(name) || "ALLDATASLOTS".equalsIgnoreCase(name) || dsName.equalsIgnoreCase("@PROCESS_INSTANCE_ID") || dsName.equalsIgnoreCase("@PROCESS_TEMPLATE_NAME")) {
                    return true;
                }
            }
        }
        return false;
    }

    public abstract String getName();

    public abstract long getID();

    public abstract void save() throws BizLogicClientException, RemoteException;

    public abstract void suspend() throws BizLogicClientException, RemoteException;

    public abstract void resume() throws BizLogicClientException, RemoteException;

    public abstract void remove() throws BizLogicClientException, RemoteException;

    public abstract void refresh() throws BizLogicClientException, RemoteException;

    protected abstract EJBObject findRemoteRef() throws BizLogicClientException, RemoteException;

    protected void setState(int status) {
        BLConstants.single();
        this.attributes.put("STATUS", status);
    }

    protected String getFileContent(String fileName) throws BizLogicClientException {
        String string;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(fileName);
            byte[] content = new byte[fs.available()];
            fs.read(content);
            string = new String(content).trim();
        }
        catch (Exception ex) {
            try {
                throw new BizLogicClientException("BizLogic_ERR_1694", new Object[]{"open file", ex.getMessage()}, (Throwable)ex);
            }
            catch (Throwable throwable) {
                FileUtil.close(fs);
                throw throwable;
            }
        }
        FileUtil.close((InputStream)fs);
        return string;
    }

    public Calendar getBizDate(String calName, long startTime, long duration) throws BizLogicClientException, RemoteException {
        BLServer blServer = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blServer.getBizDate(calName, startTime, duration);
    }

    public Calendar getBizDate(long startTime, long duration) throws BizLogicClientException, RemoteException {
        BLServer blServer = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blServer.getBizDate(startTime, duration);
    }

    private HashMap convertPriorityToString(HashMap attrs) {
        BLConstants.single();
        Object obj = attrs.get("PRIORITY");
        if (obj != null) {
            int priority = (Integer)obj;
            BLConstants.single();
            attrs.put("PRIORITY", SBMUtil.self().getStringPriority(priority));
        }
        return attrs;
    }

    protected static final String getStringWSType(int wstype) {
        String str = null;
        BLConstants.single();
        if (wstype == 100) {
            str = "START";
        } else {
            BLConstants.single();
            if (wstype == 101) {
                str = "END";
            } else {
                BLConstants.single();
                if (wstype == 105) {
                    str = "OR-JOIN";
                } else {
                    BLConstants.single();
                    if (wstype == 113) {
                        str = "XOR-JOIN";
                    } else {
                        BLConstants.single();
                        if (wstype == 104) {
                            str = "AND-JOIN";
                        } else {
                            BLConstants.single();
                            if (wstype == 103) {
                                str = "PARALLEL-SPLIT";
                            } else {
                                BLConstants.single();
                                if (wstype == 106) {
                                    str = "DECISION-SPLIT";
                                } else {
                                    BLConstants.single();
                                    if (wstype == 107) {
                                        str = "EXTERNAL";
                                    } else {
                                        BLConstants.single();
                                        if (wstype == 109) {
                                            str = "WEBSERVICE";
                                        } else {
                                            BLConstants.single();
                                            if (wstype == 102) {
                                                str = "ATOMIC";
                                            } else {
                                                BLConstants.single();
                                                if (wstype == 108) {
                                                    str = "NESTED";
                                                } else {
                                                    BLConstants.single();
                                                    if (wstype == 110) {
                                                        str = "SUBSCRIBER";
                                                    } else {
                                                        BLConstants.single();
                                                        if (wstype == 111) {
                                                            str = "PUBLISHER";
                                                        } else {
                                                            BLConstants.single();
                                                            if (wstype == 112) {
                                                                str = "DELAY";
                                                            } else {
                                                                BLConstants.single();
                                                                if (wstype == 114) {
                                                                    str = "INLINEBLOCK";
                                                                } else {
                                                                    BLConstants.single();
                                                                    if (wstype == 115) {
                                                                        str = "BLOCKSTART";
                                                                    } else {
                                                                        BLConstants.single();
                                                                        str = wstype == 116 ? "BLOCKEND" : "UNKNOWN";
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return str;
    }

    protected QSProcessNotes getQSProcessNotes() {
        if (this.qs == null) {
            this.qs = new QueryService(this.session);
        }
        return this.qs.getProcessNotes();
    }

    static void doFinally(boolean receivedException, BLProcess that) {
        if (receivedException) {
            try {
                that.refresh();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

