/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.AbstractDataSlotType;

public class DataSlotMapping
extends AbstractDataSlotType
implements Cloneable {
    static final long serialVersionUID = -4243125499277577169L;
    private final String mappedDSName;
    private String dsType;
    private final boolean indexed;
    private Object value;
    private String storageClass;

    public DataSlotMapping(String dsName, String mappedName) {
        this(dsName, mappedName, false);
    }

    public DataSlotMapping(String dsName, String mappedName, boolean indexed) {
        super(dsName);
        if (mappedName == null || mappedName.trim().length() == 0) {
            throw new RuntimeException("DataSlotMapping.<init>: The mapped dataslot name is invalid");
        }
        this.mappedDSName = mappedName;
        this.indexed = indexed;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            DataSlotMapping clonedMapping = new DataSlotMapping(this.getDataSlotName(), this.getMappedName(), this.isIndexed());
            clonedMapping.setType(this.getType());
            clonedMapping.setStorageClass(this.getStorageClass());
            clonedMapping.setValue(this.getValue());
            return clonedMapping;
        }
    }

    public void setType(String type) {
        this.dsType = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setStorageClass(String className) {
        this.storageClass = className;
    }

    public String getDataSlotName() {
        return this.getName();
    }

    public String getMappedName() {
        return this.mappedDSName;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String getType() {
        return this.dsType;
    }

    public String getStorageClass() {
        return this.storageClass;
    }
}

