/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.server.svo.DataSlotType;
import com.savvion.sbm.util.ServiceLocator;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Objects;

public class Decimal
implements DataSlotType {
    static final long serialVersionUID = 6151320027693344113L;
    private static final String TYPE = "DECIMAL";
    private BigDecimal bd;
    private int dsPrecision = -1;
    private int dsScale = -1;

    public Decimal(BigDecimal tdt) {
        this.bd = tdt;
    }

    public Decimal(String sdv) {
        this.bd = new BigDecimal(sdv);
    }

    public Decimal(double val) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(15);
        df.setGroupingSize(0);
        String str = df.format(val);
        this.bd = new BigDecimal(str);
    }

    public Decimal(long val, int scale) {
        this.bd = BigDecimal.valueOf(val, scale);
    }

    public Decimal(BigDecimal tdt, int pre, int scale) throws Exception {
        if (!ServiceLocator.self().inAppServer()) {
            throw new Exception("Decimal(b,i,i) cannot be invoked on the client side");
        }
        if (tdt != null) {
            this.bd = tdt.setScale(scale);
        }
        this.dsPrecision = pre;
        this.dsScale = scale;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public int getPrecision() {
        return this.dsPrecision;
    }

    public int getScale() {
        return this.dsScale;
    }

    public BigDecimal getValue() {
        return this.bd;
    }

    public String getStringValue() {
        if (this.bd == null) {
            return null;
        }
        return this.bd.toPlainString();
    }

    public void add(String sdv) {
        BigDecimal tbd = new BigDecimal(sdv);
        this.bd = this.bd == null ? tbd : this.bd.add(tbd);
    }

    public void add(BigDecimal dv) {
        if (dv != null) {
            this.bd = this.bd == null ? dv : this.bd.add(dv);
        }
    }

    public void add(long dv, int scale) {
        BigDecimal tbd = BigDecimal.valueOf(dv, scale);
        this.add(tbd);
    }

    public void multiply(String sdv) {
        if (this.bd != null && sdv != null) {
            BigDecimal tbd = new BigDecimal(sdv);
            this.bd = this.bd.multiply(tbd);
        }
    }

    public void multiply(BigDecimal dv) {
        if (this.bd != null && dv != null) {
            this.bd = this.bd.multiply(dv);
        }
    }

    public int compareTo(String sdv) {
        if (sdv != null) {
            BigDecimal tbd = new BigDecimal(sdv);
            if (this.bd != null) {
                return this.bd.compareTo(tbd);
            }
            return -1;
        }
        if (this.bd == null) {
            return 0;
        }
        return 1;
    }

    public int compareTo(BigDecimal dv) {
        if (dv != null) {
            if (this.bd != null) {
                return this.bd.compareTo(dv);
            }
            return -1;
        }
        if (this.bd == null) {
            return 0;
        }
        return 1;
    }

    public boolean equals(String sdv) {
        if (sdv != null) {
            BigDecimal tbd = new BigDecimal(sdv);
            if (this.bd != null) {
                return this.bd.equals(tbd);
            }
            return false;
        }
        return this.bd == null;
    }

    public boolean equals(BigDecimal dv) {
        if (dv != null) {
            if (this.bd != null) {
                return this.bd.equals(dv);
            }
            return false;
        }
        return this.bd == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Decimal) {
            Decimal de = (Decimal)obj;
            BigDecimal tbd = de.getValue();
            return this.equals(tbd);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.bd);
    }

    public void validate(int precision, int scale) throws ParseException {
        int dataPrecision = 0;
        int dataScale = 0;
        String val = this.getStringValue();
        if (val == null) {
            return;
        }
        dataScale = this.bd.scale();
        int dotpos = val.indexOf(46);
        dataPrecision = dotpos != -1 ? dotpos : this.bd.precision() - this.bd.scale();
        if (dataPrecision > precision - scale || dataScale > scale) {
            StringBuilder sb = new StringBuilder("Invalid decimal data <");
            sb.append(val);
            sb.append("> specified for the precision <");
            sb.append(precision);
            sb.append("> and scale <");
            sb.append(scale).append(">");
            throw new ParseException(sb.toString(), dotpos);
        }
    }

    public boolean isNull() {
        return null == this.bd;
    }

    public String toString() {
        String val = this.getStringValue();
        if (val == null) {
            return "0.0";
        }
        return val;
    }

    public static Decimal getInstance(BigDecimal bdl) {
        return new Decimal(bdl);
    }
}

