/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.BLClientUtil;
import com.savvion.sbm.bizlogic.client.queryservice.ProcessNotesFilter;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotes;
import com.savvion.sbm.bizlogic.client.queryservice.QSProcessNotesFilter;
import com.savvion.sbm.bizlogic.server.ejb.BLServer;
import com.savvion.sbm.bizlogic.server.ejb.BLServerHome;
import com.savvion.sbm.bizlogic.server.ejb.DataSlotSB;
import com.savvion.sbm.bizlogic.server.ejb.DataSlotSBHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessInstanceSBHome;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSB;
import com.savvion.sbm.bizlogic.server.ejb.ProcessTemplateSBHome;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSB;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSBHome;
import com.savvion.sbm.bizlogic.server.svo.BLProcess;
import com.savvion.sbm.bizlogic.server.svo.BLProcessInterface;
import com.savvion.sbm.bizlogic.server.svo.DataSlot;
import com.savvion.sbm.bizlogic.server.svo.DataSlotList;
import com.savvion.sbm.bizlogic.server.svo.DateTime;
import com.savvion.sbm.bizlogic.server.svo.DocumentDS;
import com.savvion.sbm.bizlogic.server.svo.ProcessInstanceList;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotes;
import com.savvion.sbm.bizlogic.server.svo.ProcessNotesList;
import com.savvion.sbm.bizlogic.server.svo.ProcessTemplate;
import com.savvion.sbm.bizlogic.server.svo.WorkItemList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstance;
import com.savvion.sbm.bizlogic.server.svo.WorkStepInstanceList;
import com.savvion.sbm.bizlogic.server.svo.WorkStepTemplate;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.BizLogicException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ResultData;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.ejb.EJBObject;

public class ProcessInstance
extends BLProcess
implements BLProcessInterface {
    private static final String BIZ_LOGIC_ERR_4728 = "BizLogic_ERR_4728";
    private static final String UPDATE = "Update";
    private final long ptid;
    private final String appServerID;

    ProcessInstance(Session session, HashMap attr) {
        BLConstants.single();
        super(session, (Long)attr.get("PROCESSINSTANCEID"), attr);
        this.modifiedAttrs = new HashMap(6);
        BLConstants.single();
        this.ptid = (Long)this.attributes.get("PROCESSTEMPLATEID");
        BLConstants.single();
        this.appServerID = (String)this.attributes.get("APPSERVER_ID");
    }

    public boolean isSubProcess() {
        return this.getSubProcessType() != -1;
    }

    public boolean isSynchSubProcess() {
        return this.getSubProcessType() == 1;
    }

    public boolean isAsynchSubProcess() {
        return this.getSubProcessType() == 0;
    }

    public boolean isValidProcessInstance() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).isValidProcessInstance(this.session, this.id);
    }

    public long getRootProcessInstanceID() {
        BLConstants.single();
        return (Long)this.attributes.get("RPID");
    }

    public long getRootProcessTemplateID() {
        BLConstants.single();
        return (Long)this.attributes.get("RPTID");
    }

    public String getCreator() {
        BLConstants.single();
        return (String)this.attributes.get("CREATOR");
    }

    public String getMilestone() throws RemoteException {
        throw new BizLogicClientException("Bizlogic_ERR_3703", new Object[]{"getMilestone", "ProcessInstance"});
    }

    public String getStartWorkstepName() throws RemoteException {
        BLConstants.single();
        String startPoint = (String)this.attributes.get("STARTPOINT");
        if (startPoint == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("STARTPOINT")) {
                startPoint = ((ProcessInstanceSB)this.getRemoteRef()).getStartWorkstepName(this.session, this.id);
                BLConstants.single();
                this.attributes.put("STARTPOINT", startPoint);
            }
        }
        return startPoint;
    }

    public void setStartWorkstepName(String startPoint) {
        if (startPoint != null) {
            BLConstants.single();
            this.attributes.put("STARTPOINT", startPoint);
            BLConstants.single();
            this.modifiedAttrs.put("STARTPOINT", startPoint);
        }
    }

    public HashMap getCallerInfo() throws RemoteException {
        BLConstants.single();
        HashMap callerInfo = (HashMap)this.attributes.get("CALLERINFO");
        if (callerInfo == null) {
            BLConstants.single();
            if (!this.attributes.containsKey("CALLERINFO")) {
                callerInfo = ((ProcessInstanceSB)this.getRemoteRef()).getCallerInfo(this.session, this.id);
                BLConstants.single();
                this.attributes.put("CALLERINFO", callerInfo);
            }
        }
        return callerInfo;
    }

    @Override
    public void save() throws RemoteException {
        if (this.removed) {
            throw new BizLogicClientException("BizLogic_ERR_910", new Object[]{"ProcessInstance"});
        }
        boolean receivedException = false;
        try {
            if (!this.modifiedAttrs.isEmpty()) {
                ((ProcessInstanceSB)this.getRemoteRef()).save(this.session, this.id, this.modifiedAttrs);
                this.modifiedAttrs.clear();
            }
        }
        catch (BizLogicException | RemoteException e) {
            receivedException = true;
            throw e;
        }
        finally {
            ProcessInstance.doFinally(receivedException, this);
        }
    }

    @Override
    public String getName() {
        BLConstants.single();
        return (String)this.attributes.get("PROCESSINSTANCENAME");
    }

    @Override
    public long getID() {
        return this.id;
    }

    public DateTime getDueDate() {
        BLConstants.single();
        Long duedate = (Long)this.attributes.get("DUEDATE");
        return new DateTime(duedate);
    }

    public void setDueDate(DateTime duedate) {
        if (this.isSuspended()) {
            throw new BizLogicClientException("Bizlogic_ERR_4804", new Object[]{this.getName()});
        }
        if (duedate == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = duedate;
            BLConstants.single();
            objectArray[1] = "DUEDATE";
            throw new BizLogicClientException("BizLogic_ERR_915", objectArray);
        }
        Long date = duedate.getValue().getTime();
        BLConstants.single();
        this.attributes.put("DUEDATE", date);
        BLConstants.single();
        this.modifiedAttrs.put("DUEDATE", date);
    }

    @Override
    protected EJBObject findRemoteRef() {
        try {
            if (this.appServerID != null) {
                return (ProcessInstanceSB)ProcessInstance.getRemoteRef(this.appServerID, ProcessInstanceSBHome.class);
            }
            return (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        }
        catch (Exception e) {
            throw new BizLogicClientException("BizLogic_ERR_1527", new Object[]{this.getName()}, (Throwable)e);
        }
    }

    @Override
    public void refresh() throws RemoteException {
        HashMap attribs = ((ProcessInstanceSB)this.getRemoteRef()).getAttributes(this.session, this.getID());
        this.attributes.clear();
        this.modifiedAttrs.clear();
        this.attributes.putAll(attribs);
    }

    public void activate() throws RemoteException {
        ((ProcessInstanceSB)this.getRemoteRef()).activate(this.session, this.id);
    }

    @Override
    public void suspend() throws RemoteException {
        if (this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1660", new Object[]{this.getName()});
        }
        if (!this.isActivated()) {
            throw new BizLogicClientException("BizLogic_ERR_1661", new Object[]{this.getName()});
        }
        ((ProcessInstanceSB)this.getRemoteRef()).suspend(this.session, this.id);
        BLConstants.single();
        super.setState(8);
    }

    @Override
    public void resume() throws RemoteException {
        if (!this.isSuspended()) {
            throw new BizLogicClientException("BizLogic_ERR_1666", new Object[]{this.getName()});
        }
        ((ProcessInstanceSB)this.getRemoteRef()).resume(this.session, this.id);
        BLConstants.single();
        super.setState(7);
    }

    @Override
    public void remove() throws RemoteException {
        ((ProcessInstanceSB)this.getRemoteRef()).remove(this.session, this.id);
        this.removed = true;
    }

    @Override
    public long getProcessTemplateID() {
        return this.ptid;
    }

    @Override
    public String getProcessTemplateName() {
        BLConstants.single();
        return (String)this.attributes.get("PROCESSTEMPLATENAME");
    }

    public ProcessTemplate getProcessTemplate() throws RemoteException {
        ProcessTemplate pt = ((ProcessInstanceSB)this.getRemoteRef()).getProcessTemplate(this.session, this.id);
        return pt;
    }

    @Override
    public HashMap getProcessContext() {
        return this.attributes;
    }

    public long getParentID() throws RemoteException {
        HashMap callerInfo = this.getCallerInfo();
        if (callerInfo == null) {
            return -1L;
        }
        BLConstants.single();
        return (Long)callerInfo.get("CALLERPROCESSINSTANCEID");
    }

    public ProcessInstance getParent() throws RemoteException {
        HashMap callerInfo = this.getCallerInfo();
        if (callerInfo == null) {
            return null;
        }
        BLConstants.single();
        Long ppiid = (Long)callerInfo.get("CALLERPROCESSINSTANCEID");
        if (ppiid != null) {
            return ((ProcessInstanceSB)this.getRemoteRef()).getProcessInstance(this.session, ppiid);
        }
        throw new BizLogicClientException("BizLogic_ERR_2576", new Object[]{this.id});
    }

    @Override
    public long getProcessInstanceID() {
        return this.id;
    }

    @Override
    public String getProcessInstanceName() {
        BLConstants.single();
        return (String)this.attributes.get("PROCESSINSTANCENAME");
    }

    @Override
    public void complete() throws RemoteException {
        int n = this.getState();
        BLConstants.single();
        if (n != 7) {
            throw new BizLogicClientException("BizLogic_ERR_1668", new Object[]{this.getName()});
        }
        ((ProcessInstanceSB)this.getRemoteRef()).complete(this.session, this.id);
        BLConstants.single();
        super.setState(11);
    }

    @Override
    public void complete(HashMap dsValues) throws RemoteException {
        int n = this.getState();
        BLConstants.single();
        if (n != 7) {
            throw new BizLogicClientException("BizLogic_ERR_1668", new Object[]{this.getName()});
        }
        ((ProcessInstanceSB)this.getRemoteRef()).complete(this.session, this.id, dsValues);
        BLConstants.single();
        super.setState(11);
    }

    public String[] getActivatedWorkStepNames() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getActivatedWorkStepNames(this.session, this.id);
    }

    public String[] getSuspendedWorkStepNames() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getSuspendedWorkStepNames(this.session, this.id);
    }

    public String[] getCompletedWorkStepNames() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getCompletedWorkStepNames(this.session, this.id);
    }

    public Vector getWorkStepExecutedList() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getWorkStepExecutedList(this.session, this.id);
    }

    public void reactivateWorkStep(String wsName) throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        piSB.reactivateWorkStep(this.session, this.id, wsName);
    }

    public void setCreator(String creator) {
        if (creator == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = creator;
            BLConstants.single();
            objectArray[1] = "CREATOR";
            throw new BizLogicClientException("BizLogic_ERR_915", objectArray);
        }
        if (!BLClientUtil.isUser((String)creator)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = creator;
            BLConstants.single();
            objectArray[1] = "CREATOR";
            throw new BizLogicClientException("BizLogic_ERR_915", objectArray);
        }
        BLConstants.single();
        this.attributes.put("CREATOR", creator);
        BLConstants.single();
        this.modifiedAttrs.put("CREATOR", creator);
    }

    public DataSlotList getDataSlotList() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getDataSlotList(this.session, this.id);
    }

    public DataSlotList getDataSlotList(boolean withMetaData) throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getDataSlotList(this.session, this.id, withMetaData);
    }

    public DataSlotList getDataSlotList(boolean withMetaData, boolean isPublicOnly) throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getDataSlotList(this.session, this.id, withMetaData, isPublicOnly);
    }

    public DataSlot getDataSlot(String dsName) throws RemoteException, BizLogicClientException {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3065");
        }
        return ((ProcessInstanceSB)this.getRemoteRef()).getDataSlot(this.session, this.id, dsName);
    }

    public Object getDataSlotValue(String dsName) throws RemoteException, BizLogicClientException {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3065");
        }
        Object val = ((ProcessInstanceSB)this.getRemoteRef()).getDataSlotValue(this.session, this.id, dsName);
        if (val instanceof DocumentDS) {
            return val;
        }
        if (dsName.equalsIgnoreCase("@ALLDATASLOTS") && val instanceof HashMap) {
            return val;
        }
        if (val != null && "<NULL>".equalsIgnoreCase(val.toString())) {
            val = null;
        }
        return val;
    }

    public Map getDataSlotValue(String[] dsNames) throws RemoteException {
        if (dsNames == null || dsNames.length == 0) {
            return null;
        }
        HashMap map = ((ProcessInstanceSB)this.getRemoteRef()).getDataSlotValue(this.session, this.id, dsNames);
        return map;
    }

    public Map getDataSlotValue() throws RemoteException {
        HashMap map = ((ProcessInstanceSB)this.getRemoteRef()).getDataSlotValue(this.session, this.id);
        return map;
    }

    public Vector getWorkItemSubProcesses() throws RemoteException {
        return new Vector();
    }

    public void updateSlotValue(HashMap dsValues) throws RemoteException {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        ((ProcessInstanceSB)this.getRemoteRef()).updateSlotValue((Session)this.getSession(), this.getID(), dsValues);
        for (Object value : dsValues.values()) {
            if (value == null || !(value instanceof DocumentDS)) continue;
            DocumentDS docDS = (DocumentDS)value;
            docDS.clean();
        }
    }

    public void updateSlotValue(String dsName, Object value) throws RemoteException {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3065");
        }
        HashMap<String, Object> dsValues = new HashMap<String, Object>();
        dsValues.put(dsName, value);
        ((ProcessInstanceSB)this.getRemoteRef()).updateSlotValue((Session)this.getSession(), this.getID(), dsValues);
        if (value != null && value instanceof DocumentDS) {
            DocumentDS docDS = (DocumentDS)value;
            docDS.clean();
        }
    }

    public static void updateSlotValue(Session session, long piid, HashMap<String, Object> dsValues) throws RemoteException {
        if (dsValues == null || dsValues.isEmpty()) {
            return;
        }
        ((ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class)).updateSlotValue(session, piid, dsValues);
        for (Object value : dsValues.values()) {
            if (value == null || !(value instanceof DocumentDS)) continue;
            DocumentDS docDS = (DocumentDS)value;
            docDS.clean();
        }
    }

    public ProcessInstance create(String xmlDefinition, boolean removeOnCompletion) throws RemoteException {
        if (xmlDefinition == null || "".equals(xmlDefinition)) {
            throw new BizLogicClientException("BizLogic_ERR_2544");
        }
        if (this.isSubProcess()) {
            throw new BizLogicClientException("BizLogic_ERR_646", new Object[]{this.getName()});
        }
        String fileExtension = (xmlDefinition = xmlDefinition.trim()).substring(xmlDefinition.length() - 4);
        if (".xml".equalsIgnoreCase(fileExtension)) {
            throw new BizLogicClientException("BizLogic_ERR_2543", new Object[]{xmlDefinition});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.create(this.session, this.id, xmlDefinition, removeOnCompletion);
    }

    public String getXML() throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getXML(this.session, this.id);
    }

    public HashMap getXMLWithData() throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getXMLWithData(this.session, this.id);
    }

    public WorkStepInstance getWorkStepInstance(String wsName) throws RemoteException, BizLogicClientException {
        if (wsName == null || wsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_548", new Object[]{this.getName(), "null"});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkStepInstance(this.session, this.id, wsName);
    }

    public WorkStepInstanceList getWorkStepInstanceList() throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkStepInstanceList(this.session, this.id);
    }

    public WorkStepInstanceList getWorkStepInstanceList(boolean inlcudeInlineActivities) throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkStepInstanceList(this.session, this.id, inlcudeInlineActivities);
    }

    public WorkItemList getWorkItemList() throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkItemList(this.session, this.id);
    }

    public WorkItemList getUserWorkItemList() throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getUserWorkItemList(this.session, this.id, this.session.getUser());
    }

    public Vector getWorkStepTemplateList() throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkStepTemplateList(this.session, this.id);
    }

    public Vector getWorkStepTemplateList(boolean inlcudeInlineActivities) throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkStepTemplateList(this.session, this.id, inlcudeInlineActivities);
    }

    public WorkStepTemplate getWorkStepTemplate(String wsName) throws RemoteException {
        ProcessInstanceSB piSB = (ProcessInstanceSB)this.getRemoteRef();
        return piSB.getWorkStepTemplate(this.session, this.id, wsName);
    }

    public boolean isDataSlot(String dsName) throws RemoteException {
        return this.isDataSlot(dsName, this.getDataSlotNameList());
    }

    public Vector getDataSlotNameList() throws RemoteException {
        BLConstants.single();
        if (this.attributes.containsKey("DATASLOTNAMELIST")) {
            BLConstants.single();
            return (Vector)this.attributes.get("DATASLOTNAMELIST");
        }
        Vector dsNameList = ((ProcessTemplateSB)ProcessInstance.getRemoteRef(ProcessTemplateSBHome.class)).getDataSlotNameList(this.session, this.isDynamic() ? this.id : this.ptid, this.isDynamic());
        BLConstants.single();
        this.attributes.put("DATASLOTNAMELIST", dsNameList);
        return dsNameList;
    }

    public boolean isDynamic() {
        BLConstants.single();
        long parentID = (Long)this.attributes.get("PARENTID");
        return parentID > 0L;
    }

    public boolean isCompleted() {
        int n = this.getState();
        BLConstants.single();
        return n == 11;
    }

    public void reActivateWSForIM() throws RemoteException {
        ((ProcessInstanceSB)this.getRemoteRef()).reActivateWSForIM(this.session, this.id);
    }

    public WorkStepInstanceList getWorkStepInstanceListForMilestone() throws RemoteException {
        return ((ProcessInstanceSB)this.getRemoteRef()).getWorkStepInstanceListForMilestone(this.session, this.ptid, this.id);
    }

    public Map getCompletedMilestoneList() throws RemoteException {
        WorkStepInstanceList wsiList = this.getWorkStepInstanceListForMilestone();
        List list = wsiList.getList();
        HashMap<String, String> milestoneMap = new HashMap<String, String>();
        if (list == null || list.isEmpty()) {
            return milestoneMap;
        }
        for (int ix = 0; ix < list.size(); ++ix) {
            WorkStepInstance wsi = (WorkStepInstance)list.get(ix);
            String key = wsi.getMilestoneName() + " (" + wsi.getName() + ")";
            String value = wsi.getMilestoneDescription() + " (" + new Date(wsi.getCompleteTime()) + ")";
            milestoneMap.put(key, value);
        }
        return milestoneMap;
    }

    public static ProcessInstance create(Session session, String ptName, HashMap attributes, HashMap dsValues, boolean toActivate) throws RemoteException {
        BLServer blserver = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blserver.createProcessInstance(session, ptName, attributes, dsValues, toActivate);
    }

    public static ProcessInstance create(Session session, String ptName, String prefix, String priority, HashMap dsValues) throws RemoteException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        BLConstants.single();
        attributes.put("PROCESSINSTANCENAME", prefix);
        BLConstants.single();
        attributes.put("PRIORITY", priority);
        BLServer blserver = (BLServer)BLProcess.getRemoteRef(BLServerHome.class);
        return blserver.createProcessInstance(session, ptName, attributes, dsValues, true);
    }

    public static ProcessInstance get(Session session, long piid) throws RemoteException {
        ProcessInstanceSB pisb = (ProcessInstanceSB)BLProcess.getRemoteRef(ProcessInstanceSBHome.class);
        return pisb.getProcessInstance(session, piid);
    }

    public WorkItemList getWorkItemList(String wsName) throws RemoteException {
        WorkItemSB wisb = (WorkItemSB)BLProcess.getRemoteRef(WorkItemSBHome.class);
        return wisb.getList(this.session, this.getID(), wsName);
    }

    public WorkItemList getAvailableWorkItemList() throws RemoteException {
        WorkItemSB wisb = (WorkItemSB)BLProcess.getRemoteRef(WorkItemSBHome.class);
        long[] lArray = new long[]{this.getID()};
        int[] nArray = new int[1];
        BLConstants.single();
        nArray[0] = 27;
        return wisb.getList(this.session, null, lArray, nArray);
    }

    public WorkItemList getAssignedWorkItemList() throws RemoteException {
        WorkItemSB wisb = (WorkItemSB)BLProcess.getRemoteRef(WorkItemSBHome.class);
        long[] lArray = new long[]{this.getID()};
        int[] nArray = new int[1];
        BLConstants.single();
        nArray[0] = 28;
        return wisb.getList(this.session, null, lArray, nArray);
    }

    public ProcessInstanceList getActiveSubProcessList(String wsName) throws RemoteException {
        return ((ProcessInstanceSB)this.findRemoteRef()).getActiveSubProcessList(this.session, this.getID(), wsName);
    }

    public ProcessInstanceList getActiveSubProcessList() throws RemoteException {
        return this.getActiveSubProcessList(null);
    }

    public WorkStepInstance getParentWorkStepInstance() throws RemoteException {
        if (!this.isSubProcess()) {
            throw new BizLogicClientException("BizLogic_ERR_3738", new Object[]{this.getID()});
        }
        return ((ProcessInstanceSB)this.findRemoteRef()).getParentWorkStepInstance(this.session, this.getID());
    }

    public static boolean isExist(Session session, long piID) throws RemoteException {
        return ((ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class)).isExist(session, piID);
    }

    public static DataSlot getDataSlot(Session session, long piid, String dsName) throws RemoteException, BizLogicClientException {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3563", (Object)"ProcessInstance.getDataSlot");
        }
        DataSlotSB dssb = (DataSlotSB)BLProcess.getRemoteRef(DataSlotSBHome.class);
        return dssb.getDataSlot(session, piid, dsName);
    }

    public static <T> T getExtBusinessObject(Session session, long piid, String dsName, Object pkInfo) {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3563", (Object)"ProcessInstance.getExtBusinessObject");
        }
        if (null == pkInfo) {
            throw new BizLogicClientException("BizLogic_ERR_8098", new Object[]{dsName, piid});
        }
        try {
            DataSlotSB dssb = (DataSlotSB)BLProcess.getRemoteRef(DataSlotSBHome.class);
            return (T)dssb.getExtBusinessObject(session, piid, dsName, pkInfo);
        }
        catch (Throwable th) {
            throw new BizLogicClientException("BizLogic_ERR_8099", new Object[]{dsName, piid}, th);
        }
    }

    public static DataSlotList getDataSlotList(Session session, long piid, List<String> dsNames) throws RemoteException {
        if (dsNames != null && !dsNames.isEmpty()) {
            DataSlotSB dssb = (DataSlotSB)BLProcess.getRemoteRef(DataSlotSBHome.class);
            String[] dataSlots = dsNames.toArray(new String[0]);
            return dssb.getList(session, piid, dataSlots);
        }
        return null;
    }

    public static void updateDataSlot(Session session, long piid, HashMap<String, Object> dsValues) throws RemoteException {
        DataSlotSB dssb = (DataSlotSB)ProcessInstance.getRemoteRef(DataSlotSBHome.class);
        dssb.setValue(session, piid, dsValues);
    }

    public static void updateDataSlot(Session session, long piid, String dsName, Object dsValue) throws RemoteException {
        if (dsName == null || dsName.trim().isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_1512", (Object)"ProcessInstance.updateDataSlot");
        }
        DataSlotSB dssb = (DataSlotSB)ProcessInstance.getRemoteRef(DataSlotSBHome.class);
        dssb.setValue(session, piid, dsName, dsValue);
    }

    private int getSubProcessType() {
        BLConstants.single();
        if (this.attributes.containsKey("ISCALLBACKCALLER")) {
            BLConstants.single();
            return (Integer)this.attributes.get("ISCALLBACKCALLER");
        }
        return -1;
    }

    public ProcessNotes createNotes(String notes, String threadName) throws RemoteException {
        return ProcessNotes.createForProcessInstance(this.session, this.getID(), notes, threadName);
    }

    public ProcessNotesList getAllNotes() {
        QSProcessNotes qsProcessNotes = this.getQSProcessNotes();
        QSProcessNotesFilter filter = new QSProcessNotesFilter("NotesForProcessInstance");
        filter.setConditionForProcessInstance();
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("piid", this.getID());
        filter.setParameterValues(params);
        return qsProcessNotes.getList((ProcessNotesFilter)filter);
    }

    public ProcessNotesList getNotesForWorkStepInstance(String wsName) {
        QSProcessNotes qsProcessNotes = this.getQSProcessNotes();
        QSProcessNotesFilter filter = new QSProcessNotesFilter("NotesForWorkStepInstance");
        filter.setConditionForWorkStep();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("piid", this.getID());
        params.put("wsname", wsName);
        filter.setParameterValues(params);
        return qsProcessNotes.getList((ProcessNotesFilter)filter);
    }

    public static List<String> getUsersFromDataSlot(Session session, long piid, String dsName, boolean expandGroup) throws RemoteException {
        Map<String, Integer> realUsersWithType = ProcessInstance.getUsersFromDataSlot(session, piid, dsName, expandGroup, false, true);
        ArrayList<String> realUsers = new ArrayList<String>(realUsersWithType.size());
        realUsers.addAll(realUsersWithType.keySet());
        return realUsers;
    }

    public static Map<String, Integer> getUsersFromDataSlot(Session session, long piid, String dsName, boolean expandGroup, boolean allowQueue, boolean removeInvalid) throws RemoteException {
        if (dsName == null || dsName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3563", (Object)"ProcessInstance.getRealUsersFromDataSlot");
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        return piSB.getUsersFromDataSlot(session, piid, dsName, expandGroup, allowQueue, removeInvalid);
    }

    @Override
    public String getAppName() {
        BLConstants.single();
        return (String)this.attributes.get("APP_NAME");
    }

    public static long getProcessInstanceId(Session session, String ptName, String monitorDSValue) throws RemoteException {
        if (ptName == null || ptName.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_3871", new Object[]{"ProcessInstance::getProcessInstanceId()"});
        }
        if (monitorDSValue == null || monitorDSValue.trim().length() == 0) {
            throw new BizLogicClientException("BizLogic_ERR_4839", new Object[]{ptName});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        return piSB.getProcessInstanceId(session, ptName, monitorDSValue);
    }

    public static void updateInstance(Session session, List<Long> piids, Map<String, Object> dsValues, Map<String, Object> attributes, boolean isMultiTrans) throws RemoteException, BizLogicClientException {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4730", new Object[]{"update"});
        }
        if ((dsValues == null || dsValues.isEmpty()) && (attributes == null || attributes.isEmpty())) {
            throw new BizLogicClientException("BizLogic_ERR_4729", new Object[]{"ProcessInstance::updateInstance()"});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        ResultData<List<Long>> result = piSB.updateInstance(session, piids, dsValues, attributes, isMultiTrans);
        ProcessInstance.validateUpdateResults(result);
    }

    private static void validateUpdateResults(ResultData<List<Long>> result) {
        if (!result.isSuccessful()) {
            throw new BizLogicClientException(BIZ_LOGIC_ERR_4728, new Object[]{UPDATE, result.getReturnValue()}, (Throwable)result.getConsolidatedError(), result.getFailureContext());
        }
    }

    public static void updateInstance(Session session, Map<Long, Map<String, Object>> dsValues, Map<Long, Map<String, Object>> attributes, boolean isMultiTrans) throws RemoteException, BizLogicClientException {
        if ((dsValues == null || dsValues.isEmpty()) && (attributes == null || attributes.isEmpty())) {
            throw new BizLogicClientException("BizLogic_ERR_4729", new Object[]{"ProcessInstance::updateInstance()"});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        ResultData<List<Long>> result = piSB.updateInstance(session, dsValues, attributes, isMultiTrans);
        ProcessInstance.validateUpdateResults(result);
    }

    public static void updateInstance(Session session, long piid, Map<String, Object> dsValues, Map<String, Object> attributes) throws RemoteException, BizLogicClientException {
        if ((dsValues == null || dsValues.isEmpty()) && (attributes == null || attributes.isEmpty())) {
            throw new BizLogicClientException("BizLogic_ERR_4729", new Object[]{"ProcessInstance::updateInstance()"});
        }
        ArrayList<Long> piids = new ArrayList<Long>();
        piids.add(piid);
        ProcessInstance.updateInstance(session, piids, dsValues, attributes, false);
    }

    public static void removeInstance(Session session, List<Long> piids, boolean isMultiTrans) throws RemoteException, BizLogicClientException {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4730", new Object[]{"remove"});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        ResultData<List<Long>> result = piSB.removeInstance(session, piids, isMultiTrans);
        if (!result.isSuccessful()) {
            throw new BizLogicClientException(BIZ_LOGIC_ERR_4728, new Object[]{"Removal", result.getReturnValue()}, (Throwable)result.getConsolidatedError(), result.getFailureContext());
        }
    }

    public static void suspendInstance(Session session, List<Long> piids, boolean isMultiTrans) throws RemoteException, BizLogicClientException {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4730", new Object[]{"suspend"});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        ResultData<List<Long>> result = piSB.suspendInstance(session, piids, isMultiTrans);
        if (!result.isSuccessful()) {
            throw new BizLogicClientException(BIZ_LOGIC_ERR_4728, new Object[]{"Suspend", result.getReturnValue()}, (Throwable)result.getConsolidatedError(), result.getFailureContext());
        }
    }

    public static void resumeInstance(Session session, List<Long> piids, boolean isMultiTrans) throws RemoteException, BizLogicClientException {
        if (piids == null || piids.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_4730", new Object[]{"resume"});
        }
        ProcessInstanceSB piSB = (ProcessInstanceSB)ProcessInstance.getRemoteRef(ProcessInstanceSBHome.class);
        ResultData<List<Long>> result = piSB.resumeInstance(session, piids, isMultiTrans);
        if (!result.isSuccessful()) {
            throw new BizLogicClientException(BIZ_LOGIC_ERR_4728, new Object[]{"Resume", result.getReturnValue()}, (Throwable)result.getConsolidatedError(), result.getFailureContext());
        }
    }
}

