/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.server.svo;

import com.savvion.sbm.bizlogic.client.queryservice.QSWorkItem;
import com.savvion.sbm.bizlogic.client.queryservice.QueryService;
import com.savvion.sbm.bizlogic.client.queryservice.WorkItemFilter;
import com.savvion.sbm.bizlogic.server.ejb.WorkItemSB;
import com.savvion.sbm.bizlogic.server.svo.BLCollection;
import com.savvion.sbm.bizlogic.server.svo.BLCollectionOperation;
import com.savvion.sbm.bizlogic.server.svo.WorkItem;
import com.savvion.sbm.bizlogic.util.BLConstants;
import com.savvion.sbm.bizlogic.util.BizLogicClientException;
import com.savvion.sbm.bizlogic.util.Session;
import com.savvion.sbm.util.ResultData;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class WorkItemList
extends BLCollection
implements BLCollectionOperation {
    WorkItemList(Session session, Vector list) {
        this.session = session;
        if (list != null) {
            this.list = list;
        }
    }

    public static WorkItemList getList(Session session) {
        QueryService qs = new QueryService(session);
        QSWorkItem qswi = qs.getWorkItem();
        return qswi.getList(null);
    }

    public static WorkItemList getAssignedList(Session session) {
        return QSWorkItem.getAssignedList((Session)session, null);
    }

    public static WorkItemList getAssignedList(Session session, WorkItemFilter fil) {
        return QSWorkItem.getAssignedList((Session)session, (WorkItemFilter)fil);
    }

    public static WorkItemList getAvailableList(Session session) {
        return QSWorkItem.getAvailableList((Session)session, null);
    }

    public static WorkItemList getAvailableList(Session session, WorkItemFilter fil) {
        return QSWorkItem.getAvailableList((Session)session, (WorkItemFilter)fil);
    }

    public static WorkItemList getList(Session session, int[] states) {
        QueryService qs = new QueryService(session);
        QSWorkItem qswi = qs.getWorkItem();
        return qswi.getList(null, states);
    }

    @Override
    public void save() throws RemoteException {
        HashMap modifiedAttrsList = this.getModifiedAttrsList();
        if (!modifiedAttrsList.isEmpty()) {
            ((WorkItemSB)this.getRemoteRef()).save(this.session, modifiedAttrsList);
        }
    }

    @Override
    public void complete() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 32;
        List<Long> invalidIdList = this.getSVOsInState(integerArray);
        if (!invalidIdList.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_3758", new Object[]{"complete", invalidIdList, "I_SUSPENDED"});
        }
        ArrayList<Long> idList = new ArrayList<Long>(this.getIDList());
        if (!idList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).complete(this.session, idList);
            if (!result.isSuccessful()) {
                List completedIds = (List)result.getReturnValue();
                this.removeFromList(completedIds);
                this.throwEx(completedIds, "WorkItemList", "complete", result.getError());
            } else {
                this.list = new Vector();
            }
        }
    }

    @Override
    public void suspend() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 32;
        List<Long> validIdList = this.getSVOsNotInState(integerArray);
        if (!validIdList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).suspend(this.session, validIdList);
            if (!result.isSuccessful()) {
                List suspendedIds = (List)result.getReturnValue();
                BLConstants.single();
                this.setState(32, suspendedIds);
                this.throwEx(suspendedIds, "WorkItemList", "suspend", result.getError());
            } else {
                BLConstants.single();
                this.setState(32);
            }
        }
    }

    @Override
    public void resume() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 32;
        List<Long> validIdList = this.getSVOsInState(integerArray);
        if (!validIdList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).resume(this.session, validIdList);
            if (!result.isSuccessful()) {
                List resumedIds = (List)result.getReturnValue();
                this.setPreviousState(resumedIds);
                this.throwEx(resumedIds, "WorkItemList", "resume", result.getError());
            } else {
                this.setPreviousState();
            }
        }
    }

    @Override
    public void remove() throws RemoteException {
        if (this.list == null || this.list.isEmpty()) {
            return;
        }
        Integer[] integerArray = new Integer[1];
        BLConstants.single();
        integerArray[0] = 32;
        List<Long> invalidIdList = this.getSVOsInState(integerArray);
        if (!invalidIdList.isEmpty()) {
            throw new BizLogicClientException("BizLogic_ERR_3758", new Object[]{"remove", invalidIdList, "I_SUSPENDED"});
        }
        ArrayList<Long> idList = new ArrayList<Long>(this.getIDList());
        if (!idList.isEmpty()) {
            ResultData<List<Long>> result = ((WorkItemSB)this.getRemoteRef()).remove(this.session, idList);
            if (!result.isSuccessful()) {
                List removedIds = (List)result.getReturnValue();
                this.removeFromList(removedIds);
                this.throwEx(removedIds, "WorkItemList", "remove", result.getError());
            } else {
                this.list = new Vector();
            }
        }
    }

    public void assign(String userName) throws RemoteException {
        if (this.getIDList() != null && !this.getIDList().isEmpty()) {
            Vector wiids = this.getIDList();
            WorkItem.assign(this.session, wiids, userName, true);
            this.refresh();
        }
    }

    public void makeAvailable() throws RemoteException {
        this.makeAvailable(null);
    }

    public void makeAvailable(Vector<String> performers) throws RemoteException {
        for (int i = 0; i < this.list.size(); ++i) {
            WorkItem wi = (WorkItem)this.list.get(i);
            if (!wi.isSuspended()) continue;
            throw new BizLogicClientException("BizLogic_ERR_4632", new Object[]{wi.getProcessInstanceName(), "workitem", wi.getID()});
        }
        Vector idList = this.getIDList();
        if (!idList.isEmpty()) {
            WorkItem.makeAvailable(this.session, idList, performers);
        }
    }

    public void reAssign(String performer) throws RemoteException {
        Vector wiids = this.getIDList();
        if (!wiids.isEmpty()) {
            WorkItem.reAssign(this.session, wiids, performer);
        }
    }

    public void refresh() throws RemoteException {
        Vector wiids = this.getIDList();
        WorkItemSB wisb = (WorkItemSB)this.getRemoteRef();
        List<WorkItem> wiList = wisb.getWorkItems(this.session, wiids);
        this.list = wiList != null ? new Vector<WorkItem>(wiList) : new Vector();
        int lastIndex = this.list.isEmpty() ? -1 : 0;
        this.setLastIndex(lastIndex);
    }
}

