/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.smp.persistence.dao;

import com.savvion.sbm.bizlogic.smp.MPService;
import com.savvion.sbm.bizlogic.smp.persistence.MPDBConstant;
import com.savvion.sbm.bizlogic.smp.util.MPUtil;
import com.savvion.sbm.bizlogic.smp.util.MonitoringProcessException;
import com.savvion.sbm.bizlogic.smp.util.SMPConfig;
import com.savvion.sbm.util.DBService;
import com.savvion.sbm.util.ExceptionService;
import com.savvion.sbm.util.SBMDatabase;
import com.savvion.sbm.util.logger.SBMLogger;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;

public class InvalidEventDAO
extends DBService {
    public static String createInvalidEventSQL;
    private static String deleteEventsByCreateTime;
    private static final String[] CREATE_LIST;

    public static void create(Connection conn, Map<String, Object> invalidEvent) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)InvalidEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "InvalidEventDAO.create(Map<String object>)"));
        }
        if (invalidEvent == null || invalidEvent.isEmpty()) {
            throw (MonitoringProcessException)((Object)InvalidEventDAO.getMonitoringProcessES().createException("BM_MPCM120", "InvalidEventDAO.create(Map<String object>)"));
        }
        String ctx = MPUtil.getInvalidEvtCtx(invalidEvent);
        String key = null;
        Object value = null;
        PreparedStatement pstmtCreateInvalidEvent = null;
        try {
            pstmtCreateInvalidEvent = conn.prepareStatement(createInvalidEventSQL);
            for (int ix = 1; ix < CREATE_LIST.length; ++ix) {
                key = CREATE_LIST[ix];
                value = invalidEvent.get(key);
                if (key.equalsIgnoreCase("OPERATION_TYPE")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, 4);
                        continue;
                    }
                    pstmtCreateInvalidEvent.setInt(ix, (Integer)value);
                    continue;
                }
                if (key.equalsIgnoreCase("CREATE_TIME")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, -5);
                        continue;
                    }
                    pstmtCreateInvalidEvent.setLong(ix, (Long)value);
                    continue;
                }
                if (key.equalsIgnoreCase("RECEIVED_TIME")) {
                    long dbTime = MPUtil.getSystemTimeFromDB(conn);
                    pstmtCreateInvalidEvent.setLong(ix, dbTime);
                    continue;
                }
                if (key.equalsIgnoreCase("EXTERNAL_INSTANCE_ID")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, 12);
                        continue;
                    }
                    String strVal = (String)value;
                    if (strVal.length() > 128) {
                        strVal = strVal.substring(0, 128);
                        InvalidEventDAO.getLogger().errorKey("BM_MPCM123", "InvalidEventDAO.create(Connection, Map)", new Object[]{"EXTERNAL_INSTANCE_ID", value, strVal, 128, MPUtil.getInvalidEvtCtx(invalidEvent)});
                    }
                    pstmtCreateInvalidEvent.setString(ix, strVal);
                    continue;
                }
                if (key.equalsIgnoreCase("PROCESS_NAME")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, 12);
                        continue;
                    }
                    String strVal = (String)value;
                    if (strVal.length() > 64) {
                        strVal = strVal.substring(0, 64);
                        if (SMPConfig.self().logWarningMessage()) {
                            InvalidEventDAO.getLogger().warnKey("BM_MPCM123", "InvalidEventDAO.create(Connection, Map)", new Object[]{"PROCESS_NAME", value, strVal, 64, MPUtil.getInvalidEvtCtx(invalidEvent)});
                        }
                    }
                    pstmtCreateInvalidEvent.setString(ix, strVal);
                    continue;
                }
                if (key.equalsIgnoreCase("WORKSTEP_NAME")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, 12);
                        continue;
                    }
                    String strVal = (String)value;
                    if (strVal.length() > 64) {
                        strVal = strVal.substring(0, 64);
                        if (SMPConfig.self().logWarningMessage()) {
                            InvalidEventDAO.getLogger().warnKey("BM_MPCM123", "InvalidEventDAO.create(Connection, Map)", new Object[]{"WORKSTEP_NAME", value, strVal, 64, MPUtil.getInvalidEvtCtx(invalidEvent)});
                        }
                    }
                    pstmtCreateInvalidEvent.setString(ix, strVal);
                    continue;
                }
                if (key.equalsIgnoreCase("SENDER")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, 12);
                        continue;
                    }
                    String strVal = (String)value;
                    if (strVal.length() > 64) {
                        strVal = strVal.substring(0, 64);
                        if (SMPConfig.self().logWarningMessage()) {
                            InvalidEventDAO.getLogger().warnKey("BM_MPCM123", "InvalidEventDAO.create(Connection, Map)", new Object[]{"SENDER", value, strVal, 64, MPUtil.getInvalidEvtCtx(invalidEvent)});
                        }
                    }
                    pstmtCreateInvalidEvent.setString(ix, strVal);
                    continue;
                }
                if (key.equalsIgnoreCase("REASON")) {
                    if (value == null) {
                        pstmtCreateInvalidEvent.setNull(ix, 12);
                        continue;
                    }
                    String strVal = (String)value;
                    if (strVal.length() > 512) {
                        strVal = strVal.substring(0, 512);
                        if (SMPConfig.self().logWarningMessage()) {
                            InvalidEventDAO.getLogger().warnKey("BM_MPCM123", "InvalidEventDAO.create(Connection, Map)", new Object[]{"REASON", value, strVal, 512, MPUtil.getInvalidEvtCtx(invalidEvent)});
                        }
                    }
                    pstmtCreateInvalidEvent.setString(ix, strVal);
                    continue;
                }
                if (!key.equalsIgnoreCase("MESSAGE")) continue;
                if (value == null) {
                    pstmtCreateInvalidEvent.setNull(ix, -3);
                    continue;
                }
                byte[] contextAsByteArr = MPUtil.convertToBytes(value);
                ByteArrayInputStream contextAsInStream = new ByteArrayInputStream(contextAsByteArr);
                pstmtCreateInvalidEvent.setBinaryStream(ix, (InputStream)contextAsInStream, contextAsInStream.available());
            }
            if (MPUtil.isDebug()) {
                InvalidEventDAO.getLogger().debugKey("BM_MPCM125", new Object[]{createInvalidEventSQL, ctx});
            }
            pstmtCreateInvalidEvent.executeUpdate();
        }
        catch (Throwable th) {
            throw (MonitoringProcessException)((Object)InvalidEventDAO.getMonitoringProcessES().createException("BM_MPGW123", "InvalidEventDAO.create(conn,Map)", new Object[]{ctx}, th));
        }
        finally {
            InvalidEventDAO.clean(null, (Statement)pstmtCreateInvalidEvent, null);
        }
    }

    public static synchronized void initSQLStatements() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("INSERT INTO ");
        sb.append("BIZEVENT_EXTERNAL_INVALID");
        sb.append(" (");
        int index = 1;
        if (SBMDatabase.self().isOracle() || SBMDatabase.self().isOpenEdge()) {
            index = 0;
        }
        for (int ix = index; ix < CREATE_LIST.length; ++ix) {
            sb.append(CREATE_LIST[ix]);
            if (ix == CREATE_LIST.length - 1) continue;
            sb.append(", ");
        }
        if (SBMDatabase.self().isOracle() || SBMDatabase.self().isOpenEdge()) {
            sb.append(") VALUES (");
            sb.append(MPDBConstant.EXT_INVALID_EVENTID_SEQ);
            sb.append(",");
            sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else {
            sb.append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        createInvalidEventSQL = sb.toString();
        sb = new StringBuilder();
        sb.append(" DELETE ").append(" FROM ").append("BIZEVENT_EXTERNAL_INVALID");
        sb.append(" WHERE ").append("CREATE_TIME").append(" < ");
        sb.append("?");
        deleteEventsByCreateTime = sb.toString();
    }

    public static void printSQLStatements() {
        String initStatement = "Init SQL Statement: ";
        InvalidEventDAO.getLogger().debug((Object)"InvalidEventDAO:");
        InvalidEventDAO.getLogger().debug((Object)(initStatement + createInvalidEventSQL));
    }

    private static ExceptionService<MonitoringProcessException> getMonitoringProcessES() {
        return MPService.self().getMonitoringProcessES();
    }

    private static SBMLogger getLogger() {
        return MPService.self().getLogger();
    }

    public static void deleteEventsByCreateTime(Connection conn, Timestamp createTime) {
        if (conn == null) {
            throw (MonitoringProcessException)((Object)InvalidEventDAO.getMonitoringProcessES().createException("BM_MPCM122", "InvalidEventDAO.deleteEventsByCreateTime()"));
        }
        if (createTime == null) {
            return;
        }
        PreparedStatement pstmt = null;
        try {
            conn.setAutoCommit(true);
            pstmt = conn.prepareStatement(deleteEventsByCreateTime);
            pstmt.setLong(1, createTime.getTime());
            if (MPUtil.isDebug()) {
                InvalidEventDAO.getLogger().debugKey("BM_MPCM125", "InvalidEventDAO.deleteEventsByCreateTime()", new Object[]{deleteEventsByCreateTime, createTime.getTime()});
            }
            int recordsDeleted = pstmt.executeUpdate();
            InvalidEventDAO.getLogger().infoKey("BM_MPCM226", "InvalidEventDAO.deleteEventsByCreateTime()", new Object[]{recordsDeleted});
        }
        catch (Throwable th) {
            try {
                throw (MonitoringProcessException)((Object)InvalidEventDAO.getMonitoringProcessES().createException("BM_MPCM225", "InvalidEventDAO.deleteEventsByCreateTime()", new Object[]{createTime.getTime()}, th));
            }
            catch (Throwable throwable) {
                InvalidEventDAO.clean(null, pstmt, null);
                throw throwable;
            }
        }
        InvalidEventDAO.clean(null, (Statement)pstmt, null);
    }

    static {
        CREATE_LIST = new String[]{"INVALID_EVENT_ID", "EXTERNAL_INSTANCE_ID", "OPERATION_TYPE", "SENDER", "CREATE_TIME", "PROCESS_NAME", "WORKSTEP_NAME", "REASON", "RECEIVED_TIME", "MESSAGE"};
    }
}

