/*
 * Decompiled with CFR 0.152.
 */
package com.savvion.sbm.bizlogic.storeevent;

import com.savvion.sbm.bizlogic.util.ProcessType;
import com.savvion.sbm.util.CommonEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BizLogicEventMap {
    private static final String PROCESSTEMPLATENAME = "PROCESSTEMPLATENAME";
    private static final String PROCESSTEMPLATEID = "PROCESSTEMPLATEID";
    private static final String PROCESSINSTANCENAME = "PROCESSINSTANCENAME";
    private static final String PROCESSINSTANCEID = "PROCESSINSTANCEID";
    private static final String PARENTPROCESSINSTANCEID = "PARENTPROCESSINSTANCEID";
    private static final String PARENTWORKSTEPNAME = "PARENTWORKSTEPNAME";
    private static final String PROCESSDATA = "PROCESSDATA";
    private static final String PROCESSWORKSTEPLIST = "PROCESSWSLIST";
    private static final String PROCESSMANAGER = "PMANAGER";
    private static final String PT_DESCRIPTION = "DESCRIPTION";
    private static final String PAKSERVER = "PAKSERVER";
    private static final String CLASSNAME = "CLASSNAME";
    private static final String GROUPTYPE = "GROUPTYPE";
    private static final String CREATOR = "CREATOR";
    private static final String ALL_MILESTONE = "@@ALL_MILESTONE@@";
    private static final String PRIORITY = "PRIORITY";
    private static final String DURATION = "DURATION";
    private static final String ESTIMATEDDURATION = "ESTIMATEDDURATION";
    private static final String STARTTIME = "STARTTIME";
    private static final String CATEGORY = "CATEGORY";
    private static final String ENDTIME = "ENDTIME";
    private static final String DUEDATE = "DUEDATE";
    private static final String WORKSTEPNAME = "WORKSTEPNAME";
    private static final String MONITOR_STEP = "MONITOR_STEP";
    private static final String PROCESS_TYPE = "PROCESS_TYPE";
    private static final String MONITOR_DS = "MONITOR_DS";
    private static final String WORKITEMID = "WORKITEMID";
    private static final String PERFORMER = "PERFORMER";
    private static final String PREV_PERFORMER = "PREV_PERFORMER";
    private static final String PREVIOUSSTATUS = "PREVIOUSSTATUS";
    private static final String PERFORMERVALUE = "PERFORMERVALUE";
    private static final String LOOPCOUNTER = "LOOPCOUNTER";
    private static final String DATASLOTNAME = "DATASLOTNAME";
    private static final String DATASLOTTYPE = "DATASLOTTYPE";
    private static final String DATASLOTVALUE = "DATASLOTVALUE";
    private static final String WORKSTEPDUEDATE = "WORKSTEPDUEDATE";
    private static final String XMLFILE = "XMLFILE";
    private static final String CHANGEDATTRIBUTESLIST = "CHANGEDATTRIBUTESLIST";
    private static final String CHANGEDDATASLOTSLIST = "CHANGEDDATASLOTSLIST";
    private static final String GLOBAL_SLOT_NAME_LIST = "GLOBAL_SLOT_NAME_LIST";
    private static final String IS_GLOBAL = "IS_GLOBAL";
    private static final String APP_NAME = "APP_NAME";
    private static final String ALL = "ALL";
    private static final String INLINEBLOCK_NAME = "INLINEBLOCK_NAME";
    private static final String READTIME = "READTIME";
    private static final String RPID = "RPID";
    private static final String SUBPROCESS_TYPE = "SUBPROCESS_TYPE";
    private static final String PARENTPROCESSINSTANCENAME = "PARENTPROCESSINSTANCENAME";
    private static final String CWORKITEM_ID = "CWORKITEM_ID";
    private static final String CSTEP_ID = "CSTEP_ID";
    private static final String CWORKITEM_NAME = "CWORKITEM_NAME";
    private static final String CSTEP_NAME = "CSTEP_NAME";
    private static final String COLLABORATOR = "COLLABORATOR";
    private static final String INSTRUCTION = "INSTRUCTION";
    private static final String RESPONSE = "RESPONSE";
    private static final String DATASLOT_ACCESS = "DATASLOT_ACCESS";
    private static final String DATASLOTNAMELIST = "DATASLOTNAMELIST";
    private static final String DSINDEXDATA = "DSINDEXDATA";
    private static final String NOTES = "NOTES";
    private static final String NOTES_ID = "NOTES_ID";
    private static final String REFERENCE_ID = "REFERENCE_ID";
    private static final String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private static final String NOTES_TYPE = "NOTES_TYPE";
    private static final String NOTES_CONTEXT = "NOTES_CONTEXT";
    private static final String NOTES_USER = "NOTES_USER";
    private static final String THREAD_NAME = "THREAD_NAME";
    private static final String WORKITEMNAME = "WORKITEMNAME";
    static final String VOTEINFO = "VOTEINFO";
    static final String TYPE = "TYPE";
    static final String EXPECTED_COUNT = "EXPECTED_COUNT";
    static final String MAJORITYDS = "MAJORITYDS";
    static final String RESULTDS = "RESULTDS";
    static final String CHOICES = "CHOICES";
    static final String PERCENTAGE = "PERCENTAGE";
    static final String NUMERIC = "NUMERIC";
    static final int NUMERIC_TYPE = 1;
    static final int PERCENTAGE_TYPE = 2;
    static final String DELIM = ",";
    public static final String BIZLOGIC_TYPE = "BIZLOGIC";
    public static final String ADDITIONALDS = "ADDITIONALDS";
    public static final String ADDITIONALWS = "ADDITIONALWS";
    static final int PROCESS_EVENT_BEGIN = 0;
    static final int PROCESS_TEMPLATE_CREATED = 1;
    static final int PROCESS_TEMPLATE_INSTALLED = 2;
    static final int PROCESS_TEMPLATE_REMOVED = 3;
    static final int PROCESS_TEMPLATE_SUSPENDED = 4;
    static final int PROCESS_TEMPLATE_RESUMED = 5;
    static final int PROCESS_TEMPLATE_REPLACED = 6;
    static final int PROCESS_INSTANCE_CREATED = 10;
    static final int PROCESS_INSTANCE_ACTIVATED = 11;
    static final int PROCESS_INSTANCE_SUSPENDED = 12;
    static final int PROCESS_INSTANCE_RESUMED = 13;
    static final int PROCESS_INSTANCE_COMPLETED = 14;
    static final int PROCESS_INSTANCE_REMOVED = 15;
    static final int PROCESS_INSTANCE_UPDATED = 16;
    static final int PROCESS_EVENT_END = 17;
    static final int WORK_EVENT_BEGIN = 20;
    static final int WORKSTEP_ACTIVATED = 21;
    static final int WORKSTEP_SUSPENDED = 22;
    static final int WORKSTEP_RESUMED = 23;
    static final int WORKSTEP_COMPLETED = 24;
    static final int WORKSTEP_UPDATED = 25;
    static final int WORKSTEP_TERMINATED = 26;
    static final int WORKSTEP_SKIPPED = 27;
    static final int WORKSTEP_MESSAGE_WAIT = 28;
    static final int WORKITEM_CREATED = 30;
    static final int WORKITEM_ASSIGNED = 31;
    static final int WORKITEM_COMPLETED = 32;
    static final int WORKITEM_UPDATED = 33;
    static final int WORKITEM_SUSPENDED = 34;
    static final int WORKITEM_REMOVED = 35;
    static final int WORKITEM_WAIT = 36;
    static final int WORKITEM_AVAILABLE = 37;
    static final int WORKITEM_TERMINATED = 38;
    static final int WORK_EVENT_END = 39;
    static final int WORKITEM_SKIPPED = 100;
    static final int WORKITEM_READ = 101;
    static final int DATASLOT_EVENT_BEGIN = 40;
    static final int DATASLOT_UPDATED = 42;
    static final int DATASLOT_EVENT_END = 49;
    static final int DATASLOT_TYPE_LONG = 51;
    static final int DATASLOT_TYPE_DOUBLE = 52;
    static final int DATASLOT_TYPE_SMALLSTRING = 53;
    static final int DATASLOT_TYPE_STRING = 54;
    static final int DATASLOT_TYPE_URL = 55;
    static final int DATASLOT_TYPE_BOOLEAN = 56;
    static final int DATASLOT_TYPE_OBJECT = 57;
    static final int DATASLOT_TYPE_DOCUMENT = 58;
    static final int PROCESS_INSTANCE_ATTRIBUTESSET = 61;
    static final int PROCESS_INSTANCE_DSSET = 62;
    static final int DATASLOT_TYPE_DATETIME = 70;
    static final int DATASLOT_TYPE_DECIMAL = 71;
    static final int DATASLOT_TYPE_XML = 72;
    static final int DATASLOT_TYPE_CURRENCY = 73;
    static final int DATASLOT_TYPE_LIST = 74;
    static final int DATASLOT_TYPE_SET = 75;
    static final int DATASLOT_TYPE_MAP = 76;
    static final int EP_EVENT_BEGIN = 80;
    static final int EP_AFTERBREAK = 81;
    static final int EP_EVENT_END = 89;
    static final int WORKSTEP_ACTIVATION_WAIT = 90;
    static final int WORKSTEP_PRECONDITION_WAIT = 91;
    static final int WORKSTEP_EVENTACTIVATION_WAIT = 92;
    static final int CSTEP_CREATED = 126;
    static final int CWORKITEM_ASSIGNED = 127;
    static final int CWORKITEM_SUSPENDED = 128;
    static final int CWORKITEM_COMPLETED = 129;
    static final int CWORKITEM_TERMINATED = 130;
    static final int CWORKITEM_AVAILABLE = 131;
    static final int CWORKITEM_WAIT = 132;
    static final int CWORKITEM_UPDATED = 133;
    static final int CWORKITEM_CREATED = 134;
    static final int CWORKITEM_DECLINED = 135;
    static final int PNOTES_CREATED = 161;
    static final int PNOTES_UPDATED = 162;
    static final int PNOTES_REMOVED = 163;
    private static HashMap map = new HashMap();
    private static HashMap status_map = new HashMap();
    private static Vector nonSupportedDS = new Vector();

    public static void initialize() {
        BizLogicEventMap.initStatusMap();
        BizLogicEventMap.initMap();
        BizLogicEventMap.initNonSupportedDs();
    }

    private static void initNonSupportedDs() {
        nonSupportedDS.add("OBJECT");
        nonSupportedDS.add("LIST");
        nonSupportedDS.add("SET");
        nonSupportedDS.add("MAP");
    }

    private static void initMap() {
        BizLogicEventMap.addPEventsToMap();
        BizLogicEventMap.addPiEventsToMap();
        BizLogicEventMap.addWEventsToMap();
        BizLogicEventMap.addIEventsToMap();
        BizLogicEventMap.addCollaborativeEventToMap();
        map.put("S_UPDATED", 42);
        map.put("EP_AFTERBREAK", 81);
        BizLogicEventMap.addDsTypeToMap();
        BizLogicEventMap.addProcessNotesToMap();
    }

    private static void addCollaborativeEventToMap() {
        map.put("CS_CREATED", 126);
        map.put("CI_ASSIGNED", 127);
        map.put("CI_SUSPENDED", 128);
        map.put("CI_COMPLETED", 129);
        map.put("CI_TERMINATED", 130);
        map.put("CI_AVAILABLE", 131);
        map.put("CI_WAIT", 132);
        map.put("CI_UPDATED", 133);
        map.put("CI_CREATED", 134);
        map.put("CI_DECLINED", 135);
    }

    private static void addIEventsToMap() {
        map.put("I_CREATED", 30);
        map.put("I_AVAILABLE", 37);
        map.put("I_ASSIGNED", 31);
        map.put("I_COMPLETED", 32);
        map.put("I_SUSPENDED", 34);
        map.put("I_REMOVED", 35);
        map.put("I_WAIT", 36);
        map.put("I_PRIORITY", 33);
        map.put("I_DUEDATE", 33);
        map.put("I_PERFORMER", 33);
        map.put("I_TERMINATED", 38);
        map.put("I_SKIPPED", 100);
        map.put("I_READ", 101);
    }

    private static void addWEventsToMap() {
        map.put("W_ACTIVATED", 21);
        map.put("W_SUSPENDED", 22);
        map.put("W_RESUMED", 23);
        map.put("W_COMPLETED", 24);
        map.put("W_ACTIVATION_WAIT", 90);
        map.put("W_PRECONDITION_WAIT", 91);
        map.put("W_PRIORITYSET", 25);
        map.put("W_DUEDATESET", 25);
        map.put("W_PERFORMERSET", 25);
        map.put("W_TERMINATED", 26);
        map.put("W_SKIPPED", 27);
        map.put("W_MESSAGE_WAIT", 28);
        map.put("W_EVENTACTIVATION_WAIT", 92);
    }

    private static void addPiEventsToMap() {
        map.put("PI_CREATED", 10);
        map.put("PI_ACTIVATED", 11);
        map.put("PI_SUSPENDED", 12);
        map.put("PI_RESUMED", 13);
        map.put("PI_COMPLETED", 14);
        map.put("PI_REMOVED", 15);
        map.put("PI_PRIORITYSET", 16);
        map.put("PI_CREATORSET", 16);
        map.put("PI_DUEDATESET", 16);
        map.put("PI_ATTRIBUTESSET", 61);
        map.put("PI_DATASLOTSSET", 62);
    }

    private static void addPEventsToMap() {
        map.put("P_CREATED", 1);
        map.put("P_INSTALLED", 2);
        map.put("P_REMOVED", 3);
        map.put("P_SUSPENDED", 4);
        map.put("P_RESUMED", 5);
        map.put("P_REPLACE", 6);
    }

    private static void addDsTypeToMap() {
        map.put("LONG", 51);
        map.put("DOUBLE", 52);
        map.put("STRING", 53);
        map.put("STRING_MULTI", 54);
        map.put("DOCUMENT", 58);
        map.put("URL", 55);
        map.put("BOOLEAN", 56);
        map.put("OBJECT", 57);
        map.put("DATETIME", 70);
        map.put("DECIMAL", 71);
        map.put("XML", 72);
        map.put("CURRENCY", 73);
        map.put("LIST", 74);
        map.put("SET", 75);
        map.put("MAP", 76);
    }

    private static void addProcessNotesToMap() {
        map.put("PN_CREATED", 161);
        map.put("PN_UPDATED", 162);
        map.put("PN_REMOVED", 163);
    }

    private static void initStatusMap() {
        status_map.put("P_CREATED", "Created");
        status_map.put("P_INSTALLED", "Installed");
        status_map.put("P_REMOVED", "Removed");
        status_map.put("P_REPLACE", "Replace");
        status_map.put("PI_CREATED", "Created");
        status_map.put("PI_ACTIVATED", "Activated");
        status_map.put("PI_SUSPENDED", "Suspended");
        status_map.put("PI_RESUMED", "Resumed");
        status_map.put("PI_COMPLETED", "Completed");
        status_map.put("PI_REMOVED", "Removed");
        status_map.put("W_ACTIVATED", "Activated");
        status_map.put("W_SUSPENDED", "Suspended");
        status_map.put("W_RESUMED", "Resumed");
        status_map.put("W_COMPLETED", "Completed");
        status_map.put("W_TERMINATED", "Terminated");
        status_map.put("W_SKIPPED", "Skipped");
        status_map.put("W_ACTIVATION_WAIT", "ActivationWait");
        status_map.put("W_PRECONDITION_WAIT", "PreConditionWait");
        status_map.put("I_CREATED", "Created");
        status_map.put("I_AVAILABLE", "Available");
        status_map.put("I_ASSIGNED", "Assigned");
        status_map.put("I_COMPLETED", "Completed");
        status_map.put("I_TERMINATED", "Terminated");
        status_map.put("I_SUSPENDED", "Suspended");
        status_map.put("I_REMOVED", "Removed");
        status_map.put("I_WAIT", "Wait");
        status_map.put("I_SKIPPED", "Skipped");
        status_map.put("I_READ", "Read");
    }

    public static boolean isSupportedDSType(String type) {
        return !nonSupportedDS.contains(type);
    }

    public static boolean isPRemoved(CommonEvent event) {
        String val = event.getValue();
        if (val != null) {
            return "P_REMOVED".equalsIgnoreCase(val);
        }
        return false;
    }

    public static boolean isPCreated(CommonEvent event) {
        String val = event.getValue();
        if (val != null) {
            return "P_CREATED".equalsIgnoreCase(val);
        }
        return false;
    }

    public static boolean isPReplaced(CommonEvent event) {
        String val = event.getValue();
        if (val != null) {
            return "P_REPLACE".equalsIgnoreCase(val);
        }
        return false;
    }

    public static boolean isValid(CommonEvent event) {
        return event.getContext() != null;
    }

    public static long getDate(CommonEvent event) {
        return event.getDate();
    }

    public static long getReadTime(CommonEvent event) {
        Object readTime = event.getContext().get(READTIME);
        if (readTime != null && readTime instanceof Long) {
            return (Long)readTime;
        }
        return 0L;
    }

    public static int getMap(String str) {
        Integer type = (Integer)map.get(str);
        if (type == null) {
            return -1;
        }
        return type;
    }

    public static int getType(CommonEvent event) {
        Integer type = (Integer)map.get(event.getValue());
        if (type == null) {
            return -1;
        }
        return type;
    }

    public static String getTypeString(CommonEvent event) {
        return event.getValue();
    }

    public static String getTypeString(int eventType) {
        for (String str : map.keySet()) {
            Integer value = (Integer)map.get(str);
            if (value == null || value != eventType) continue;
            return str;
        }
        return "";
    }

    public static String getPreviousStatus(CommonEvent event) {
        return (String)event.getContext().get(PREVIOUSSTATUS);
    }

    public static String getStatusString(CommonEvent event) {
        String statusString = event.getValue();
        String mappedStatusString = statusString;
        return mappedStatusString != null ? mappedStatusString : statusString;
    }

    public static int getStatus(CommonEvent event) {
        return BizLogicEventMap.getMap(event.getValue());
    }

    public static String getWorkstepStatus(CommonEvent event) {
        return BizLogicEventMap.getStatusString(event);
    }

    public static String getWorkitemStatus(CommonEvent event) {
        return BizLogicEventMap.getStatusString(event);
    }

    public static long getProcessTemplateID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, PROCESSTEMPLATEID);
    }

    public static String getProcessTemplateName(CommonEvent event) {
        return (String)event.getContext().get(PROCESSTEMPLATENAME);
    }

    public static long getProcessInstanceID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, PROCESSINSTANCEID);
    }

    public static String getProcessInstanceName(CommonEvent event) {
        return (String)event.getContext().get(PROCESSINSTANCENAME);
    }

    public static String getProcessManager(CommonEvent event) {
        return (String)event.getContext().get(PROCESSMANAGER);
    }

    public static String getProcessTemplateDescription(CommonEvent event) {
        return (String)event.getContext().get(PT_DESCRIPTION);
    }

    public static String getPakServer(CommonEvent event) {
        return (String)event.getContext().get(PAKSERVER);
    }

    public static String getClassName(CommonEvent event) {
        return (String)event.getContext().get(CLASSNAME);
    }

    public static String getGroupType(CommonEvent event) {
        Object grpType = event.getContext().get(GROUPTYPE);
        if (grpType == null) {
            return ALL;
        }
        return (String)grpType;
    }

    public static String getCreator(CommonEvent event) {
        return (String)event.getContext().get(CREATOR);
    }

    public static String getMilestoneDescription(CommonEvent event, String milestoneName) {
        Hashtable milestones = (Hashtable)event.getContext().get(ALL_MILESTONE);
        return (String)milestones.get(milestoneName);
    }

    public static String getPriority(CommonEvent event) {
        return (String)event.getContext().get(PRIORITY);
    }

    public static String getDuration(CommonEvent event) {
        return (String)event.getContext().get(DURATION);
    }

    public static String getEstimatedDuration(CommonEvent event) {
        return (String)event.getContext().get(ESTIMATEDDURATION);
    }

    public static String getInlineBlockName(CommonEvent event) {
        return (String)event.getContext().get(INLINEBLOCK_NAME);
    }

    public static String getStartTime(CommonEvent event) {
        return (String)event.getContext().get(STARTTIME);
    }

    public static String getEndTime(CommonEvent event) {
        return (String)event.getContext().get(ENDTIME);
    }

    public static String getDueDate(CommonEvent event) {
        return (String)event.getContext().get(DUEDATE);
    }

    public static String getWorkstepName(CommonEvent event) {
        return (String)event.getContext().get(WORKSTEPNAME);
    }

    public static String getWorkstepType(CommonEvent event) {
        return (String)event.getContext().get(TYPE);
    }

    public static long getWorkitemID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, WORKITEMID);
    }

    private static String parsePerformer(String performer) {
        if (performer == null) {
            return performer;
        }
        int indx = performer.indexOf("(");
        if (indx == -1) {
            return performer;
        }
        return performer.substring(0, indx);
    }

    public static String getPerformer(CommonEvent event) {
        return BizLogicEventMap.parsePerformer((String)event.getContext().get(PERFORMER));
    }

    public static String getPreviousPerformer(CommonEvent event) {
        return BizLogicEventMap.parsePerformer((String)event.getContext().get(PREV_PERFORMER));
    }

    public static String getPerformerValue(CommonEvent event) {
        return BizLogicEventMap.parsePerformer((String)event.getContext().get(PERFORMERVALUE));
    }

    public static String getDataslotName(CommonEvent event) {
        return (String)event.getContext().get(DATASLOTNAME);
    }

    public static Object getDataslotValue(CommonEvent event) {
        return event.getContext().get(DATASLOTVALUE);
    }

    public static String getDataslotType(CommonEvent event) {
        return (String)event.getContext().get(DATASLOTTYPE);
    }

    public static String getWorkstepDueDate(CommonEvent event) {
        return (String)event.getContext().get(WORKSTEPDUEDATE);
    }

    public static String getXmlFile(CommonEvent event) {
        String ret = null;
        Object v = event.getContext().get(XMLFILE);
        if (v instanceof String[]) {
            String[] strs = (String[])v;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strs.length; ++i) {
                sb.append(strs[i]);
            }
            ret = sb.toString();
        } else {
            ret = v.toString();
        }
        return ret;
    }

    public static HashMap getProcessData(CommonEvent event) {
        return (HashMap)event.getContext().get(PROCESSDATA);
    }

    public static String[] getAdditionalDSData(CommonEvent event) {
        return (String[])event.getContext().get(ADDITIONALDS);
    }

    public static String[] getAdditionalWSData(CommonEvent event) {
        return (String[])event.getContext().get(ADDITIONALWS);
    }

    public static String getProcessWorkstepList(CommonEvent event) {
        return (String)event.getContext().get(PROCESSWORKSTEPLIST);
    }

    public static boolean hasDataslotValue(CommonEvent event, String dsName) {
        return event.getContext().containsKey(dsName);
    }

    public static Object getDataslotValue(CommonEvent event, String dsName) {
        return event.getContext().get(dsName);
    }

    public static Object getKeyValue(CommonEvent event, String key) {
        return event.getContext().get(key);
    }

    public static long getParentProcessInstanceID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, PARENTPROCESSINSTANCEID);
    }

    public static String getParentWorkstepName(CommonEvent event) {
        return (String)event.getContext().get(PARENTWORKSTEPNAME);
    }

    public static int getLoopcounter(CommonEvent event) {
        String n = (String)event.getContext().get(LOOPCOUNTER);
        return n == null ? 0 : Integer.valueOf(n);
    }

    public static HashMap getChangedAttributesList(CommonEvent event) {
        return (HashMap)event.getContext().get(CHANGEDATTRIBUTESLIST);
    }

    public static HashMap getChangedDataslotsList(CommonEvent event) {
        return (HashMap)event.getContext().get(CHANGEDDATASLOTSLIST);
    }

    private static int getIntValue(CommonEvent event, String eventAttrib) {
        Integer id = (Integer)event.getContext().get(eventAttrib);
        return id == null ? -1 : id;
    }

    private static long getLongValue(CommonEvent event, String eventAttrib) {
        Long id = (Long)event.getContext().get(eventAttrib);
        return id == null ? -1L : id;
    }

    private static boolean getBooleanValue(CommonEvent event, String eventAttrib) {
        Boolean bool = (Boolean)event.getContext().get(eventAttrib);
        return bool != null && bool != false;
    }

    public static boolean isGlobalDS(CommonEvent event, String dsName) {
        boolean isGlobal = false;
        Vector globalDSList = (Vector)event.getContext().get(GLOBAL_SLOT_NAME_LIST);
        if (globalDSList != null) {
            isGlobal = globalDSList.contains(dsName);
        }
        return isGlobal;
    }

    public static boolean isGlobalDS(CommonEvent event) {
        return (Boolean)event.getContext().get(IS_GLOBAL);
    }

    public static HashMap getProcessVoteInfo(CommonEvent event) {
        return (HashMap)event.getContext().get(VOTEINFO);
    }

    public static String getVoteType(HashMap map) {
        int typ = (Integer)map.get(TYPE);
        if (typ == 2) {
            return PERCENTAGE;
        }
        return NUMERIC;
    }

    public static Integer getExpectedCount(HashMap map) {
        return (Integer)map.get(EXPECTED_COUNT);
    }

    public static String getVoteChoices(HashMap map) {
        List choices = (List)map.get(CHOICES);
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        StringBuilder str = new StringBuilder(100);
        for (int ix = 0; ix < choices.size(); ++ix) {
            str.append(choices.get(ix).toString());
            if (ix >= choices.size() - 1) continue;
            str.append(DELIM);
        }
        return str.toString();
    }

    public static String getMajorityDS(HashMap map) {
        return (String)map.get(MAJORITYDS);
    }

    public static String getVoteResultDS(HashMap map) {
        return (String)map.get(RESULTDS);
    }

    public static String getAppName(CommonEvent event) {
        return (String)event.getContext().get(APP_NAME);
    }

    public static long getCWorkItemID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, CWORKITEM_ID);
    }

    public static long getCStepID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, CSTEP_ID);
    }

    public static String getWorkItemName(CommonEvent event) {
        return (String)event.getContext().get(WORKITEMNAME);
    }

    public static String getCWorkItemName(CommonEvent event) {
        return (String)event.getContext().get(CWORKITEM_NAME);
    }

    public static String getCStepName(CommonEvent event) {
        return (String)event.getContext().get(CSTEP_NAME);
    }

    public static String getCollaborator(CommonEvent event) {
        return (String)event.getContext().get(COLLABORATOR);
    }

    public static String getInstruction(CommonEvent event) {
        return (String)event.getContext().get(INSTRUCTION);
    }

    public static String getResponse(CommonEvent event) {
        return (String)event.getContext().get(RESPONSE);
    }

    public static String getDataSlotAccessForCStep(CommonEvent event) {
        return (String)event.getContext().get(DATASLOT_ACCESS);
    }

    public static Map<String, String> getCStepDataSlots(CommonEvent event) {
        return (Map)event.getContext().get(DATASLOTNAMELIST);
    }

    public static Map<String, List<String>> getDataSlotDBIndexData(CommonEvent event) {
        return (Map)event.getContext().get(DSINDEXDATA);
    }

    public static String getNotes(CommonEvent event) {
        return (String)event.getContext().get(NOTES);
    }

    public static long getNotesID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, NOTES_ID);
    }

    public static long getReferenceID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, REFERENCE_ID);
    }

    public static long getLastModifiedTime(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, LAST_MODIFIED_TIME);
    }

    public static String getCategory(CommonEvent event) {
        String category = (String)event.getContext().get(CATEGORY);
        return category == null ? "" : category;
    }

    public static int getNotesContext(CommonEvent event) {
        return BizLogicEventMap.getIntValue(event, NOTES_CONTEXT);
    }

    public static String getNotesType(CommonEvent event) {
        return (String)event.getContext().get(NOTES_TYPE);
    }

    public static String getNotesUser(CommonEvent event) {
        return (String)event.getContext().get(NOTES_USER);
    }

    public static String getThreadName(CommonEvent event) {
        return (String)event.getContext().get(THREAD_NAME);
    }

    public static boolean isMonitorStep(CommonEvent event) {
        return (Boolean)event.getContext().get(MONITOR_STEP);
    }

    public static ProcessType getProcessType(CommonEvent event) {
        return (ProcessType)event.getContext().get(PROCESS_TYPE);
    }

    public static String getMonitorDSName(CommonEvent event) {
        return (String)event.getContext().get(MONITOR_DS);
    }

    public static long getRootPID(CommonEvent event) {
        return BizLogicEventMap.getLongValue(event, RPID);
    }

    public static int getSubProcessType(CommonEvent event) {
        return BizLogicEventMap.getIntValue(event, SUBPROCESS_TYPE);
    }

    public static String getParentProcessInstanceName(CommonEvent event) {
        return (String)event.getContext().get(PARENTPROCESSINSTANCENAME);
    }
}

